/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.io.Resources;
import com.sun.javadoc.DocErrorReporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.asciidoctor.asciidoclet.DocletOptions;

public class Stylesheets {
    static final String JAVA8_STYLESHEET = "stylesheet8.css";
    static final String JAVA6_STYLESHEET = "stylesheet6.css";
    static final String CODERAY_STYLESHEET = "coderay-asciidoctor.css";
    static final String OUTPUT_STYLESHEET = "stylesheet.css";
    private final DocletOptions docletOptions;
    private final DocErrorReporter errorReporter;

    public Stylesheets(DocletOptions options2, DocErrorReporter errorReporter) {
        this.docletOptions = options2;
        this.errorReporter = errorReporter;
    }

    public boolean copy() {
        if (!this.docletOptions.destDir().isPresent()) {
            this.errorReporter.printError("Destination directory not specified, cannot copy stylesheet");
            return false;
        }
        String stylesheet = this.selectStylesheet(System.getProperty("java.version"));
        File destDir = this.docletOptions.destDir().get();
        try {
            Resources.copy(Resources.getResource(stylesheet), new FileOutputStream(new File(destDir, OUTPUT_STYLESHEET)));
            Resources.copy(Resources.getResource(CODERAY_STYLESHEET), new FileOutputStream(new File(destDir, CODERAY_STYLESHEET)));
            return true;
        }
        catch (IOException e) {
            this.errorReporter.printError(e.getLocalizedMessage());
            return false;
        }
    }

    String selectStylesheet(String javaVersion) {
        if (javaVersion.matches("^1\\.[56]\\D.*")) {
            return JAVA6_STYLESHEET;
        }
        if (javaVersion.matches("^1\\.[78]\\D.*")) {
            return JAVA8_STYLESHEET;
        }
        this.errorReporter.printWarning("Unrecognized Java version " + javaVersion + ", using Java 7/8 stylesheet");
        return JAVA8_STYLESHEET;
    }
}

