/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.converter;

import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.converter.Converter;
import org.asciidoctor.converter.ConverterProxy;
import org.asciidoctor.internal.AsciidoctorModule;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;

public class JavaConverterRegistry {
    private AsciidoctorModule asciidoctorModule;
    private Ruby rubyRuntime;

    public JavaConverterRegistry(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
    }

    public void register(Class<? extends Converter> converterClass, String ... backends) {
        RubyModule module = this.rubyRuntime.defineModule(this.getModuleName(converterClass));
        RubyClass clazz = module.defineClassUnder(converterClass.getSimpleName(), this.rubyRuntime.getObject(), new ConverterProxy.Allocator(converterClass));
        clazz.defineAnnotatedMethods(ConverterProxy.class);
        if (backends.length > 0) {
            this.asciidoctorModule.register_converter(clazz, backends);
        } else {
            this.asciidoctorModule.register_converter(clazz);
        }
    }

    private String getModuleName(Class<?> converterClass) {
        StringBuilder sb = new StringBuilder();
        for (String s2 : converterClass.getPackage().getName().split("\\.")) {
            sb.append(s2.substring(0, 1).toUpperCase()).append(s2.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public Class<?> resolve(String backend) {
        RubyClass rubyClass = this.asciidoctorModule.resolve_converter(backend);
        Class clazz = rubyClass.getReifiedClass();
        if (clazz != null) {
            return clazz;
        }
        if (rubyClass.getAllocator() instanceof ConverterProxy.Allocator) {
            ConverterProxy.Allocator allocator = (ConverterProxy.Allocator)rubyClass.getAllocator();
            return allocator.getConverterClass();
        }
        return null;
    }

    public void unregisterAll() {
        this.asciidoctorModule.unregister_all_converters();
    }

    public Map<String, Class<?>> converters() {
        RubyArray rubyKeys = this.asciidoctorModule.converters();
        HashMap converters = new HashMap();
        for (Object rubyBackend : rubyKeys.getList()) {
            String backend = ((RubyString)rubyBackend).asJavaString();
            converters.put(backend, this.resolve(backend));
        }
        return converters;
    }
}

