/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.extensions.compactnotation;

import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.extensions.compactnotation.CompactData;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactConstructor
extends Constructor {
    private static final Pattern GUESS_COMPACT = Pattern.compile("\\p{Alpha}.*\\s*\\((?:,?\\s*(?:(?:\\w*)|(?:\\p{Alpha}\\w*\\s*=.+))\\s*)+\\)");
    private static final Pattern FIRST_PATTERN = Pattern.compile("(\\p{Alpha}.*)(\\s*)\\((.*?)\\)");
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("\\s*(\\p{Alpha}\\w*)\\s*=(.+)");
    private Construct compactConstruct;

    protected Object constructCompactFormat(ScalarNode node, CompactData data2) {
        try {
            Object obj = this.createInstance(node, data2);
            HashMap<String, Object> properties = new HashMap<String, Object>(data2.getProperties());
            this.setProperties(obj, properties);
            return obj;
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    protected Object createInstance(ScalarNode node, CompactData data2) throws Exception {
        Class<?> clazz = this.getClassForName(data2.getPrefix());
        Class[] args2 = new Class[data2.getArguments().size()];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            args2[i2] = String.class;
        }
        java.lang.reflect.Constructor<?> c = clazz.getDeclaredConstructor(args2);
        c.setAccessible(true);
        return c.newInstance(data2.getArguments().toArray());
    }

    protected void setProperties(Object bean, Map<String, Object> data2) throws Exception {
        if (data2 == null) {
            throw new NullPointerException("Data for Compact Object Notation cannot be null.");
        }
        for (Map.Entry<String, Object> entry : data2.entrySet()) {
            String key2 = entry.getKey();
            Property property = this.getPropertyUtils().getProperty(bean.getClass(), key2);
            try {
                property.set(bean, entry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new YAMLException("Cannot set property='" + key2 + "' with value='" + data2.get(key2) + "' (" + data2.get(key2).getClass() + ") in " + bean);
            }
        }
    }

    public CompactData getCompactData(String scalar2) {
        if (!scalar2.endsWith(")")) {
            return null;
        }
        if (scalar2.indexOf(40) < 0) {
            return null;
        }
        Matcher m = FIRST_PATTERN.matcher(scalar2);
        if (m.matches()) {
            String tag2 = m.group(1).trim();
            String content = m.group(3);
            CompactData data2 = new CompactData(tag2);
            if (content.length() == 0) {
                return data2;
            }
            String[] names2 = content.split("\\s*,\\s*");
            for (int i2 = 0; i2 < names2.length; ++i2) {
                String section = names2[i2];
                if (section.indexOf(61) < 0) {
                    data2.getArguments().add(section);
                    continue;
                }
                Matcher sm = PROPERTY_NAME_PATTERN.matcher(section);
                if (sm.matches()) {
                    String name2 = sm.group(1);
                    String value2 = sm.group(2).trim();
                    data2.getProperties().put(name2, value2);
                    continue;
                }
                return null;
            }
            return data2;
        }
        return null;
    }

    private Construct getCompactConstruct() {
        if (this.compactConstruct == null) {
            this.compactConstruct = this.createCompactConstruct();
        }
        return this.compactConstruct;
    }

    protected Construct createCompactConstruct() {
        return new ConstructCompactObject();
    }

    @Override
    protected Construct getConstructor(Node node) {
        ScalarNode scalar2;
        ScalarNode scalar3;
        NodeTuple tuple;
        Node key2;
        MappingNode mnode;
        List<NodeTuple> list2;
        if (node instanceof MappingNode ? (list2 = (mnode = (MappingNode)node).getValue()).size() == 1 && (key2 = (tuple = list2.get(0)).getKeyNode()) instanceof ScalarNode && GUESS_COMPACT.matcher((scalar3 = (ScalarNode)key2).getValue()).matches() : node instanceof ScalarNode && GUESS_COMPACT.matcher((scalar2 = (ScalarNode)node).getValue()).matches()) {
            return this.getCompactConstruct();
        }
        return super.getConstructor(node);
    }

    protected void applySequence(Object bean, List<?> value2) {
        try {
            Property property = this.getPropertyUtils().getProperty(bean.getClass(), this.getSequencePropertyName(bean.getClass()));
            property.set(bean, value2);
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    protected String getSequencePropertyName(Class<?> bean) throws IntrospectionException {
        Set<Property> properties = this.getPropertyUtils().getProperties(bean);
        Iterator<Property> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            if (List.class.isAssignableFrom(property.getType())) continue;
            iterator.remove();
        }
        if (properties.size() == 0) {
            throw new YAMLException("No list property found in " + bean);
        }
        if (properties.size() > 1) {
            throw new YAMLException("Many list properties found in " + bean + "; Please override getSequencePropertyName() to specify which property to use.");
        }
        return properties.iterator().next().getName();
    }

    public class ConstructCompactObject
    extends Constructor.ConstructMapping {
        public ConstructCompactObject() {
            super(CompactConstructor.this);
        }

        public void construct2ndStep(Node node, Object object) {
            MappingNode mnode = (MappingNode)node;
            NodeTuple nodeTuple = mnode.getValue().iterator().next();
            Node valueNode = nodeTuple.getValueNode();
            if (valueNode instanceof MappingNode) {
                valueNode.setType(object.getClass());
                this.constructJavaBean2ndStep((MappingNode)valueNode, object);
            } else {
                CompactConstructor.this.applySequence(object, CompactConstructor.this.constructSequence((SequenceNode)valueNode));
            }
        }

        public Object construct(Node node) {
            ScalarNode tmpNode = null;
            if (node instanceof MappingNode) {
                MappingNode mnode = (MappingNode)node;
                NodeTuple nodeTuple = mnode.getValue().iterator().next();
                node.setTwoStepsConstruction(true);
                tmpNode = (ScalarNode)nodeTuple.getKeyNode();
            } else {
                tmpNode = (ScalarNode)node;
            }
            CompactData data2 = CompactConstructor.this.getCompactData(tmpNode.getValue());
            if (data2 == null) {
                return CompactConstructor.this.constructScalar(tmpNode);
            }
            return CompactConstructor.this.constructCompactFormat(tmpNode, data2);
        }
    }
}

