/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreeFactory;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.asciidoctor.asciidoclet.AsciidocComment;
import org.asciidoctor.asciidoclet.AsciidocFileView;
import org.asciidoctor.asciidoclet.AsciidoctorConverter;
import org.asciidoctor.asciidoclet.LazyDocCommentTableProcessor;

class AsciiDocTrees
extends DocTrees {
    private final AsciidoctorConverter converter;
    private final StandardJavaFileManager fileManager;
    private final DocTrees docTrees;
    private final Field elementsField;

    AsciiDocTrees(AsciidoctorConverter converter, StandardJavaFileManager fileManager, DocTrees docTrees) {
        this.converter = converter;
        this.fileManager = fileManager;
        this.docTrees = docTrees;
        try {
            this.elementsField = docTrees.getClass().getDeclaredField("elements");
            this.elementsField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BreakIterator getBreakIterator() {
        return this.docTrees.getBreakIterator();
    }

    @Override
    public String getDocComment(TreePath path) {
        return this.converter.convert(this.docTrees.getDocComment(path));
    }

    @Override
    public DocCommentTree getDocCommentTree(TreePath path) {
        JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)path.getCompilationUnit();
        LazyDocCommentTableProcessor.processComments(cu.docComments, this::convertToAsciidoctor);
        return this.docTrees.getDocCommentTree(path);
    }

    private Tokens.Comment convertToAsciidoctor(Tokens.Comment comment) {
        String asciidoc = this.convertJavadocStringToAsciidoctorString(comment.getText());
        AsciidocComment result = new AsciidocComment(asciidoc, comment);
        return result;
    }

    private String convertJavadocStringToAsciidoctorString(String javadocString) {
        return this.converter.convert(javadocString);
    }

    @Override
    public DocCommentTree getDocCommentTree(Element e) {
        TreePath path = this.getPath(e);
        if (path == null) {
            return null;
        }
        return this.getDocCommentTree(path);
    }

    @Override
    public DocCommentTree getDocCommentTree(FileObject fileObject) {
        if (!fileObject.getName().isEmpty() && !(fileObject instanceof AsciidocFileView)) {
            return this.docTrees.getDocCommentTree(new AsciidocFileView(this.converter, fileObject));
        }
        return this.docTrees.getDocCommentTree(fileObject);
    }

    @Override
    public DocCommentTree getDocCommentTree(Element e, String relativePath) throws IOException {
        PackageElement pkg = this.getElements().getPackageOf(e);
        JavaFileManager fileManager = this.getFileManager();
        FileObject input = fileManager.getFileForInput(StandardLocation.SOURCE_PATH, pkg.getQualifiedName().toString(), relativePath);
        if (input == null) {
            throw new FileNotFoundException(relativePath);
        }
        return this.getDocCommentTree(input);
    }

    private JavacElements getElements() {
        try {
            return (JavacElements)this.elementsField.get(this.docTrees);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JavaFileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public DocTreePath getDocTreePath(FileObject fileObject, PackageElement packageElement) {
        return this.docTrees.getDocTreePath(fileObject, packageElement);
    }

    @Override
    public Element getElement(DocTreePath path) {
        return this.docTrees.getElement(path);
    }

    @Override
    public TypeMirror getType(DocTreePath path) {
        try {
            return (TypeMirror)DocTrees.class.getMethod("getType", DocTreePath.class).invoke((Object)this.docTrees, path);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<DocTree> getFirstSentence(List<? extends DocTree> list) {
        return this.docTrees.getFirstSentence(list);
    }

    @Override
    public DocSourcePositions getSourcePositions() {
        return this.docTrees.getSourcePositions();
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, DocTree t, DocCommentTree c, CompilationUnitTree root) {
        this.docTrees.printMessage(kind, msg, t, c, root);
    }

    @Override
    public void setBreakIterator(BreakIterator breakiterator) {
        this.docTrees.setBreakIterator(breakiterator);
    }

    @Override
    public DocTreeFactory getDocTreeFactory() {
        return this.docTrees.getDocTreeFactory();
    }

    @Override
    public String getCharacters(EntityTree tree) {
        return tree.toString();
    }

    @Override
    public Tree getTree(Element element) {
        return this.docTrees.getTree(element);
    }

    @Override
    public ClassTree getTree(TypeElement element) {
        return this.docTrees.getTree(element);
    }

    @Override
    public MethodTree getTree(ExecutableElement method) {
        return this.docTrees.getTree(method);
    }

    @Override
    public Tree getTree(Element e, AnnotationMirror a) {
        return this.docTrees.getTree(e, a);
    }

    @Override
    public Tree getTree(Element e, AnnotationMirror a, AnnotationValue v) {
        return this.docTrees.getTree(e, a, v);
    }

    @Override
    public TreePath getPath(CompilationUnitTree unit, Tree node) {
        return this.docTrees.getPath(unit, node);
    }

    @Override
    public TreePath getPath(Element e) {
        return this.docTrees.getPath(e);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a) {
        return this.docTrees.getPath(e, a);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a, AnnotationValue v) {
        return this.docTrees.getPath(e, a, v);
    }

    @Override
    public Element getElement(TreePath path) {
        return this.docTrees.getElement(path);
    }

    @Override
    public TypeMirror getTypeMirror(TreePath path) {
        return this.docTrees.getTypeMirror(path);
    }

    @Override
    public Scope getScope(TreePath path) {
        return this.docTrees.getScope(path);
    }

    @Override
    public boolean isAccessible(Scope scope, TypeElement type) {
        return this.docTrees.isAccessible(scope, type);
    }

    @Override
    public boolean isAccessible(Scope scope, Element member, DeclaredType type) {
        return this.docTrees.isAccessible(scope, member, type);
    }

    @Override
    public TypeMirror getOriginalType(ErrorType errorType) {
        return this.docTrees.getOriginalType(errorType);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Tree t, CompilationUnitTree root) {
        this.docTrees.printMessage(kind, msg, t, root);
    }

    @Override
    public TypeMirror getLub(CatchTree tree) {
        return this.docTrees.getLub(tree);
    }
}

