/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import org.asciidoctor.asciidoclet.AsciidoctorConverter;

class AsciidocFileView
implements JavaFileObject {
    private final AsciidoctorConverter converter;
    private final FileObject fileObject;
    private String renderedContents;

    AsciidocFileView(AsciidoctorConverter converter, FileObject fileObject) {
        this.converter = converter;
        this.fileObject = fileObject;
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.maskFileExtension(this.fileObject.toUri().toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.maskFileExtension(this.fileObject.getName());
    }

    private String maskFileExtension(String name) {
        if (this.isAsciidoctorFile((String)name)) {
            name = ((String)name).substring(0, ((String)name).lastIndexOf(46)) + ".html";
        }
        return name;
    }

    private boolean isAsciidoctorFile(String name) {
        return name.endsWith(".adoc") || name.endsWith(".ad") || name.endsWith(".asciidoc") || name.endsWith(".txt");
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.getCharContent(true).getBytes(Charset.defaultCharset()));
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.fileObject.openOutputStream();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new StringReader(this.getCharContent(ignoreEncodingErrors));
    }

    @Override
    public String getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.renderedContents == null) {
            this.renderedContents = this.fileObject.getCharContent(ignoreEncodingErrors).toString();
            if (this.isAsciidoctorFile(this.fileObject.getName())) {
                this.renderedContents = "<body>" + this.converter.convert(this.renderedContents) + "</body>";
            }
        }
        return this.renderedContents;
    }

    @Override
    public Writer openWriter() throws IOException {
        return this.fileObject.openWriter();
    }

    @Override
    public long getLastModified() {
        return this.fileObject.getLastModified();
    }

    @Override
    public boolean delete() {
        return this.fileObject.delete();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return ((JavaFileObject)this.fileObject).getKind();
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return ((JavaFileObject)this.fileObject).isNameCompatible(simpleName, kind);
    }

    @Override
    public NestingKind getNestingKind() {
        return ((JavaFileObject)this.fileObject).getNestingKind();
    }

    @Override
    public Modifier getAccessLevel() {
        return ((JavaFileObject)this.fileObject).getAccessLevel();
    }

    <T extends FileObject> T unwrap() {
        return (T)this.fileObject;
    }
}

