/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.javadoc.doclet.Reporter;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.asciidoclet.AsciidoctorOptionsFactory;
import org.asciidoctor.asciidoclet.DocletOptions;
import org.asciidoctor.asciidoclet.JavadocParser;
import org.asciidoctor.asciidoclet.OutputTemplates;
import org.asciidoctor.jruby.AsciidoctorJRuby;

class AsciidoctorConverter {
    static final String MARKER = " \t \t";
    private static final Pattern TYPE_PARAM = Pattern.compile("\\s*<(\\w+)>(.*)");
    private static final String INLINE_DOCTYPE = "inline";
    private final DocletOptions docletOptions;
    private final Reporter reporter;
    private final Asciidoctor asciidoctor;
    private final OutputTemplates templates;

    AsciidoctorConverter(DocletOptions docletOptions, Reporter reporter) {
        this.asciidoctor = AsciidoctorConverter.createAsciidoctorInstance(docletOptions.gemPath());
        this.reporter = reporter;
        this.templates = OutputTemplates.create(reporter);
        this.docletOptions = docletOptions;
    }

    private static Asciidoctor createAsciidoctorInstance(String gemPath) {
        if (gemPath != null) {
            return AsciidoctorJRuby.Factory.create((String)gemPath);
        }
        return Asciidoctor.Factory.create();
    }

    String convert(String doc) {
        if (doc.startsWith(MARKER)) {
            return doc;
        }
        JavadocParser javadocParser = JavadocParser.parse(doc);
        StringBuilder buffer = new StringBuilder(MARKER);
        String convert = this.convert(javadocParser.getCommentBody(), false);
        buffer.append(convert);
        buffer.append(System.lineSeparator());
        for (JavadocParser.Tag tag : javadocParser.tags()) {
            this.convertTag(tag, buffer);
            buffer.append(System.lineSeparator());
        }
        return buffer.toString();
    }

    private void convertTag(JavadocParser.Tag tag, StringBuilder buffer) {
        buffer.append(tag.tagName).append(' ');
        if (tag.tagName.equals("@param")) {
            Matcher matcher = TYPE_PARAM.matcher(tag.tagText);
            if (matcher.find()) {
                buffer.append('<').append(matcher.group(1)).append('>');
                String text = matcher.group(2);
                if (!text.isBlank()) {
                    buffer.append(' ');
                }
                buffer.append(this.convert(text, true));
            } else {
                buffer.append(this.convert(tag.tagText, true));
            }
        } else {
            buffer.append(this.convert(tag.tagText, true));
        }
    }

    private String convert(String input, boolean inline) {
        if (input.trim().isEmpty()) {
            return "";
        }
        Options options = new AsciidoctorOptionsFactory(this.asciidoctor, this.reporter).create(this.docletOptions, this.templates);
        options.setDocType(inline ? INLINE_DOCTYPE : (options.map().containsKey("doctype") ? (String)options.map().get("doctype") : "article"));
        return this.asciidoctor.convert(AsciidoctorConverter.cleanJavadocInput(input), options);
    }

    static String cleanJavadocInput(String input) {
        return input.trim().replaceAll("\n ", "\n").replaceAll("\\{at}", "&#64;").replaceAll("\\{slash}", "/").replaceAll("(?m)^( *)\\*\\\\/$", "$1*/");
    }
}

