/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.asciidoctor.asciidoclet.AsciidocFileView;
import org.asciidoctor.asciidoclet.AsciidoctorConverter;

class AsciidoctorFileManager
implements StandardJavaFileManager {
    private final AsciidoctorConverter converter;
    private final StandardJavaFileManager delegate;

    AsciidoctorFileManager(AsciidoctorConverter converter, StandardJavaFileManager delegate) {
        this.converter = converter;
        this.delegate = delegate;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.delegate.isSameFile(a, b);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return this.wrap(this.delegate.getJavaFileObjectsFromFiles(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> paths) {
        return this.wrap(this.delegate.getJavaFileObjectsFromPaths(paths));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.wrap(this.delegate.getJavaFileObjects(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
        return this.wrap(this.delegate.getJavaFileObjects(paths));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return this.wrap(this.delegate.getJavaFileObjectsFromStrings(names));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.wrap(this.delegate.getJavaFileObjects(names));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) throws IOException {
        this.delegate.setLocation(location, files);
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> paths) throws IOException {
        this.delegate.setLocationFromPaths(location, paths);
    }

    @Override
    public void setLocationForModule(JavaFileManager.Location location, String moduleName, Collection<? extends Path> paths) throws IOException {
        this.delegate.setLocationForModule(location, moduleName, paths);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return this.delegate.getLocation(location);
    }

    @Override
    public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        return this.delegate.getLocationAsPaths(location);
    }

    @Override
    public Path asPath(FileObject file) {
        return this.delegate.asPath(this.unwrap(file));
    }

    @Override
    public void setPathFactory(StandardJavaFileManager.PathFactory f) {
        this.delegate.setPathFactory(f);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.delegate.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.wrap(this.delegate.list(location, packageName, kinds, recurse));
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.delegate.inferBinaryName(location, this.unwrap(file));
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.delegate.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.delegate.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.wrap(this.delegate.getJavaFileForInput(location, className, kind));
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.wrap(this.delegate.getJavaFileForOutput(location, className, kind, this.unwrap(sibling)));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.wrap(this.delegate.getFileForInput(location, packageName, relativeName));
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.wrap(this.delegate.getFileForOutput(location, packageName, relativeName, this.unwrap(sibling)));
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return this.delegate.getLocationForModule(location, moduleName);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        return this.delegate.getLocationForModule(location, this.unwrap(fo));
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        return this.delegate.getServiceLoader(location, service);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return this.delegate.inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.delegate.listLocationsForModules(location);
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        return this.delegate.contains(location, this.unwrap(fo));
    }

    @Override
    public int isSupportedOption(String option) {
        return this.delegate.isSupportedOption(option);
    }

    private <T extends FileObject> T wrap(T fo) {
        return (T)new AsciidocFileView(this.converter, fo);
    }

    private <T extends FileObject> Iterable<T> wrap(Iterable<T> fos) {
        return () -> StreamSupport.stream(fos.spliterator(), false).map(this::wrap).iterator();
    }

    private <T extends FileObject> T unwrap(T fo) {
        if (fo instanceof AsciidocFileView) {
            return ((AsciidocFileView)fo).unwrap();
        }
        return fo;
    }
}

