/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import jdk.javadoc.doclet.Reporter;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.asciidoclet.AttributesLoader;
import org.asciidoctor.asciidoclet.DocletOptions;
import org.asciidoctor.asciidoclet.OutputTemplates;
import org.asciidoctor.extension.RubyExtensionRegistry;

class AsciidoctorOptionsFactory {
    private static final String DEFAULT_BACKEND = "html5";
    private final Asciidoctor asciidoctor;
    private final Reporter reporter;

    AsciidoctorOptionsFactory(Asciidoctor asciidoctor, Reporter reporter) {
        this.asciidoctor = asciidoctor;
        this.reporter = reporter;
    }

    Options create(DocletOptions docletOptions, OutputTemplates templates) {
        OptionsBuilder opts = AsciidoctorOptionsFactory.defaultOptions();
        if (docletOptions.baseDir().isPresent()) {
            opts.baseDir(docletOptions.baseDir().get());
        }
        if (templates != null) {
            opts.templateDir(templates.templateDir().toFile());
        }
        opts.attributes(this.buildAttributes(docletOptions));
        if (docletOptions.requires().size() > 0) {
            RubyExtensionRegistry rubyExtensionRegistry = this.asciidoctor.rubyExtensionRegistry();
            for (String require : docletOptions.requires()) {
                rubyExtensionRegistry.requireLibrary(require);
            }
        }
        return opts.get();
    }

    private Attributes buildAttributes(DocletOptions docletOptions) {
        return AsciidoctorOptionsFactory.defaultAttributes().attributes(new AttributesLoader(this.asciidoctor, docletOptions, this.reporter).load()).get();
    }

    private static OptionsBuilder defaultOptions() {
        return Options.builder().safe(SafeMode.SAFE).backend(DEFAULT_BACKEND);
    }

    private static AttributesBuilder defaultAttributes() {
        return Attributes.builder().attribute("at", (Object)"&#64;").attribute("slash", (Object)"/").attribute("icons", null).attribute("idprefix", (Object)"").attribute("idseparator", (Object)"-").attribute("javadoc", (Object)"").attribute("showtitle", (Object)true).attribute("source-highlighter", (Object)"coderay").attribute("coderay-css", (Object)"class").attribute("env-asciidoclet").attribute("env", (Object)"asciidoclet");
    }
}

