/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.asciidoclet.DocletOptions;

class AttributesLoader {
    private final Asciidoctor asciidoctor;
    private final DocletOptions docletOptions;
    private final Reporter reporter;

    AttributesLoader(Asciidoctor asciidoctor, DocletOptions docletOptions, Reporter reporter) {
        this.asciidoctor = asciidoctor;
        this.docletOptions = docletOptions;
        this.reporter = reporter;
    }

    Map<String, Object> load() {
        List<String> attributeArgs = this.docletOptions.attributes();
        Set<String> unset = this.getUnsetAttributes(attributeArgs);
        Map<String, Object> cmdlineAttrs = this.parseCmdLineAttributes(attributeArgs);
        Map<String, Object> attrs = this.parseAttributesFile(this.docletOptions.attributesFile(), cmdlineAttrs);
        attrs.keySet().removeAll(unset);
        for (String key : unset) {
            attrs.put(key + "!", "");
        }
        return attrs;
    }

    private Map<String, Object> parseCmdLineAttributes(List<String> attributeArgs) {
        return new Attributes(attributeArgs.toArray(new String[0])).map();
    }

    private Map<String, Object> parseAttributesFile(Optional<File> attrsFile, Map<String, Object> cmdlineAttrs) {
        if (attrsFile.isPresent()) {
            Map<String, Object> map;
            block9: {
                BufferedReader reader = Files.newBufferedReader(attrsFile.get().toPath(), this.docletOptions.encoding());
                try {
                    map = this.parseAttributes(reader, cmdlineAttrs);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.reporter.print(Diagnostic.Kind.WARNING, "Cannot read attributes file: " + e);
                    }
                }
                ((Reader)reader).close();
            }
            return map;
        }
        return cmdlineAttrs;
    }

    private Map<String, Object> parseAttributes(Reader in, Map<String, Object> existingAttrs) {
        OptionsBuilder options = Options.builder().safe(SafeMode.SAFE).attributes(existingAttrs).parseHeaderOnly(true);
        if (this.docletOptions.baseDir().isPresent()) {
            options.baseDir(this.docletOptions.baseDir().get());
        }
        return this.asciidoctor.load(AttributesLoader.read(in), options.build()).getAttributes();
    }

    public static String read(Reader reader) {
        try (Scanner scanner = new Scanner(reader).useDelimiter("\\A");){
            String string = scanner.next();
            return string;
        }
    }

    private Set<String> getUnsetAttributes(List<String> args) {
        HashSet<String> removed = new HashSet<String>();
        for (String arg : args) {
            String key = this.getKey(arg);
            if (!key.startsWith("!") && !key.endsWith("!")) continue;
            removed.add(this.normalizeAttrName(key));
        }
        return Set.copyOf(removed);
    }

    private String getKey(String arg) {
        int idx = arg.indexOf(61);
        if (idx == 0) {
            throw new IllegalArgumentException("Invalid attribute arg: \"" + arg + "\"");
        }
        return idx == -1 ? arg : arg.substring(0, idx);
    }

    private String normalizeAttrName(String name) {
        return name.replaceAll("\\W", "").toLowerCase();
    }
}

