/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import org.asciidoctor.asciidoclet.AsciidocletOptions;

public class DocletOptions {
    private final Reporter reporter;
    private Charset encoding;
    private File basedir;
    private File stylesheet;
    private File attributesFile;
    private List<String> attributes;
    private String gemPath;
    private List<String> requires;

    public DocletOptions(Reporter reporter) {
        this.reporter = reporter;
        this.encoding = Charset.defaultCharset();
        this.attributes = new ArrayList<String>();
        this.requires = new ArrayList<String>();
    }

    void collect(AsciidocletOptions option, List<String> list) {
        switch (option) {
            case ENCODING: {
                this.encoding = Charset.forName(list.get(0));
                break;
            }
            case BASEDIR: {
                this.basedir = new File(list.get(0));
                break;
            }
            case STYLESHEET: {
                this.stylesheet = new File(list.get(0));
                break;
            }
            case ATTRIBUTE: 
            case ATTRIBUTE_LONG: {
                this.splitTrimStream(list).forEach(this.attributes::add);
                break;
            }
            case ATTRIBUTES_FILE: {
                this.attributesFile = new File(list.get(0));
                break;
            }
            case GEM_PATH: {
                this.gemPath = list.get(0);
                break;
            }
            case REQUIRE: 
            case REQUIRE_LONG: {
                this.splitTrimStream(list).forEach(this.requires::add);
            }
        }
    }

    private Stream<String> splitTrimStream(List<String> list) {
        return list.stream().flatMap(s -> Arrays.stream(s.split("\\s*,\\s*"))).map(String::trim).filter(s -> !s.isEmpty());
    }

    void validate() {
        Optional<File> attrsFile;
        if (this.baseDir().isEmpty()) {
            this.printWarning(AsciidocletOptions.BASEDIR + " must be present for includes or file reference features to work properly");
        }
        if ((attrsFile = this.attributesFile()).isPresent() && !attrsFile.get().canRead()) {
            this.printWarning("Cannot read attributes file " + attrsFile.get());
        }
    }

    private void printWarning(String message) {
        this.reporter.print(Diagnostic.Kind.WARNING, message);
    }

    Optional<File> stylesheet() {
        return Optional.ofNullable(this.stylesheet);
    }

    Optional<File> baseDir() {
        return Optional.ofNullable(this.basedir);
    }

    Charset encoding() {
        return this.encoding;
    }

    List<String> attributes() {
        return this.attributes;
    }

    Optional<File> attributesFile() {
        if (this.attributesFile == null) {
            return Optional.empty();
        }
        if (!this.attributesFile.isAbsolute() && this.baseDir().isPresent()) {
            return Optional.of(new File(this.baseDir().get(), this.attributesFile.getPath()));
        }
        return Optional.of(this.attributesFile);
    }

    String gemPath() {
        return this.gemPath;
    }

    List<String> requires() {
        return this.requires;
    }
}

