/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class JavadocParser {
    private static final String[] DELIMITERS = new String[]{"====", "////", "```", "----", "....", "--", "____", "****", "|==="};
    private static final Pattern DELIMITER_OR_TAG = Pattern.compile("(^\\s*)((" + Stream.of(DELIMITERS).map(Pattern::quote).collect(Collectors.joining(")|(")) + ")|@)", 8);
    private static final Map<String, Pattern> DELIMITER_PATTERNS = Map.ofEntries((Map.Entry[])Stream.of(DELIMITERS).map(k -> Map.entry(k, Pattern.compile("(^\\s*)" + Pattern.quote(k), 8))).toArray(Map.Entry[]::new));
    private static final Pattern TAG_NAME = Pattern.compile("\\G(\\w+)\\s*");
    private final List<Tag> tags = new ArrayList<Tag>();
    private String commentBody;

    JavadocParser() {
    }

    public static JavadocParser parse(String commentString) {
        JavadocParser javadocParser = new JavadocParser();
        javadocParser.parseComment(commentString);
        return javadocParser;
    }

    private void parseComment(String commentString) {
        Matcher matcher = DELIMITER_OR_TAG.matcher(commentString);
        int captureSince = 0;
        while (matcher.find()) {
            String group = matcher.group(2);
            if (group.equals("@")) {
                int startOfMatch = matcher.start();
                this.captureComponent(commentString, captureSince, startOfMatch);
                matcher.usePattern(TAG_NAME);
                if (matcher.find()) {
                    Tag tag = new Tag(group + matcher.group(1), null);
                    this.tags.add(tag);
                    captureSince = matcher.end();
                }
                matcher.usePattern(DELIMITER_OR_TAG);
                continue;
            }
            matcher.usePattern(DELIMITER_PATTERNS.get(group));
            matcher.find();
            matcher.usePattern(DELIMITER_OR_TAG);
        }
        this.captureComponent(commentString, captureSince, commentString.length());
    }

    private void captureComponent(String commentString, int captureSince, int endOfCapture) {
        String component = commentString.substring(captureSince, endOfCapture).trim();
        if (this.commentBody == null) {
            this.commentBody = component;
        } else {
            this.tags.get((int)(this.tags.size() - 1)).tagText = component;
        }
    }

    String getCommentBody() {
        return this.commentBody;
    }

    List<Tag> tags() {
        return this.tags;
    }

    static class Tag {
        String tagName;
        String tagText;

        Tag(String tagName, String tagText) {
            this.tagName = tagName;
            this.tagText = tagText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return this.tagName.equals(tag.tagName) && Objects.equals(this.tagText, tag.tagText);
        }

        public int hashCode() {
            return Objects.hash(this.tagName, this.tagText);
        }

        public String toString() {
            return "Tag{tagName='" + this.tagName + "', tagText='" + this.tagText + "'}";
        }
    }
}

