/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.sun.tools.javac.parser.LazyDocCommentTable;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DocCommentTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Function;

class LazyDocCommentTableProcessor {
    static final Function<Object, Tokens.Comment> COMMENT_FIELD_EXTRACTOR = LazyDocCommentTableProcessor.commentFieldExtractor();
    static final Function<Tokens.Comment, Object> COMMENT_INSTANTIATOR = LazyDocCommentTableProcessor.commentInstantiator();
    public static final Field LAZY_DOC_COMMENT_TABLE_TABLE_FIELD = LazyDocCommentTableProcessor.getLazyDocCommentTable_TableField();

    LazyDocCommentTableProcessor() {
    }

    static void processComments(DocCommentTable table, Function<Tokens.Comment, Tokens.Comment> commentMapper) {
        if (table instanceof LazyDocCommentTable) {
            Map map = LazyDocCommentTableProcessor.tableFieldValueOf(table);
            Function<Object, Object> converter = COMMENT_FIELD_EXTRACTOR.andThen(commentMapper).andThen(COMMENT_INSTANTIATOR);
            map.replaceAll((tree, entry) -> converter.apply(entry));
        }
    }

    private static Map tableFieldValueOf(DocCommentTable table) {
        try {
            return (Map)LAZY_DOC_COMMENT_TABLE_TABLE_FIELD.get(table);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Function<Object, Tokens.Comment> commentFieldExtractor() {
        Field entryClassCommentField = LazyDocCommentTableProcessor.getLazyDocCommentTable$EntryClassCommentField(LazyDocCommentTableProcessor.getLazyDocCommentTable$EntryClass());
        return entry -> {
            try {
                return (Tokens.Comment)entryClassCommentField.get(entry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static Function<Tokens.Comment, Object> commentInstantiator() {
        Constructor<?> entryClassConstructor = LazyDocCommentTableProcessor.getLazyDocCommentTable$EntryClassConstructor();
        return comment -> {
            try {
                return entryClassConstructor.newInstance(comment);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static Field getLazyDocCommentTable$EntryClassCommentField(Class<?> entryClass) {
        try {
            Field commentField = entryClass.getDeclaredField("comment");
            commentField.setAccessible(true);
            return commentField;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor<?> getLazyDocCommentTable$EntryClassConstructor() {
        try {
            Constructor<?> ctor = LazyDocCommentTableProcessor.getLazyDocCommentTable$EntryClass().getDeclaredConstructor(Tokens.Comment.class);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getLazyDocCommentTable$EntryClass() {
        try {
            return Class.forName("com.sun.tools.javac.parser.LazyDocCommentTable$Entry");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getLazyDocCommentTable_TableField() {
        try {
            Field tableField = LazyDocCommentTable.class.getDeclaredField("table");
            tableField.setAccessible(true);
            return tableField;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

