/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;

class OutputTemplates {
    private static final String[] TEMPLATE_NAMES = new String[]{"section.html.haml", "paragraph.html.haml"};
    private final Path templateDir;

    private OutputTemplates(Path templateDir) {
        this.templateDir = templateDir;
    }

    static OutputTemplates create(Reporter reporter) {
        Path dir = OutputTemplates.prepareTemplateDir(reporter);
        return dir != null ? new OutputTemplates(dir) : null;
    }

    Path templateDir() {
        return this.templateDir;
    }

    private static Path prepareTemplateDir(Reporter reporter) {
        try {
            Path templateDir = Files.createTempDirectory("asciidoclet", new FileAttribute[0]);
            for (String templateName : TEMPLATE_NAMES) {
                OutputTemplates.prepareTemplate(templateDir, templateName);
            }
            return templateDir;
        }
        catch (IOException e) {
            reporter.print(Diagnostic.Kind.WARNING, "Failed to prepare templates: " + e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareTemplate(Path templateDir, String template) throws IOException {
        String templatePath = "templates/" + template;
        InputStream input = ModuleLayer.boot().findModule("asciidoclet").map(module -> OutputTemplates.getResourceAsStream(module, templatePath)).orElseGet(() -> OutputTemplates.class.getClassLoader().getResourceAsStream(templatePath));
        if (input == null) {
            throw new IOException("Could not find template " + template);
        }
        Path path = templateDir.resolve(template);
        try (OutputStream output = Files.newOutputStream(path, new OpenOption[0]);){
            input.transferTo(output);
        }
        finally {
            input.close();
        }
    }

    private static InputStream getResourceAsStream(Module module, String path) {
        try {
            return module.getResourceAsStream(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

