/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;

public class MemoryLogHandler
implements LogHandler {
    final List<LogRecord> records = new ArrayList<LogRecord>();
    private final Boolean outputToConsole;
    private final Consumer<LogRecord> recordConsumer;

    public MemoryLogHandler(Boolean outputToConsole, Consumer<LogRecord> recordConsumer) {
        this.outputToConsole = outputToConsole == null ? Boolean.FALSE : outputToConsole;
        this.recordConsumer = recordConsumer;
    }

    public void log(LogRecord logRecord) {
        this.records.add(logRecord);
        if (this.outputToConsole.booleanValue()) {
            this.recordConsumer.accept(logRecord);
        }
    }

    public void clear() {
        this.records.clear();
    }

    public List<LogRecord> filter(Severity severity) {
        return this.records.stream().filter((? super T record) -> MemoryLogHandler.severityIsHigher(record, severity)).collect(Collectors.toList());
    }

    public List<LogRecord> filter(String text) {
        return this.records.stream().filter((? super T record) -> MemoryLogHandler.messageContains(record, text)).collect(Collectors.toList());
    }

    public List<LogRecord> filter(Severity severity, String text) {
        return this.records.stream().filter((? super T record) -> MemoryLogHandler.severityIsHigher(record, severity) && MemoryLogHandler.messageContains(record, text)).collect(Collectors.toList());
    }

    private static boolean severityIsHigher(LogRecord record, Severity severity) {
        return record.getSeverity().ordinal() >= severity.ordinal();
    }

    private static boolean messageContains(LogRecord record, String text) {
        return record.getMessage().contains(text);
    }
}

