/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.maven.commons.AsciidoctorHelper;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.site.SiteConversionConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SiteConversionConfigurationParser {
    private final MavenProject project;

    public SiteConversionConfigurationParser(MavenProject project) {
        this.project = project;
    }

    public SiteConversionConfiguration processAsciiDocConfig(Xpp3Dom siteConfig, OptionsBuilder presetOptions, AttributesBuilder presetAttributes) {
        AsciidoctorHelper.addProperties(this.project.getProperties(), presetAttributes);
        Xpp3Dom siteConfiguration = Optional.ofNullable(siteConfig).map(sc -> sc.getChild("asciidoc")).orElse(null);
        if (siteConfiguration == null) {
            OptionsBuilder options = presetOptions.attributes(presetAttributes.build());
            return new SiteConversionConfiguration(options.build(), Collections.emptyList());
        }
        ArrayList<String> gemsToRequire = new ArrayList<String>();
        for (Xpp3Dom asciidocOpt : siteConfiguration.getChildren()) {
            String optName = asciidocOpt.getName();
            if ("requires".equals(optName)) {
                Xpp3Dom[] requires = asciidocOpt.getChildren("require");
                if (requires.length <= 0) continue;
                Xpp3Dom[] xpp3DomArray = requires;
                int n = xpp3DomArray.length;
                for (int i = 0; i < n; ++i) {
                    Xpp3Dom requireNode = xpp3DomArray[i];
                    if (requireNode.getValue().contains(",")) {
                        Stream.of(requireNode.getValue().split(",")).filter(StringUtils::isNotBlank).map(String::trim).forEach(value -> gemsToRequire.add((String)value));
                        continue;
                    }
                    String value2 = requireNode.getValue();
                    if (!StringUtils.isNotBlank(value2)) continue;
                    gemsToRequire.add(value2.trim());
                }
                continue;
            }
            if ("attributes".equals(optName)) {
                for (Xpp3Dom asciidocAttr : asciidocOpt.getChildren()) {
                    AsciidoctorHelper.addAttribute(asciidocAttr.getName(), asciidocAttr.getValue(), presetAttributes);
                }
                continue;
            }
            if ("templateDirs".equals(optName) || "template_dirs".equals(optName)) {
                List<File> dirs = Arrays.stream(asciidocOpt.getChildren("dir")).filter(node -> StringUtils.isNotBlank(node.getValue())).map(node -> this.resolveProjectDir(this.project, node.getValue())).collect(Collectors.toList());
                presetOptions.templateDirs(dirs.toArray(new File[dirs.size()]));
                continue;
            }
            if ("baseDir".equals(optName)) {
                presetOptions.baseDir(this.resolveProjectDir(this.project, asciidocOpt.getValue()));
                continue;
            }
            presetOptions.option(optName.replaceAll("(?<!_)([A-Z])", "_$1").toLowerCase(), (Object)asciidocOpt.getValue());
        }
        Options options = presetOptions.attributes(presetAttributes.build()).build();
        return new SiteConversionConfiguration(options, gemsToRequire);
    }

    private File resolveProjectDir(MavenProject project, String path) {
        File filePath = new File(path);
        return !filePath.isAbsolute() ? new File(project.getBasedir(), filePath.toString()) : filePath;
    }
}

