/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoc.maven;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;

@Mojo(name="process-asciidoc")
public class AsciidoctorMojo
extends AbstractMojo {
    @Parameter(property="sourceDir", defaultValue="${basedir}/src/main/asciidoc", required=true)
    protected File sourceDirectory;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-docs", required=true)
    protected File outputDirectory;
    @Parameter(property="backend", defaultValue="docbook", required=true)
    protected String backend;
    @Parameter(property="doctype", defaultValue="article", required=true)
    protected String doctype;
    @Parameter(property="attributes", required=false)
    protected Map<String, String> attributes = new HashMap<String, String>();
    @Parameter(property="compact", required=false)
    protected boolean compact = false;
    @Parameter(property="headerFooter", required=false)
    protected boolean headerFooter = false;
    @Parameter(property="templateDir", required=false)
    protected String templateDir;
    @Parameter(property="templateEngine", required=false)
    protected String templateEngine;
    @Parameter(property="imagesDir", required=false)
    protected File imagesDir = new File(this.sourceDirectory, "images");
    @Parameter(property="sourceHighlighter", required=false)
    protected String sourceHighlighter;
    @Parameter(property="title", required=false)
    protected String title;
    @Parameter(property="sourceDocumentName", required=false)
    protected File sourceDocumentName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.ensureOutputExists();
        Asciidoctor asciidoctorInstance = Asciidoctor.Factory.create();
        OptionsBuilder optionsBuilder = OptionsBuilder.options().toDir(this.outputDirectory).compact(this.compact).headerFooter(this.headerFooter).safe(SafeMode.UNSAFE).templateDir(this.templateDir).templateEngine(this.templateEngine);
        AttributesBuilder attributesBuilder = AttributesBuilder.attributes().backend(this.backend).docType(this.doctype).imagesDir(this.imagesDir).sourceHighlighter(this.sourceHighlighter).title(this.title);
        Map attributesMap = attributesBuilder.asMap();
        attributesMap.putAll(this.attributes);
        optionsBuilder.attributes(attributesMap);
        if (this.sourceDocumentName == null) {
            asciidoctorInstance.renderDirectory(this.sourceDirectory, optionsBuilder.asMap());
        } else {
            asciidoctorInstance.renderFile(this.sourceDocumentName, optionsBuilder.asMap());
        }
    }

    private void ensureOutputExists() {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Can't create " + this.outputDirectory.getPath()));
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public boolean isHeaderFooter() {
        return this.headerFooter;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public File getImagesDir() {
        return this.imagesDir;
    }

    public void setImagesDir(File imagesDir) {
        this.imagesDir = imagesDir;
    }

    public String getSourceHighlighter() {
        return this.sourceHighlighter;
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.sourceHighlighter = sourceHighlighter;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

