/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.asciidoctor.AsciiDocDirectoryWalker;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.maven.Synchronization;

@Mojo(name="process-asciidoc")
public class AsciidoctorMojo
extends AbstractMojo {
    protected static final String ASCIIDOC_REG_EXP_EXTENSION = ".*\\.a((sc(iidoc)?)|d(oc)?)$";
    @Parameter(property="asciidoctor.sourceDir", defaultValue="${basedir}/src/main/asciidoc", required=true)
    protected File sourceDirectory;
    @Parameter(property="asciidoctor.outputDir", defaultValue="${project.build.directory}/generated-docs", required=true)
    protected File outputDirectory;
    @Parameter(property="asciidoctor.attributes", required=false)
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    @Parameter(property="asciidoctor.backend", defaultValue="docbook", required=true)
    protected String backend = "";
    @Parameter(property="asciidoctor.compact", required=false)
    protected boolean compact = false;
    @Parameter(property="asciidoctor.doctype", defaultValue="article", required=true)
    protected String doctype = "article";
    @Parameter(property="asciidoctor.eruby", required=false)
    protected String eruby = "";
    @Parameter(property="asciidoctor.headerFooter", required=false)
    protected boolean headerFooter = true;
    @Parameter(property="asciidoctor.templateDir", required=false)
    protected File templateDir;
    @Parameter(property="asciidoctor.templateEngine", required=false)
    protected String templateEngine = "";
    @Parameter(property="asciidoctor.imagesDir", required=false)
    protected String imagesDir = "images";
    @Parameter(property="asciidoctor.sourceHighlighter", required=false)
    protected String sourceHighlighter = "";
    @Parameter(property="asciidoctor.title", required=false)
    protected String title = "";
    @Parameter(property="asciidoctor.sourceDocumentName", required=false)
    protected File sourceDocumentName;
    protected List<Synchronization> synchronizations = new ArrayList<Synchronization>();
    @Parameter(property="asciidoctor.extensions")
    protected List<String> extensions = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.ensureOutputExists();
        Asciidoctor asciidoctorInstance = this.getAsciidoctorInstance();
        OptionsBuilder optionsBuilder = OptionsBuilder.options().toDir(this.outputDirectory).compact(this.compact).headerFooter(this.headerFooter).safe(SafeMode.UNSAFE).templateEngine(this.templateEngine).eruby(this.eruby).backend(this.backend).docType(this.doctype).headerFooter(this.headerFooter);
        if (this.templateDir != null) {
            optionsBuilder.templateDir(this.templateDir);
        }
        optionsBuilder.attributes(this.attributes);
        if (this.sourceDocumentName == null) {
            for (File f : this.scanSourceFiles()) {
                this.renderFile(asciidoctorInstance, optionsBuilder.asMap(), f);
            }
        } else {
            this.renderFile(asciidoctorInstance, optionsBuilder.asMap(), this.sourceDocumentName);
        }
        if (this.synchronizations != null) {
            this.synchronize();
        }
    }

    protected Asciidoctor getAsciidoctorInstance() throws MojoExecutionException {
        return Asciidoctor.Factory.create();
    }

    private List<File> scanSourceFiles() {
        List asciidoctorFiles;
        if (this.extensions == null || this.extensions.isEmpty()) {
            AsciiDocDirectoryWalker directoryWalker = new AsciiDocDirectoryWalker(this.sourceDirectory.getAbsolutePath());
            asciidoctorFiles = directoryWalker.scan();
        } else {
            CustomExtensionDirectoryWalker directoryWalker = new CustomExtensionDirectoryWalker(this.sourceDirectory.getAbsolutePath(), this.extensions);
            asciidoctorFiles = directoryWalker.scan();
        }
        return asciidoctorFiles;
    }

    private void synchronize() {
        for (Synchronization synchronization : this.synchronizations) {
            this.synchronize(synchronization);
        }
    }

    protected void renderFile(Asciidoctor asciidoctorInstance, Map<String, Object> options, File f) {
        asciidoctorInstance.renderFile(f, options);
        this.logRenderedFile(f);
    }

    protected void logRenderedFile(File f) {
        this.getLog().info((CharSequence)("Rendered " + f.getAbsolutePath()));
    }

    protected void synchronize(Synchronization synchronization) {
        if (synchronization.getSource().isDirectory()) {
            try {
                FileUtils.copyDirectory((File)synchronization.getSource(), (File)synchronization.getTarget());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Can't synchronize %s -> %s", synchronization.getSource(), synchronization.getTarget()));
            }
        } else {
            try {
                FileUtils.copyFile((File)synchronization.getSource(), (File)synchronization.getTarget());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Can't synchronize %s -> %s", synchronization.getSource(), synchronization.getTarget()));
            }
        }
    }

    protected void ensureOutputExists() {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Can't create " + this.outputDirectory.getPath()));
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public boolean isHeaderFooter() {
        return this.headerFooter;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public void setTemplateDir(File templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public String getImagesDir() {
        return this.imagesDir;
    }

    public void setImagesDir(String imagesDir) {
        this.imagesDir = imagesDir;
    }

    public String getSourceHighlighter() {
        return this.sourceHighlighter;
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.sourceHighlighter = sourceHighlighter;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public String getEruby() {
        return this.eruby;
    }

    public void setEruby(String eruby) {
        this.eruby = eruby;
    }

    public File getSourceDocumentName() {
        return this.sourceDocumentName;
    }

    public void setSourceDocumentName(File sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    public List<Synchronization> getSynchronizations() {
        return this.synchronizations;
    }

    public void setSynchronizations(List<Synchronization> synchronizations) {
        this.synchronizations = synchronizations;
    }

    private static class CustomExtensionDirectoryWalker
    extends DirectoryWalker {
        private final List<String> extensions;

        public CustomExtensionDirectoryWalker(String absolutePath, List<String> extensions) {
            super(absolutePath);
            this.extensions = extensions;
        }

        protected boolean isAcceptedFile(File filename) {
            String name = filename.getName();
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

