/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.asciidoctor.AbstractDirectoryWalker;
import org.asciidoctor.AsciiDocDirectoryWalker;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.maven.Synchronization;
import org.asciidoctor.maven.extensions.AsciidoctorJExtensionRegistry;
import org.asciidoctor.maven.extensions.ExtensionConfiguration;

@Mojo(name="process-asciidoc")
public class AsciidoctorMojo
extends AbstractMojo {
    protected static final String ASCIIDOC_REG_EXP_EXTENSION = ".*\\.a((sc(iidoc)?)|d(oc)?)$";
    @Parameter(property="asciidoctor.sourceDir", defaultValue="${basedir}/src/main/asciidoc", required=true)
    protected File sourceDirectory;
    @Parameter(property="asciidoctor.outputDir", defaultValue="${project.build.directory}/generated-docs", required=true)
    protected File outputDirectory;
    @Parameter(property="asciidoctor.preserveDirectories", defaultValue="false", required=false)
    protected boolean preserveDirectories = false;
    @Parameter(property="asciidoctor.relativeBaseDir", defaultValue="false", required=false)
    protected boolean relativeBaseDir = false;
    @Parameter(property="asciidoctor.projectDirectory", defaultValue="${basedir}", required=false, readonly=false)
    protected File projectDirectory;
    @Parameter(property="asciidoctor.rootDir", defaultValue="${basedir}", required=false, readonly=false)
    protected File rootDir;
    @Parameter(property="asciidoctor.baseDir", required=false)
    protected File baseDir;
    @Parameter(property="asciidoctor.skip", required=false)
    protected boolean skip = false;
    @Parameter(property="asciidoctor.gemPath", defaultValue="", required=false)
    protected String gemPath = "";
    @Parameter(property="asciidoctor.requires")
    protected List<String> requires = new ArrayList<String>();
    @Parameter(property="asciidoctor.attributes", required=false)
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    @Parameter(property="asciidoctor.backend", defaultValue="docbook", required=true)
    protected String backend = "";
    @Parameter(property="asciidoctor.doctype", required=false)
    protected String doctype;
    @Parameter(property="asciidoctor.eruby", required=false)
    protected String eruby = "";
    @Parameter(property="asciidoctor.headerFooter", required=false)
    protected boolean headerFooter = true;
    @Parameter(property="asciidoctor.templateDir", required=false)
    protected File templateDir;
    @Parameter(property="asciidoctor.templateEngine", required=false)
    protected String templateEngine;
    @Parameter(property="asciidoctor.imagesDir", required=false)
    protected String imagesDir = "images";
    @Parameter(property="asciidoctor.sourceHighlighter", required=false)
    protected String sourceHighlighter = "";
    @Parameter(property="asciidoctor.title", required=false)
    protected String title = "";
    @Parameter(property="asciidoctor.sourceDocumentName", required=false)
    protected String sourceDocumentName;
    @Parameter(property="asciidoctor.sourceDocumentExtensions")
    protected List<String> sourceDocumentExtensions = new ArrayList<String>();
    @Parameter(property="asciidoctor.synchronizations", required=false)
    protected List<Synchronization> synchronizations = new ArrayList<Synchronization>();
    @Parameter(property="asciidoctor.extensions")
    protected List<ExtensionConfiguration> extensions = new ArrayList<ExtensionConfiguration>();
    @Parameter(property="asciidoctor.embedAssets")
    protected boolean embedAssets = false;
    @Parameter(property="asciidoctor.attributeMissing")
    protected String attributeMissing = "skip";
    @Parameter(property="asciidoctor.attributeUndefined")
    protected String attributeUndefined = "drop-line";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"AsciiDoc processing is skipped.");
            return;
        }
        if (this.sourceDirectory == null) {
            throw new MojoExecutionException("Required parameter 'asciidoctor.sourceDir' not set.");
        }
        this.ensureOutputExists();
        Asciidoctor asciidoctor = this.getAsciidoctorInstance(this.gemPath);
        asciidoctor.requireLibraries(this.requires);
        OptionsBuilder optionsBuilder = OptionsBuilder.options().backend(this.backend).safe(SafeMode.UNSAFE).headerFooter(this.headerFooter).eruby(this.eruby).mkDirs(true);
        this.setOptions(optionsBuilder);
        AttributesBuilder attributesBuilder = AttributesBuilder.attributes();
        this.setAttributesOnBuilder(attributesBuilder);
        optionsBuilder.attributes(attributesBuilder);
        AsciidoctorJExtensionRegistry extensionRegistry = new AsciidoctorJExtensionRegistry(asciidoctor);
        for (ExtensionConfiguration extension : this.extensions) {
            try {
                extensionRegistry.register(extension.getClassName(), extension.getBlockName());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        if (this.sourceDocumentName == null) {
            for (File f : this.scanSourceFiles()) {
                this.setDestinationPaths(optionsBuilder, f);
                this.renderFile(asciidoctor, optionsBuilder.asMap(), f);
            }
        } else {
            File sourceFile = new File(this.sourceDirectory, this.sourceDocumentName);
            this.setDestinationPaths(optionsBuilder, sourceFile);
            this.renderFile(asciidoctor, optionsBuilder.asMap(), sourceFile);
        }
        try {
            FileUtils.copyDirectory((File)this.sourceDirectory, (File)this.outputDirectory, (FileFilter)new NonAsciiDocExtensionFileFilter(), (boolean)false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying resources", (Exception)e);
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            this.synchronize();
        }
    }

    private void setDestinationPaths(OptionsBuilder optionsBuilder, File sourceFile) throws MojoExecutionException {
        try {
            if (this.baseDir != null) {
                optionsBuilder.baseDir(this.baseDir);
            } else if (this.relativeBaseDir) {
                optionsBuilder.baseDir(sourceFile.getParentFile());
            } else {
                optionsBuilder.baseDir(this.sourceDirectory);
            }
            if (this.preserveDirectories) {
                String propostalPath = sourceFile.getParentFile().getCanonicalPath().substring(this.sourceDirectory.getCanonicalPath().length());
                File relativePath = new File(this.outputDirectory.getCanonicalPath() + propostalPath);
                optionsBuilder.toDir(relativePath).destinationDir(relativePath);
            } else {
                optionsBuilder.toDir(this.outputDirectory).destinationDir(this.outputDirectory);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to locate output directory", (Exception)e);
        }
    }

    protected Asciidoctor getAsciidoctorInstance(String gemPath) throws MojoExecutionException {
        String gemHomeExpected;
        Asciidoctor asciidoctor = null;
        if (gemPath == null) {
            asciidoctor = Asciidoctor.Factory.create();
        } else {
            String normalizedGemPath = File.separatorChar == '\\' ? gemPath.replaceAll("\\\\", "/") : gemPath;
            asciidoctor = Asciidoctor.Factory.create((String)normalizedGemPath);
        }
        String gemHome = JRubyRuntimeContext.get().evalScriptlet("ENV['GEM_HOME']").toString();
        String string = gemHomeExpected = gemPath == null || "".equals(gemPath) ? "" : gemPath.split(File.pathSeparator)[0];
        if (!"".equals(gemHome) && !gemHomeExpected.equals(gemHome)) {
            this.getLog().warn((CharSequence)("Using inherited external environment to resolve gems (" + gemHome + "), i.e. build is platform dependent!"));
        }
        return asciidoctor;
    }

    private List<File> scanSourceFiles() {
        List asciidoctorFiles;
        Object directoryWalker;
        if (this.sourceDocumentExtensions == null || this.sourceDocumentExtensions.isEmpty()) {
            directoryWalker = new AsciiDocDirectoryWalker(this.sourceDirectory.getAbsolutePath());
            asciidoctorFiles = directoryWalker.scan();
        } else {
            directoryWalker = new CustomExtensionDirectoryWalker(this.sourceDirectory.getAbsolutePath(), this.sourceDocumentExtensions);
            asciidoctorFiles = directoryWalker.scan();
        }
        String absoluteSourceDirectory = this.sourceDirectory.getAbsolutePath();
        Iterator iter = asciidoctorFiles.iterator();
        block0: while (iter.hasNext()) {
            File f = (File)iter.next();
            while (!absoluteSourceDirectory.equals(f.getAbsolutePath())) {
                if (f.getName().startsWith("_")) {
                    iter.remove();
                    continue block0;
                }
                if ((f = f.getParentFile()) != null) continue;
                continue block0;
            }
        }
        return asciidoctorFiles;
    }

    private void synchronize() {
        for (Synchronization synchronization : this.synchronizations) {
            this.synchronize(synchronization);
        }
    }

    protected void renderFile(Asciidoctor asciidoctor, Map<String, Object> options, File f) {
        asciidoctor.renderFile(f, options);
        this.logRenderedFile(f);
    }

    protected void logRenderedFile(File f) {
        this.getLog().info((CharSequence)("Rendered " + f.getAbsolutePath()));
    }

    protected void synchronize(Synchronization synchronization) {
        if (synchronization.getSource().isDirectory()) {
            try {
                FileUtils.copyDirectory((File)synchronization.getSource(), (File)synchronization.getTarget());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Can't synchronize %s -> %s", synchronization.getSource(), synchronization.getTarget()));
            }
        } else {
            try {
                FileUtils.copyFile((File)synchronization.getSource(), (File)synchronization.getTarget());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Can't synchronize %s -> %s", synchronization.getSource(), synchronization.getTarget()));
            }
        }
    }

    protected void ensureOutputExists() {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Can't create " + this.outputDirectory.getPath()));
        }
    }

    protected void setOptions(OptionsBuilder optionsBuilder) {
        if (this.doctype != null) {
            optionsBuilder.docType(this.doctype);
        }
        if (this.templateEngine != null) {
            optionsBuilder.templateEngine(this.templateEngine);
        }
        if (this.templateDir != null) {
            optionsBuilder.templateDir(this.templateDir);
        }
    }

    protected void setAttributesOnBuilder(AttributesBuilder attributesBuilder) throws MojoExecutionException {
        if (this.sourceHighlighter != null) {
            attributesBuilder.sourceHighlighter(this.sourceHighlighter);
        }
        if (this.embedAssets) {
            attributesBuilder.linkCss(false);
            attributesBuilder.dataUri(true);
        }
        if (this.imagesDir != null) {
            attributesBuilder.imagesDir(this.imagesDir);
        }
        if (!("skip".equals(this.attributeMissing) || "drop".equals(this.attributeMissing) || "drop-line".equals(this.attributeMissing))) {
            throw new MojoExecutionException(this.attributeMissing + " is not valid. Must be one of 'skip', 'drop' or 'drop-line'");
        }
        attributesBuilder.attributeMissing(this.attributeMissing);
        if (!"drop".equals(this.attributeUndefined) && !"drop-line".equals(this.attributeUndefined)) {
            throw new MojoExecutionException(this.attributeUndefined + " is not valid. Must be one of 'drop' or 'drop-line'");
        }
        attributesBuilder.attributeUndefined(this.attributeUndefined);
        for (Map.Entry<String, Object> attributeEntry : this.attributes.entrySet()) {
            Object val = attributeEntry.getValue();
            if (val == null || "true".equals(val)) {
                attributesBuilder.attribute(attributeEntry.getKey(), (Object)"");
                continue;
            }
            if ("false".equals(val)) {
                attributesBuilder.attribute(attributeEntry.getKey(), null);
                continue;
            }
            if (val instanceof Boolean) {
                attributesBuilder.attribute(attributeEntry.getKey(), (Object)Attributes.toAsciidoctorFlag((boolean)((Boolean)val)));
                continue;
            }
            attributesBuilder.attribute(attributeEntry.getKey(), val);
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isHeaderFooter() {
        return this.headerFooter;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public void setTemplateDir(File templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public String getImagesDir() {
        return this.imagesDir;
    }

    public void setImagesDir(String imagesDir) {
        this.imagesDir = imagesDir;
    }

    public String getSourceHighlighter() {
        return this.sourceHighlighter;
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.sourceHighlighter = sourceHighlighter;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getSourceDocumentExtensions() {
        return this.sourceDocumentExtensions;
    }

    public void setSourceDocumentExtensions(List<String> sourceDocumentExtensions) {
        this.sourceDocumentExtensions = sourceDocumentExtensions;
    }

    public String getEruby() {
        return this.eruby;
    }

    public void setEruby(String eruby) {
        this.eruby = eruby;
    }

    public String getSourceDocumentName() {
        return this.sourceDocumentName;
    }

    public void setSourceDocumentName(String sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    public List<Synchronization> getSynchronizations() {
        return this.synchronizations;
    }

    public void setSynchronizations(List<Synchronization> synchronizations) {
        this.synchronizations = synchronizations;
    }

    public boolean isEmbedAssets() {
        return this.embedAssets;
    }

    public void setEmbedAssets(boolean embedAssets) {
        this.embedAssets = embedAssets;
    }

    public String getAttributeMissing() {
        return this.attributeMissing;
    }

    public void setAttributeMissing(String attributeMissing) {
        this.attributeMissing = attributeMissing;
    }

    public String getAttributeUndefined() {
        return this.attributeUndefined;
    }

    public void setAttributeUndefined(String attributeUndefined) {
        this.attributeUndefined = attributeUndefined;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public String getGemPath() {
        return this.gemPath;
    }

    public void setGemPath(String gemPath) {
        this.gemPath = gemPath;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setPreserveDirertories(boolean preserveDirertories) {
        this.preserveDirectories = preserveDirertories;
    }

    public void setRelativeBaseDir(boolean relativeBaseDir) {
        this.relativeBaseDir = relativeBaseDir;
    }

    public List<ExtensionConfiguration> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ExtensionConfiguration> extensions) {
        this.extensions = extensions;
    }

    private static class NonAsciiDocExtensionFileFilter
    implements FileFilter {
        private final List<String> fileExtensions = Arrays.asList("ad", "adoc", "asciidoc");

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            for (String extension : this.fileExtensions) {
                if (!name.endsWith(extension)) continue;
                return false;
            }
            return true;
        }
    }

    private static class CustomExtensionDirectoryWalker
    extends AbstractDirectoryWalker {
        private final List<String> fileExtensions;

        public CustomExtensionDirectoryWalker(String absolutePath, List<String> fileExtensions) {
            super(absolutePath);
            this.fileExtensions = fileExtensions;
        }

        protected boolean isAcceptedFile(File filename) {
            String name = filename.getName();
            for (String extension : this.fileExtensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

