/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.io.IOException;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.log.LogRecord;

public class LogRecordHelper {
    public static final String ASCIIDOCTOR_LOG_FORMAT = "asciidoctor: %s: %s: line %s: %s";

    public static String format(LogRecord logRecord) {
        Cursor cursor = logRecord.getCursor();
        return String.format(ASCIIDOCTOR_LOG_FORMAT, logRecord.getSeverity(), cursor.getFile(), cursor.getLineNumber(), logRecord.getMessage());
    }

    public static String format(LogRecord logRecord, File sourceDirectory) {
        String relativePath;
        Cursor cursor = logRecord.getCursor();
        try {
            relativePath = new File(cursor.getFile()).getCanonicalPath().substring(sourceDirectory.getCanonicalPath().length() + 1);
        }
        catch (IOException e) {
            relativePath = cursor.getFile();
        }
        return String.format(ASCIIDOCTOR_LOG_FORMAT, logRecord.getSeverity(), relativePath, cursor.getLineNumber(), logRecord.getMessage());
    }
}

