/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.maven.AsciidoctorRefreshMojo;
import org.asciidoctor.maven.http.AsciidoctorHttpServer;
import org.asciidoctor.maven.io.IO;

@Mojo(name="http")
public class AsciidoctorHttpMojo
extends AsciidoctorRefreshMojo {
    public static final String PREFIX = "asciidoctor.http.";
    @Parameter(property="asciidoctor.http.home", required=false, defaultValue="index")
    protected String home;
    @Parameter(property="asciidoctor.http.reload-interval", required=false, defaultValue="0")
    protected int autoReloadInterval;

    @Override
    protected void doWork() throws MojoFailureException, MojoExecutionException {
        AsciidoctorHttpServer server = new AsciidoctorHttpServer(this.getLog(), this.port, this.outputDirectory, this.home);
        server.start();
        super.doWork();
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void convertFile(Asciidoctor asciidoctorInstance, Map<String, Object> options, File f) {
        block8: {
            block9: {
                asciidoctorInstance.convertFile(f, options);
                if (this.autoReloadInterval <= 0 || !this.backend.toLowerCase().startsWith("html")) break block9;
                String filename = f.getName();
                File out = new File(this.outputDirectory, filename.substring(0, filename.lastIndexOf(".")) + ".html");
                if (!out.exists()) break block8;
                String content = null;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(out);
                    content = IO.slurp(fis);
                }
                catch (Exception e) {
                    try {
                        this.getLog().error((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
                IOUtils.closeQuietly((InputStream)fis);
                if (content == null) break block8;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(out);
                    fos.write(this.addRefreshing(content).getBytes());
                }
                catch (Exception e) {
                    try {
                        this.getLog().error((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                    break block8;
                }
                IOUtils.closeQuietly((OutputStream)fos);
                break block8;
                break block8;
            }
            asciidoctorInstance.convertFile(f, options);
        }
        this.logConvertedFile(f);
    }

    private String addRefreshing(String html) {
        return html.replace("</body>", "<script>setTimeout(\"location.reload(true);\"," + this.autoReloadInterval + ");</script>\n</body>");
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }
}

