/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class AsciidoctorHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final String HTML_MEDIA_TYPE = "text/html";
    public static final String HTML_EXTENSION = ".html";
    private final File directory;
    private final String defaultPage;

    public AsciidoctorHandler(File workDir, String defaultPage) {
        this.directory = workDir;
        this.defaultPage = defaultPage.contains(".") ? defaultPage : AsciidoctorHandler.addDefaultExtension(defaultPage);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        ByteBuf body;
        if (msg.method() != HttpMethod.GET && msg.method() != HttpMethod.HEAD) {
            this.send(ctx, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED));
            return;
        }
        File file = this.deduceFile(msg.uri());
        if (!file.exists()) {
            ByteBuf body2 = Unpooled.copiedBuffer((CharSequence)("<body><html>File not found: " + file.getPath() + "<body></html>"), (Charset)CharsetUtil.UTF_8);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, body2);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HTML_MEDIA_TYPE);
            this.send(ctx, response);
            return;
        }
        if (msg.method() == HttpMethod.HEAD) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.RESET_CONTENT);
            HttpHeaders headers = response.headers();
            headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)file.length());
            headers.set((CharSequence)HttpHeaderNames.EXPIRES, (Object)0);
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HTML_MEDIA_TYPE);
            this.send(ctx, response);
            return;
        }
        if (file.getName().endsWith("html")) {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            body = Unpooled.copiedBuffer((CharSequence)this.addRefreshing(content), (Charset)CharsetUtil.UTF_8);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream fileInputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)baos);
            body = Unpooled.copiedBuffer((byte[])FileUtils.readFileToByteArray((File)file));
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, body);
        response.headers().set("Content-Type", (Object)AsciidoctorHandler.mediaType(file.getName()));
        this.send(ctx, response);
    }

    private String addRefreshing(String html) {
        return html.replace("</body>", "<script src=\"http://livejs.com/live.js#html\"></script></body>");
    }

    private void send(ChannelHandlerContext ctx, DefaultFullHttpResponse response) {
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private File deduceFile(String path) {
        if (path.isEmpty() || "/".equals(path)) {
            return new File(this.directory, this.defaultPage);
        }
        return new File(this.directory, path.contains(".") ? path : AsciidoctorHandler.addDefaultExtension(path));
    }

    private static String addDefaultExtension(String path) {
        return path + HTML_EXTENSION;
    }

    private static String mediaType(String name) {
        if (name.endsWith(HTML_EXTENSION)) {
            return HTML_MEDIA_TYPE;
        }
        if (name.endsWith(".js")) {
            return "text/javascript";
        }
        if (name.endsWith(".css")) {
            return "text/css";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".jpeg") || name.endsWith(".jpg")) {
            return "image/jpeg";
        }
        return "application/octet-stream";
    }
}

