/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.inject.Inject;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordsProcessors;
import org.asciidoctor.maven.log.MemoryLogHandler;
import org.asciidoctor.maven.site.HeadParser;
import org.asciidoctor.maven.site.HeaderMetadata;
import org.asciidoctor.maven.site.LogHandlerFactory;
import org.asciidoctor.maven.site.SiteConversionConfiguration;
import org.asciidoctor.maven.site.SiteConversionConfigurationParser;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Parser.class, hint="asciidoc")
public class AsciidoctorAstDoxiaParser
extends AbstractTextParser {
    public static final String ROLE_HINT = "asciidoc";
    private static final Logger logger = LoggerFactory.getLogger(AsciidoctorAstDoxiaParser.class);
    private final MavenProject mavenProject;
    private final SiteConversionConfigurationParser siteConfigParser;
    private final LogHandlerFactory logHandlerFactory;

    @Inject
    public AsciidoctorAstDoxiaParser(MavenProject mavenProject, SiteConversionConfigurationParser siteConfigParser, LogHandlerFactory logHandlerFactory) {
        this.mavenProject = mavenProject;
        this.siteConfigParser = siteConfigParser;
        this.logHandlerFactory = logHandlerFactory;
    }

    public void parse(Reader reader, Sink sink, String reference) throws ParseException {
        String source;
        try {
            source = IOUtil.toString((Reader)reader);
            if (source == null) {
                source = "";
            }
        }
        catch (IOException ex) {
            logger.error("Could not read AsciiDoc source: {}", (Object)ex.getLocalizedMessage());
            return;
        }
        SiteConversionConfiguration conversionConfig = this.siteConfigParser.processAsciiDocConfig(this.mavenProject, ROLE_HINT);
        Xpp3Dom siteConfig = conversionConfig.getAsciidocConfig();
        File siteDirectory = conversionConfig.getSiteBaseDir();
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        for (String require : conversionConfig.getRequires()) {
            this.requireLibrary(asciidoctor, require);
        }
        if (StringUtils.isNotBlank((CharSequence)reference)) {
            logger.debug("Document loaded: {}", (Object)reference);
        }
        LogHandler logHandler = this.logHandlerFactory.getConfiguration(siteConfig);
        MemoryLogHandler memoryLogHandler = this.logHandlerFactory.create(asciidoctor, siteDirectory, logger);
        Document document = asciidoctor.load(source, conversionConfig.getOptions());
        try {
            if (!memoryLogHandler.isEmpty()) {
                logger.info("Issues found in: {}", (Object)reference);
                if (logHandler.getOutputToConsole().booleanValue() && StringUtils.isNotBlank((CharSequence)reference)) {
                    memoryLogHandler.processAll();
                }
                new LogRecordsProcessors(logHandler, siteDirectory, arg_0 -> ((Logger)logger).error(arg_0)).processLogRecords(memoryLogHandler);
            }
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
        new HeadParser(sink).parse(HeaderMetadata.from((Document)document));
        new NodeSinker(sink).sink((StructuralNode)document);
    }

    private void requireLibrary(Asciidoctor asciidoctor, String require) {
        if (!(require = require.trim()).isEmpty()) {
            try {
                asciidoctor.requireLibrary(new String[]{require});
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage());
            }
        }
    }
}

