/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser.processors;

import java.util.List;
import org.apache.maven.doxia.sink.Sink;
import org.asciidoctor.ast.DescriptionList;
import org.asciidoctor.ast.DescriptionListEntry;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.maven.site.parser.NodeProcessor;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.asciidoctor.maven.site.parser.processors.AbstractSinkNodeProcessor;

public class DescriptionListNodeProcessor
extends AbstractSinkNodeProcessor
implements NodeProcessor {
    public DescriptionListNodeProcessor(Sink sink, NodeSinker nodeSinker) {
        super(sink, nodeSinker);
    }

    @Override
    public boolean applies(StructuralNode node) {
        return "dlist".equals(node.getNodeName());
    }

    @Override
    public boolean isTerminal(StructuralNode node) {
        return true;
    }

    @Override
    public void process(StructuralNode node) {
        List items = ((DescriptionList)node).getItems();
        Sink sink = this.getSink();
        if (!items.isEmpty()) {
            sink.definitionList();
            for (DescriptionListEntry item : items) {
                ListItem term = (ListItem)item.getTerms().get(0);
                sink.definedTerm();
                sink.rawText(term.getText());
                sink.definedTerm_();
                ListItem description = item.getDescription();
                sink.definition();
                if (description.getBlocks().isEmpty()) {
                    sink.rawText(description.getText());
                } else {
                    super.sink((StructuralNode)description);
                }
                sink.definition_();
            }
            sink.definitionList_();
        }
    }
}

