/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser.processors;

import org.apache.maven.doxia.sink.Sink;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.site.parser.NodeProcessor;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.asciidoctor.maven.site.parser.processors.AbstractSinkNodeProcessor;
import org.asciidoctor.maven.site.parser.processors.Styles;
import org.asciidoctor.maven.site.parser.processors.TitleCaptionExtractor;

public class ListingNodeProcessor
extends AbstractSinkNodeProcessor
implements NodeProcessor {
    private static final String FLUIDO_SKIN_SOURCE_HIGHLIGHTER = "prettyprint";
    private static final String LINENUMS_ATTRIBUTE = "linenums";
    private static final String LINENUMS_OPTION_ATTRIBUTE = "linenums-option";

    public ListingNodeProcessor(Sink sink, NodeSinker nodeSinker) {
        super(sink, nodeSinker);
    }

    @Override
    public boolean applies(StructuralNode node) {
        return "listing".equals(node.getNodeName());
    }

    @Override
    public void process(StructuralNode node) {
        String style;
        StringBuilder contentBuilder = new StringBuilder();
        String language = (String)node.getAttribute((Object)"language");
        boolean isSourceBlock = this.isSourceBlock(language, style = node.getStyle());
        if (isSourceBlock) {
            contentBuilder.append("<div class=\"source\">");
            ListingNodeProcessor.processTitle(node, contentBuilder);
            contentBuilder.append("<pre class=\"").append(FLUIDO_SKIN_SOURCE_HIGHLIGHTER);
            if (this.isLinenumsEnabled(node)) {
                contentBuilder.append(" linenums");
            }
            contentBuilder.append("\">");
            contentBuilder.append("<code>");
        } else {
            contentBuilder.append("<div>");
            contentBuilder.append("<pre>");
        }
        contentBuilder.append((String)node.getContent());
        if (isSourceBlock) {
            contentBuilder.append("</code>");
        }
        contentBuilder.append("</pre></div>");
        this.getSink().rawText(contentBuilder.toString());
    }

    private static void processTitle(StructuralNode node, StringBuilder contentBuilder) {
        String title = TitleCaptionExtractor.getText(node);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            contentBuilder.append("<div style=\"" + Styles.CAPTION + "\" >" + title + "</div>");
        }
    }

    private boolean isLinenumsEnabled(StructuralNode node) {
        return LINENUMS_ATTRIBUTE.equals(node.getAttribute((Object)LINENUMS_ATTRIBUTE)) || node.getAttribute((Object)LINENUMS_OPTION_ATTRIBUTE) != null;
    }

    private boolean isSourceBlock(String language, String style) {
        return StringUtils.isNotBlank((CharSequence)language) || "source".equals(style);
    }
}

