/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser.processors;

import org.apache.maven.doxia.sink.Sink;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.jruby.ast.impl.SectionImpl;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.site.parser.NodeProcessor;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.asciidoctor.maven.site.parser.processors.AbstractSinkNodeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionNodeProcessor
extends AbstractSinkNodeProcessor
implements NodeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SectionNodeProcessor.class);

    public SectionNodeProcessor(Sink sink, NodeSinker nodeSinker) {
        super(sink, nodeSinker);
    }

    @Override
    public boolean applies(StructuralNode node) {
        return "section".equals(node.getNodeName());
    }

    @Override
    public void process(StructuralNode node) {
        Sink sink = this.getSink();
        String title = node.getTitle();
        String formattedTitle = this.formatTitle(title, (Section)node);
        sink.division();
        int level = node.getLevel();
        if (level == 0) {
            if (StringUtils.isNotBlank((CharSequence)formattedTitle)) {
                sink.sectionTitle1();
                sink.rawText(formattedTitle);
                sink.sectionTitle1_();
            }
        } else {
            int siteLevel = level + 1;
            if (level >= 5) {
                logger.warn("Site module does not support level 6 sections. Re-writing as 5");
                siteLevel = 5;
            }
            sink.sectionTitle(siteLevel, null);
            this.anchor(sink, (Section)node);
            sink.rawText(formattedTitle);
            sink.sectionTitle_(siteLevel);
        }
        node.getBlocks().forEach(this::sink);
        sink.division_();
    }

    private void anchor(Sink sink, Section node) {
        sink.anchor(node.getId());
        sink.anchor_();
    }

    private String formatTitle(String title, Section node) {
        boolean numbered = node.isNumbered();
        Long sectnumlevels = this.getSectnumlevels(node);
        int level = node.getLevel();
        if (numbered && (long)level <= sectnumlevels) {
            String caption = node.getCaption();
            String sectnum = ((SectionImpl)node).getString("sectnum", new Object[0]);
            if (StringUtils.isBlank((CharSequence)caption)) {
                return String.format("%s %s", sectnum, title);
            }
            return String.format("%s %s", caption.trim(), title);
        }
        return title;
    }

    private Long getSectnumlevels(Section node) {
        Object sectnumlevels = node.getDocument().getAttribute((Object)"sectnumlevels");
        if (sectnumlevels != null) {
            if (sectnumlevels instanceof String) {
                return Long.valueOf((String)sectnumlevels);
            }
            if (sectnumlevels instanceof Long) {
                return (Long)sectnumlevels;
            }
        }
        return 3L;
    }
}

