/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.ContentPart;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.DocumentHeader;
import org.asciidoctor.ast.DocumentRuby;
import org.asciidoctor.ast.StructuredDocument;
import org.asciidoctor.ast.Title;
import org.asciidoctor.converter.JavaConverterRegistry;
import org.asciidoctor.converter.internal.ConverterRegistryExecutor;
import org.asciidoctor.extension.ExtensionGroup;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.RubyExtensionRegistry;
import org.asciidoctor.extension.internal.ExtensionRegistryExecutor;
import org.asciidoctor.internal.AsciidoctorCoreException;
import org.asciidoctor.internal.AsciidoctorModule;
import org.asciidoctor.internal.AsciidoctorUtils;
import org.asciidoctor.internal.EnvironmentInjector;
import org.asciidoctor.internal.ExtensionGroupImpl;
import org.asciidoctor.internal.IOUtils;
import org.asciidoctor.internal.JRubyAsciidoctorModuleFactory;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.internal.RubyGemsPreloader;
import org.asciidoctor.internal.RubyHashUtil;
import org.asciidoctor.internal.RubyUtils;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.internal.JULLogHandler;
import org.asciidoctor.log.internal.JavaLogger;
import org.asciidoctor.log.internal.LogHandlerRegistryExecutor;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.ScriptingContainer;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;

public class JRubyAsciidoctor
implements Asciidoctor,
LogHandler {
    private static final Logger logger = Logger.getLogger(JRubyAsciidoctor.class.getName());
    private static final String GEM_PATH = "GEM_PATH";
    private static final int DEFAULT_MAX_LEVEL = 1;
    private AsciidoctorModule asciidoctorModule;
    protected RubyGemsPreloader rubyGemsPreloader;
    protected Ruby rubyRuntime;
    private List<LogHandler> logHandlers = new ArrayList<LogHandler>();
    private static final Logger LOGGER = Logger.getLogger("asciidoctorj");

    private JRubyAsciidoctor(AsciidoctorModule asciidoctorModule, Ruby rubyRuntime) {
        this.asciidoctorModule = asciidoctorModule;
        this.rubyRuntime = rubyRuntime;
        this.rubyGemsPreloader = new RubyGemsPreloader(this.rubyRuntime);
        this.logHandlers.add(new JULLogHandler());
    }

    public static Asciidoctor create() {
        return JRubyAsciidoctor.create((String)null);
    }

    public static Asciidoctor create(String gemPath) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(GEM_PATH, gemPath);
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(env);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        JRubyAsciidoctor.registerConverters(asciidoctor);
        JRubyAsciidoctor.registerLogHandlers(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(List<String> loadPaths) {
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(loadPaths);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        JRubyAsciidoctor.registerConverters(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(ClassLoader classloader) {
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(classloader, null);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        return asciidoctor;
    }

    public static Asciidoctor create(ClassLoader classloader, String gemPath) {
        Asciidoctor asciidoctor = JRubyAsciidoctor.createJRubyAsciidoctorInstance(classloader, gemPath);
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        JRubyAsciidoctor.registerConverters(asciidoctor);
        return asciidoctor;
    }

    private static void registerConverters(Asciidoctor asciidoctor) {
        new ConverterRegistryExecutor(asciidoctor).registerAllConverters();
    }

    private static void registerExtensions(Asciidoctor asciidoctor) {
        new ExtensionRegistryExecutor(asciidoctor).registerAllExtensions();
    }

    private static void registerLogHandlers(Asciidoctor asciidoctor) {
        new LogHandlerRegistryExecutor(asciidoctor).registerAllLogHandlers();
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(List<String> loadPaths) {
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        Ruby rubyRuntime = JavaEmbedUtils.initialize(loadPaths, (RubyInstanceConfig)config);
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        JavaLogger.install(rubyRuntime, jRubyAsciidoctor);
        return jRubyAsciidoctor;
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(Map<String, String> environmentVars) {
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        JRubyAsciidoctor.injectEnvironmentVariables(config, environmentVars);
        Ruby rubyRuntime = JavaEmbedUtils.initialize(Collections.emptyList(), (RubyInstanceConfig)config);
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        JavaLogger.install(rubyRuntime, jRubyAsciidoctor);
        return jRubyAsciidoctor;
    }

    private static Asciidoctor createJRubyAsciidoctorInstance(ClassLoader classloader, String gemPath) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(GEM_PATH, gemPath);
        ScriptingContainer container = new ScriptingContainer();
        JRubyAsciidoctor.injectEnvironmentVariables(container.getProvider().getRubyInstanceConfig(), env);
        container.setClassLoader(classloader);
        Ruby rubyRuntime = container.getProvider().getRuntime();
        JRubyRuntimeContext.set(rubyRuntime);
        JRubyAsciidoctorModuleFactory jRubyAsciidoctorModuleFactory = new JRubyAsciidoctorModuleFactory(rubyRuntime);
        AsciidoctorModule asciidoctorModule = jRubyAsciidoctorModuleFactory.createAsciidoctorModule();
        JRubyAsciidoctor jRubyAsciidoctor = new JRubyAsciidoctor(asciidoctorModule, rubyRuntime);
        JavaLogger.install(rubyRuntime, jRubyAsciidoctor);
        return jRubyAsciidoctor;
    }

    private static void injectEnvironmentVariables(RubyInstanceConfig config, Map<String, String> environmentVars) {
        EnvironmentInjector environmentInjector = new EnvironmentInjector(config);
        environmentInjector.inject(environmentVars);
    }

    private static RubyInstanceConfig createOptimizedConfiguration() {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setCompatVersion(CompatVersion.RUBY2_0);
        config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
        return config;
    }

    private DocumentHeader toDocumentHeader(DocumentRuby documentRuby) {
        HashMap<Object, Object> opts = new HashMap<Object, Object>();
        opts.put("partition", true);
        Document document = new Document(documentRuby, this.rubyRuntime);
        return DocumentHeader.createDocumentHeader((Title)document.doctitle(opts), documentRuby.getTitle(), documentRuby.getAttributes());
    }

    private StructuredDocument toDocument(DocumentRuby documentRuby, Ruby rubyRuntime, int maxDeepLevel) {
        Document document = new Document(documentRuby, rubyRuntime);
        List<ContentPart> contentParts = this.getContents(document.getBlocks(), 1, maxDeepLevel);
        return StructuredDocument.createStructuredDocument(this.toDocumentHeader(documentRuby), contentParts);
    }

    private List<ContentPart> getContents(List<AbstractBlock> blocks, int level, int maxDeepLevel) {
        if (level > maxDeepLevel) {
            return null;
        }
        ArrayList<ContentPart> parts = new ArrayList<ContentPart>();
        for (AbstractBlock block : blocks) {
            parts.add(this.getContentPartFromBlock(block, level, maxDeepLevel));
        }
        return parts;
    }

    private ContentPart getContentPartFromBlock(AbstractBlock child, int level, int maxDeepLevel) {
        Object content = child.getContent();
        String textContent = content instanceof String ? (String)content : child.convert();
        ContentPart contentPart = ContentPart.createContentPart(child.id(), level, child.getContext(), child.getTitle(), child.getStyle(), child.getRole(), child.getAttributes(), textContent);
        contentPart.setParts(this.getContents(child.getBlocks(), level + 1, maxDeepLevel));
        return contentPart;
    }

    @Override
    public StructuredDocument readDocumentStructure(File filename, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        DocumentRuby documentRuby = this.asciidoctorModule.load_file(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
        int maxDeepLevel = options.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(documentRuby, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(String content, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        DocumentRuby documentRuby = this.asciidoctorModule.load(content, (Map<String, Object>)rubyHash);
        int maxDeepLevel = options.containsKey("STRUCTURE_MAX_LEVEL") ? (Integer)options.get("STRUCTURE_MAX_LEVEL") : 1;
        return this.toDocument(documentRuby, this.rubyRuntime, maxDeepLevel);
    }

    @Override
    public StructuredDocument readDocumentStructure(Reader contentReader, Map<String, Object> options) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentStructure(content, options);
    }

    @Override
    public DocumentHeader readDocumentHeader(File filename) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load_file(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
        return this.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(String content) {
        RubyHash rubyHash = this.getParseHeaderOnlyOption();
        DocumentRuby documentRuby = this.asciidoctorModule.load(content, (Map<String, Object>)rubyHash);
        return this.toDocumentHeader(documentRuby);
    }

    @Override
    public DocumentHeader readDocumentHeader(Reader contentReader) {
        String content = IOUtils.readFull(contentReader);
        return this.readDocumentHeader(content);
    }

    private RubyHash getParseHeaderOnlyOption() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("parse_header_only", true);
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        return rubyHash;
    }

    @Override
    @Deprecated
    public String render(String content, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        logger.fine(AsciidoctorUtils.toAsciidoctorCommand(options, "-"));
        if (AsciidoctorUtils.isOptionWithAttribute(options, "source-highlighter", "pygments")) {
            logger.fine("In order to use Pygments with Asciidoctor, you need to install Pygments (and Python, if you don't have it yet). Read http://asciidoctor.org/news/#syntax-highlighting-with-pygments.");
        }
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        if (options.containsKey("base_dir")) {
            this.rubyRuntime.setCurrentDirectory((String)options.get("base_dir"));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        try {
            Object object = this.asciidoctorModule.convert(content, (Map<String, Object>)rubyHash);
            String string = this.returnExpectedValue(object);
            return string;
        }
        catch (RaiseException e) {
            logger.severe(e.getException().getClass().getCanonicalName());
            throw new AsciidoctorCoreException(e);
        }
        finally {
            this.rubyRuntime.setCurrentDirectory(currentDirectory);
        }
    }

    @Override
    @Deprecated
    public String renderFile(File filename, Map<String, Object> options) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options);
        logger.fine(AsciidoctorUtils.toAsciidoctorCommand(options, filename.getAbsolutePath()));
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        if (options.containsKey("base_dir")) {
            this.rubyRuntime.setCurrentDirectory((String)options.get("base_dir"));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        try {
            Object object = this.asciidoctorModule.convertFile(filename.getAbsolutePath(), (Map<String, Object>)rubyHash);
            String string = this.returnExpectedValue(object);
            return string;
        }
        catch (RaiseException e) {
            logger.severe(e.getMessage());
            throw new AsciidoctorCoreException(e);
        }
        finally {
            this.rubyRuntime.setCurrentDirectory(currentDirectory);
        }
    }

    private String returnExpectedValue(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        return null;
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, Map<String, Object> options) throws IOException {
        String content = IOUtils.readFull(contentReader);
        String renderedContent = this.render(content, options);
        IOUtils.writeFull(rendererWriter, renderedContent);
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, Map<String, Object> options) {
        List<String> asciidoctorContent = this.renderAllFiles(options, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, Options options) {
        return this.renderFiles(asciidoctorFiles, options.map());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, Map<String, Object> options) {
        List<File> asciidoctorFiles = this.scanForAsciiDocFiles(directoryWalker);
        List<String> asciidoctorContent = this.renderAllFiles(options, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[asciidoctorContent.size()]);
    }

    private List<String> renderAllFiles(Map<String, Object> options, Collection<File> asciidoctorFiles) {
        ArrayList<String> asciidoctorContent = new ArrayList<String>();
        for (File asciidoctorFile : asciidoctorFiles) {
            String renderedFile = this.renderFile(asciidoctorFile, options);
            if (renderedFile == null) continue;
            asciidoctorContent.add(renderedFile);
        }
        return asciidoctorContent;
    }

    private List<File> scanForAsciiDocFiles(DirectoryWalker directoryWalker) {
        List<File> asciidoctorFiles = directoryWalker.scan();
        return asciidoctorFiles;
    }

    @Override
    @Deprecated
    public String render(String content, Options options) {
        return this.render(content, options.map());
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, Options options) throws IOException {
        this.render(contentReader, rendererWriter, options.map());
    }

    @Override
    @Deprecated
    public String renderFile(File filename, Options options) {
        return this.renderFile(filename, options.map());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, Options options) {
        return this.renderDirectory(directoryWalker, options.map());
    }

    @Override
    @Deprecated
    public String render(String content, OptionsBuilder options) {
        return this.render(content, options.asMap());
    }

    @Override
    @Deprecated
    public void render(Reader contentReader, Writer rendererWriter, OptionsBuilder options) throws IOException {
        this.render(contentReader, rendererWriter, options.asMap());
    }

    @Override
    @Deprecated
    public String renderFile(File filename, OptionsBuilder options) {
        return this.renderFile(filename, options.asMap());
    }

    @Override
    @Deprecated
    public String[] renderDirectory(DirectoryWalker directoryWalker, OptionsBuilder options) {
        return this.renderDirectory(directoryWalker, options.asMap());
    }

    @Override
    @Deprecated
    public String[] renderFiles(Collection<File> asciidoctorFiles, OptionsBuilder options) {
        return this.renderFiles(asciidoctorFiles, options.asMap());
    }

    @Override
    public void requireLibrary(String ... library) {
        this.requireLibraries(Arrays.asList(library));
    }

    @Override
    public void requireLibraries(Collection<String> libraries) {
        if (libraries != null) {
            for (String library : libraries) {
                RubyUtils.requireLibrary(this.rubyRuntime, library);
            }
        }
    }

    @Override
    public JavaExtensionRegistry javaExtensionRegistry() {
        return new JavaExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public RubyExtensionRegistry rubyExtensionRegistry() {
        return new RubyExtensionRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public JavaConverterRegistry javaConverterRegistry() {
        return new JavaConverterRegistry(this.asciidoctorModule, this.rubyRuntime);
    }

    @Override
    public void unregisterAllExtensions() {
        this.asciidoctorModule.unregister_all_extensions();
    }

    @Override
    public void shutdown() {
        this.rubyRuntime.tearDown();
    }

    @Override
    public String asciidoctorVersion() {
        return this.asciidoctorModule.asciidoctorRuntimeEnvironmentVersion();
    }

    @Override
    public String convert(String content, Map<String, Object> options) {
        return this.render(content, options);
    }

    @Override
    public String convert(String content, Options options) {
        return this.render(content, options);
    }

    @Override
    public String convert(String content, OptionsBuilder options) {
        return this.render(content, options);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, Map<String, Object> options) throws IOException {
        this.render(contentReader, rendererWriter, options);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, Options options) throws IOException {
        this.render(contentReader, rendererWriter, options);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, OptionsBuilder options) throws IOException {
        this.render(contentReader, rendererWriter, options);
    }

    @Override
    public String convertFile(File filename, Map<String, Object> options) {
        return this.renderFile(filename, options);
    }

    @Override
    public String convertFile(File filename, Options options) {
        return this.renderFile(filename, options);
    }

    @Override
    public String convertFile(File filename, OptionsBuilder options) {
        return this.renderFile(filename, options);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, Map<String, Object> options) {
        return this.renderDirectory(directoryWalker, options);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, Options options) {
        return this.renderDirectory(directoryWalker, options);
    }

    @Override
    public String[] convertDirectory(DirectoryWalker directoryWalker, OptionsBuilder options) {
        return this.renderDirectory(directoryWalker, options);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, Map<String, Object> options) {
        return this.renderFiles(asciidoctorFiles, options);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, Options options) {
        return this.renderFiles(asciidoctorFiles, options);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, OptionsBuilder options) {
        return this.renderFiles(asciidoctorFiles, options);
    }

    @Override
    public Document load(String content, Map<String, Object> options) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        return new Document(this.asciidoctorModule.load(content, (Map<String, Object>)rubyHash), this.rubyRuntime);
    }

    @Override
    public Document loadFile(File file, Map<String, Object> options) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options);
        return new Document(this.asciidoctorModule.load_file(file.getAbsolutePath(), (Map<String, Object>)rubyHash), this.rubyRuntime);
    }

    @Override
    public void registerLogHandler(LogHandler logHandler) {
        if (!this.logHandlers.contains(logHandler)) {
            this.logHandlers.add(logHandler);
        }
    }

    @Override
    public void unregisterLogHandler(LogHandler logHandler) {
        this.logHandlers.remove(logHandler);
    }

    Ruby getRubyRuntime() {
        return this.rubyRuntime;
    }

    AsciidoctorModule getAsciidoctorModule() {
        return this.asciidoctorModule;
    }

    @Override
    public ExtensionGroup createGroup() {
        return new ExtensionGroupImpl(UUID.randomUUID().toString(), this);
    }

    @Override
    public ExtensionGroup createGroup(String groupName) {
        return new ExtensionGroupImpl(groupName, this);
    }

    @Override
    public void log(LogRecord logRecord) {
        for (LogHandler logHandler : this.logHandlers) {
            try {
                logHandler.log(logRecord);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unexpected exception while logging Asciidoctor log entry", e);
            }
        }
    }
}

