/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.InputStream;
import org.asciidoctor.internal.IOUtils;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubySymbol;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyUtils {
    public static <T> T rubyToJava(Ruby runtime, IRubyObject rubyObject, Class<T> returnType) {
        return (T)JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)rubyObject, returnType);
    }

    public static RubySymbol toSymbol(Ruby rubyRuntime, String key) {
        RubySymbol newSymbol = RubySymbol.newSymbol((Ruby)rubyRuntime, (String)key);
        return newSymbol;
    }

    public static RubyClass toRubyClass(Ruby rubyRuntime, Class<?> rubyClass) {
        return JavaClass.get((Ruby)rubyRuntime, rubyClass).getProxyClass();
    }

    public static void requireLibrary(Ruby rubyRuntime, String require) {
        rubyRuntime.evalScriptlet(String.format("require '%s'", require));
    }

    public static void loadRubyClass(Ruby rubyRuntime, InputStream rubyClassDefinition) {
        String script = IOUtils.readFull(rubyClassDefinition);
        rubyRuntime.evalScriptlet(script);
    }

    public static final void setGlobalVariable(Ruby rubyRuntime, String variableName, Object variableValue) {
        String script = String.format("$%s = %s", variableName, variableValue);
        rubyRuntime.evalScriptlet(script);
    }

    public static <T> T invokeRubyMethod(Object target, String methodName, Object[] args, Class<T> resultType) {
        IRubyObject rubyObject = null;
        if (target instanceof RubyObjectHolderProxy) {
            rubyObject = ((RubyObjectHolderProxy)RubyObjectHolderProxy.class.cast(target)).__ruby_object();
        } else if (target instanceof IRubyObject) {
            rubyObject = (IRubyObject)target;
        }
        if (rubyObject != null) {
            return (T)JavaEmbedUtils.invokeMethod((Ruby)rubyObject.getRuntime(), (Object)rubyObject, (String)methodName, (Object[])args, resultType);
        }
        throw new IllegalArgumentException("Target is a " + target.getClass() + " instead of a Ruby object.");
    }
}

