/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.DescriptionList;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.NodeConverter;
import org.asciidoctor.ast.PhraseNode;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.ast.impl.ColumnImpl;
import org.asciidoctor.ast.impl.ContentNodeImpl;
import org.asciidoctor.ast.impl.DescriptionListImpl;
import org.asciidoctor.ast.impl.DocumentImpl;
import org.asciidoctor.ast.impl.ListImpl;
import org.asciidoctor.ast.impl.RowImpl;
import org.asciidoctor.ast.impl.StructuralNodeImpl;
import org.asciidoctor.extension.Reader;
import org.asciidoctor.extension.ReaderImpl;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.internal.RubyHashUtil;
import org.asciidoctor.internal.RubyObjectWrapper;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

public class Processor {
    @Deprecated
    public static final String CONTENT_MODEL = "content_model";
    @Deprecated
    public static final String CONTENT_MODEL_COMPOUND = ":compound";
    @Deprecated
    public static final String CONTENT_MODEL_SIMPLE = ":simple";
    @Deprecated
    public static final String CONTENT_MODEL_VERBATIM = ":verbatim";
    @Deprecated
    public static final String CONTENT_MODEL_RAW = ":raw";
    @Deprecated
    public static final String CONTENT_MODEL_SKIP = ":skip";
    @Deprecated
    public static final String CONTENT_MODEL_EMPTY = ":empty";
    @Deprecated
    public static final String CONTENT_MODEL_ATTRIBUTES = ":attributes";
    protected Map<String, Object> config;
    private boolean configFinalized = false;

    public Processor() {
        this(new HashMap<String, Object>());
    }

    public Processor(Map<String, Object> config) {
        this.config = new HashMap<String, Object>(config);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public final void setConfig(Map<String, Object> config) {
        if (this.configFinalized) {
            throw new IllegalStateException("It is only allowed to set the config in the constructor!");
        }
        this.config = config;
    }

    public final void updateConfig(Map<String, Object> config) {
        this.config.putAll(config);
    }

    public final void setConfigFinalized() {
        this.configFinalized = true;
    }

    public Table createTable(StructuralNode parent) {
        return this.createTable(parent, new HashMap<String, Object>());
    }

    public Table createTable(StructuralNode parent, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash rubyAttributes = RubyHash.newHash((Ruby)rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters = new IRubyObject[]{((StructuralNodeImpl)parent).getRubyObject(), rubyAttributes};
        Table ret = (Table)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_CLASS, parameters);
        ret.setAttr("rowcount", 0, false);
        return ret;
    }

    public Row createTableRow(Table parent) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyArray rubyRow = rubyRuntime.newArray();
        return new RowImpl((IRubyObject)rubyRow);
    }

    public Column createTableColumn(Table parent, int index) {
        return this.createTableColumn(parent, index, new HashMap<String, Object>());
    }

    public Column createTableColumn(Table parent, int index, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash rubyAttributes = RubyHash.newHash((Ruby)rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters = new IRubyObject[]{((StructuralNodeImpl)((Object)parent)).getRubyObject(), RubyFixnum.newFixnum((Ruby)rubyRuntime, (long)index), rubyAttributes};
        return (Column)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_COLUMN_CLASS, parameters);
    }

    public Cell createTableCell(Column column, String text) {
        return this.createTableCell(column, text, new HashMap<String, Object>());
    }

    public Cell createTableCell(Column column, Document innerDocument) {
        return this.createTableCell(column, innerDocument, new HashMap<String, Object>());
    }

    public Cell createTableCell(Column column, Document innerDocument, Map<String, Object> attributes) {
        Cell cell = this.createTableCell(column, (String)null, attributes);
        cell.setStyle("asciidoc");
        cell.setInnerDocument(innerDocument);
        return cell;
    }

    public Cell createTableCell(Column column, String text, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(column);
        RubyHash rubyAttributes = RubyHash.newHash((Ruby)rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters = new IRubyObject[]{((ColumnImpl)column).getRubyObject(), text != null ? rubyRuntime.newString(text) : rubyRuntime.getNil(), rubyAttributes};
        return (Cell)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_CELL_CLASS, parameters);
    }

    public Block createBlock(StructuralNode parent, String context, String content) {
        return this.createBlock(parent, context, content, new HashMap<String, Object>(), new HashMap<Object, Object>());
    }

    public Block createBlock(StructuralNode parent, String context, String content, Map<String, Object> attributes) {
        return this.createBlock(parent, context, content, attributes, new HashMap<Object, Object>());
    }

    public Block createBlock(StructuralNode parent, String context, String content, Map<String, Object> attributes, Map<Object, Object> options) {
        options.put("source", content);
        options.put("attributes", attributes);
        return this.createBlock(parent, context, options);
    }

    public Block createBlock(StructuralNode parent, String context, List<String> content) {
        return this.createBlock(parent, context, content, new HashMap<String, Object>(), new HashMap<Object, Object>());
    }

    public Block createBlock(StructuralNode parent, String context, List<String> content, Map<String, Object> attributes) {
        return this.createBlock(parent, context, content, attributes, new HashMap<Object, Object>());
    }

    public Block createBlock(StructuralNode parent, String context, List<String> content, Map<String, Object> attributes, Map<Object, Object> options) {
        options.put("source", content);
        options.put("attributes", new HashMap<String, Object>(attributes));
        return this.createBlock(parent, context, options);
    }

    public Section createSection(StructuralNode parent) {
        return this.createSection(parent, null, true, new HashMap<Object, Object>());
    }

    public Section createSection(StructuralNode parent, Map<Object, Object> options) {
        return this.createSection(parent, null, true, options);
    }

    public Section createSection(StructuralNode parent, boolean numbered, Map<Object, Object> options) {
        return this.createSection(parent, null, numbered, options);
    }

    public Section createSection(StructuralNode parent, int level, boolean numbered, Map<Object, Object> options) {
        return this.createSection(parent, (Integer)level, numbered, options);
    }

    public PhraseNode createPhraseNode(ContentNode parent, String context, List<String> text) {
        return this.createPhraseNode(parent, context, text, new HashMap<String, Object>());
    }

    public PhraseNode createPhraseNode(ContentNode parent, String context, List<String> text, Map<String, Object> attributes) {
        return this.createPhraseNode(parent, context, text, attributes, new HashMap<Object, Object>());
    }

    public PhraseNode createPhraseNode(ContentNode parent, String context, List<String> text, Map<String, Object> attributes, Map<Object, Object> options) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        options.put("attributes", attributes);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, options);
        RubyArray rubyText = rubyRuntime.newArray();
        rubyText.addAll(text);
        IRubyObject[] parameters = new IRubyObject[]{((ContentNodeImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), rubyText, convertMapToRubyHashWithSymbols};
        return (PhraseNode)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.INLINE_CLASS, parameters);
    }

    public PhraseNode createPhraseNode(ContentNode parent, String context, String text) {
        return this.createPhraseNode(parent, context, text, new HashMap<String, Object>());
    }

    public PhraseNode createPhraseNode(ContentNode parent, String context, String text, Map<String, Object> attributes) {
        return this.createPhraseNode(parent, context, text, attributes, new HashMap<String, Object>());
    }

    public PhraseNode createPhraseNode(ContentNode parent, String context, String text, Map<String, Object> attributes, Map<String, Object> options) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        options.put("attributes", RubyHashUtil.convertMapToRubyHashWithStrings(rubyRuntime, attributes));
        RubyHash convertedOptions = RubyHashUtil.convertMapToRubyHashWithSymbols(rubyRuntime, options);
        IRubyObject[] parameters = new IRubyObject[]{((ContentNodeImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), text == null ? rubyRuntime.getNil() : rubyRuntime.newString(text), convertedOptions};
        return (PhraseNode)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.INLINE_CLASS, parameters);
    }

    private Block createBlock(StructuralNode parent, String context, Map<Object, Object> options) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, this.filterBlockOptions(parent, options, "subs", CONTENT_MODEL));
        IRubyObject[] parameters = new IRubyObject[]{((StructuralNodeImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), convertMapToRubyHashWithSymbols};
        return (Block)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.BLOCK_CLASS, parameters);
    }

    private Map<Object, Object> filterBlockOptions(StructuralNode parent, Map<Object, Object> options, String ... optionNames) {
        HashMap<Object, Object> copy = new HashMap<Object, Object>(options);
        Ruby ruby = JRubyRuntimeContext.get(parent);
        for (String optionName : optionNames) {
            Object optionValue = copy.get(optionName);
            if (optionValue == null) continue;
            if (optionValue instanceof String) {
                copy.put(optionName, this.getRubySymbol(ruby, (String)optionValue));
                continue;
            }
            if (!(optionValue instanceof List)) continue;
            List valueList = (List)optionValue;
            ArrayList<Object> newValueList = new ArrayList<Object>(valueList.size());
            for (Object v : valueList) {
                if (v instanceof String) {
                    newValueList.add(this.getRubySymbol(ruby, (String)v));
                    continue;
                }
                newValueList.add(v);
            }
            copy.put(optionName, newValueList);
        }
        return copy;
    }

    private RubySymbol getRubySymbol(Ruby ruby, String s) {
        return ruby.newSymbol(s.startsWith(":") ? s.substring(1) : s);
    }

    private Section createSection(StructuralNode parent, Integer level, boolean numbered, Map<Object, Object> options) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, options);
        IRubyObject[] parameters = new IRubyObject[]{((StructuralNodeImpl)parent).getRubyObject(), level == null ? rubyRuntime.getNil() : rubyRuntime.newFixnum(level.intValue()), rubyRuntime.newBoolean(numbered), convertMapToRubyHashWithSymbols};
        return (Section)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.SECTION_CLASS, parameters);
    }

    public Document createDocument(Document parentDocument) {
        Ruby runtime = JRubyRuntimeContext.get(parentDocument);
        RubyHash options = RubyHash.newHash((Ruby)runtime);
        options.put((Object)runtime.newSymbol("parent"), (Object)((DocumentImpl)parentDocument).getRubyObject());
        return (Document)NodeConverter.createASTNode(runtime, NodeConverter.NodeType.DOCUMENT_CLASS, new IRubyObject[]{runtime.getNil(), options});
    }

    public ListItem createListItem(org.asciidoctor.ast.List parent, String text) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        return (ListItem)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.LIST_ITEM_CLASS, new IRubyObject[]{((ListImpl)ListImpl.class.cast(parent)).getRubyObject(), rubyRuntime.newString(text)});
    }

    public ListItem createListItem(DescriptionList parent, String text) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        return (ListItem)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.LIST_ITEM_CLASS, new IRubyObject[]{((DescriptionListImpl)DescriptionListImpl.class.cast(parent)).getRubyObject(), rubyRuntime.newString(text)});
    }

    public void parseContent(StructuralNode parent, List<String> lines) {
        Ruby runtime = JRubyRuntimeContext.get(parent);
        Parser parser = new Parser(runtime, parent, ReaderImpl.createReader(runtime, lines));
        StructuralNode nextBlock = parser.nextBlock();
        while (nextBlock != null) {
            parent.append(nextBlock);
            nextBlock = parser.nextBlock();
        }
    }

    private class Parser
    extends RubyObjectWrapper {
        private final Reader reader;
        private final StructuralNode parent;

        public Parser(Ruby runtime, StructuralNode parent, Reader reader) {
            super((IRubyObject)runtime.getModule("Asciidoctor").getClass("Parser"));
            this.reader = reader;
            this.parent = parent;
        }

        public StructuralNode nextBlock() {
            if (!this.reader.hasMoreLines()) {
                return null;
            }
            IRubyObject nextBlock = this.getRubyProperty("next_block", this.reader, ((StructuralNodeImpl)this.parent).getRubyObject());
            if (nextBlock.isNil()) {
                return null;
            }
            return (StructuralNode)NodeConverter.createASTNode(nextBlock);
        }
    }
}

