/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.DirectoryWalker;

public abstract class AbstractDirectoryWalker
implements DirectoryWalker {
    private final String baseDir;

    public AbstractDirectoryWalker(String baseDir) {
        this.baseDir = baseDir;
    }

    public List<File> scan() {
        File baseDirFile = new File(this.baseDir);
        List<File> includedFiles = this.walkDirectory(baseDirFile);
        return includedFiles;
    }

    private List<File> walkDirectory(File parentDir) {
        ArrayList<File> includedAsciidocFiles = new ArrayList<File>();
        File[] listOfCurrentFiles = parentDir.listFiles();
        if (listOfCurrentFiles != null) {
            for (File currentFile : listOfCurrentFiles) {
                if (currentFile.isDirectory()) {
                    if (currentFile.getName().startsWith(".") || currentFile.getName().startsWith("_")) continue;
                    List<File> asciidocFiles = this.walkDirectory(currentFile);
                    includedAsciidocFiles.addAll(asciidocFiles);
                    continue;
                }
                if (!this.isAcceptedFile(currentFile)) continue;
                includedAsciidocFiles.add(currentFile);
            }
        }
        return includedAsciidocFiles;
    }

    protected abstract boolean isAcceptedFile(File var1);
}

