/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyOutputStreamWrapper
extends RubyObject {
    public static final String RUBY_CLASS_NAME = "OutputStreamWrapper";
    private OutputStream out;
    private int bytesWritten = 0;

    public static IRubyObject wrap(Ruby rubyRuntime, OutputStream out) {
        RubyClass rubyClass = RubyOutputStreamWrapper.getOrCreateOutputStreamWrapperClass(rubyRuntime);
        IRubyObject wrapper = rubyClass.allocate();
        ((RubyOutputStreamWrapper)wrapper).setOut(out);
        return wrapper;
    }

    public RubyOutputStreamWrapper(Ruby rubyRuntime, RubyClass rubyClass) {
        super(rubyRuntime, rubyClass);
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public static RubyClass getOrCreateOutputStreamWrapperClass(Ruby rubyRuntime) {
        RubyModule asciidoctorModule = rubyRuntime.getModule("AsciidoctorJ");
        RubyClass outputStreamWrapperClass = asciidoctorModule.getClass(RUBY_CLASS_NAME);
        if (outputStreamWrapperClass != null) {
            return outputStreamWrapperClass;
        }
        RubyClass rubyClass = asciidoctorModule.defineClassUnder(RUBY_CLASS_NAME, rubyRuntime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new RubyOutputStreamWrapper(runtime, klazz);
            }
        });
        rubyClass.defineAnnotatedMethods(RubyOutputStreamWrapper.class);
        return rubyClass;
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject arg) throws IOException {
        this.writeToStream(arg);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext context, IRubyObject arg) throws IOException {
        this.writeToStream(arg);
        return this;
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args) throws IOException {
        this.writeToStream(RubyKernel.sprintf((ThreadContext)context, null, (IRubyObject[])args));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) throws IOException {
        return context.getRuntime().newFixnum(this.bytesWritten);
    }

    private void writeToStream(IRubyObject arg) throws IOException {
        byte[] bytes = this.convertToBytes(arg);
        this.out.write(bytes);
        this.bytesWritten += bytes.length;
    }

    private byte[] convertToBytes(IRubyObject arg) {
        if (arg instanceof RubyString) {
            return ((RubyString)arg).getBytes();
        }
        if (arg instanceof RubyNumeric) {
            return arg.asString().getBytes();
        }
        throw new IllegalArgumentException("Don't know how to write a " + arg + " " + arg.getClass());
    }
}

