/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.jruby.internal.RubyHashMapDecorator;
import org.asciidoctor.jruby.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashUtil {
    private RubyHashUtil() {
    }

    public static RubyHash convertMapToRubyHashWithSymbolsIfNecessary(Ruby rubyRuntime, Map<Object, Object> options) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<Object, Object>> optionsSet = options.entrySet();
        for (Map.Entry<Object, Object> entry : optionsSet) {
            Object keyType = entry.getKey();
            if (RubyHashUtil.isNotARubySymbol(keyType)) {
                CharSequence key = (CharSequence)keyType;
                Object value = entry.getValue();
                RubySymbol newSymbol = RubyUtils.toSymbol(rubyRuntime, key.toString());
                IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value);
                rubyHash.put((Object)newSymbol, (Object)iRubyValue);
                continue;
            }
            if (!(keyType instanceof RubySymbol)) continue;
            Object value = entry.getValue();
            IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value);
            rubyHash.put(keyType, (Object)iRubyValue);
        }
        return rubyHash;
    }

    public static RubyHash convertMapToRubyHashWithSymbols(Ruby rubyRuntime, Map<String, Object> options) {
        if (options instanceof RubyHashMapDecorator) {
            return ((RubyHashMapDecorator)options).getRubyHash();
        }
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> optionsSet = options.entrySet();
        for (Map.Entry<String, Object> entry : optionsSet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            RubySymbol newSymbol = RubyUtils.toSymbol(rubyRuntime, key);
            IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value);
            rubyHash.put((Object)newSymbol, (Object)iRubyValue);
        }
        return rubyHash;
    }

    public static RubyHash convertMapToRubyHashWithStrings(Ruby rubyRuntime, Map<String, Object> attributes) {
        if (attributes instanceof RubyHashMapDecorator) {
            return ((RubyHashMapDecorator)attributes).getRubyHash();
        }
        if (attributes instanceof RubyHash) {
            return (RubyHash)attributes;
        }
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> optionsSet = attributes.entrySet();
        for (Map.Entry<String, Object> entry : optionsSet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            RubyString newKey = rubyRuntime.newString(key);
            IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value);
            rubyHash.put((Object)newKey, (Object)iRubyValue);
        }
        return rubyHash;
    }

    private static boolean isNotARubySymbol(Object keyType) {
        return keyType instanceof CharSequence;
    }

    public static Map<Object, Object> convertRubyHashMapToMap(Map<Object, Object> rubyHashMap) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Set<Map.Entry<Object, Object>> elements = rubyHashMap.entrySet();
        for (Map.Entry<Object, Object> element : elements) {
            if (element.getKey() instanceof RubySymbol) {
                map.put(RubyHashUtil.toJavaString((RubySymbol)element.getKey()), RubyHashUtil.toJavaObject(element.getValue()));
                continue;
            }
            map.put(RubyHashUtil.toJavaObject(element.getKey()).toString(), RubyHashUtil.toJavaObject(element.getValue()));
        }
        return map;
    }

    public static Map<String, Object> convertRubyHashMapToStringObjectMap(Map<Object, Object> rubyHashMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<Map.Entry<Object, Object>> elements = rubyHashMap.entrySet();
        for (Map.Entry<Object, Object> element : elements) {
            if (element.getKey() instanceof RubySymbol) {
                map.put(RubyHashUtil.toJavaString((RubySymbol)element.getKey()), RubyHashUtil.toJavaObject(element.getValue()));
                continue;
            }
            if (element.getKey() instanceof RubyString) {
                map.put(((RubyString)element.getKey()).asJavaString(), RubyHashUtil.toJavaObject(element.getValue()));
                continue;
            }
            if (!(element.getKey() instanceof String)) continue;
            map.put((String)element.getKey(), RubyHashUtil.toJavaObject(element.getValue()));
        }
        return map;
    }

    private static String toJavaString(RubySymbol element) {
        return element.asJavaString();
    }

    private static Object toJavaObject(Object rubyObject) {
        if (rubyObject instanceof IRubyObject) {
            IRubyObject iRubyObject = (IRubyObject)rubyObject;
            return JavaEmbedUtils.rubyToJava((IRubyObject)iRubyObject);
        }
        return rubyObject;
    }

    private static IRubyObject toRubyObject(Ruby rubyRuntime, Object value) {
        CharSequence stringValue;
        if (value instanceof List) {
            return RubyHashUtil.toRubyArray(rubyRuntime, (List)value);
        }
        if (value instanceof Map) {
            return RubyHashUtil.convertMapToRubyHashWithStrings(rubyRuntime, (Map)value);
        }
        if (RubyHashUtil.isNotARubySymbol(value) && (stringValue = (CharSequence)value).length() > 0 && stringValue.charAt(0) == ':') {
            return RubyUtils.toSymbol(rubyRuntime, stringValue.subSequence(1, stringValue.length()).toString());
        }
        IRubyObject iRubyObject = JavaEmbedUtils.javaToRuby((Ruby)rubyRuntime, (Object)value);
        return iRubyObject;
    }

    private static IRubyObject toRubyArray(Ruby rubyRuntime, List<Object> values) {
        RubyArray rubyArray = RubyArray.newArray((Ruby)rubyRuntime, (int)values.size());
        for (Object value : values) {
            rubyArray.add((Object)RubyHashUtil.toRubyObject(rubyRuntime, value));
        }
        return rubyArray;
    }

    public static RubyHash toNoneSymbolsRubyHash(Ruby rubyRuntime, Map<String, Object> map) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            rubyHash.put(RubyHashUtil.toJavaObject(entry.getKey()), RubyHashUtil.toJavaObject(entry.getValue()));
        }
        return rubyHash;
    }
}

