/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.IconRegistry;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.StructureViewRenderer;
import org.aspectj.ajde.ui.swing.StructureTreeManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;

public class BrowserViewPanel
extends JPanel
implements StructureViewRenderer {
    private static final long serialVersionUID = 2201330630036486567L;
    private StructureTreeManager treeManager;
    private JComboBox view_comboBox = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JToolBar view_toolBar = new JToolBar();
    private JSlider depth_slider = new JSlider();
    JScrollPane tree_ScrollPane = new JScrollPane();
    JPanel tree_panel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();

    public BrowserViewPanel(IconRegistry icons, List views, StructureViewProperties.Hierarchy visibleViewHierarchy) {
        try {
            this.view_comboBox = new JComboBox<Object>(views.toArray());
            Iterator it = views.iterator();
            while (it.hasNext()) {
                StructureViewProperties.Hierarchy hierarchy = (StructureViewProperties.Hierarchy)it.next();
                if (hierarchy != visibleViewHierarchy) continue;
                this.view_comboBox.setSelectedItem(hierarchy);
            }
            this.treeManager = new StructureTreeManager();
            this.jbInit();
            this.initDepthSlider();
            this.tree_ScrollPane.getViewport().add((Component)this.treeManager.getStructureTree(), null);
        }
        catch (Exception e) {
            Message msg = new Message("Could not initialize GUI.", IMessage.ERROR, e, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
    }

    public void setActiveNode(IStructureViewNode node) {
        throw new RuntimeException("not implemented");
    }

    public void setActiveNode(IStructureViewNode activeNode, int lineOffset) {
        throw new RuntimeException("not implemented");
    }

    public void updateView(StructureView structureView) {
        if (structureView instanceof GlobalStructureView) {
            this.treeManager.updateTree((GlobalStructureView)structureView);
        }
    }

    void updateTree(String filePath) {
    }

    private void initDepthSlider() {
        this.depth_slider.setMinimum(0);
        this.depth_slider.setMaximum(9);
        this.depth_slider.setMinorTickSpacing(1);
        this.depth_slider.setValue(9);
        this.depth_slider.setSnapToTicks(true);
        this.depth_slider.setPaintTrack(true);
        this.depth_slider.setPaintTicks(true);
    }

    private void view_comboBox_actionPerformed(ActionEvent e) {
        throw new RuntimeException("not implemented");
    }

    private void jbInit() throws Exception {
        this.tree_panel.setLayout(this.borderLayout2);
        this.setLayout(this.borderLayout1);
        this.view_comboBox.setPreferredSize(new Dimension(200, 20));
        this.view_comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserViewPanel.this.view_comboBox_actionPerformed(e);
            }
        });
        this.view_comboBox.setMinimumSize(new Dimension(40, 20));
        this.view_comboBox.setFont(new Font("SansSerif", 0, 11));
        this.depth_slider.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.depth_slider.setToolTipText("");
        this.depth_slider.setMinimumSize(new Dimension(30, 20));
        this.depth_slider.setBorder(null);
        this.depth_slider.setPreferredSize(new Dimension(30, 25));
        this.depth_slider.setMaximum(3);
        this.depth_slider.setPaintTicks(true);
        this.depth_slider.setValue(1);
        this.depth_slider.setPaintLabels(true);
        this.view_toolBar.setFloatable(false);
        this.add((Component)this.view_toolBar, "North");
        this.view_toolBar.add((Component)this.view_comboBox, null);
        this.view_toolBar.add((Component)this.depth_slider, null);
        this.add((Component)this.tree_panel, "Center");
        this.tree_panel.add((Component)this.tree_ScrollPane, "Center");
    }
}

