/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import org.aspectj.ajdt.internal.compiler.ast.InterTypeMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;

public class InterTypeMethodBinding
extends MethodBinding {
    private ReferenceBinding targetType;
    private MethodBinding syntheticMethod;
    public MethodBinding postDispatchMethod;
    public AbstractMethodDeclaration sourceMethod;

    public InterTypeMethodBinding(EclipseFactory world, ResolvedTypeMunger munger, UnresolvedType withinType, AbstractMethodDeclaration sourceMethod) {
        int i;
        ResolvedMember signature = munger.getSignature();
        MethodBinding mb = world.makeMethodBinding(signature, munger.getTypeVariableAliases());
        this.modifiers = mb.modifiers;
        this.selector = mb.selector;
        this.returnType = mb.returnType;
        this.parameters = mb.parameters;
        this.thrownExceptions = mb.thrownExceptions;
        this.typeVariables = mb.typeVariables;
        this.sourceMethod = sourceMethod;
        this.targetType = (ReferenceBinding)world.makeTypeBinding(signature.getDeclaringType());
        this.declaringClass = (ReferenceBinding)world.makeTypeBinding(withinType);
        for (i = 0; i < this.typeVariables.length; ++i) {
            TypeVariableBinding tv = this.typeVariables[i];
            String name = new String(tv.sourceName);
            TypeVariableBinding[] tv2 = sourceMethod.binding.typeVariables;
            for (int j = 0; j < tv2.length; ++j) {
                TypeVariableBinding typeVariable = tv2[j];
                if (!new String(tv2[j].sourceName).equals(name)) continue;
                this.typeVariables[i].declaringElement = this;
            }
        }
        for (i = 0; i < this.typeVariables.length; ++i) {
            if (this.typeVariables[i].declaringElement != null) continue;
            throw new RuntimeException("Declaring element not set");
        }
        if (signature.getKind() == Member.METHOD) {
            this.syntheticMethod = world.makeMethodBinding(AjcMemberMaker.interMethodDispatcher(signature, withinType));
            this.postDispatchMethod = world.makeMethodBinding(AjcMemberMaker.interMethodBody(signature, withinType));
        } else {
            this.postDispatchMethod = this.syntheticMethod = world.makeMethodBinding(AjcMemberMaker.interConstructor(world.getWorld().resolve(signature.getDeclaringType()), signature, withinType));
        }
    }

    public boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        scope.compilationUnitScope().recordTypeReference(this.declaringClass);
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.invocationType();
        if (invocationType == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            throw new RuntimeException("unimplemented");
        }
        if (this.isPrivate()) {
            if (invocationType != this.declaringClass) {
                ReferenceBinding temp;
                ReferenceBinding outerInvocationType = invocationType;
                for (temp = outerInvocationType.enclosingType(); temp != null; temp = temp.enclosingType()) {
                    outerInvocationType = temp;
                }
                ReferenceBinding outerDeclaringClass = this.declaringClass;
                for (temp = outerDeclaringClass.enclosingType(); temp != null; temp = temp.enclosingType()) {
                    outerDeclaringClass = temp;
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        return invocationType.fPackage == this.declaringClass.fPackage;
    }

    public boolean isFinal() {
        if (this.sourceMethod == null || !(this.sourceMethod instanceof InterTypeMethodDeclaration)) {
            return super.isFinal();
        }
        return ((InterTypeMethodDeclaration)this.sourceMethod).isFinal();
    }

    public MethodBinding getAccessMethod(boolean staticReference) {
        if (staticReference) {
            return this.postDispatchMethod;
        }
        return this.syntheticMethod;
    }

    public boolean alwaysNeedsAccessMethod() {
        return true;
    }

    public AbstractMethodDeclaration sourceMethod() {
        return this.sourceMethod;
    }

    public ReferenceBinding getTargetType() {
        return this.targetType;
    }

    public ReferenceBinding getOwningClass() {
        return this.targetType;
    }

    public String toString() {
        return "InterTypeMethodBinding(" + super.toString() + ", " + this.getTargetType() + ")";
    }
}

