/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForMethodBindings;
import org.aspectj.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.IAttribute;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.StackMapFrame;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Messages;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.runtime.internal.AroundClosure;

public class ClassFile
implements TypeConstants,
TypeIds {
    private byte[] bytes;
    public CodeStream codeStream;
    public ConstantPool constantPool;
    public int constantPoolOffset;
    public byte[] contents;
    public int contentsOffset;
    protected boolean creatingProblemType;
    public ClassFile enclosingClassFile;
    public byte[] header;
    public int headerOffset;
    public Set innerClassesBindings;
    public int methodCount;
    public int methodCountOffset;
    public boolean isShared = false;
    public int produceAttributes;
    public SourceTypeBinding referenceBinding;
    public long targetJDK;
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public static final int INNER_CLASSES_SIZE = 5;
    public List extraAttributes = new ArrayList(1);

    public static String buildAllDirectoriesInto(String outputPath, String relativeFileName) throws IOException {
        String fileName;
        String outputDirPath;
        char fileSeparatorChar = File.separatorChar;
        String fileSeparator = File.separator;
        outputPath = outputPath.replace('/', fileSeparatorChar);
        int separatorIndex = (relativeFileName = relativeFileName.replace('/', fileSeparatorChar)).lastIndexOf(fileSeparatorChar);
        if (separatorIndex == -1) {
            if (outputPath.endsWith(fileSeparator)) {
                outputDirPath = outputPath.substring(0, outputPath.length() - 1);
                fileName = String.valueOf(outputPath) + relativeFileName;
            } else {
                outputDirPath = outputPath;
                fileName = String.valueOf(outputPath) + fileSeparator + relativeFileName;
            }
        } else if (outputPath.endsWith(fileSeparator)) {
            outputDirPath = String.valueOf(outputPath) + relativeFileName.substring(0, separatorIndex);
            fileName = String.valueOf(outputPath) + relativeFileName;
        } else {
            outputDirPath = String.valueOf(outputPath) + fileSeparator + relativeFileName.substring(0, separatorIndex);
            fileName = String.valueOf(outputPath) + fileSeparator + relativeFileName;
        }
        File f = new File(outputDirPath);
        f.mkdirs();
        if (f.isDirectory()) {
            return fileName;
        }
        if (outputPath.endsWith(fileSeparator)) {
            outputPath = outputPath.substring(0, outputPath.length() - 1);
        }
        f = new File(outputPath);
        boolean checkFileType = false;
        if (f.exists()) {
            checkFileType = true;
        } else if (!f.mkdirs()) {
            if (f.exists()) {
                checkFileType = true;
            } else {
                throw new IOException(Messages.bind(Messages.output_notValidAll, f.getAbsolutePath()));
            }
        }
        if (checkFileType && !f.isDirectory()) {
            throw new IOException(Messages.bind(Messages.output_isFile, f.getAbsolutePath()));
        }
        StringBuffer outDir = new StringBuffer(outputPath);
        outDir.append(fileSeparator);
        StringTokenizer tokenizer = new StringTokenizer(relativeFileName, fileSeparator);
        String token = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            f = new File(outDir.append(token).append(fileSeparator).toString());
            checkFileType = false;
            if (f.exists()) {
                checkFileType = true;
            } else if (!f.mkdir()) {
                if (f.exists()) {
                    checkFileType = true;
                } else {
                    throw new IOException(Messages.bind(Messages.output_notValid, outDir.substring(outputPath.length() + 1, outDir.length() - 1), outputPath));
                }
            }
            if (checkFileType && !f.isDirectory()) {
                throw new IOException(Messages.bind(Messages.output_isFile, f.getAbsolutePath()));
            }
            token = tokenizer.nextToken();
        }
        return outDir.append(token).toString();
    }

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult unitResult) {
        int i;
        FieldBinding[] fields;
        SourceTypeBinding typeBinding = typeDeclaration.binding;
        ClassFile classFile = ClassFile.getNewInstance(typeBinding);
        classFile.initialize(typeBinding, null, true);
        if (typeBinding.hasMemberTypes()) {
            ReferenceBinding[] members = typeBinding.memberTypes;
            int i2 = 0;
            int l = members.length;
            while (i2 < l) {
                classFile.recordInnerClasses(members[i2]);
                ++i2;
            }
        }
        if (typeBinding.isNestedType()) {
            classFile.recordInnerClasses(typeBinding);
        }
        if ((fields = typeBinding.fields()) != null && fields != Binding.NO_FIELDS) {
            classFile.addFieldInfos();
        } else {
            classFile.contents[classFile.contentsOffset++] = 0;
            classFile.contents[classFile.contentsOffset++] = 0;
        }
        classFile.setForMethodInfos();
        CategorizedProblem[] problems = unitResult.getErrors();
        if (problems == null) {
            problems = new CategorizedProblem[]{};
        }
        int problemsLength = problems.length;
        CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
        System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
        AbstractMethodDeclaration[] methodDecls = typeDeclaration.methods;
        if (methodDecls != null) {
            MethodBinding method;
            AbstractMethodDeclaration methodDecl;
            int length;
            if (typeBinding.isInterface()) {
                classFile.addProblemClinit(problemsCopy);
                i = 0;
                length = methodDecls.length;
                while (i < length) {
                    methodDecl = methodDecls[i];
                    method = methodDecl.binding;
                    if (method != null && !method.isConstructor()) {
                        classFile.addAbstractMethod(methodDecl, method);
                    }
                    ++i;
                }
            } else {
                i = 0;
                length = methodDecls.length;
                while (i < length) {
                    methodDecl = methodDecls[i];
                    method = methodDecl.binding;
                    if (method != null) {
                        if (method.isConstructor()) {
                            classFile.addProblemConstructor(methodDecl, method, problemsCopy);
                        } else {
                            classFile.addProblemMethod(methodDecl, method, problemsCopy);
                        }
                    }
                    ++i;
                }
            }
            classFile.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            i = 0;
            int max = typeDeclaration.memberTypes.length;
            while (i < max) {
                TypeDeclaration memberType = typeDeclaration.memberTypes[i];
                if (memberType.binding != null) {
                    ClassFile.createProblemType(memberType, unitResult);
                }
                ++i;
            }
        }
        classFile.addAttributes();
        unitResult.record(typeBinding.constantPoolName(), classFile);
    }

    public static ClassFile getNewInstance(SourceTypeBinding typeBinding) {
        LookupEnvironment env = typeBinding.scope.environment();
        return env.classFilePool.acquire(typeBinding);
    }

    public static void writeToDisk(boolean generatePackagesStructure, String outputPath, String relativeFileName, ClassFile classFile) throws IOException {
        BufferedOutputStream output = null;
        if (generatePackagesStructure) {
            output = new BufferedOutputStream(new FileOutputStream(new File(ClassFile.buildAllDirectoriesInto(outputPath, relativeFileName))));
        } else {
            String fileName = null;
            char fileSeparatorChar = File.separatorChar;
            String fileSeparator = File.separator;
            outputPath = outputPath.replace('/', fileSeparatorChar);
            int indexOfPackageSeparator = relativeFileName.lastIndexOf(fileSeparatorChar);
            if (indexOfPackageSeparator == -1) {
                fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName : String.valueOf(outputPath) + fileSeparator + relativeFileName;
            } else {
                int length = relativeFileName.length();
                fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName.substring(indexOfPackageSeparator + 1, length) : String.valueOf(outputPath) + fileSeparator + relativeFileName.substring(indexOfPackageSeparator + 1, length);
            }
            output = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
        }
        try {
            output.write(classFile.header, 0, classFile.headerOffset);
            output.write(classFile.contents, 0, classFile.contentsOffset);
            output.flush();
        }
        finally {
            output.close();
        }
    }

    protected ClassFile() {
    }

    public ClassFile(SourceTypeBinding typeBinding) {
        this.constantPool = new ConstantPool(this);
        CompilerOptions options = typeBinding.scope.compilerOptions();
        this.targetJDK = options.targetJDK;
        this.produceAttributes = options.produceDebugAttributes;
        this.referenceBinding = typeBinding;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            this.codeStream = new StackMapFrameCodeStream(this);
        } else {
            this.codeStream = new CodeStream(this);
        }
        this.initByteArrays();
    }

    public void addAbstractMethod(AbstractMethodDeclaration method, MethodBinding methodBinding) {
        methodBinding.modifiers = 1025;
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addAttributes() {
        int numberOfInnerClasses;
        TypeDeclaration typeDeclaration;
        char[] genericSignature;
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int attributeNumber = 0;
        int attributeOffset = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceAttributes & 1) != 0) {
            String fullFileName = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            int lastIndex = (fullFileName = fullFileName.replace('\\', '/')).lastIndexOf(47);
            if (lastIndex != -1) {
                fullFileName = fullFileName.substring(lastIndex + 1, fullFileName.length());
            }
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int sourceAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
            this.contents[this.contentsOffset++] = (byte)(sourceAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)sourceAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int fileNameIndex = this.constantPool.literalIndex(fullFileName.toCharArray());
            this.contents[this.contentsOffset++] = (byte)(fileNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)fileNameIndex;
            ++attributeNumber;
        }
        if (this.referenceBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if ((genericSignature = this.referenceBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int signatureAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(signatureAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int signatureIndex = this.constantPool.literalIndex(genericSignature);
            this.contents[this.contentsOffset++] = (byte)(signatureIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureIndex;
            ++attributeNumber;
        }
        if (this.targetJDK >= 0x310000L && this.referenceBinding.isNestedType() && !this.referenceBinding.isMemberType()) {
            MethodBinding methodBinding;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int enclosingMethodAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.EnclosingMethodName);
            this.contents[this.contentsOffset++] = (byte)(enclosingMethodAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)enclosingMethodAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 4;
            int enclosingTypeIndex = this.constantPool.literalIndexForType(this.referenceBinding.enclosingType().constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(enclosingTypeIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)enclosingTypeIndex;
            byte methodIndexByte1 = 0;
            byte methodIndexByte2 = 0;
            if (this.referenceBinding instanceof LocalTypeBinding && (methodBinding = ((LocalTypeBinding)this.referenceBinding).enclosingMethod) != null) {
                int enclosingMethodIndex = this.constantPool.literalIndexForNameAndType(methodBinding.selector, methodBinding.signature(this));
                methodIndexByte1 = (byte)(enclosingMethodIndex >> 8);
                methodIndexByte2 = (byte)enclosingMethodIndex;
            }
            this.contents[this.contentsOffset++] = methodIndexByte1;
            this.contents[this.contentsOffset++] = methodIndexByte2;
            ++attributeNumber;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (typeDeclaration = this.referenceBinding.scope.referenceContext) != null) {
            Annotation[] annotations = typeDeclaration.originalAnnotations;
            if (annotations == null) {
                annotations = typeDeclaration.annotations;
            }
            if (annotations != null) {
                attributeNumber += this.generateRuntimeAnnotations(annotations);
            }
        }
        if (this.referenceBinding.isHierarchyInconsistent()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int inconsistentHierarchyNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.InconsistentHierarchy);
            this.contents[this.contentsOffset++] = (byte)(inconsistentHierarchyNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)inconsistentHierarchyNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        int n = numberOfInnerClasses = this.innerClassesBindings == null ? 0 : this.innerClassesBindings.size();
        if (numberOfInnerClasses != 0) {
            ReferenceBinding[] innerClasses = new ReferenceBinding[numberOfInnerClasses];
            this.innerClassesBindings.toArray(innerClasses);
            Arrays.sort(innerClasses, new Comparator(){

                public int compare(Object o1, Object o2) {
                    TypeBinding binding1 = (TypeBinding)o1;
                    TypeBinding binding2 = (TypeBinding)o2;
                    return CharOperation.compareTo(binding1.constantPoolName(), binding2.constantPoolName());
                }
            });
            int exSize = 8 * numberOfInnerClasses + 8;
            if (exSize + this.contentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            int attributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
            this.contents[this.contentsOffset++] = (byte)(attributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeNameIndex;
            int value = (numberOfInnerClasses << 3) + 2;
            this.contents[this.contentsOffset++] = (byte)(value >> 24);
            this.contents[this.contentsOffset++] = (byte)(value >> 16);
            this.contents[this.contentsOffset++] = (byte)(value >> 8);
            this.contents[this.contentsOffset++] = (byte)value;
            this.contents[this.contentsOffset++] = (byte)(numberOfInnerClasses >> 8);
            this.contents[this.contentsOffset++] = (byte)numberOfInnerClasses;
            int i = 0;
            while (i < numberOfInnerClasses) {
                ReferenceBinding innerClass = innerClasses[i];
                int accessFlags = innerClass.getAccessFlags();
                int innerClassIndex = this.constantPool.literalIndexForType(innerClass.constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(innerClassIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)innerClassIndex;
                if (innerClass.isMemberType()) {
                    int outerClassIndex = this.constantPool.literalIndexForType(innerClass.enclosingType().constantPoolName());
                    this.contents[this.contentsOffset++] = (byte)(outerClassIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)outerClassIndex;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (!innerClass.isAnonymousType()) {
                    int nameIndex = this.constantPool.literalIndex(innerClass.sourceName());
                    this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)nameIndex;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (innerClass.isAnonymousType()) {
                    accessFlags &= 0xFFFFFFEF;
                } else if (innerClass.isMemberType() && innerClass.isInterface()) {
                    accessFlags |= 8;
                }
                this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
                this.contents[this.contentsOffset++] = (byte)accessFlags;
                ++i;
            }
            ++attributeNumber;
        }
        if (this.extraAttributes != null) {
            int i = 0;
            int len = this.extraAttributes.size();
            while (i < len) {
                IAttribute attribute = (IAttribute)this.extraAttributes.get(i);
                short nameIndex = (short)this.constantPool.literalIndex(attribute.getNameChars());
                this.writeToContents(attribute.getAllBytes(nameIndex));
                ++attributeNumber;
                ++i;
            }
        }
        if (attributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[attributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[attributeOffset] = (byte)attributeNumber;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int constantPoolCount = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(constantPoolCount >> 8);
        this.header[this.constantPoolOffset] = (byte)constantPoolCount;
    }

    public void addDefaultAbstractMethods() {
        MethodBinding[] defaultAbstractMethods = this.referenceBinding.getDefaultAbstractMethods();
        int i = 0;
        int max = defaultAbstractMethods.length;
        while (i < max) {
            this.generateMethodInfoHeader(defaultAbstractMethods[i]);
            int methodAttributeOffset = this.contentsOffset;
            int attributeNumber = this.generateMethodInfoAttribute(defaultAbstractMethods[i]);
            this.completeMethodInfo(methodAttributeOffset, attributeNumber);
            ++i;
        }
    }

    private int addFieldAttributes(FieldBinding fieldBinding, int fieldAttributeOffset) {
        Annotation[] annotations;
        FieldDeclaration fieldDeclaration;
        char[] genericSignature;
        int attributesNumber = 0;
        Constant fieldConstant = fieldBinding.constant();
        if (fieldConstant != Constant.NotAConstant) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int constantValueNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
            this.contents[this.contentsOffset++] = (byte)(constantValueNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)constantValueNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            ++attributesNumber;
            switch (fieldConstant.typeID()) {
                case 5: {
                    int booleanValueIndex = this.constantPool.literalIndex(fieldConstant.booleanValue() ? 1 : 0);
                    this.contents[this.contentsOffset++] = (byte)(booleanValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)booleanValueIndex;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    int integerValueIndex = this.constantPool.literalIndex(fieldConstant.intValue());
                    this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                    break;
                }
                case 9: {
                    int floatValueIndex = this.constantPool.literalIndex(fieldConstant.floatValue());
                    this.contents[this.contentsOffset++] = (byte)(floatValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)floatValueIndex;
                    break;
                }
                case 8: {
                    int doubleValueIndex = this.constantPool.literalIndex(fieldConstant.doubleValue());
                    this.contents[this.contentsOffset++] = (byte)(doubleValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)doubleValueIndex;
                    break;
                }
                case 7: {
                    int longValueIndex = this.constantPool.literalIndex(fieldConstant.longValue());
                    this.contents[this.contentsOffset++] = (byte)(longValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)longValueIndex;
                    break;
                }
                case 11: {
                    int stringValueIndex = this.constantPool.literalIndex(((StringConstant)fieldConstant).stringValue());
                    if (stringValueIndex == -1) {
                        if (!this.creatingProblemType) {
                            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                            FieldDeclaration[] fieldDecls = typeDeclaration.fields;
                            int i = 0;
                            int max = fieldDecls.length;
                            while (i < max) {
                                if (fieldDecls[i].binding == fieldBinding) {
                                    typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDecls[i]);
                                }
                                ++i;
                            }
                            break;
                        }
                        this.contentsOffset = fieldAttributeOffset;
                        break;
                    }
                    this.contents[this.contentsOffset++] = (byte)(stringValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)stringValueIndex;
                }
            }
        }
        if (this.targetJDK < 0x310000L && fieldBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributesNumber;
        }
        if (fieldBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributesNumber;
        }
        if ((genericSignature = fieldBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int signatureAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(signatureAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int signatureIndex = this.constantPool.literalIndex(genericSignature);
            this.contents[this.contentsOffset++] = (byte)(signatureIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureIndex;
            ++attributesNumber;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (fieldDeclaration = fieldBinding.sourceField()) != null && (annotations = fieldDeclaration.annotations) != null) {
            attributesNumber += this.generateRuntimeAnnotations(annotations);
        }
        return attributesNumber;
    }

    private void addFieldInfo(FieldBinding fieldBinding) {
        if (this.contentsOffset + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int accessFlags = fieldBinding.getAccessFlags();
        if (this.targetJDK < 0x310000L) {
            accessFlags &= 0xFFFFEFFF;
        }
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int nameIndex = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(fieldBinding.type);
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
        int fieldAttributeOffset = this.contentsOffset;
        int attributeNumber = 0;
        this.contentsOffset += 2;
        attributeNumber += this.addFieldAttributes(fieldBinding, fieldAttributeOffset);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[fieldAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[fieldAttributeOffset] = (byte)attributeNumber;
    }

    public void addFieldInfos() {
        SourceTypeBinding currentBinding = this.referenceBinding;
        FieldBinding[] syntheticFields = currentBinding.syntheticFields();
        int fieldCount = currentBinding.fieldCount() + (syntheticFields == null ? 0 : syntheticFields.length);
        if (fieldCount > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        this.contents[this.contentsOffset++] = (byte)(fieldCount >> 8);
        this.contents[this.contentsOffset++] = (byte)fieldCount;
        FieldDeclaration[] fieldDecls = currentBinding.scope.referenceContext.fields;
        int i = 0;
        int max = fieldDecls == null ? 0 : fieldDecls.length;
        while (i < max) {
            FieldDeclaration fieldDecl = fieldDecls[i];
            if (fieldDecl.binding != null) {
                this.addFieldInfo(fieldDecl.binding);
            }
            ++i;
        }
        if (syntheticFields != null) {
            i = 0;
            max = syntheticFields.length;
            while (i < max) {
                this.addFieldInfo(syntheticFields[i]);
                ++i;
            }
        }
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, CategorizedProblem problem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("\t" + problem.getMessage() + "\n");
        buffer.insert(0, Messages.compilation_unresolvedProblem);
        String problemString = buffer.toString();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, codeAttributeOffset, compilationResult.getLineSeparatorPositions(), problem.getSourceLineNumber());
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemClinit(CategorizedProblem[] problems) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int attributeOffset = this.contentsOffset;
        this.contentsOffset += 2;
        int attributeNumber = 0;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String problemString = "";
        int problemLine = 0;
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            int i = 0;
            while (i < max) {
                CategorizedProblem problem = problems[i];
                if (problem != null && problem.isError()) {
                    buffer.append("\t" + problem.getMessage() + "\n");
                    ++count;
                    if (problemLine == 0) {
                        problemLine = problem.getSourceLineNumber();
                    }
                    problems[i] = null;
                }
                ++i;
            }
            if (count > 1) {
                buffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                buffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        ++attributeNumber;
        this.completeCodeAttributeForClinit(codeAttributeOffset, problemLine);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[attributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[attributeOffset] = (byte)attributeNumber;
    }

    public void addProblemConstructor(AbstractMethodDeclaration method, MethodBinding methodBinding, CategorizedProblem[] problems) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding, true);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(method, this);
        String problemString = "";
        int problemLine = 0;
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            int i = 0;
            while (i < max) {
                CategorizedProblem problem = problems[i];
                if (problem != null && problem.isError()) {
                    buffer.append("\t" + problem.getMessage() + "\n");
                    ++count;
                    if (problemLine == 0) {
                        problemLine = problem.getSourceLineNumber();
                    }
                }
                ++i;
            }
            if (count > 1) {
                buffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                buffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        MethodBinding methodBinding2 = methodBinding;
        this.completeCodeAttributeForProblemMethod(method, methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody1$advice((ClassFile)this, (MethodBinding)methodBinding2, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding2, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), problemLine);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemConstructor(AbstractMethodDeclaration method, MethodBinding methodBinding, CategorizedProblem[] problems, int savedOffset) {
        this.contentsOffset = savedOffset;
        --this.methodCount;
        this.addProblemConstructor(method, methodBinding, problems);
    }

    public void addProblemMethod(AbstractMethodDeclaration method, MethodBinding methodBinding, CategorizedProblem[] problems) {
        MethodBinding methodBinding2;
        if (methodBinding.isAbstract() && ((ReferenceBinding)ClassFile.declaringClass_aroundBody3$advice(this, methodBinding2 = methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null)).isInterface()) {
            method.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding, true);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(method, this);
        String problemString = "";
        int problemLine = 0;
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            int i = 0;
            while (i < max) {
                CategorizedProblem problem = problems[i];
                if (problem != null && problem.isError() && problem.getSourceStart() >= method.declarationSourceStart && problem.getSourceEnd() <= method.declarationSourceEnd) {
                    buffer.append("\t" + problem.getMessage() + "\n");
                    ++count;
                    if (problemLine == 0) {
                        problemLine = problem.getSourceLineNumber();
                    }
                    problems[i] = null;
                }
                ++i;
            }
            if (count > 1) {
                buffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                buffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        MethodBinding methodBinding3 = methodBinding;
        this.completeCodeAttributeForProblemMethod(method, methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody5$advice((ClassFile)this, (MethodBinding)methodBinding3, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding3, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), problemLine);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemMethod(AbstractMethodDeclaration method, MethodBinding methodBinding, CategorizedProblem[] problems, int savedOffset) {
        this.contentsOffset = savedOffset;
        --this.methodCount;
        this.addProblemMethod(method, methodBinding, problems);
    }

    public void addSpecialMethods() {
        this.generateMissingAbstractMethods(this.referenceBinding.scope.referenceType().missingAbstractMethods, this.referenceBinding.scope.referenceCompilationUnit().compilationResult);
        MethodBinding[] defaultAbstractMethods = this.referenceBinding.getDefaultAbstractMethods();
        int i = 0;
        int max = defaultAbstractMethods.length;
        while (i < max) {
            this.generateMethodInfoHeader(defaultAbstractMethods[i]);
            int methodAttributeOffset = this.contentsOffset;
            int attributeNumber = this.generateMethodInfoAttribute(defaultAbstractMethods[i]);
            this.completeMethodInfo(methodAttributeOffset, attributeNumber);
            ++i;
        }
        SyntheticMethodBinding[] syntheticMethods = this.referenceBinding.syntheticMethods();
        if (syntheticMethods != null) {
            int i2 = 0;
            int max2 = syntheticMethods.length;
            while (i2 < max2) {
                SyntheticMethodBinding syntheticMethod = syntheticMethods[i2];
                switch (syntheticMethod.kind) {
                    case 1: {
                        this.addSyntheticFieldReadAccessMethod(syntheticMethod);
                        break;
                    }
                    case 2: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticMethod);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        this.addSyntheticMethodAccessMethod(syntheticMethod);
                        break;
                    }
                    case 4: {
                        this.addSyntheticConstructorAccessMethod(syntheticMethod);
                        break;
                    }
                    case 7: {
                        this.addSyntheticEnumValuesMethod(syntheticMethod);
                        break;
                    }
                    case 8: {
                        this.addSyntheticEnumValueOfMethod(syntheticMethod);
                        break;
                    }
                    case 9: {
                        this.addSyntheticSwitchTable(syntheticMethod);
                    }
                }
                ++i2;
            }
        }
    }

    public void addSyntheticConstructorAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody7$advice((ClassFile)this, (SyntheticMethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticEnumValueOfMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValueOf(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody9$advice((ClassFile)this, (SyntheticMethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticEnumValuesMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValues(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody11$advice((ClassFile)this, (SyntheticMethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody13$advice((ClassFile)this, (SyntheticMethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody15$advice((ClassFile)this, (SyntheticMethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticMethodAccessMethod(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody17$advice((ClassFile)this, (SyntheticMethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void addSyntheticSwitchTable(SyntheticMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        int codeAttributeOffset = this.contentsOffset;
        ++attributeNumber;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForSwitchTable(methodBinding);
        SyntheticMethodBinding syntheticMethodBinding = methodBinding;
        this.completeCodeAttributeForSyntheticMethod(true, methodBinding, codeAttributeOffset, ((SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody19$advice((ClassFile)this, (SyntheticMethodBinding)syntheticMethodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)syntheticMethodBinding, null))).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public void completeCodeAttribute(int codeAttributeOffset) {
        Set framesPositions;
        int framesPositionsSize;
        int numberOfFrames;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        ExceptionLabel[] exceptionLabels = this.codeStream.exceptionLabels;
        int exceptionHandlersCount = 0;
        int i = 0;
        int length = this.codeStream.exceptionLabelsCounter;
        while (i < length) {
            exceptionHandlersCount += this.codeStream.exceptionLabels[i].count / 2;
            ++i;
        }
        int exSize = exceptionHandlersCount * 8 + 2;
        if (exSize + localContentsOffset >= this.contents.length) {
            this.resizeContents(exSize);
        }
        this.contents[localContentsOffset++] = (byte)(exceptionHandlersCount >> 8);
        this.contents[localContentsOffset++] = (byte)exceptionHandlersCount;
        int i2 = 0;
        int max = this.codeStream.exceptionLabelsCounter;
        while (i2 < max) {
            ExceptionLabel exceptionLabel = exceptionLabels[i2];
            if (exceptionLabel != null) {
                int iRange = 0;
                int maxRange = exceptionLabel.count;
                if ((maxRange & 1) != 0) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                }
                while (iRange < maxRange) {
                    int start = exceptionLabel.ranges[iRange++];
                    this.contents[localContentsOffset++] = (byte)(start >> 8);
                    this.contents[localContentsOffset++] = (byte)start;
                    int end = exceptionLabel.ranges[iRange++];
                    this.contents[localContentsOffset++] = (byte)(end >> 8);
                    this.contents[localContentsOffset++] = (byte)end;
                    int handlerPC = exceptionLabel.position;
                    this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
                    this.contents[localContentsOffset++] = (byte)handlerPC;
                    if (exceptionLabel.exceptionType == null) {
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = 0;
                        continue;
                    }
                    int nameIndex = exceptionLabel.exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                }
            }
            ++i2;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        if ((localContentsOffset += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            int[] pcToSourceMapTable = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
                int lineNumberTableOffset = localContentsOffset;
                localContentsOffset += 6;
                int numberOfEntries = 0;
                int length2 = this.codeStream.pcToSourceMapSize;
                int i3 = 0;
                while (i3 < length2) {
                    if (localContentsOffset + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int pc = pcToSourceMapTable[i3++];
                    this.contents[localContentsOffset++] = (byte)(pc >> 8);
                    this.contents[localContentsOffset++] = (byte)pc;
                    int lineNumber = pcToSourceMapTable[i3++];
                    this.contents[localContentsOffset++] = (byte)(lineNumber >> 8);
                    this.contents[localContentsOffset++] = (byte)lineNumber;
                    ++numberOfEntries;
                }
                int lineNumberAttr_length = numberOfEntries * 4 + 2;
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 24);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 16);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 8);
                this.contents[lineNumberTableOffset++] = (byte)lineNumberAttr_length;
                this.contents[lineNumberTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[lineNumberTableOffset++] = (byte)numberOfEntries;
                ++attributeNumber;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            boolean currentInstanceIsGeneric;
            int resolvedPosition;
            int length3;
            int endPC;
            int startPC;
            int j;
            int descriptorIndex;
            int nameIndex;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            boolean methodDeclarationIsStatic = this.codeStream.methodDeclaration.isStatic();
            int maxOfEntries = 8 + 10 * (methodDeclarationIsStatic ? 0 : 1);
            int i4 = 0;
            while (i4 < this.codeStream.allLocalsCounter) {
                maxOfEntries += 10 * this.codeStream.locals[i4].initializationCount;
                ++i4;
            }
            if (localContentsOffset + maxOfEntries >= this.contents.length) {
                this.resizeContents(maxOfEntries);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            int localVariableTableOffset = localContentsOffset;
            localContentsOffset += 6;
            SourceTypeBinding declaringClassBinding = null;
            if (!methodDeclarationIsStatic) {
                ++numberOfEntries;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                this.contents[localContentsOffset++] = (byte)code_length;
                nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)nameIndex;
                MethodBinding methodBinding = this.codeStream.methodDeclaration.binding;
                declaringClassBinding = (SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody21$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null));
                descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.signature());
                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
            }
            int genericLocalVariablesCounter = 0;
            LocalVariableBinding[] genericLocalVariables = null;
            int numberOfGenericEntries = 0;
            int i5 = 0;
            int max2 = this.codeStream.allLocalsCounter;
            while (i5 < max2) {
                boolean isParameterizedType;
                LocalVariableBinding localVariable = this.codeStream.locals[i5];
                TypeBinding localVariableTypeBinding = localVariable.type;
                boolean bl = isParameterizedType = localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable();
                if (localVariable.initializationCount != 0 && isParameterizedType) {
                    if (genericLocalVariables == null) {
                        genericLocalVariables = new LocalVariableBinding[max2];
                    }
                    genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                }
                j = 0;
                while (j < localVariable.initializationCount) {
                    startPC = localVariable.initializationPCs[j << 1];
                    endPC = localVariable.initializationPCs[(j << 1) + 1];
                    if (startPC != endPC) {
                        if (endPC == -1) {
                            localVariable.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                        }
                        if (isParameterizedType) {
                            ++numberOfGenericEntries;
                        }
                        ++numberOfEntries;
                        this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                        this.contents[localContentsOffset++] = (byte)startPC;
                        length3 = endPC - startPC;
                        this.contents[localContentsOffset++] = (byte)(length3 >> 8);
                        this.contents[localContentsOffset++] = (byte)length3;
                        nameIndex = this.constantPool.literalIndex(localVariable.name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        resolvedPosition = localVariable.resolvedPosition;
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    }
                    ++j;
                }
                ++i5;
            }
            int value = numberOfEntries * 10 + 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
            boolean bl = currentInstanceIsGeneric = !methodDeclarationIsStatic && declaringClassBinding != null && declaringClassBinding.typeVariables != Binding.NO_TYPE_VARIABLES;
            if (genericLocalVariablesCounter != 0 || currentInstanceIsGeneric) {
                maxOfEntries = 8 + (numberOfGenericEntries += currentInstanceIsGeneric ? 1 : 0) * 10;
                if (localContentsOffset + maxOfEntries >= this.contents.length) {
                    this.resizeContents(maxOfEntries);
                }
                int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                value = numberOfGenericEntries * 10 + 2;
                this.contents[localContentsOffset++] = (byte)(value >> 24);
                this.contents[localContentsOffset++] = (byte)(value >> 16);
                this.contents[localContentsOffset++] = (byte)(value >> 8);
                this.contents[localContentsOffset++] = (byte)value;
                this.contents[localContentsOffset++] = (byte)(numberOfGenericEntries >> 8);
                this.contents[localContentsOffset++] = (byte)numberOfGenericEntries;
                if (currentInstanceIsGeneric) {
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                }
                int i6 = 0;
                while (i6 < genericLocalVariablesCounter) {
                    LocalVariableBinding localVariable = genericLocalVariables[i6];
                    j = 0;
                    while (j < localVariable.initializationCount) {
                        startPC = localVariable.initializationPCs[j << 1];
                        endPC = localVariable.initializationPCs[(j << 1) + 1];
                        if (startPC != endPC) {
                            this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                            this.contents[localContentsOffset++] = (byte)startPC;
                            length3 = endPC - startPC;
                            this.contents[localContentsOffset++] = (byte)(length3 >> 8);
                            this.contents[localContentsOffset++] = (byte)length3;
                            nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            resolvedPosition = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        }
                        ++j;
                    }
                    ++i6;
                }
                ++attributeNumber;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (numberOfFrames = (framesPositionsSize = (framesPositions = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList framePositions = new ArrayList(framesPositionsSize);
            framePositions.addAll(framesPositions);
            Collections.sort(framePositions);
            int stackMapTableAttributeOffset = localContentsOffset;
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int stackMapTableAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[localContentsOffset++] = (byte)(stackMapTableAttributeNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)stackMapTableAttributeNameIndex;
            int stackMapTableAttributeLengthOffset = localContentsOffset;
            if ((localContentsOffset += 4) + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            numberOfFrames = 0;
            int numberOfFramesOffset = localContentsOffset;
            if ((localContentsOffset += 2) + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            ArrayList frames = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame currentFrame = (StackMapFrame)frames.get(0);
            StackMapFrame prevFrame = null;
            int framesSize = frames.size();
            int frameIndex = 0;
            int j = 0;
            while (j < framesPositionsSize && (Integer)framePositions.get(j) < code_length) {
                prevFrame = currentFrame;
                currentFrame = null;
                while (frameIndex < framesSize) {
                    currentFrame = (StackMapFrame)frames.get(frameIndex);
                    if (currentFrame.pc == (Integer)framePositions.get(j)) break;
                    ++frameIndex;
                }
                if (currentFrame == null) break;
                ++numberOfFrames;
                int offsetDelta = currentFrame.getOffsetDelta(prevFrame);
                block0 : switch (currentFrame.getFrameType(prevFrame)) {
                    case 2: {
                        int indexForType;
                        int offset;
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 + numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int index = currentFrame.getIndexOfDifferentLocals(numberOfDifferentLocals);
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int i7 = index;
                        while (i7 < currentFrame.locals.length && numberOfDifferentLocals > 0) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((info = currentFrame.locals[i7]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block8 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i7;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i7;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block8;
                                            }
                                            case 7: {
                                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                --numberOfDifferentLocals;
                            }
                            ++i7;
                        }
                        break;
                    }
                    case 0: {
                        if (localContentsOffset + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 3: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[localContentsOffset++] = -5;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 1: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = -currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 - numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 5: {
                        int indexForType;
                        int offset;
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[localContentsOffset++] = (byte)(offsetDelta + 64);
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        byte tag = (byte)info.tag;
                        this.contents[localContentsOffset++] = tag;
                        switch (tag) {
                            case 8: {
                                offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int indexForType;
                        int offset;
                        if (localContentsOffset + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[localContentsOffset++] = -9;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        byte tag = (byte)info.tag;
                        this.contents[localContentsOffset++] = tag;
                        switch (tag) {
                            case 8: {
                                offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    default: {
                        if (localContentsOffset + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[localContentsOffset++] = -1;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int numberOfLocalOffset = localContentsOffset;
                        localContentsOffset += 2;
                        int numberOfLocalEntries = 0;
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int numberOfEntries = 0;
                        int localsLength = currentFrame.locals == null ? 0 : currentFrame.locals.length;
                        int i8 = 0;
                        while (i8 < localsLength && numberOfLocalEntries < numberOfLocals) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.locals[i8]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block41 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i8;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i8;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block41;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                ++numberOfLocalEntries;
                            }
                            ++numberOfEntries;
                            ++i8;
                        }
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[numberOfLocalOffset++] = (byte)(numberOfEntries >> 8);
                        this.contents[numberOfLocalOffset] = (byte)numberOfEntries;
                        int numberOfStackItems = currentFrame.numberOfStackItems;
                        this.contents[localContentsOffset++] = (byte)(numberOfStackItems >> 8);
                        this.contents[localContentsOffset++] = (byte)numberOfStackItems;
                        int i9 = 0;
                        while (i9 < numberOfStackItems) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.stackItems[i9]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block52 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block52;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i9;
                        }
                        break block0;
                    }
                }
                ++j;
            }
            if (numberOfFrames != 0) {
                this.contents[numberOfFramesOffset++] = (byte)(numberOfFrames >> 8);
                this.contents[numberOfFramesOffset] = (byte)numberOfFrames;
                int attributeLength = localContentsOffset - stackMapTableAttributeLengthOffset - 4;
                this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[stackMapTableAttributeLengthOffset] = (byte)attributeLength;
                ++attributeNumber;
            } else {
                localContentsOffset = stackMapTableAttributeOffset;
            }
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForClinit(int codeAttributeOffset) {
        Set framesPositions;
        int framesPositionsSize;
        int numberOfFrames;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        ExceptionLabel[] exceptionLabels = this.codeStream.exceptionLabels;
        int exceptionHandlersCount = 0;
        int i = 0;
        int length = this.codeStream.exceptionLabelsCounter;
        while (i < length) {
            exceptionHandlersCount += this.codeStream.exceptionLabels[i].count / 2;
            ++i;
        }
        int exSize = exceptionHandlersCount * 8 + 2;
        if (exSize + localContentsOffset >= this.contents.length) {
            this.resizeContents(exSize);
        }
        this.contents[localContentsOffset++] = (byte)(exceptionHandlersCount >> 8);
        this.contents[localContentsOffset++] = (byte)exceptionHandlersCount;
        int i2 = 0;
        int max = this.codeStream.exceptionLabelsCounter;
        while (i2 < max) {
            ExceptionLabel exceptionLabel = exceptionLabels[i2];
            if (exceptionLabel != null) {
                int iRange = 0;
                int maxRange = exceptionLabel.count;
                if ((maxRange & 1) != 0) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                }
                while (iRange < maxRange) {
                    int start = exceptionLabel.ranges[iRange++];
                    this.contents[localContentsOffset++] = (byte)(start >> 8);
                    this.contents[localContentsOffset++] = (byte)start;
                    int end = exceptionLabel.ranges[iRange++];
                    this.contents[localContentsOffset++] = (byte)(end >> 8);
                    this.contents[localContentsOffset++] = (byte)end;
                    int handlerPC = exceptionLabel.position;
                    this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
                    this.contents[localContentsOffset++] = (byte)handlerPC;
                    if (exceptionLabel.exceptionType == null) {
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = 0;
                        continue;
                    }
                    int nameIndex = exceptionLabel.exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                }
            }
            ++i2;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        if ((localContentsOffset += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            int[] pcToSourceMapTable = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
                int lineNumberTableOffset = localContentsOffset;
                localContentsOffset += 6;
                int numberOfEntries = 0;
                int length2 = this.codeStream.pcToSourceMapSize;
                int i3 = 0;
                while (i3 < length2) {
                    if (localContentsOffset + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int pc = pcToSourceMapTable[i3++];
                    this.contents[localContentsOffset++] = (byte)(pc >> 8);
                    this.contents[localContentsOffset++] = (byte)pc;
                    int lineNumber = pcToSourceMapTable[i3++];
                    this.contents[localContentsOffset++] = (byte)(lineNumber >> 8);
                    this.contents[localContentsOffset++] = (byte)lineNumber;
                    ++numberOfEntries;
                }
                int lineNumberAttr_length = numberOfEntries * 4 + 2;
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 24);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 16);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 8);
                this.contents[lineNumberTableOffset++] = (byte)lineNumberAttr_length;
                this.contents[lineNumberTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[lineNumberTableOffset++] = (byte)numberOfEntries;
                ++attributeNumber;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            int numberOfEntries = 0;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int resolvedPosition;
                int descriptorIndex;
                int nameIndex;
                int length3;
                int endPC;
                int startPC;
                int j;
                int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
                int localVariableTableOffset = localContentsOffset;
                localContentsOffset += 6;
                int genericLocalVariablesCounter = 0;
                LocalVariableBinding[] genericLocalVariables = null;
                int numberOfGenericEntries = 0;
                int i4 = 0;
                int max2 = this.codeStream.allLocalsCounter;
                while (i4 < max2) {
                    boolean isParameterizedType;
                    LocalVariableBinding localVariable = this.codeStream.locals[i4];
                    TypeBinding localVariableTypeBinding = localVariable.type;
                    boolean bl = isParameterizedType = localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable();
                    if (localVariable.initializationCount != 0 && isParameterizedType) {
                        if (genericLocalVariables == null) {
                            genericLocalVariables = new LocalVariableBinding[max2];
                        }
                        genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                    }
                    j = 0;
                    while (j < localVariable.initializationCount) {
                        startPC = localVariable.initializationPCs[j << 1];
                        endPC = localVariable.initializationPCs[(j << 1) + 1];
                        if (startPC != endPC) {
                            if (endPC == -1) {
                                localVariable.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                            }
                            if (localContentsOffset + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++numberOfEntries;
                            if (isParameterizedType) {
                                ++numberOfGenericEntries;
                            }
                            this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                            this.contents[localContentsOffset++] = (byte)startPC;
                            length3 = endPC - startPC;
                            this.contents[localContentsOffset++] = (byte)(length3 >> 8);
                            this.contents[localContentsOffset++] = (byte)length3;
                            nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            resolvedPosition = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        }
                        ++j;
                    }
                    ++i4;
                }
                int value = numberOfEntries * 10 + 2;
                this.contents[localVariableTableOffset++] = (byte)(value >> 24);
                this.contents[localVariableTableOffset++] = (byte)(value >> 16);
                this.contents[localVariableTableOffset++] = (byte)(value >> 8);
                this.contents[localVariableTableOffset++] = (byte)value;
                this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[localVariableTableOffset] = (byte)numberOfEntries;
                ++attributeNumber;
                if (genericLocalVariablesCounter != 0) {
                    int maxOfEntries = 8 + numberOfGenericEntries * 10;
                    if (localContentsOffset + maxOfEntries >= this.contents.length) {
                        this.resizeContents(maxOfEntries);
                    }
                    int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                    this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                    value = numberOfGenericEntries * 10 + 2;
                    this.contents[localContentsOffset++] = (byte)(value >> 24);
                    this.contents[localContentsOffset++] = (byte)(value >> 16);
                    this.contents[localContentsOffset++] = (byte)(value >> 8);
                    this.contents[localContentsOffset++] = (byte)value;
                    this.contents[localContentsOffset++] = (byte)(numberOfGenericEntries >> 8);
                    this.contents[localContentsOffset++] = (byte)numberOfGenericEntries;
                    int i5 = 0;
                    while (i5 < genericLocalVariablesCounter) {
                        LocalVariableBinding localVariable = genericLocalVariables[i5];
                        j = 0;
                        while (j < localVariable.initializationCount) {
                            startPC = localVariable.initializationPCs[j << 1];
                            endPC = localVariable.initializationPCs[(j << 1) + 1];
                            if (startPC != endPC) {
                                this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                                this.contents[localContentsOffset++] = (byte)startPC;
                                length3 = endPC - startPC;
                                this.contents[localContentsOffset++] = (byte)(length3 >> 8);
                                this.contents[localContentsOffset++] = (byte)length3;
                                nameIndex = this.constantPool.literalIndex(localVariable.name);
                                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                                this.contents[localContentsOffset++] = (byte)nameIndex;
                                descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                                resolvedPosition = localVariable.resolvedPosition;
                                this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                                this.contents[localContentsOffset++] = (byte)resolvedPosition;
                            }
                            ++j;
                        }
                        ++i5;
                    }
                    ++attributeNumber;
                }
            }
        }
        if ((this.produceAttributes & 8) != 0 && (numberOfFrames = (framesPositionsSize = (framesPositions = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList framePositions = new ArrayList(framesPositionsSize);
            framePositions.addAll(framesPositions);
            Collections.sort(framePositions);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int stackMapTableAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[localContentsOffset++] = (byte)(stackMapTableAttributeNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)stackMapTableAttributeNameIndex;
            int stackMapTableAttributeLengthOffset = localContentsOffset;
            numberOfFrames = 0;
            int numberOfFramesOffset = localContentsOffset += 4;
            localContentsOffset += 2;
            ArrayList frames = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame currentFrame = (StackMapFrame)frames.get(0);
            StackMapFrame prevFrame = null;
            int framesSize = frames.size();
            int frameIndex = 0;
            int j = 0;
            while (j < framesPositionsSize && (Integer)framePositions.get(j) < code_length) {
                prevFrame = currentFrame;
                currentFrame = null;
                while (frameIndex < framesSize) {
                    currentFrame = (StackMapFrame)frames.get(frameIndex);
                    if (currentFrame.pc == (Integer)framePositions.get(j)) break;
                    ++frameIndex;
                }
                if (currentFrame == null) break;
                ++numberOfFrames;
                int offsetDelta = currentFrame.getOffsetDelta(prevFrame);
                block0 : switch (currentFrame.getFrameType(prevFrame)) {
                    case 2: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 + numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int index = currentFrame.getIndexOfDifferentLocals(numberOfDifferentLocals);
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int i6 = index;
                        while (i6 < currentFrame.locals.length && numberOfDifferentLocals > 0) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((info = currentFrame.locals[i6]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block8 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i6;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i6;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block8;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                --numberOfDifferentLocals;
                            }
                            ++i6;
                        }
                        break;
                    }
                    case 0: {
                        if (localContentsOffset + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 3: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[localContentsOffset++] = -5;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 1: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = -currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 - numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 5: {
                        int indexForType;
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[localContentsOffset++] = (byte)(offsetDelta + 64);
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int indexForType;
                        if (localContentsOffset + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[localContentsOffset++] = -9;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    default: {
                        if (localContentsOffset + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[localContentsOffset++] = -1;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int numberOfLocalOffset = localContentsOffset;
                        localContentsOffset += 2;
                        int numberOfLocalEntries = 0;
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int numberOfEntries = 0;
                        int localsLength = currentFrame.locals == null ? 0 : currentFrame.locals.length;
                        int i7 = 0;
                        while (i7 < localsLength && numberOfLocalEntries < numberOfLocals) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.locals[i7]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block41 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i7;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i7;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block41;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                ++numberOfLocalEntries;
                            }
                            ++numberOfEntries;
                            ++i7;
                        }
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[numberOfLocalOffset++] = (byte)(numberOfEntries >> 8);
                        this.contents[numberOfLocalOffset] = (byte)numberOfEntries;
                        int numberOfStackItems = currentFrame.numberOfStackItems;
                        this.contents[localContentsOffset++] = (byte)(numberOfStackItems >> 8);
                        this.contents[localContentsOffset++] = (byte)numberOfStackItems;
                        int i8 = 0;
                        while (i8 < numberOfStackItems) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.stackItems[i8]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block52 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block52;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i8;
                        }
                        break block0;
                    }
                }
                ++j;
            }
            this.contents[numberOfFramesOffset++] = (byte)(numberOfFrames >> 8);
            this.contents[numberOfFramesOffset] = (byte)numberOfFrames;
            int attributeLength = localContentsOffset - stackMapTableAttributeLengthOffset - 4;
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 24);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 16);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 8);
            this.contents[stackMapTableAttributeLengthOffset] = (byte)attributeLength;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForClinit(int codeAttributeOffset, int problemLine) {
        Set framesPositions;
        int framesPositionsSize;
        int numberOfFrames;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        if ((localContentsOffset += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (localContentsOffset + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)problemLine;
            ++attributeNumber;
        }
        if ((this.produceAttributes & 4) != 0) {
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 2;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            ++attributeNumber;
        }
        if ((this.produceAttributes & 8) != 0 && (numberOfFrames = (framesPositionsSize = (framesPositions = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList framePositions = new ArrayList(framesPositionsSize);
            framePositions.addAll(framesPositions);
            Collections.sort(framePositions);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int stackMapTableAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[localContentsOffset++] = (byte)(stackMapTableAttributeNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)stackMapTableAttributeNameIndex;
            int stackMapTableAttributeLengthOffset = localContentsOffset;
            numberOfFrames = 0;
            int numberOfFramesOffset = localContentsOffset += 4;
            localContentsOffset += 2;
            ArrayList frames = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame currentFrame = (StackMapFrame)frames.get(0);
            StackMapFrame prevFrame = null;
            int framesSize = frames.size();
            int frameIndex = 0;
            int j = 0;
            while (j < framesPositionsSize && (Integer)framePositions.get(j) < code_length) {
                prevFrame = currentFrame;
                currentFrame = null;
                while (frameIndex < framesSize) {
                    currentFrame = (StackMapFrame)frames.get(frameIndex);
                    if (currentFrame.pc == (Integer)framePositions.get(j)) break;
                    ++frameIndex;
                }
                if (currentFrame == null) break;
                ++numberOfFrames;
                int offsetDelta = currentFrame.getOffsetDelta(prevFrame);
                block0 : switch (currentFrame.getFrameType(prevFrame)) {
                    case 2: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 + numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int index = currentFrame.getIndexOfDifferentLocals(numberOfDifferentLocals);
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int i = index;
                        while (i < currentFrame.locals.length && numberOfDifferentLocals > 0) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block8 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block8;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                --numberOfDifferentLocals;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 0: {
                        if (localContentsOffset + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 3: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[localContentsOffset++] = -5;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 1: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = -currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 - numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 5: {
                        int indexForType;
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[localContentsOffset++] = (byte)(offsetDelta + 64);
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int indexForType;
                        if (localContentsOffset + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[localContentsOffset++] = -9;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    default: {
                        if (localContentsOffset + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[localContentsOffset++] = -1;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int numberOfLocalOffset = localContentsOffset;
                        localContentsOffset += 2;
                        int numberOfLocalEntries = 0;
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int numberOfEntries = 0;
                        int localsLength = currentFrame.locals == null ? 0 : currentFrame.locals.length;
                        int i = 0;
                        while (i < localsLength && numberOfLocalEntries < numberOfLocals) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block41 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block41;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                ++numberOfLocalEntries;
                            }
                            ++numberOfEntries;
                            ++i;
                        }
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[numberOfLocalOffset++] = (byte)(numberOfEntries >> 8);
                        this.contents[numberOfLocalOffset] = (byte)numberOfEntries;
                        int numberOfStackItems = currentFrame.numberOfStackItems;
                        this.contents[localContentsOffset++] = (byte)(numberOfStackItems >> 8);
                        this.contents[localContentsOffset++] = (byte)numberOfStackItems;
                        int i2 = 0;
                        while (i2 < numberOfStackItems) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.stackItems[i2]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block52 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block52;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
                ++j;
            }
            this.contents[numberOfFramesOffset++] = (byte)(numberOfFrames >> 8);
            this.contents[numberOfFramesOffset] = (byte)numberOfFrames;
            int attributeLength = localContentsOffset - stackMapTableAttributeLengthOffset - 4;
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 24);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 16);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 8);
            this.contents[stackMapTableAttributeLengthOffset] = (byte)attributeLength;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding binding, int codeAttributeOffset, int[] startLineIndexes, int problemLine) {
        Set framesPositions;
        int framesPositionsSize;
        int numberOfFrames;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        if ((localContentsOffset += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (localContentsOffset + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            if (problemLine == 0) {
                problemLine = Util.getLineNumber(binding.sourceStart(), startLineIndexes, 0, startLineIndexes.length - 1);
            }
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)problemLine;
            ++attributeNumber;
        }
        if ((this.produceAttributes & 8) != 0 && (numberOfFrames = (framesPositionsSize = (framesPositions = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList framePositions = new ArrayList(framesPositionsSize);
            framePositions.addAll(framesPositions);
            Collections.sort(framePositions);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int stackMapTableAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[localContentsOffset++] = (byte)(stackMapTableAttributeNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)stackMapTableAttributeNameIndex;
            int stackMapTableAttributeLengthOffset = localContentsOffset;
            numberOfFrames = 0;
            int numberOfFramesOffset = localContentsOffset += 4;
            localContentsOffset += 2;
            ArrayList frames = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame currentFrame = (StackMapFrame)frames.get(0);
            StackMapFrame prevFrame = null;
            int framesSize = frames.size();
            int frameIndex = 0;
            int j = 0;
            while (j < framesPositionsSize && (Integer)framePositions.get(j) < code_length) {
                prevFrame = currentFrame;
                currentFrame = null;
                while (frameIndex < framesSize) {
                    currentFrame = (StackMapFrame)frames.get(frameIndex);
                    if (currentFrame.pc == (Integer)framePositions.get(j)) break;
                    ++frameIndex;
                }
                if (currentFrame == null) break;
                ++numberOfFrames;
                int offsetDelta = currentFrame.getOffsetDelta(prevFrame);
                block0 : switch (currentFrame.getFrameType(prevFrame)) {
                    case 2: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 + numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int index = currentFrame.getIndexOfDifferentLocals(numberOfDifferentLocals);
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int i = index;
                        while (i < currentFrame.locals.length && numberOfDifferentLocals > 0) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block8 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block8;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                --numberOfDifferentLocals;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 0: {
                        if (localContentsOffset + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 3: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[localContentsOffset++] = -5;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 1: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = -currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 - numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 5: {
                        int indexForType;
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[localContentsOffset++] = (byte)(offsetDelta + 64);
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int indexForType;
                        if (localContentsOffset + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[localContentsOffset++] = -9;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    default: {
                        if (localContentsOffset + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[localContentsOffset++] = -1;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int numberOfLocalOffset = localContentsOffset;
                        localContentsOffset += 2;
                        int numberOfLocalEntries = 0;
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int numberOfEntries = 0;
                        int localsLength = currentFrame.locals == null ? 0 : currentFrame.locals.length;
                        int i = 0;
                        while (i < localsLength && numberOfLocalEntries < numberOfLocals) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block41 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block41;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                ++numberOfLocalEntries;
                            }
                            ++numberOfEntries;
                            ++i;
                        }
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[numberOfLocalOffset++] = (byte)(numberOfEntries >> 8);
                        this.contents[numberOfLocalOffset] = (byte)numberOfEntries;
                        int numberOfStackItems = currentFrame.numberOfStackItems;
                        this.contents[localContentsOffset++] = (byte)(numberOfStackItems >> 8);
                        this.contents[localContentsOffset++] = (byte)numberOfStackItems;
                        int i2 = 0;
                        while (i2 < numberOfStackItems) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.stackItems[i2]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block52 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block52;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
                ++j;
            }
            this.contents[numberOfFramesOffset++] = (byte)(numberOfFrames >> 8);
            this.contents[numberOfFramesOffset] = (byte)numberOfFrames;
            int attributeLength = localContentsOffset - stackMapTableAttributeLengthOffset - 4;
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 24);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 16);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 8);
            this.contents[stackMapTableAttributeLengthOffset] = (byte)attributeLength;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration method, MethodBinding binding, int codeAttributeOffset, int[] startLineIndexes, int problemLine) {
        Set framesPositions;
        int framesPositionsSize;
        int numberOfFrames;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        if ((localContentsOffset += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (localContentsOffset + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            if (problemLine == 0) {
                problemLine = Util.getLineNumber(binding.sourceStart(), startLineIndexes, 0, startLineIndexes.length - 1);
            }
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)problemLine;
            ++attributeNumber;
        }
        if ((this.produceAttributes & 4) != 0) {
            boolean currentInstanceIsGeneric;
            int resolvedPosition;
            int argSize;
            int descriptorIndex;
            int nameIndex;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            int localVariableTableOffset = localContentsOffset;
            localContentsOffset += 6;
            SourceTypeBinding declaringClassBinding = null;
            boolean methodDeclarationIsStatic = this.codeStream.methodDeclaration.isStatic();
            if (!methodDeclarationIsStatic) {
                ++numberOfEntries;
                if (localContentsOffset + 10 >= this.contents.length) {
                    this.resizeContents(10);
                }
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                this.contents[localContentsOffset++] = (byte)code_length;
                nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)nameIndex;
                MethodBinding methodBinding = this.codeStream.methodDeclaration.binding;
                declaringClassBinding = (SourceTypeBinding)((ReferenceBinding)ClassFile.declaringClass_aroundBody23$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null));
                descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.signature());
                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
            }
            int genericLocalVariablesCounter = 0;
            LocalVariableBinding[] genericLocalVariables = null;
            int numberOfGenericEntries = 0;
            if (binding.isConstructor()) {
                MethodBinding methodBinding = binding;
                ReferenceBinding declaringClass = (ReferenceBinding)ClassFile.declaringClass_aroundBody25$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null);
                if (declaringClass.isNestedType()) {
                    NestedTypeBinding methodDeclaringClass = (NestedTypeBinding)declaringClass;
                    argSize = methodDeclaringClass.enclosingInstancesSlotSize;
                    SyntheticArgumentBinding[] syntheticArguments = methodDeclaringClass.syntheticEnclosingInstances();
                    if (syntheticArguments != null) {
                        int i = 0;
                        int max = syntheticArguments.length;
                        while (i < max) {
                            SyntheticArgumentBinding localVariable = syntheticArguments[i];
                            TypeBinding localVariableTypeBinding = localVariable.type;
                            if (localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable()) {
                                if (genericLocalVariables == null) {
                                    genericLocalVariables = new LocalVariableBinding[max];
                                }
                                genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                                ++numberOfGenericEntries;
                            }
                            if (localContentsOffset + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++numberOfEntries;
                            this.contents[localContentsOffset++] = 0;
                            this.contents[localContentsOffset++] = 0;
                            this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                            this.contents[localContentsOffset++] = (byte)code_length;
                            nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            int resolvedPosition2 = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition2 >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition2;
                            ++i;
                        }
                    }
                } else {
                    argSize = 1;
                }
            } else {
                argSize = binding.isStatic() ? 0 : 1;
            }
            int genericArgumentsCounter = 0;
            int[] genericArgumentsNameIndexes = null;
            int[] genericArgumentsResolvedPositions = null;
            TypeBinding[] genericArgumentsTypeBindings = null;
            if (method.binding != null) {
                TypeBinding[] parameters = method.binding.parameters;
                Argument[] arguments = method.arguments;
                if (parameters != null && arguments != null) {
                    int i = 0;
                    int max = parameters.length;
                    while (i < max) {
                        TypeBinding argumentBinding = parameters[i];
                        if (localContentsOffset + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++numberOfEntries;
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                        this.contents[localContentsOffset++] = (byte)code_length;
                        nameIndex = this.constantPool.literalIndex(arguments[i].name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        resolvedPosition = argSize;
                        if (argumentBinding.isParameterizedType() || argumentBinding.isTypeVariable()) {
                            if (genericArgumentsCounter == 0) {
                                genericArgumentsNameIndexes = new int[max];
                                genericArgumentsResolvedPositions = new int[max];
                                genericArgumentsTypeBindings = new TypeBinding[max];
                            }
                            genericArgumentsNameIndexes[genericArgumentsCounter] = nameIndex;
                            genericArgumentsResolvedPositions[genericArgumentsCounter] = resolvedPosition;
                            genericArgumentsTypeBindings[genericArgumentsCounter++] = argumentBinding;
                        }
                        descriptorIndex = this.constantPool.literalIndex(argumentBinding.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        argSize = argumentBinding == TypeBinding.LONG || argumentBinding == TypeBinding.DOUBLE ? (argSize += 2) : ++argSize;
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        ++i;
                    }
                }
            }
            int value = numberOfEntries * 10 + 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
            boolean bl = currentInstanceIsGeneric = !methodDeclarationIsStatic && declaringClassBinding != null && declaringClassBinding.typeVariables != Binding.NO_TYPE_VARIABLES;
            if (genericLocalVariablesCounter != 0 || genericArgumentsCounter != 0 || currentInstanceIsGeneric) {
                numberOfEntries = numberOfGenericEntries + genericArgumentsCounter + (currentInstanceIsGeneric ? 1 : 0);
                int maxOfEntries = 8 + numberOfEntries * 10;
                if (localContentsOffset + maxOfEntries >= this.contents.length) {
                    this.resizeContents(maxOfEntries);
                }
                int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                value = numberOfEntries * 10 + 2;
                this.contents[localContentsOffset++] = (byte)(value >> 24);
                this.contents[localContentsOffset++] = (byte)(value >> 16);
                this.contents[localContentsOffset++] = (byte)(value >> 8);
                this.contents[localContentsOffset++] = (byte)value;
                this.contents[localContentsOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[localContentsOffset++] = (byte)numberOfEntries;
                if (currentInstanceIsGeneric) {
                    ++numberOfEntries;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(declaringClassBinding.genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                }
                int i = 0;
                while (i < genericLocalVariablesCounter) {
                    LocalVariableBinding localVariable = genericLocalVariables[i];
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = this.constantPool.literalIndex(localVariable.name);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    int resolvedPosition3 = localVariable.resolvedPosition;
                    this.contents[localContentsOffset++] = (byte)(resolvedPosition3 >> 8);
                    this.contents[localContentsOffset++] = (byte)resolvedPosition3;
                    ++i;
                }
                i = 0;
                while (i < genericArgumentsCounter) {
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = 0;
                    this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                    this.contents[localContentsOffset++] = (byte)code_length;
                    nameIndex = genericArgumentsNameIndexes[i];
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(genericArgumentsTypeBindings[i].genericTypeSignature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    resolvedPosition = genericArgumentsResolvedPositions[i];
                    this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                    this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    ++i;
                }
                ++attributeNumber;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (numberOfFrames = (framesPositionsSize = (framesPositions = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList framePositions = new ArrayList(framesPositionsSize);
            framePositions.addAll(framesPositions);
            Collections.sort(framePositions);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int stackMapTableAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[localContentsOffset++] = (byte)(stackMapTableAttributeNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)stackMapTableAttributeNameIndex;
            int stackMapTableAttributeLengthOffset = localContentsOffset;
            numberOfFrames = 0;
            int numberOfFramesOffset = localContentsOffset += 4;
            localContentsOffset += 2;
            ArrayList frames = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame currentFrame = (StackMapFrame)frames.get(0);
            StackMapFrame prevFrame = null;
            int framesSize = frames.size();
            int frameIndex = 0;
            int j = 0;
            while (j < framesPositionsSize && (Integer)framePositions.get(j) < code_length) {
                prevFrame = currentFrame;
                currentFrame = null;
                while (frameIndex < framesSize) {
                    currentFrame = (StackMapFrame)frames.get(frameIndex);
                    if (currentFrame.pc == (Integer)framePositions.get(j)) break;
                    ++frameIndex;
                }
                if (currentFrame == null) break;
                ++numberOfFrames;
                int offsetDelta = currentFrame.getOffsetDelta(prevFrame);
                block0 : switch (currentFrame.getFrameType(prevFrame)) {
                    case 2: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 + numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int index = currentFrame.getIndexOfDifferentLocals(numberOfDifferentLocals);
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int i = index;
                        while (i < currentFrame.locals.length && numberOfDifferentLocals > 0) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block8 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block8;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                --numberOfDifferentLocals;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 0: {
                        if (localContentsOffset + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 3: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[localContentsOffset++] = -5;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 1: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = -currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 - numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 5: {
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[localContentsOffset++] = (byte)(offsetDelta + 64);
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    case 6: {
                        if (localContentsOffset + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[localContentsOffset++] = -9;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    default: {
                        if (localContentsOffset + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[localContentsOffset++] = -1;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int numberOfLocalOffset = localContentsOffset;
                        localContentsOffset += 2;
                        int numberOfLocalEntries = 0;
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int numberOfEntries = 0;
                        int localsLength = currentFrame.locals == null ? 0 : currentFrame.locals.length;
                        int i = 0;
                        while (i < localsLength && numberOfLocalEntries < numberOfLocals) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block41 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block41;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                ++numberOfLocalEntries;
                            }
                            ++numberOfEntries;
                            ++i;
                        }
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[numberOfLocalOffset++] = (byte)(numberOfEntries >> 8);
                        this.contents[numberOfLocalOffset] = (byte)numberOfEntries;
                        int numberOfStackItems = currentFrame.numberOfStackItems;
                        this.contents[localContentsOffset++] = (byte)(numberOfStackItems >> 8);
                        this.contents[localContentsOffset++] = (byte)numberOfStackItems;
                        int i2 = 0;
                        while (i2 < numberOfStackItems) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.stackItems[i2]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block52 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block52;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
                ++j;
            }
            this.contents[numberOfFramesOffset++] = (byte)(numberOfFrames >> 8);
            this.contents[numberOfFramesOffset] = (byte)numberOfFrames;
            int attributeLength = localContentsOffset - stackMapTableAttributeLengthOffset - 4;
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 24);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 16);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 8);
            this.contents[stackMapTableAttributeLengthOffset] = (byte)attributeLength;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForSyntheticMethod(boolean hasExceptionHandlers, SyntheticMethodBinding binding, int codeAttributeOffset, int[] startLineIndexes) {
        Set framesPositions;
        int framesPositionsSize;
        int numberOfFrames;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        if (hasExceptionHandlers) {
            ExceptionLabel[] exceptionLabels = this.codeStream.exceptionLabels;
            int exceptionHandlersCount = 0;
            int i = 0;
            int length = this.codeStream.exceptionLabelsCounter;
            while (i < length) {
                exceptionHandlersCount += this.codeStream.exceptionLabels[i].count / 2;
                ++i;
            }
            int exSize = exceptionHandlersCount * 8 + 2;
            if (exSize + localContentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            this.contents[localContentsOffset++] = (byte)(exceptionHandlersCount >> 8);
            this.contents[localContentsOffset++] = (byte)exceptionHandlersCount;
            int i2 = 0;
            int max = this.codeStream.exceptionLabelsCounter;
            while (i2 < max) {
                ExceptionLabel exceptionLabel = exceptionLabels[i2];
                if (exceptionLabel != null) {
                    int iRange = 0;
                    int maxRange = exceptionLabel.count;
                    if ((maxRange & 1) != 0) {
                        this.referenceBinding.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(binding.selector), this.referenceBinding.scope.problemReporter().referenceContext));
                    }
                    while (iRange < maxRange) {
                        int nameIndex;
                        int start = exceptionLabel.ranges[iRange++];
                        this.contents[localContentsOffset++] = (byte)(start >> 8);
                        this.contents[localContentsOffset++] = (byte)start;
                        int end = exceptionLabel.ranges[iRange++];
                        this.contents[localContentsOffset++] = (byte)(end >> 8);
                        this.contents[localContentsOffset++] = (byte)end;
                        int handlerPC = exceptionLabel.position;
                        this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
                        this.contents[localContentsOffset++] = (byte)handlerPC;
                        if (exceptionLabel.exceptionType == null) {
                            this.contents[localContentsOffset++] = 0;
                            this.contents[localContentsOffset++] = 0;
                            continue;
                        }
                        switch (exceptionLabel.exceptionType.id) {
                            case 12: {
                                nameIndex = this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName);
                                break;
                            }
                            case 7: {
                                nameIndex = this.constantPool.literalIndexForType(ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName);
                                break;
                            }
                            default: {
                                nameIndex = this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                            }
                        }
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                    }
                }
                ++i2;
            }
        } else {
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        if ((localContentsOffset += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (localContentsOffset + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            int index = 0;
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            int lineNumberTableOffset = localContentsOffset;
            localContentsOffset += 6;
            index = Util.getLineNumber(binding.sourceStart, startLineIndexes, 0, startLineIndexes.length - 1);
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(index >> 8);
            this.contents[localContentsOffset++] = (byte)index;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 6;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 1;
            ++attributeNumber;
        }
        if ((this.produceAttributes & 4) != 0) {
            int resolvedPosition;
            int descriptorIndex;
            int length;
            int endPC;
            int startPC;
            int j;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 > this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            int localVariableTableOffset = localContentsOffset;
            localContentsOffset += 6;
            int genericLocalVariablesCounter = 0;
            LocalVariableBinding[] genericLocalVariables = null;
            int numberOfGenericEntries = 0;
            int i = 0;
            int max = this.codeStream.allLocalsCounter;
            while (i < max) {
                boolean isParameterizedType;
                LocalVariableBinding localVariable = this.codeStream.locals[i];
                TypeBinding localVariableTypeBinding = localVariable.type;
                boolean bl = isParameterizedType = localVariableTypeBinding.isParameterizedType() || localVariableTypeBinding.isTypeVariable();
                if (localVariable.initializationCount != 0 && isParameterizedType) {
                    if (genericLocalVariables == null) {
                        genericLocalVariables = new LocalVariableBinding[max];
                    }
                    genericLocalVariables[genericLocalVariablesCounter++] = localVariable;
                }
                j = 0;
                while (j < localVariable.initializationCount) {
                    startPC = localVariable.initializationPCs[j << 1];
                    endPC = localVariable.initializationPCs[(j << 1) + 1];
                    if (startPC != endPC) {
                        if (endPC == -1) {
                            localVariable.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                        }
                        if (localContentsOffset + 10 > this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++numberOfEntries;
                        if (isParameterizedType) {
                            ++numberOfGenericEntries;
                        }
                        this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                        this.contents[localContentsOffset++] = (byte)startPC;
                        length = endPC - startPC;
                        this.contents[localContentsOffset++] = (byte)(length >> 8);
                        this.contents[localContentsOffset++] = (byte)length;
                        int nameIndex = this.constantPool.literalIndex(localVariable.name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        descriptorIndex = this.constantPool.literalIndex(localVariableTypeBinding.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        resolvedPosition = localVariable.resolvedPosition;
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    }
                    ++j;
                }
                ++i;
            }
            int value = numberOfEntries * 10 + 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
            if (genericLocalVariablesCounter != 0) {
                int maxOfEntries = 8 + numberOfGenericEntries * 10;
                if (localContentsOffset + maxOfEntries >= this.contents.length) {
                    this.resizeContents(maxOfEntries);
                }
                int localVariableTypeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[localContentsOffset++] = (byte)(localVariableTypeNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableTypeNameIndex;
                value = numberOfGenericEntries * 10 + 2;
                this.contents[localContentsOffset++] = (byte)(value >> 24);
                this.contents[localContentsOffset++] = (byte)(value >> 16);
                this.contents[localContentsOffset++] = (byte)(value >> 8);
                this.contents[localContentsOffset++] = (byte)value;
                this.contents[localContentsOffset++] = (byte)(numberOfGenericEntries >> 8);
                this.contents[localContentsOffset++] = (byte)numberOfGenericEntries;
                int i3 = 0;
                while (i3 < genericLocalVariablesCounter) {
                    LocalVariableBinding localVariable = genericLocalVariables[i3];
                    j = 0;
                    while (j < localVariable.initializationCount) {
                        startPC = localVariable.initializationPCs[j << 1];
                        endPC = localVariable.initializationPCs[(j << 1) + 1];
                        if (startPC != endPC) {
                            this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                            this.contents[localContentsOffset++] = (byte)startPC;
                            length = endPC - startPC;
                            this.contents[localContentsOffset++] = (byte)(length >> 8);
                            this.contents[localContentsOffset++] = (byte)length;
                            int nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariable.type.genericTypeSignature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            resolvedPosition = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        }
                        ++j;
                    }
                    ++i3;
                }
                ++attributeNumber;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (numberOfFrames = (framesPositionsSize = (framesPositions = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList framePositions = new ArrayList(framesPositionsSize);
            framePositions.addAll(framesPositions);
            Collections.sort(framePositions);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int stackMapTableAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[localContentsOffset++] = (byte)(stackMapTableAttributeNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)stackMapTableAttributeNameIndex;
            int stackMapTableAttributeLengthOffset = localContentsOffset;
            numberOfFrames = 0;
            int numberOfFramesOffset = localContentsOffset += 4;
            localContentsOffset += 2;
            ArrayList frames = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame currentFrame = (StackMapFrame)frames.get(0);
            StackMapFrame prevFrame = null;
            int framesSize = frames.size();
            int frameIndex = 0;
            int j = 0;
            while (j < framesPositionsSize && (Integer)framePositions.get(j) < code_length) {
                prevFrame = currentFrame;
                currentFrame = null;
                while (frameIndex < framesSize) {
                    currentFrame = (StackMapFrame)frames.get(frameIndex);
                    if (currentFrame.pc == (Integer)framePositions.get(j)) break;
                    ++frameIndex;
                }
                if (currentFrame == null) break;
                ++numberOfFrames;
                int offsetDelta = currentFrame.getOffsetDelta(prevFrame);
                block4 : switch (currentFrame.getFrameType(prevFrame)) {
                    case 2: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 + numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int index = currentFrame.getIndexOfDifferentLocals(numberOfDifferentLocals);
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int i = index;
                        while (i < currentFrame.locals.length && numberOfDifferentLocals > 0) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block12 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block12;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                --numberOfDifferentLocals;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 0: {
                        if (localContentsOffset + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 3: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[localContentsOffset++] = -5;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 1: {
                        if (localContentsOffset + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int numberOfDifferentLocals = -currentFrame.numberOfDifferentLocals(prevFrame);
                        this.contents[localContentsOffset++] = (byte)(251 - numberOfDifferentLocals);
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        break;
                    }
                    case 5: {
                        int indexForType;
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[localContentsOffset++] = (byte)(offsetDelta + 64);
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block4;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block4;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block4;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block4;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block4;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int indexForType;
                        if (localContentsOffset + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[localContentsOffset++] = -9;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        if (currentFrame.stackItems[0] == null) {
                            this.contents[localContentsOffset++] = 0;
                            break;
                        }
                        switch (currentFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[localContentsOffset++] = 1;
                                break block4;
                            }
                            case 9: {
                                this.contents[localContentsOffset++] = 2;
                                break block4;
                            }
                            case 7: {
                                this.contents[localContentsOffset++] = 4;
                                break block4;
                            }
                            case 8: {
                                this.contents[localContentsOffset++] = 3;
                                break block4;
                            }
                            case 12: {
                                this.contents[localContentsOffset++] = 5;
                                break block4;
                            }
                        }
                        VerificationTypeInfo info = currentFrame.stackItems[0];
                        this.contents[localContentsOffset++] = (byte)info.tag;
                        switch (info.tag) {
                            case 8: {
                                int offset = info.offset;
                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                this.contents[localContentsOffset++] = (byte)offset;
                                break;
                            }
                            case 7: {
                                indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                this.contents[localContentsOffset++] = (byte)indexForType;
                            }
                        }
                        break;
                    }
                    default: {
                        if (localContentsOffset + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[localContentsOffset++] = -1;
                        this.contents[localContentsOffset++] = (byte)(offsetDelta >> 8);
                        this.contents[localContentsOffset++] = (byte)offsetDelta;
                        int numberOfLocalOffset = localContentsOffset;
                        localContentsOffset += 2;
                        int numberOfLocalEntries = 0;
                        int numberOfLocals = currentFrame.getNumberOfLocals();
                        int numberOfEntries = 0;
                        int localsLength = currentFrame.locals == null ? 0 : currentFrame.locals.length;
                        int i = 0;
                        while (i < localsLength && numberOfLocalEntries < numberOfLocals) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.locals[i]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block45 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        ++i;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        ++i;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block45;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                                ++numberOfLocalEntries;
                            }
                            ++numberOfEntries;
                            ++i;
                        }
                        if (localContentsOffset + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[numberOfLocalOffset++] = (byte)(numberOfEntries >> 8);
                        this.contents[numberOfLocalOffset] = (byte)numberOfEntries;
                        int numberOfStackItems = currentFrame.numberOfStackItems;
                        this.contents[localContentsOffset++] = (byte)(numberOfStackItems >> 8);
                        this.contents[localContentsOffset++] = (byte)numberOfStackItems;
                        int i4 = 0;
                        while (i4 < numberOfStackItems) {
                            VerificationTypeInfo info;
                            if (localContentsOffset + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((info = currentFrame.stackItems[i4]) == null) {
                                this.contents[localContentsOffset++] = 0;
                            } else {
                                block56 : switch (info.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[localContentsOffset++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[localContentsOffset++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[localContentsOffset++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[localContentsOffset++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[localContentsOffset++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[localContentsOffset++] = (byte)info.tag;
                                        switch (info.tag) {
                                            case 8: {
                                                int offset = info.offset;
                                                this.contents[localContentsOffset++] = (byte)(offset >> 8);
                                                this.contents[localContentsOffset++] = (byte)offset;
                                                break block56;
                                            }
                                            case 7: {
                                                int indexForType = this.constantPool.literalIndexForType(info.constantPoolName());
                                                this.contents[localContentsOffset++] = (byte)(indexForType >> 8);
                                                this.contents[localContentsOffset++] = (byte)indexForType;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i4;
                        }
                        break block4;
                    }
                }
                ++j;
            }
            this.contents[numberOfFramesOffset++] = (byte)(numberOfFrames >> 8);
            this.contents[numberOfFramesOffset] = (byte)numberOfFrames;
            int attributeLength = localContentsOffset - stackMapTableAttributeLengthOffset - 4;
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 24);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 16);
            this.contents[stackMapTableAttributeLengthOffset++] = (byte)(attributeLength >> 8);
            this.contents[stackMapTableAttributeLengthOffset] = (byte)attributeLength;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForSyntheticMethod(SyntheticMethodBinding binding, int codeAttributeOffset, int[] startLineIndexes) {
        this.completeCodeAttributeForSyntheticMethod(false, binding, codeAttributeOffset, startLineIndexes);
    }

    public void completeMethodInfo(int methodAttributeOffset, int attributeNumber) {
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(2);
    }

    private void generateAnnotation(Annotation annotation, int attributeOffset) {
        TypeBinding annotationTypeBinding;
        if (this.contentsOffset + 4 >= this.contents.length) {
            this.resizeContents(4);
        }
        if ((annotationTypeBinding = annotation.resolvedType) == null) {
            this.contentsOffset = attributeOffset;
            return;
        }
        int typeIndex = this.constantPool.literalIndex(annotationTypeBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(typeIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)typeIndex;
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairs = normalAnnotation.memberValuePairs;
            if (memberValuePairs != null) {
                int memberValuePairsLength = memberValuePairs.length;
                this.contents[this.contentsOffset++] = (byte)(memberValuePairsLength >> 8);
                this.contents[this.contentsOffset++] = (byte)memberValuePairsLength;
                int i = 0;
                while (i < memberValuePairsLength) {
                    MemberValuePair memberValuePair = memberValuePairs[i];
                    if (this.contentsOffset + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    int elementNameIndex = this.constantPool.literalIndex(memberValuePair.name);
                    this.contents[this.contentsOffset++] = (byte)(elementNameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)elementNameIndex;
                    MethodBinding methodBinding = memberValuePair.binding;
                    if (methodBinding == null) {
                        this.contentsOffset = attributeOffset;
                    } else {
                        this.generateElementValue(memberValuePair.value, methodBinding.returnType, attributeOffset);
                    }
                    ++i;
                }
            } else {
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 1;
            if (this.contentsOffset + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            int elementNameIndex = this.constantPool.literalIndex(TypeConstants.VALUE);
            this.contents[this.contentsOffset++] = (byte)(elementNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)elementNameIndex;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                this.contentsOffset = attributeOffset;
            } else {
                this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType, attributeOffset);
            }
        } else {
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
        }
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int constantValueNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(constantValueNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)constantValueNameIndex;
        this.contentsOffset += 12;
    }

    private void generateElementValue(Expression defaultValue, TypeBinding memberValuePairReturnType, int attributeOffset) {
        Constant constant = defaultValue.constant;
        TypeBinding defaultValueBinding = defaultValue.resolvedType;
        if (defaultValueBinding == null) {
            this.contentsOffset = attributeOffset;
        } else {
            if (memberValuePairReturnType.isArrayType() && !defaultValueBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 1;
            }
            if (constant != null && constant != Constant.NotAConstant) {
                this.generateElementValue(attributeOffset, defaultValue, constant, memberValuePairReturnType.leafComponentType());
            } else {
                this.generateElementValueForNonConstantExpression(defaultValue, attributeOffset, defaultValueBinding);
            }
        }
    }

    private void generateElementValue(int attributeOffset, Expression defaultValue, Constant constant, TypeBinding binding) {
        if (this.contentsOffset + 3 >= this.contents.length) {
            this.resizeContents(3);
        }
        switch (binding.id) {
            case 5: {
                this.contents[this.contentsOffset++] = 90;
                int booleanValueIndex = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[this.contentsOffset++] = (byte)(booleanValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)booleanValueIndex;
                break;
            }
            case 3: {
                this.contents[this.contentsOffset++] = 66;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 2: {
                this.contents[this.contentsOffset++] = 67;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 10: {
                this.contents[this.contentsOffset++] = 73;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 4: {
                this.contents[this.contentsOffset++] = 83;
                int integerValueIndex = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                break;
            }
            case 9: {
                this.contents[this.contentsOffset++] = 70;
                int floatValueIndex = this.constantPool.literalIndex(constant.floatValue());
                this.contents[this.contentsOffset++] = (byte)(floatValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)floatValueIndex;
                break;
            }
            case 8: {
                this.contents[this.contentsOffset++] = 68;
                int doubleValueIndex = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[this.contentsOffset++] = (byte)(doubleValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)doubleValueIndex;
                break;
            }
            case 7: {
                this.contents[this.contentsOffset++] = 74;
                int longValueIndex = this.constantPool.literalIndex(constant.longValue());
                this.contents[this.contentsOffset++] = (byte)(longValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)longValueIndex;
                break;
            }
            case 11: {
                this.contents[this.contentsOffset++] = 115;
                int stringValueIndex = this.constantPool.literalIndex(((StringConstant)constant).stringValue().toCharArray());
                if (stringValueIndex == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(defaultValue);
                        break;
                    }
                    this.contentsOffset = attributeOffset;
                    break;
                }
                this.contents[this.contentsOffset++] = (byte)(stringValueIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)stringValueIndex;
            }
        }
    }

    private void generateElementValueForNonConstantExpression(Expression defaultValue, int attributeOffset, TypeBinding defaultValueBinding) {
        if (defaultValueBinding != null) {
            if (defaultValueBinding.isEnum()) {
                NameReference nameReference;
                if (this.contentsOffset + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[this.contentsOffset++] = 101;
                FieldBinding fieldBinding = null;
                if (defaultValue instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (defaultValue instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)defaultValue;
                    fieldBinding = (FieldBinding)((SingleNameReference)nameReference).binding;
                } else {
                    this.contentsOffset = attributeOffset;
                }
                if (fieldBinding != null) {
                    int enumConstantTypeNameIndex = this.constantPool.literalIndex(fieldBinding.type.signature());
                    int enumConstantNameIndex = this.constantPool.literalIndex(fieldBinding.name);
                    this.contents[this.contentsOffset++] = (byte)(enumConstantTypeNameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)enumConstantTypeNameIndex;
                    this.contents[this.contentsOffset++] = (byte)(enumConstantNameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)enumConstantNameIndex;
                }
            } else if (defaultValueBinding.isAnnotationType()) {
                if (this.contentsOffset + 1 >= this.contents.length) {
                    this.resizeContents(1);
                }
                this.contents[this.contentsOffset++] = 64;
                this.generateAnnotation((Annotation)defaultValue, attributeOffset);
            } else if (defaultValueBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                if (defaultValue instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)defaultValue;
                    int arrayLength = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    this.contents[this.contentsOffset++] = (byte)(arrayLength >> 8);
                    this.contents[this.contentsOffset++] = (byte)arrayLength;
                    int i = 0;
                    while (i < arrayLength) {
                        this.generateElementValue(arrayInitializer.expressions[i], defaultValueBinding.leafComponentType(), attributeOffset);
                        ++i;
                    }
                } else {
                    this.contentsOffset = attributeOffset;
                }
            } else {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 99;
                if (defaultValue instanceof ClassLiteralAccess) {
                    ClassLiteralAccess classLiteralAccess = (ClassLiteralAccess)defaultValue;
                    int classInfoIndex = this.constantPool.literalIndex(classLiteralAccess.targetType.signature());
                    this.contents[this.contentsOffset++] = (byte)(classInfoIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)classInfoIndex;
                } else {
                    this.contentsOffset = attributeOffset;
                }
            }
        } else {
            this.contentsOffset = attributeOffset;
        }
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding) {
        return this.generateMethodInfoAttribute(methodBinding, false, null);
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, boolean createProblemMethod) {
        return this.generateMethodInfoAttribute(methodBinding, createProblemMethod, null);
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, AnnotationMethodDeclaration declaration) {
        int attributesNumber = this.generateMethodInfoAttribute(methodBinding);
        int attributeOffset = this.contentsOffset;
        if ((declaration.modifiers & 0x20000) != 0) {
            int annotationDefaultNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.AnnotationDefaultName);
            this.contents[this.contentsOffset++] = (byte)(annotationDefaultNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)annotationDefaultNameIndex;
            int attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            if (this.contentsOffset + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            this.generateElementValue(declaration.defaultValue, declaration.binding.returnType, attributeOffset);
            if (this.contentsOffset != attributeOffset) {
                int attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            }
        }
        return attributesNumber;
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, boolean createProblemMethod, List extraAttributes) {
        AbstractMethodDeclaration methodDeclaration;
        char[] genericSignature;
        this.contentsOffset += 2;
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        int attributeNumber = 0;
        ReferenceBinding[] thrownsExceptions = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            int length = thrownsExceptions.length;
            int exSize = 8 + length * 2;
            if (exSize + this.contentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            int exceptionNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
            this.contents[this.contentsOffset++] = (byte)(exceptionNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)exceptionNameIndex;
            int attributeLength = length * 2 + 2;
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 24);
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 16);
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeLength;
            this.contents[this.contentsOffset++] = (byte)(length >> 8);
            this.contents[this.contentsOffset++] = (byte)length;
            int i = 0;
            while (i < length) {
                int exceptionIndex = this.constantPool.literalIndexForType(thrownsExceptions[i]);
                this.contents[this.contentsOffset++] = (byte)(exceptionIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)exceptionIndex;
                ++i;
            }
            ++attributeNumber;
        }
        if (methodBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if (this.targetJDK < 0x310000L) {
            if (methodBinding.isSynthetic()) {
                if (this.contentsOffset + 6 >= this.contents.length) {
                    this.resizeContents(6);
                }
                int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
                this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                ++attributeNumber;
            }
            if (methodBinding.isVarargs()) {
                if (this.contentsOffset + 6 >= this.contents.length) {
                    this.resizeContents(6);
                }
                int varargsAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.VarargsName);
                this.contents[this.contentsOffset++] = (byte)(varargsAttributeNameIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)varargsAttributeNameIndex;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
                ++attributeNumber;
            }
        }
        if ((genericSignature = methodBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int signatureAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(signatureAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int signatureIndex = this.constantPool.literalIndex(genericSignature);
            this.contents[this.contentsOffset++] = (byte)(signatureIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)signatureIndex;
            ++attributeNumber;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && !createProblemMethod && (methodDeclaration = methodBinding.sourceMethod()) != null) {
            Argument[] arguments;
            Annotation[] annotations = methodDeclaration.annotations;
            if (annotations != null) {
                attributeNumber += this.generateRuntimeAnnotations(annotations);
            }
            if ((methodBinding.tagBits & 0x400L) != 0L && (arguments = methodDeclaration.arguments) != null) {
                attributeNumber += this.generateRuntimeAnnotationsForParameters(arguments);
            }
        }
        if (extraAttributes != null) {
            int i = 0;
            int len = extraAttributes.size();
            while (i < len) {
                IAttribute attribute = (IAttribute)extraAttributes.get(i);
                short nameIndex = (short)this.constantPool.literalIndex(attribute.getNameChars());
                this.writeToContents(attribute.getAllBytes(nameIndex));
                ++attributeNumber;
                ++i;
            }
        }
        return attributeNumber;
    }

    void writeToContents(byte[] data) {
        int N = data.length;
        if (this.contentsOffset + N >= this.contents.length) {
            this.resizeContents(N);
        }
        System.arraycopy(data, 0, this.contents, this.contentsOffset, N);
        this.contentsOffset += N;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int accessFlags) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            accessFlags &= 0xFFFFEF7F;
        }
        if ((methodBinding.tagBits & 0x400L) != 0L) {
            accessFlags &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int nameIndex = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(methodBinding.signature(this));
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int nameIndex = this.constantPool.literalIndex(ConstantPool.Clinit);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(ConstantPool.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarations, CompilationResult compilationResult) {
        if (methodDeclarations != null) {
            TypeDeclaration currentDeclaration = this.referenceBinding.scope.referenceContext;
            int typeDeclarationSourceStart = currentDeclaration.sourceStart();
            int typeDeclarationSourceEnd = currentDeclaration.sourceEnd();
            int i = 0;
            int max = methodDeclarations.length;
            while (i < max) {
                MethodDeclaration methodDeclaration = methodDeclarations[i];
                MethodBinding methodBinding = methodDeclaration.binding;
                String readableName = new String(methodBinding.readableName());
                CategorizedProblem[] problems = compilationResult.problems;
                int problemsCount = compilationResult.problemCount;
                int j = 0;
                while (j < problemsCount) {
                    CategorizedProblem problem = problems[j];
                    if (problem != null && problem.getID() == 67109264 && problem.getMessage().indexOf(readableName) != -1 && problem.getSourceStart() >= typeDeclarationSourceStart && problem.getSourceEnd() <= typeDeclarationSourceEnd) {
                        this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, problem, compilationResult);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private int generateRuntimeAnnotations(Annotation[] annotations) {
        int attributeLength;
        Annotation annotation;
        int i;
        int annotationsLengthOffset;
        int attributeLengthOffset;
        int annotationAttributeOffset;
        int attributesNumber = 0;
        int length = annotations.length;
        int visibleAnnotationsCounter = 0;
        int invisibleAnnotationsCounter = 0;
        int i2 = 0;
        while (i2 < length) {
            Annotation annotation2 = annotations[i2];
            if (this.isRuntimeInvisible(annotation2)) {
                ++invisibleAnnotationsCounter;
            } else if (this.isRuntimeVisible(annotation2)) {
                ++visibleAnnotationsCounter;
            }
            ++i2;
        }
        if (invisibleAnnotationsCounter != 0) {
            annotationAttributeOffset = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int runtimeInvisibleAnnotationsAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(runtimeInvisibleAnnotationsAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)runtimeInvisibleAnnotationsAttributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            annotationsLengthOffset = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[annotationsLengthOffset++] = (byte)(invisibleAnnotationsCounter >> 8);
            this.contents[annotationsLengthOffset++] = (byte)invisibleAnnotationsCounter;
            i = 0;
            while (i < length) {
                if (invisibleAnnotationsCounter == 0) break;
                annotation = annotations[i];
                if (this.isRuntimeInvisible(annotation)) {
                    this.generateAnnotation(annotation, annotationAttributeOffset);
                    --invisibleAnnotationsCounter;
                    if (this.contentsOffset == annotationAttributeOffset) break;
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        if (visibleAnnotationsCounter != 0) {
            annotationAttributeOffset = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int runtimeVisibleAnnotationsAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(runtimeVisibleAnnotationsAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)runtimeVisibleAnnotationsAttributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            annotationsLengthOffset = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[annotationsLengthOffset++] = (byte)(visibleAnnotationsCounter >> 8);
            this.contents[annotationsLengthOffset++] = (byte)visibleAnnotationsCounter;
            i = 0;
            while (i < length) {
                if (visibleAnnotationsCounter == 0) break;
                annotation = annotations[i];
                if (this.isRuntimeVisible(annotation)) {
                    --visibleAnnotationsCounter;
                    this.generateAnnotation(annotation, annotationAttributeOffset);
                    if (this.contentsOffset == annotationAttributeOffset) break;
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        return attributesNumber;
    }

    private int generateRuntimeAnnotationsForParameters(Argument[] arguments) {
        int attributeLength;
        Annotation annotation;
        int max;
        int j;
        Annotation[] annotations;
        Argument argument;
        int i;
        int attributeLengthOffset;
        int argumentsLength = arguments.length;
        boolean VISIBLE_INDEX = false;
        boolean INVISIBLE_INDEX = true;
        int invisibleParametersAnnotationsCounter = 0;
        int visibleParametersAnnotationsCounter = 0;
        int[][] annotationsCounters = new int[argumentsLength][2];
        int i2 = 0;
        while (i2 < argumentsLength) {
            Argument argument2 = arguments[i2];
            Annotation[] annotations2 = argument2.annotations;
            if (annotations2 != null) {
                int j2 = 0;
                int max2 = annotations2.length;
                while (j2 < max2) {
                    Annotation annotation2 = annotations2[j2];
                    if (this.isRuntimeInvisible(annotation2)) {
                        int[] nArray = annotationsCounters[i2];
                        nArray[1] = nArray[1] + 1;
                        ++invisibleParametersAnnotationsCounter;
                    } else if (this.isRuntimeVisible(annotation2)) {
                        int[] nArray = annotationsCounters[i2];
                        nArray[0] = nArray[0] + 1;
                        ++visibleParametersAnnotationsCounter;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        int attributesNumber = 0;
        int annotationAttributeOffset = this.contentsOffset;
        if (invisibleParametersAnnotationsCounter != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int attributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(attributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)argumentsLength;
            i = 0;
            block2: while (i < argumentsLength) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (invisibleParametersAnnotationsCounter == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int numberOfInvisibleAnnotations = annotationsCounters[i][1];
                    this.contents[this.contentsOffset++] = (byte)(numberOfInvisibleAnnotations >> 8);
                    this.contents[this.contentsOffset++] = (byte)numberOfInvisibleAnnotations;
                    if (numberOfInvisibleAnnotations != 0) {
                        argument = arguments[i];
                        annotations = argument.annotations;
                        j = 0;
                        max = annotations.length;
                        while (j < max) {
                            annotation = annotations[j];
                            if (this.isRuntimeInvisible(annotation)) {
                                this.generateAnnotation(annotation, annotationAttributeOffset);
                                if (this.contentsOffset == annotationAttributeOffset) break block2;
                                --invisibleParametersAnnotationsCounter;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        if (visibleParametersAnnotationsCounter != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int attributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(attributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeNameIndex;
            attributeLengthOffset = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)argumentsLength;
            i = 0;
            block4: while (i < argumentsLength) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (visibleParametersAnnotationsCounter == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int numberOfVisibleAnnotations = annotationsCounters[i][0];
                    this.contents[this.contentsOffset++] = (byte)(numberOfVisibleAnnotations >> 8);
                    this.contents[this.contentsOffset++] = (byte)numberOfVisibleAnnotations;
                    if (numberOfVisibleAnnotations != 0) {
                        argument = arguments[i];
                        annotations = argument.annotations;
                        j = 0;
                        max = annotations.length;
                        while (j < max) {
                            annotation = annotations[j];
                            if (this.isRuntimeVisible(annotation)) {
                                this.generateAnnotation(annotation, annotationAttributeOffset);
                                if (this.contentsOffset == annotationAttributeOffset) break block4;
                                --visibleParametersAnnotationsCounter;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (this.contentsOffset != annotationAttributeOffset) {
                attributeLength = this.contentsOffset - attributeLengthOffset - 4;
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 24);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 16);
                this.contents[attributeLengthOffset++] = (byte)(attributeLength >> 8);
                this.contents[attributeLengthOffset++] = (byte)attributeLength;
                ++attributesNumber;
            } else {
                this.contentsOffset = annotationAttributeOffset;
            }
        }
        return attributesNumber;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = new byte[this.headerOffset + this.contentsOffset];
            System.arraycopy(this.header, 0, this.bytes, 0, this.headerOffset);
            System.arraycopy(this.contents, 0, this.bytes, this.headerOffset, this.contentsOffset);
        }
        return this.bytes;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    protected void initByteArrays() {
        int members = this.referenceBinding.methods().length + this.referenceBinding.fields().length;
        this.header = new byte[1500];
        this.contents = new byte[members < 15 ? 400 : 1500];
    }

    public void initialize(SourceTypeBinding aType, ClassFile parentClassFile, boolean createProblemType) {
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 8);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 0);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 24);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool.initialize(this);
        int accessFlags = aType.getAccessFlags();
        if (aType.isPrivate()) {
            accessFlags &= 0xFFFFFFFE;
        }
        if (aType.isProtected()) {
            accessFlags |= 1;
        }
        accessFlags &= 0xFFFFF6D1;
        if (!aType.isInterface()) {
            accessFlags |= 0x20;
        }
        this.enclosingClassFile = parentClassFile;
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int classNameIndex = this.constantPool.literalIndexForType(aType);
        this.contents[this.contentsOffset++] = (byte)(classNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)classNameIndex;
        ReferenceBinding superclass = null;
        int superclassNameIndex = -1;
        superclass = aType.originalSuperclass != null ? aType.originalSuperclass : aType.superclass;
        superclassNameIndex = aType.isInterface() ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : (superclass == null ? 0 : this.constantPool.literalIndexForType(superclass.constantPoolName()));
        this.contents[this.contentsOffset++] = (byte)(superclassNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)superclassNameIndex;
        ReferenceBinding[] superInterfacesBinding = null;
        superInterfacesBinding = aType.originalSuperInterfaces != null ? aType.originalSuperInterfaces : aType.superInterfaces();
        int interfacesCount = superInterfacesBinding.length;
        this.contents[this.contentsOffset++] = (byte)(interfacesCount >> 8);
        this.contents[this.contentsOffset++] = (byte)interfacesCount;
        int i = 0;
        while (i < interfacesCount) {
            int interfaceIndex = this.constantPool.literalIndexForType(superInterfacesBinding[i]);
            this.contents[this.contentsOffset++] = (byte)(interfaceIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)interfaceIndex;
            ++i;
        }
        this.creatingProblemType = createProblemType;
        if (this.enclosingClassFile == null) {
            this.codeStream.maxFieldCount = aType.scope.referenceType().maxFieldCount;
        } else {
            ClassFile outermostClassFile = this.outerMostEnclosingClassFile();
            this.codeStream.maxFieldCount = outermostClassFile.codeStream.maxFieldCount;
        }
    }

    private boolean isRuntimeInvisible(Annotation annotation) {
        TypeBinding annotationBinding = annotation.resolvedType;
        if (annotationBinding == null) {
            return false;
        }
        long metaTagBits = annotationBinding.getAnnotationTagBits();
        if ((metaTagBits & 0x300000000000L) == 0L) {
            return true;
        }
        return (metaTagBits & 0x300000000000L) == 0x200000000000L;
    }

    private boolean isRuntimeVisible(Annotation annotation) {
        TypeBinding annotationBinding = annotation.resolvedType;
        if (annotationBinding == null) {
            return false;
        }
        long metaTagBits = annotationBinding.getAnnotationTagBits();
        if ((metaTagBits & 0x300000000000L) == 0L) {
            return false;
        }
        return (metaTagBits & 0x300000000000L) == 0x300000000000L;
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile current = this;
        while (current.enclosingClassFile != null) {
            current = current.enclosingClassFile;
        }
        return current;
    }

    public void recordInnerClasses(TypeBinding binding) {
        if (this.innerClassesBindings == null) {
            this.innerClassesBindings = new HashSet(5);
        }
        ReferenceBinding innerClass = (ReferenceBinding)binding;
        this.innerClassesBindings.add(innerClass.erasure());
        ReferenceBinding enclosingType = innerClass.enclosingType();
        while (enclosingType != null && enclosingType.isNestedType()) {
            this.innerClassesBindings.add(enclosingType.erasure());
            enclosingType = enclosingType.enclosingType();
        }
    }

    public void reset(SourceTypeBinding typeBinding) {
        CompilerOptions options = typeBinding.scope.compilerOptions();
        this.referenceBinding = typeBinding;
        this.targetJDK = options.targetJDK;
        this.produceAttributes = options.produceDebugAttributes;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
        }
        this.bytes = null;
        this.constantPool.reset();
        this.codeStream.reset(this);
        this.constantPoolOffset = 0;
        this.contentsOffset = 0;
        this.creatingProblemType = false;
        this.enclosingClassFile = null;
        this.headerOffset = 0;
        this.methodCount = 0;
        this.methodCountOffset = 0;
        if (this.innerClassesBindings != null) {
            this.innerClassesBindings.clear();
        }
    }

    private final void resizeContents(int minimalSize) {
        int length = this.contents.length;
        int toAdd = length;
        if (toAdd < minimalSize) {
            toAdd = minimalSize;
        }
        this.contents = new byte[length + toAdd];
        System.arraycopy(this.contents, 0, this.contents, 0, length);
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody0(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody1$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody2(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody3$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody4(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody5$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody6(ClassFile classFile, SyntheticMethodBinding syntheticMethodBinding) {
        return syntheticMethodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody7$advice(ClassFile this_, SyntheticMethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody8(ClassFile classFile, SyntheticMethodBinding syntheticMethodBinding) {
        return syntheticMethodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody9$advice(ClassFile this_, SyntheticMethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody10(ClassFile classFile, SyntheticMethodBinding syntheticMethodBinding) {
        return syntheticMethodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody11$advice(ClassFile this_, SyntheticMethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody12(ClassFile classFile, SyntheticMethodBinding syntheticMethodBinding) {
        return syntheticMethodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody13$advice(ClassFile this_, SyntheticMethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody14(ClassFile classFile, SyntheticMethodBinding syntheticMethodBinding) {
        return syntheticMethodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody15$advice(ClassFile this_, SyntheticMethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody16(ClassFile classFile, SyntheticMethodBinding syntheticMethodBinding) {
        return syntheticMethodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody17$advice(ClassFile this_, SyntheticMethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody18(ClassFile classFile, SyntheticMethodBinding syntheticMethodBinding) {
        return syntheticMethodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody19$advice(ClassFile this_, SyntheticMethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody20(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody21$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody22(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody23$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody24(ClassFile classFile, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody25$advice(ClassFile this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }
}

