/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.AbstractIconRegistry;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;

public abstract class StructureViewNodeFactory {
    private AbstractIconRegistry iconRegistry;

    public StructureViewNodeFactory(AbstractIconRegistry iconRegistry) {
        this.iconRegistry = iconRegistry;
    }

    public IStructureViewNode createNode(IProgramElement node) {
        return this.createNode(node, null);
    }

    public IStructureViewNode createNode(IProgramElement node, List children) {
        AbstractIcon icon = this.iconRegistry.getStructureIcon(node.getKind(), node.getAccessibility());
        IStructureViewNode svNode = this.createDeclaration(node, icon, children);
        String nodeHandle = node.getHandleIdentifier();
        if (nodeHandle != null && !node.getKind().equals(IProgramElement.Kind.FIELD)) {
            List relationships;
            AsmManager manager = AsmManager.getDefault();
            IRelationshipMap relMap = manager == null ? null : manager.getRelationshipMap();
            List list = relationships = relMap == null ? null : relMap.get(nodeHandle);
            if (relationships != null) {
                Iterator it = relationships.iterator();
                while (it.hasNext()) {
                    IStructureViewNode relNode;
                    IRelationship rel = (IRelationship)it.next();
                    if (rel == null || rel.getTargets().size() <= 0 || (relNode = this.createRelationship(rel, this.iconRegistry.getIcon(rel.getKind()))) == null) continue;
                    svNode.add(relNode, 0);
                    Iterator it2 = rel.getTargets().iterator();
                    while (it2.hasNext()) {
                        String handle = (String)it2.next();
                        IProgramElement link = AsmManager.getDefault().getHierarchy().findElementForHandle(handle);
                        if (link == null) continue;
                        IStructureViewNode linkNode = this.createLink(link, this.iconRegistry.getStructureIcon(link.getKind(), link.getAccessibility()));
                        relNode.add(linkNode);
                    }
                }
            }
        }
        return svNode;
    }

    protected abstract IStructureViewNode createLink(IProgramElement var1, AbstractIcon var2);

    protected abstract IStructureViewNode createRelationship(IRelationship var1, AbstractIcon var2);

    protected abstract IStructureViewNode createDeclaration(IProgramElement var1, AbstractIcon var2, List var3);

    public static boolean acceptNode(IProgramElement parent, IProgramElement child) {
        return parent.getKind() != IProgramElement.Kind.CLASS || child.getKind() != IProgramElement.Kind.CODE;
    }
}

