/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import java.util.Iterator;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.AbstractCompilerAdapter;
import org.aspectj.ajdt.internal.compiler.AjClassFile;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.compiler.WeaverMessageHandler;
import org.aspectj.asm.internal.CharOperation;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.eclipse.core.runtime.OperationCanceledException;

public class WeaverAdapter
implements IClassFileProvider,
IWeaveRequestor,
Iterator {
    private AbstractCompilerAdapter compilerAdapter;
    private Iterator resultIterator;
    private int classFileIndex = 0;
    private InterimCompilationResult nowProcessing;
    private InterimCompilationResult lastReturnedResult;
    private WeaverMessageHandler weaverMessageHandler;
    private IProgressListener progressListener;
    private boolean finalPhase = false;
    private int localIteratorCounter;
    private int progressMaxTypes;
    private String progressPhasePrefix;
    private double fromPercent;
    private double toPercent = 100.0;
    private int progressCompletionCount;

    public WeaverAdapter(AbstractCompilerAdapter forCompiler, WeaverMessageHandler weaverMessageHandler, IProgressListener progressListener) {
        this.compilerAdapter = forCompiler;
        this.weaverMessageHandler = weaverMessageHandler;
        this.progressListener = progressListener;
    }

    public Iterator getClassFileIterator() {
        this.classFileIndex = 0;
        this.localIteratorCounter = 0;
        this.nowProcessing = null;
        this.lastReturnedResult = null;
        this.resultIterator = this.compilerAdapter.getResultsPendingWeave().iterator();
        return this;
    }

    public IWeaveRequestor getRequestor() {
        return this;
    }

    public boolean isApplyAtAspectJMungersOnly() {
        return false;
    }

    public boolean hasNext() {
        if (this.nowProcessing == null) {
            if (!this.resultIterator.hasNext()) {
                return false;
            }
            this.nowProcessing = (InterimCompilationResult)this.resultIterator.next();
            this.classFileIndex = 0;
        }
        while (this.nowProcessing.unwovenClassFiles().length == 0) {
            if (!this.resultIterator.hasNext()) {
                return false;
            }
            this.nowProcessing = (InterimCompilationResult)this.resultIterator.next();
        }
        if (this.classFileIndex < this.nowProcessing.unwovenClassFiles().length) {
            return true;
        }
        this.classFileIndex = 0;
        if (!this.resultIterator.hasNext()) {
            return false;
        }
        this.nowProcessing = (InterimCompilationResult)this.resultIterator.next();
        while (this.nowProcessing.unwovenClassFiles().length == 0) {
            if (!this.resultIterator.hasNext()) {
                return false;
            }
            this.nowProcessing = (InterimCompilationResult)this.resultIterator.next();
        }
        return true;
    }

    public Object next() {
        if (!this.hasNext()) {
            return null;
        }
        if (this.finalPhase && this.lastReturnedResult != null && this.lastReturnedResult != this.nowProcessing) {
            this.finishedWith(this.lastReturnedResult);
        }
        ++this.localIteratorCounter;
        this.lastReturnedResult = this.nowProcessing;
        this.weaverMessageHandler.setCurrentResult(this.nowProcessing.result());
        return this.nowProcessing.unwovenClassFiles()[this.classFileIndex++];
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void processingReweavableState() {
        this.fromPercent = 50.0;
    }

    public void addingTypeMungers() {
        this.progressMaxTypes = this.localIteratorCounter;
    }

    public void weavingAspects() {
        this.progressPhasePrefix = "woven aspect ";
        this.progressCompletionCount = 0;
    }

    public void weavingClasses() {
        this.finalPhase = true;
        this.progressPhasePrefix = "woven class ";
    }

    public void weaveCompleted() {
        if (this.lastReturnedResult != null && !this.lastReturnedResult.result().hasBeenAccepted) {
            this.finishedWith(this.lastReturnedResult);
        }
        this.lastReturnedResult = null;
    }

    public void acceptResult(UnwovenClassFile result) {
        char[] key = result.getClassNameAsChars();
        this.removeFromMap(this.lastReturnedResult.result().compiledTypes, key);
        AjClassFile ajcf = new AjClassFile(key, result.getBytes());
        this.lastReturnedResult.result().record(ajcf.fileName(), ajcf);
        if (!this.weaverMessageHandler.isIgnoring(IMessage.INFO) || this.progressListener != null) {
            StringBuffer msg = new StringBuffer();
            msg.append(this.progressPhasePrefix).append(result.getClassName()).append(" (from ").append(this.nowProcessing.fileName()).append(")");
            this.weaverMessageHandler.handleMessage(MessageUtil.info(msg.toString()));
            if (this.progressListener != null) {
                ++this.progressCompletionCount;
                this.recordProgress(this.fromPercent + (double)this.progressCompletionCount / (double)this.progressMaxTypes * (this.toPercent - this.fromPercent), msg.toString());
                if (this.progressListener.isCancelledRequested()) {
                    throw new AbortCompilation(true, new OperationCanceledException("Weaving cancelled as requested"));
                }
            }
        }
    }

    private void finishedWith(InterimCompilationResult result) {
        this.compilerAdapter.acceptResult(result.result());
    }

    private boolean removeFromMap(Map aMap, char[] key) {
        if (aMap.remove(key) != null) {
            return true;
        }
        char[] victim = null;
        Iterator iter = aMap.keySet().iterator();
        while (iter.hasNext()) {
            char[] thisKey = (char[])iter.next();
            if (!CharOperation.equals(thisKey, key)) continue;
            victim = thisKey;
            break;
        }
        if (victim != null) {
            aMap.remove(victim);
            return true;
        }
        return false;
    }

    private void recordProgress(String message) {
        if (this.progressListener != null) {
            this.progressListener.setText(message);
        }
    }

    private void recordProgress(double percentage, String message) {
        if (this.progressListener != null) {
            this.progressListener.setProgress(percentage / 100.0);
            this.progressListener.setText(message);
        }
    }
}

