/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AjMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDesignator;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseScope;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.AbstractPatternNodeVisitor;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public class ValidateAtAspectJAnnotationsVisitor
extends ASTVisitor {
    private static final char[] beforeAdviceSig = "Lorg/aspectj/lang/annotation/Before;".toCharArray();
    private static final char[] afterAdviceSig = "Lorg/aspectj/lang/annotation/After;".toCharArray();
    private static final char[] afterReturningAdviceSig = "Lorg/aspectj/lang/annotation/AfterReturning;".toCharArray();
    private static final char[] afterThrowingAdviceSig = "Lorg/aspectj/lang/annotation/AfterThrowing;".toCharArray();
    private static final char[] aroundAdviceSig = "Lorg/aspectj/lang/annotation/Around;".toCharArray();
    private static final char[] pointcutSig = "Lorg/aspectj/lang/annotation/Pointcut;".toCharArray();
    private static final char[] aspectSig = "Lorg/aspectj/lang/annotation/Aspect;".toCharArray();
    private static final char[] declareParentsSig = "Lorg/aspectj/lang/annotation/DeclareParents;".toCharArray();
    private static final char[] adviceNameSig = "Lorg/aspectj/lang/annotation/AdviceName;".toCharArray();
    private static final char[] orgAspectJLangAnnotation = "org/aspectj/lang/annotation/".toCharArray();
    private static final char[] voidType = "void".toCharArray();
    private static final char[] booleanType = "boolean".toCharArray();
    private static final char[] joinPoint = "Lorg/aspectj/lang/JoinPoint;".toCharArray();
    private static final char[] joinPointStaticPart = "Lorg/aspectj/lang/JoinPoint$StaticPart;".toCharArray();
    private static final char[] joinPointEnclosingStaticPart = "Lorg/aspectj/lang/JoinPoint$EnclosingStaticPart;".toCharArray();
    private static final char[] proceedingJoinPoint = "Lorg/aspectj/lang/ProceedingJoinPoint;".toCharArray();
    private static final char[][] adviceSigs = new char[][]{beforeAdviceSig, afterAdviceSig, afterReturningAdviceSig, afterThrowingAdviceSig, aroundAdviceSig};
    private CompilationUnitDeclaration unit;
    private Stack typeStack = new Stack();
    private AspectJAnnotations ajAnnotations;
    static /* synthetic */ Class class$org$aspectj$ajdt$internal$compiler$ast$AjMethodDeclaration;

    public ValidateAtAspectJAnnotationsVisitor(CompilationUnitDeclaration unit) {
        this.unit = unit;
    }

    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        this.typeStack.push(localTypeDeclaration);
        this.ajAnnotations = new AspectJAnnotations(localTypeDeclaration.annotations);
        this.checkTypeDeclaration(localTypeDeclaration);
        return true;
    }

    public void endVisit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        this.typeStack.pop();
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.typeStack.push(memberTypeDeclaration);
        this.ajAnnotations = new AspectJAnnotations(memberTypeDeclaration.annotations);
        this.checkTypeDeclaration(memberTypeDeclaration);
        return true;
    }

    public void endVisit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.typeStack.pop();
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        this.typeStack.push(typeDeclaration);
        this.ajAnnotations = new AspectJAnnotations(typeDeclaration.annotations);
        this.checkTypeDeclaration(typeDeclaration);
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        this.typeStack.pop();
    }

    private void checkTypeDeclaration(TypeDeclaration typeDecl) {
        ContextToken tok = CompilationAndWeavingContext.enteringPhase(16, typeDecl.name);
        if (!(typeDecl instanceof AspectDeclaration)) {
            if (this.ajAnnotations.hasAspectAnnotation) {
                this.validateAspectDeclaration(typeDecl);
            } else {
                TypeBinding parentBinding;
                TypeReference parentRef = typeDecl.superclass;
                if (parentRef != null && (parentBinding = parentRef.resolvedType) instanceof SourceTypeBinding) {
                    TypeDeclaration parentDecl;
                    SourceTypeBinding parentSTB = (SourceTypeBinding)parentBinding;
                    if (parentSTB.scope != null && this.isAspect(parentDecl = parentSTB.scope.referenceContext)) {
                        typeDecl.scope.problemReporter().signalError(typeDecl.sourceStart, typeDecl.sourceEnd, "a class cannot extend an aspect");
                    }
                }
            }
        } else if (this.ajAnnotations.hasMultipleAspectAnnotations) {
            typeDecl.scope.problemReporter().signalError(typeDecl.sourceStart, typeDecl.sourceEnd, "aspects cannot have @Aspect annotation");
        }
        CompilationAndWeavingContext.leavingPhase(tok);
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.ajAnnotations = new AspectJAnnotations(fieldDeclaration.annotations);
        if (this.ajAnnotations.hasDeclareParents && !this.insideAspect()) {
            scope.problemReporter().signalError(fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd, "DeclareParents can only be used inside an aspect type");
        }
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        if (methodDeclaration.hasErrors()) {
            return false;
        }
        ContextToken tok = CompilationAndWeavingContext.enteringPhase(16, methodDeclaration.selector);
        this.ajAnnotations = new AspectJAnnotations(methodDeclaration.annotations);
        if (!methodDeclaration.getClass().equals(class$org$aspectj$ajdt$internal$compiler$ast$AjMethodDeclaration == null ? (class$org$aspectj$ajdt$internal$compiler$ast$AjMethodDeclaration = ValidateAtAspectJAnnotationsVisitor.class$("org.aspectj.ajdt.internal.compiler.ast.AjMethodDeclaration")) : class$org$aspectj$ajdt$internal$compiler$ast$AjMethodDeclaration)) {
            if (methodDeclaration instanceof PointcutDeclaration) {
                if (this.ajAnnotations.hasMultiplePointcutAnnotations || this.ajAnnotations.hasAdviceAnnotation || this.ajAnnotations.hasAspectAnnotation || this.ajAnnotations.hasAdviceNameAnnotation) {
                    methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "@AspectJ annotations cannot be declared on this aspect member");
                }
            } else if (methodDeclaration instanceof AdviceDeclaration) {
                if (this.ajAnnotations.hasMultipleAdviceAnnotations || this.ajAnnotations.hasAspectAnnotation || this.ajAnnotations.hasPointcutAnnotation) {
                    methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "Only @AdviceName AspectJ annotation allowed on advice");
                }
            } else if (this.ajAnnotations.hasAspectJAnnotations()) {
                methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "@AspectJ annotations cannot be declared on this aspect member");
            }
            CompilationAndWeavingContext.leavingPhase(tok);
            return false;
        }
        if (this.ajAnnotations.hasAdviceAnnotation) {
            this.validateAdvice(methodDeclaration);
        } else if (this.ajAnnotations.hasPointcutAnnotation) {
            this.convertToPointcutDeclaration(methodDeclaration, scope);
        }
        CompilationAndWeavingContext.leavingPhase(tok);
        return false;
    }

    private boolean isAspectJAnnotation(Annotation ann) {
        if (ann.resolvedType == null) {
            return false;
        }
        char[] sig = ann.resolvedType.signature();
        return CharOperation.contains(orgAspectJLangAnnotation, sig);
    }

    private boolean insideAspect() {
        if (this.typeStack.empty()) {
            return false;
        }
        TypeDeclaration typeDecl = (TypeDeclaration)this.typeStack.peek();
        return this.isAspect(typeDecl);
    }

    private boolean isAspect(TypeDeclaration typeDecl) {
        if (typeDecl instanceof AspectDeclaration) {
            return true;
        }
        return new AspectJAnnotations((Annotation[])typeDecl.annotations).hasAspectAnnotation;
    }

    private void validateAspectDeclaration(TypeDeclaration typeDecl) {
        TypeBinding parentBinding;
        TypeReference parentRef;
        if (this.typeStack.size() > 1 && !Modifier.isStatic(typeDecl.modifiers)) {
            typeDecl.scope.problemReporter().signalError(typeDecl.sourceStart, typeDecl.sourceEnd, "inner aspects must be static");
            return;
        }
        SourceTypeBinding binding = typeDecl.binding;
        if (binding != null && (binding.isEnum() || binding.isInterface() || binding.isAnnotationType())) {
            typeDecl.scope.problemReporter().signalError(typeDecl.sourceStart, typeDecl.sourceEnd, "only classes can have an @Aspect annotation");
        }
        if ((parentRef = typeDecl.superclass) != null && (parentBinding = parentRef.resolvedType) instanceof SourceTypeBinding) {
            TypeDeclaration parentDecl;
            SourceTypeBinding parentSTB = (SourceTypeBinding)parentBinding;
            if (parentSTB.scope != null && this.isAspect(parentDecl = parentSTB.scope.referenceContext) && !Modifier.isAbstract(parentDecl.modifiers)) {
                typeDecl.scope.problemReporter().signalError(typeDecl.sourceStart, typeDecl.sourceEnd, "cannot extend a concrete aspect");
            }
        }
        Annotation aspectAnnotation = this.ajAnnotations.aspectAnnotation;
        int[] pcLoc = new int[2];
        String perClause = this.getStringLiteralFor("value", aspectAnnotation, pcLoc);
        AspectDeclaration aspectDecl = new AspectDeclaration(typeDecl.compilationResult);
        try {
            if (perClause != null && !perClause.equals("")) {
                EclipseSourceContext context = new EclipseSourceContext(this.unit.compilationResult, pcLoc[0]);
                PerClause pc = new PatternParser(perClause, context).maybeParsePerClause();
                FormalBinding[] bindings = new FormalBinding[]{};
                if (pc != null) {
                    pc.resolve(new EclipseScope(bindings, typeDecl.scope));
                }
            }
        }
        catch (ParserException pEx) {
            typeDecl.scope.problemReporter().parseError(pcLoc[0] + pEx.getLocation().getStart(), pcLoc[0] + pEx.getLocation().getEnd(), -1, perClause.toCharArray(), perClause, new String[]{pEx.getMessage()});
        }
    }

    private void validateAdvice(MethodDeclaration methodDeclaration) {
        String returningFormal;
        int[] throwingLocation;
        String thrownFormal;
        if (!this.insideAspect()) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "Advice must be declared inside an aspect type");
        }
        if (!Modifier.isPublic(methodDeclaration.modifiers)) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "advice must be public");
        }
        if (Modifier.isStatic(methodDeclaration.modifiers)) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "advice can not be declared static");
        }
        if (this.ajAnnotations.hasMultipleAdviceAnnotations) {
            methodDeclaration.scope.problemReporter().disallowedTargetForAnnotation(this.ajAnnotations.duplicateAdviceAnnotation);
        }
        if (this.ajAnnotations.hasPointcutAnnotation) {
            methodDeclaration.scope.problemReporter().disallowedTargetForAnnotation(this.ajAnnotations.pointcutAnnotation);
        }
        if (this.ajAnnotations.hasAspectAnnotation) {
            methodDeclaration.scope.problemReporter().disallowedTargetForAnnotation(this.ajAnnotations.aspectAnnotation);
        }
        if (this.ajAnnotations.hasAdviceNameAnnotation) {
            methodDeclaration.scope.problemReporter().disallowedTargetForAnnotation(this.ajAnnotations.adviceNameAnnotation);
        }
        if (this.ajAnnotations.adviceKind != AdviceKind.Around) {
            this.ensureVoidReturnType(methodDeclaration);
        }
        if (this.ajAnnotations.adviceKind == AdviceKind.AfterThrowing && (thrownFormal = this.getStringLiteralFor("throwing", this.ajAnnotations.adviceAnnotation, throwingLocation = new int[2])) != null) {
            Argument[] arguments = methodDeclaration.arguments;
            if (!this.toArgumentNames(methodDeclaration.arguments).contains(thrownFormal)) {
                methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "throwing formal '" + thrownFormal + "' must be declared as a parameter in the advice signature");
            }
        }
        if (this.ajAnnotations.adviceKind == AdviceKind.AfterReturning && (returningFormal = this.getStringLiteralFor("returning", this.ajAnnotations.adviceAnnotation, throwingLocation = new int[2])) != null && !this.toArgumentNames(methodDeclaration.arguments).contains(returningFormal)) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "returning formal '" + returningFormal + "' must be declared as a parameter in the advice signature");
        }
        this.resolveAndSetPointcut(methodDeclaration, this.ajAnnotations.adviceAnnotation);
    }

    private List toArgumentNames(Argument[] arguments) {
        ArrayList<String> names = new ArrayList<String>();
        if (arguments == null) {
            return names;
        }
        for (int i = 0; i < arguments.length; ++i) {
            names.add(new String(arguments[i].name));
        }
        return names;
    }

    private void resolveAndSetPointcut(MethodDeclaration methodDeclaration, Annotation adviceAnn) {
        int[] pcLocation = new int[2];
        String pointcutExpression = this.getStringLiteralFor("pointcut", adviceAnn, pcLocation);
        if (pointcutExpression == null) {
            pointcutExpression = this.getStringLiteralFor("value", adviceAnn, pcLocation);
        }
        try {
            EclipseSourceContext context = new EclipseSourceContext(this.unit.compilationResult, pcLocation[0]);
            Pointcut pc = new PatternParser(pointcutExpression, context).parsePointcut();
            FormalBinding[] bindings = this.buildFormalAdviceBindingsFrom(methodDeclaration);
            pc.resolve(new EclipseScope(bindings, methodDeclaration.scope));
            EclipseFactory factory = EclipseFactory.fromScopeLookupEnvironment(methodDeclaration.scope);
            UnresolvedType[] paramTypes = new UnresolvedType[bindings.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = bindings[i].getType();
            }
            ResolvedPointcutDefinition resPcutDef = new ResolvedPointcutDefinition(factory.fromBinding(((TypeDeclaration)this.typeStack.peek()).binding), methodDeclaration.modifiers, "anonymous", paramTypes, pc);
            AjAttribute.PointcutDeclarationAttribute attr = new AjAttribute.PointcutDeclarationAttribute(resPcutDef);
            ((AjMethodDeclaration)methodDeclaration).addAttribute(new EclipseAttributeAdapter(attr));
        }
        catch (ParserException pEx) {
            methodDeclaration.scope.problemReporter().parseError(pcLocation[0] + pEx.getLocation().getStart(), pcLocation[0] + pEx.getLocation().getEnd(), -1, pointcutExpression.toCharArray(), pointcutExpression, new String[]{pEx.getMessage()});
        }
    }

    private void ensureVoidReturnType(MethodDeclaration methodDeclaration) {
        boolean returnsVoid = true;
        if (methodDeclaration.returnType instanceof SingleTypeReference) {
            SingleTypeReference retType = (SingleTypeReference)methodDeclaration.returnType;
            if (!CharOperation.equals(voidType, retType.token)) {
                returnsVoid = false;
            }
        } else {
            returnsVoid = false;
        }
        if (!returnsVoid) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, "This advice must return void");
        }
    }

    private FormalBinding[] buildFormalAdviceBindingsFrom(MethodDeclaration mDecl) {
        if (mDecl.arguments == null) {
            return new FormalBinding[0];
        }
        if (mDecl.binding == null) {
            return new FormalBinding[0];
        }
        EclipseFactory factory = EclipseFactory.fromScopeLookupEnvironment(mDecl.scope);
        String extraArgName = this.maybeGetExtraArgName();
        if (extraArgName == null) {
            extraArgName = "";
        }
        FormalBinding[] ret = new FormalBinding[mDecl.arguments.length];
        for (int i = 0; i < mDecl.arguments.length; ++i) {
            Argument arg = mDecl.arguments[i];
            String name = new String(arg.name);
            TypeBinding argTypeBinding = mDecl.binding.parameters[i];
            UnresolvedType type = factory.fromBinding(argTypeBinding);
            ret[i] = CharOperation.equals(joinPoint, argTypeBinding.signature()) || CharOperation.equals(joinPointStaticPart, argTypeBinding.signature()) || CharOperation.equals(joinPointEnclosingStaticPart, argTypeBinding.signature()) || CharOperation.equals(proceedingJoinPoint, argTypeBinding.signature()) || name.equals(extraArgName) ? new FormalBinding.ImplicitFormalBinding(type, name, i) : new FormalBinding(type, name, i, arg.sourceStart, arg.sourceEnd, "unknown");
        }
        return ret;
    }

    private String maybeGetExtraArgName() {
        String argName = null;
        if (this.ajAnnotations.adviceKind == AdviceKind.AfterReturning) {
            argName = this.getStringLiteralFor("returning", this.ajAnnotations.adviceAnnotation, new int[2]);
        } else if (this.ajAnnotations.adviceKind == AdviceKind.AfterThrowing) {
            argName = this.getStringLiteralFor("throwing", this.ajAnnotations.adviceAnnotation, new int[2]);
        }
        return argName;
    }

    private String getStringLiteralFor(String memberName, Annotation inAnnotation, int[] location) {
        if (inAnnotation instanceof SingleMemberAnnotation && memberName.equals("value")) {
            SingleMemberAnnotation sma = (SingleMemberAnnotation)inAnnotation;
            if (sma.memberValue instanceof StringLiteral) {
                StringLiteral sv = (StringLiteral)sma.memberValue;
                location[0] = sv.sourceStart;
                location[1] = sv.sourceEnd;
                return new String(sv.source());
            }
            if (sma.memberValue instanceof NameReference && ((NameReference)sma.memberValue).binding instanceof FieldBinding) {
                Binding b = ((NameReference)sma.memberValue).binding;
                Constant c = ((FieldBinding)b).constant;
                return c.stringValue();
            }
        }
        if (!(inAnnotation instanceof NormalAnnotation)) {
            return null;
        }
        NormalAnnotation ann = (NormalAnnotation)inAnnotation;
        MemberValuePair[] mvps = ann.memberValuePairs;
        if (mvps == null) {
            return null;
        }
        for (int i = 0; i < mvps.length; ++i) {
            if (!CharOperation.equals(memberName.toCharArray(), mvps[i].name) || !(mvps[i].value instanceof StringLiteral)) continue;
            StringLiteral sv = (StringLiteral)mvps[i].value;
            location[0] = sv.sourceStart;
            location[1] = sv.sourceEnd;
            return new String(sv.source());
        }
        return null;
    }

    private void convertToPointcutDeclaration(MethodDeclaration methodDeclaration, ClassScope scope) {
        TypeDeclaration typeDecl = (TypeDeclaration)this.typeStack.peek();
        if (typeDecl.binding != null && !typeDecl.binding.isClass()) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "pointcuts can only be declared in a class or an aspect");
        }
        if (methodDeclaration.thrownExceptions != null && methodDeclaration.thrownExceptions.length > 0) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.sourceStart, methodDeclaration.sourceEnd, "pointcuts cannot throw exceptions!");
        }
        PointcutDeclaration pcDecl = new PointcutDeclaration(this.unit.compilationResult);
        this.copyAllFields(methodDeclaration, pcDecl);
        if (this.ajAnnotations.hasAdviceAnnotation) {
            methodDeclaration.scope.problemReporter().disallowedTargetForAnnotation(this.ajAnnotations.adviceAnnotation);
        }
        if (this.ajAnnotations.hasAspectAnnotation) {
            methodDeclaration.scope.problemReporter().disallowedTargetForAnnotation(this.ajAnnotations.aspectAnnotation);
        }
        if (this.ajAnnotations.hasAdviceNameAnnotation) {
            methodDeclaration.scope.problemReporter().disallowedTargetForAnnotation(this.ajAnnotations.adviceNameAnnotation);
        }
        boolean noValueSupplied = true;
        boolean containsIfPcd = false;
        int[] pcLocation = new int[2];
        String pointcutExpression = this.getStringLiteralFor("value", this.ajAnnotations.pointcutAnnotation, pcLocation);
        try {
            EclipseSourceContext context = new EclipseSourceContext(this.unit.compilationResult, pcLocation[0]);
            Pointcut pc = null;
            if (pointcutExpression == null || pointcutExpression.length() == 0) {
                noValueSupplied = true;
            } else {
                noValueSupplied = false;
                pc = new PatternParser(pointcutExpression, context).parsePointcut();
            }
            pcDecl.pointcutDesignator = pc == null ? null : new PointcutDesignator(pc);
            pcDecl.setGenerateSyntheticPointcutMethod();
            TypeDeclaration onType = (TypeDeclaration)this.typeStack.peek();
            pcDecl.postParse(onType);
            FormalBinding[] bindings = this.buildFormalAdviceBindingsFrom(methodDeclaration);
            this.swap(onType, methodDeclaration, pcDecl);
            if (pc != null) {
                pc.resolve(new EclipseScope(bindings, methodDeclaration.scope));
                HasIfPCDVisitor ifFinder = new HasIfPCDVisitor();
                pc.traverse(ifFinder, null);
                containsIfPcd = ifFinder.containsIfPcd;
            }
        }
        catch (ParserException pEx) {
            methodDeclaration.scope.problemReporter().parseError(pcLocation[0] + pEx.getLocation().getStart(), pcLocation[0] + pEx.getLocation().getEnd(), -1, pointcutExpression.toCharArray(), pointcutExpression, new String[]{pEx.getMessage()});
        }
        boolean returnsVoid = false;
        boolean returnsBoolean = false;
        if (methodDeclaration.returnType instanceof SingleTypeReference) {
            SingleTypeReference retType = (SingleTypeReference)methodDeclaration.returnType;
            if (CharOperation.equals(voidType, retType.token)) {
                returnsVoid = true;
            }
            if (CharOperation.equals(booleanType, retType.token)) {
                returnsBoolean = true;
            }
        }
        if (!returnsVoid && !containsIfPcd) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, "Methods annotated with @Pointcut must return void unless the pointcut contains an if() expression");
        }
        if (!returnsBoolean && containsIfPcd) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, "Methods annotated with @Pointcut must return boolean when the pointcut contains an if() expression");
        }
        if (methodDeclaration.statements != null && methodDeclaration.statements.length > 0 && !containsIfPcd) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, "Pointcuts without an if() expression should have an empty method body");
        }
        if (pcDecl.pointcutDesignator == null) {
            if (!Modifier.isAbstract(methodDeclaration.modifiers) && !noValueSupplied) {
                methodDeclaration.scope.problemReporter().signalError(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, "Method annotated with @Pointcut() for abstract pointcut must be abstract");
            }
        } else if (Modifier.isAbstract(methodDeclaration.modifiers)) {
            methodDeclaration.scope.problemReporter().signalError(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, "Method annotated with non abstract @Pointcut(\"" + pointcutExpression + "\") is abstract");
        }
    }

    private void copyAllFields(MethodDeclaration from, MethodDeclaration to) {
        to.annotations = from.annotations;
        to.arguments = from.arguments;
        to.binding = from.binding;
        to.bits = from.bits;
        to.bodyEnd = from.bodyEnd;
        to.bodyStart = from.bodyStart;
        to.declarationSourceEnd = from.declarationSourceEnd;
        to.declarationSourceStart = from.declarationSourceStart;
        to.explicitDeclarations = from.explicitDeclarations;
        to.ignoreFurtherInvestigation = from.ignoreFurtherInvestigation;
        to.javadoc = from.javadoc;
        to.modifiers = from.modifiers;
        to.modifiersSourceStart = from.modifiersSourceStart;
        to.returnType = from.returnType;
        to.scope = from.scope;
        to.selector = from.selector;
        to.sourceEnd = from.sourceEnd;
        to.sourceStart = from.sourceStart;
        to.statements = from.statements;
        to.thrownExceptions = from.thrownExceptions;
        to.typeParameters = from.typeParameters;
    }

    private void swap(TypeDeclaration inType, MethodDeclaration thisDeclaration, MethodDeclaration forThatDeclaration) {
        for (int i = 0; i < inType.methods.length; ++i) {
            if (inType.methods[i] != thisDeclaration) continue;
            inType.methods[i] = forThatDeclaration;
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HasIfPCDVisitor
    extends AbstractPatternNodeVisitor {
        public boolean containsIfPcd = false;

        private HasIfPCDVisitor() {
        }

        public Object visit(IfPointcut node, Object data) {
            this.containsIfPcd = true;
            return data;
        }
    }

    private static class AspectJAnnotations {
        boolean hasAdviceAnnotation = false;
        boolean hasPointcutAnnotation = false;
        boolean hasAspectAnnotation = false;
        boolean hasAdviceNameAnnotation = false;
        boolean hasDeclareParents = false;
        boolean hasMultipleAdviceAnnotations = false;
        boolean hasMultiplePointcutAnnotations = false;
        boolean hasMultipleAspectAnnotations = false;
        AdviceKind adviceKind = null;
        Annotation adviceAnnotation = null;
        Annotation pointcutAnnotation = null;
        Annotation aspectAnnotation = null;
        Annotation adviceNameAnnotation = null;
        Annotation duplicateAdviceAnnotation = null;
        Annotation duplicatePointcutAnnotation = null;
        Annotation duplicateAspectAnnotation = null;

        public AspectJAnnotations(Annotation[] annotations) {
            if (annotations == null) {
                return;
            }
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i].resolvedType == null) continue;
                char[] sig = annotations[i].resolvedType.signature();
                if (CharOperation.equals(afterAdviceSig, sig)) {
                    this.adviceKind = AdviceKind.After;
                    this.addAdviceAnnotation(annotations[i]);
                    continue;
                }
                if (CharOperation.equals(afterReturningAdviceSig, sig)) {
                    this.adviceKind = AdviceKind.AfterReturning;
                    this.addAdviceAnnotation(annotations[i]);
                    continue;
                }
                if (CharOperation.equals(afterThrowingAdviceSig, sig)) {
                    this.adviceKind = AdviceKind.AfterThrowing;
                    this.addAdviceAnnotation(annotations[i]);
                    continue;
                }
                if (CharOperation.equals(beforeAdviceSig, sig)) {
                    this.adviceKind = AdviceKind.Before;
                    this.addAdviceAnnotation(annotations[i]);
                    continue;
                }
                if (CharOperation.equals(aroundAdviceSig, sig)) {
                    this.adviceKind = AdviceKind.Around;
                    this.addAdviceAnnotation(annotations[i]);
                    continue;
                }
                if (CharOperation.equals(adviceNameSig, sig)) {
                    this.hasAdviceNameAnnotation = true;
                    this.adviceNameAnnotation = annotations[i];
                    continue;
                }
                if (CharOperation.equals(declareParentsSig, sig)) {
                    this.hasDeclareParents = true;
                    continue;
                }
                if (CharOperation.equals(aspectSig, sig)) {
                    if (this.hasAspectAnnotation) {
                        this.hasMultipleAspectAnnotations = true;
                        this.duplicateAspectAnnotation = annotations[i];
                        continue;
                    }
                    this.hasAspectAnnotation = true;
                    this.aspectAnnotation = annotations[i];
                    continue;
                }
                if (!CharOperation.equals(pointcutSig, sig)) continue;
                if (this.hasPointcutAnnotation) {
                    this.hasMultiplePointcutAnnotations = true;
                    this.duplicatePointcutAnnotation = annotations[i];
                    continue;
                }
                this.hasPointcutAnnotation = true;
                this.pointcutAnnotation = annotations[i];
            }
        }

        public boolean hasAspectJAnnotations() {
            return this.hasAdviceAnnotation || this.hasPointcutAnnotation || this.hasAdviceNameAnnotation || this.hasAspectAnnotation;
        }

        private void addAdviceAnnotation(Annotation annotation) {
            if (!this.hasAdviceAnnotation) {
                this.hasAdviceAnnotation = true;
                this.adviceAnnotation = annotation;
            } else {
                this.hasMultipleAdviceAnnotations = true;
                this.duplicateAdviceAnnotation = annotation;
            }
        }
    }
}

