/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.Map;
import org.aspectj.weaver.BoundedReferenceTypeDelegate;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVariableReferenceType
extends ReferenceType
implements TypeVariableReference {
    private TypeVariable typeVariable;
    boolean fixedUp = false;

    public TypeVariableReferenceType(TypeVariable typeVariable, World world) {
        super(typeVariable.getGenericSignature(), typeVariable.getErasureSignature(), world);
        this.typeVariable = typeVariable;
    }

    @Override
    public ReferenceTypeDelegate getDelegate() {
        if (this.delegate == null) {
            this.setDelegate(new BoundedReferenceTypeDelegate((ReferenceType)this.typeVariable.getFirstBound().resolve(this.world)));
        }
        return this.delegate;
    }

    @Override
    public UnresolvedType parameterize(Map<String, UnresolvedType> typeBindings) {
        UnresolvedType ut = typeBindings.get(this.getName());
        if (ut != null) {
            return this.world.resolve(ut);
        }
        return this;
    }

    @Override
    public TypeVariable getTypeVariable() {
        return this.typeVariable;
    }

    @Override
    public boolean isTypeVariableReference() {
        return true;
    }

    @Override
    public String toString() {
        return this.typeVariable.getName();
    }

    @Override
    public boolean isGenericWildcard() {
        return false;
    }

    @Override
    public boolean isAnnotation() {
        ReferenceType upper = (ReferenceType)this.typeVariable.getUpperBound();
        if (upper.isAnnotation()) {
            return true;
        }
        World world = upper.getWorld();
        this.typeVariable.resolve(world);
        ResolvedType annotationType = ResolvedType.ANNOTATION.resolve(world);
        UnresolvedType[] ifBounds = this.typeVariable.getSuperInterfaces();
        for (int i = 0; i < ifBounds.length; ++i) {
            if (((ReferenceType)ifBounds[i]).isAnnotation()) {
                return true;
            }
            if (!ifBounds[i].equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append("T");
        sb.append(this.typeVariable.getName());
        sb.append(";");
        return sb.toString();
    }

    public String getTypeVariableName() {
        return this.typeVariable.getName();
    }

    public ReferenceType getUpperBound() {
        return (ReferenceType)this.typeVariable.resolve(this.world).getUpperBound();
    }
}

