/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.core;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.ajde.ui.UserPreferencesAdapter;
import org.aspectj.tools.ajbrowser.BrowserManager;
import org.aspectj.tools.ajbrowser.core.BrowserOutputLocationManager;

public class BrowserCompilerConfiguration
implements ICompilerConfiguration {
    private UserPreferencesAdapter preferencesAdapter;
    private IOutputLocationManager locationManager;

    public BrowserCompilerConfiguration(UserPreferencesAdapter preferencesAdapter) {
        this.preferencesAdapter = preferencesAdapter;
    }

    public String getClasspath() {
        StringBuffer classpath = new StringBuffer();
        String userPath = this.preferencesAdapter.getProjectPreference("build.classpath");
        if (userPath != null && userPath.trim().length() != 0) {
            classpath.append(userPath);
        }
        List outputDirs = this.getOutputLocationManager().getAllOutputLocations();
        Iterator iterator = outputDirs.iterator();
        while (iterator.hasNext()) {
            File dir = (File)iterator.next();
            classpath.append(File.pathSeparator + dir.getAbsolutePath() + File.pathSeparator);
        }
        classpath.append(System.getProperty("java.class.path", "."));
        return classpath.toString();
    }

    public Map getJavaOptionsMap() {
        return BrowserManager.getDefault().getJavaBuildOptions().getJavaBuildOptionsMap();
    }

    public String getNonStandardOptions() {
        return this.preferencesAdapter.getProjectPreference("ajc.nonStandardOptions");
    }

    public IOutputLocationManager getOutputLocationManager() {
        if (this.locationManager == null) {
            this.locationManager = new BrowserOutputLocationManager(this.preferencesAdapter);
        }
        return this.locationManager;
    }

    public List getProjectSourceFiles() {
        return null;
    }

    public List getProjectSourceFilesChanged() {
        return null;
    }

    public Map getSourcePathResources() {
        return null;
    }

    public Set getAspectPath() {
        return null;
    }

    public Set getInpath() {
        return null;
    }

    public String getOutJar() {
        return null;
    }

    public int getConfigurationChanges() {
        return 65535;
    }

    public void configurationRead() {
    }

    public List getClasspathElementsWithModifiedContents() {
        return null;
    }
}

