/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.StringTokenizer;
import org.aspectj.ajdt.internal.compiler.CompilationResultDestinationManager;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeFieldDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AsmElementFormatter;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.CharOperation;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.ReferencePointcut;
import org.aspectj.weaver.patterns.TypePatternList;

public class AsmHierarchyBuilder
extends ASTVisitor {
    protected AsmElementFormatter formatter = new AsmElementFormatter();
    protected AjBuildConfig buildConfig;
    protected Stack stack;
    protected ImportReference packageDecl = null;
    private CompilationResult currCompilationResult;
    private String filename;
    int[] lineseps;
    private AsmManager activeStructureModel = null;
    private Initializer inInitializer = null;

    public void buildStructureForCompilationUnit(CompilationUnitDeclaration cuDeclaration, AsmManager structureModel, AjBuildConfig buildConfig) {
        this.currCompilationResult = cuDeclaration.compilationResult();
        this.filename = new String(this.currCompilationResult.fileName);
        this.lineseps = this.currCompilationResult.lineSeparatorPositions;
        LangUtil.throwIaxIfNull(this.currCompilationResult, "result");
        this.stack = new Stack();
        this.packageDecl = null;
        this.buildConfig = buildConfig;
        this.internalBuild(cuDeclaration, structureModel);
        this.buildConfig = null;
        this.currCompilationResult = null;
        this.stack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalBuild(CompilationUnitDeclaration unit, AsmManager structureModel) {
        LangUtil.throwIaxIfNull(structureModel, "structureModel");
        try {
            this.activeStructureModel = structureModel;
            File file = new File(new String(unit.getFileName()));
            int startLine = this.getStartLine(unit);
            int endLine = this.getEndLine(unit);
            SourceLocation sourceLocation = new SourceLocation(file, startLine, endLine);
            sourceLocation.setOffset(unit.sourceStart);
            ProgramElement cuNode = new ProgramElement(structureModel, new String(file.getName()), IProgramElement.Kind.FILE_JAVA, sourceLocation, 0, null, null);
            cuNode.addChild(new ProgramElement(structureModel, "", IProgramElement.Kind.IMPORT_REFERENCE, null, 0, null, null));
            IProgramElement addToNode = this.genAddToNode(file, unit, structureModel);
            if (addToNode != null && addToNode.getChildren() != null) {
                ListIterator itt = addToNode.getChildren().listIterator();
                while (itt.hasNext()) {
                    IProgramElement child = (IProgramElement)itt.next();
                    ISourceLocation childLoc = child.getSourceLocation();
                    if (null == childLoc || !childLoc.getSourceFile().equals(file)) continue;
                    itt.remove();
                }
            }
            addToNode.addChild(cuNode);
            this.stack.push(cuNode);
            unit.traverse((ASTVisitor)this, unit.scope);
            try {
                structureModel.getHierarchy().addToFileMap(file.getCanonicalPath(), cuNode);
            }
            catch (IOException e) {
                System.err.println("IOException " + e.getMessage() + " creating path for " + file);
            }
        }
        finally {
            this.activeStructureModel = null;
        }
    }

    private IProgramElement findOrCreateChildSourceFolder(String sourceFolder, AsmManager structureModel) {
        IProgramElement root = structureModel.getHierarchy().getRoot();
        IProgramElement sourceFolderNode = null;
        List kids = root.getChildren();
        Iterator iterator = kids.iterator();
        while (iterator.hasNext()) {
            IProgramElement child = (IProgramElement)iterator.next();
            if (child.getKind() != IProgramElement.Kind.SOURCE_FOLDER || !child.getName().equals(sourceFolder)) continue;
            sourceFolderNode = child;
            break;
        }
        if (sourceFolderNode == null) {
            sourceFolderNode = new ProgramElement(structureModel, sourceFolder, IProgramElement.Kind.SOURCE_FOLDER, new ArrayList());
            root.addChild(sourceFolderNode);
        }
        return sourceFolderNode;
    }

    private IProgramElement genAddToNode(File sourceFile, CompilationUnitDeclaration unit, AsmManager structureModel) {
        String pkgName;
        CompilationResultDestinationManager manager = this.buildConfig.getCompilationResultDestinationManager();
        String sourceFolder = manager == null ? null : manager.getSourceFolderForFile(sourceFile);
        ImportReference unitPackage = unit.currentPackage;
        IProgramElement rootForSource = structureModel.getHierarchy().getRoot();
        if (sourceFolder != null) {
            rootForSource = this.findOrCreateChildSourceFolder(sourceFolder, structureModel);
        }
        if (unitPackage == null) {
            pkgName = "";
        } else {
            StringBuffer nameBuffer = new StringBuffer();
            char[][] importName = unitPackage.getImportName();
            int last = importName.length - 1;
            for (int i = 0; i < importName.length; ++i) {
                nameBuffer.append(new String(importName[i]));
                if (i >= last) continue;
                nameBuffer.append('.');
            }
            pkgName = nameBuffer.toString();
        }
        IProgramElement pkgNode = null;
        if (structureModel != null && structureModel.getHierarchy().getRoot() != null && rootForSource.getChildren() != null) {
            Iterator it = rootForSource.getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement currNode = (IProgramElement)it.next();
                if (!pkgName.equals(currNode.getName())) continue;
                pkgNode = currNode;
                break;
            }
        }
        if (pkgNode == null) {
            pkgNode = new ProgramElement(this.activeStructureModel, pkgName, IProgramElement.Kind.PACKAGE, new ArrayList());
            rootForSource.addChild(pkgNode);
        }
        ProgramElement addToNode = pkgNode;
        return addToNode;
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        String name = new String(typeDeclaration.name);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (typeDeclaration instanceof AspectDeclaration) {
            kind = IProgramElement.Kind.ASPECT;
        } else if (TypeDeclaration.kind(typeDeclaration.modifiers) == 2) {
            kind = IProgramElement.Kind.INTERFACE;
        } else if (TypeDeclaration.kind(typeDeclaration.modifiers) == 3) {
            kind = IProgramElement.Kind.ENUM;
        } else if (TypeDeclaration.kind(typeDeclaration.modifiers) == 4) {
            kind = IProgramElement.Kind.ANNOTATION;
        }
        boolean isAnnotationStyleAspect = false;
        if (typeDeclaration.annotations != null) {
            for (int i = 0; i < typeDeclaration.annotations.length; ++i) {
                String[] temp;
                Annotation annotation = typeDeclaration.annotations[i];
                if (Arrays.equals(annotation.type.getTypeBindingPublic(scope).signature(), "Lorg/aspectj/lang/annotation/Aspect;".toCharArray())) {
                    kind = IProgramElement.Kind.ASPECT;
                    if (typeDeclaration instanceof AspectDeclaration) continue;
                    isAnnotationStyleAspect = true;
                    continue;
                }
                if (annotation.resolvedType == null || (temp = new String(annotation.resolvedType.constantPoolName()).split("/")).length <= 1) continue;
                char[][] path = new char[temp.length][];
                for (int k = 0; k < temp.length; ++k) {
                    path[k] = temp[k].toCharArray();
                }
                ImportReference importRef = new ImportReference(path, new long[]{0L}, false, 0);
                ProgramElement ceNode = new ProgramElement(this.activeStructureModel, importRef.toString(), IProgramElement.Kind.IMPORT_REFERENCE, this.makeLocation(importRef), 0, null, null);
                ceNode.setSourceSignature(this.genSourceSignature(importRef));
                ProgramElement imports = this.getImportReferencesRoot();
                imports.addChild(0, ceNode);
            }
        }
        int typeModifiers = typeDeclaration.modifiers;
        if (typeDeclaration instanceof AspectDeclaration) {
            typeModifiers = ((AspectDeclaration)typeDeclaration).getDeclaredModifiers();
        }
        ProgramElement peNode = new ProgramElement(this.activeStructureModel, name, kind, this.makeLocation(typeDeclaration), typeModifiers, null, null);
        peNode.setSourceSignature(this.genSourceSignature(typeDeclaration));
        peNode.setFormalComment(this.generateJavadocComment(typeDeclaration));
        peNode.setAnnotationStyleDeclaration(isAnnotationStyleAspect);
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        if (this.packageDecl != null) {
            int dotIndex = this.packageDecl.toString().lastIndexOf(46);
            String packageString = this.packageDecl.toString();
            if (dotIndex != -1) {
                packageString = this.packageDecl.toString().substring(0, dotIndex);
            }
            ProgramElement packageDeclaration = new ProgramElement(this.activeStructureModel, packageString, IProgramElement.Kind.PACKAGE_DECLARATION, this.makeLocation(this.packageDecl), 0, null, null);
            StringBuffer packageSourceDeclaration = new StringBuffer();
            packageSourceDeclaration.append("package ");
            packageSourceDeclaration.append(packageString);
            packageSourceDeclaration.append(";");
            packageDeclaration.setSourceSignature(packageSourceDeclaration.toString());
            this.stack.pop();
            ProgramElement containingTypeElement = (ProgramElement)this.stack.peek();
            containingTypeElement.addChild(0, packageDeclaration);
            this.packageDecl = null;
        } else {
            this.stack.pop();
        }
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        String name = new String(memberTypeDeclaration.name);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        int typeDeclarationKind = TypeDeclaration.kind(memberTypeDeclaration.modifiers);
        if (memberTypeDeclaration instanceof AspectDeclaration) {
            kind = IProgramElement.Kind.ASPECT;
        } else if (typeDeclarationKind == 2) {
            kind = IProgramElement.Kind.INTERFACE;
        } else if (typeDeclarationKind == 3) {
            kind = IProgramElement.Kind.ENUM;
        } else if (typeDeclarationKind == 4) {
            kind = IProgramElement.Kind.ANNOTATION;
        }
        boolean isAnnotationStyleAspect = false;
        if (memberTypeDeclaration.annotations != null) {
            for (int i = 0; i < memberTypeDeclaration.annotations.length; ++i) {
                Annotation annotation = memberTypeDeclaration.annotations[i];
                if (!Arrays.equals(annotation.type.getTypeBindingPublic(scope).signature(), "Lorg/aspectj/lang/annotation/Aspect;".toCharArray())) continue;
                kind = IProgramElement.Kind.ASPECT;
                if (memberTypeDeclaration instanceof AspectDeclaration) continue;
                isAnnotationStyleAspect = true;
            }
        }
        int typeModifiers = memberTypeDeclaration.modifiers;
        if (memberTypeDeclaration instanceof AspectDeclaration) {
            typeModifiers = ((AspectDeclaration)memberTypeDeclaration).getDeclaredModifiers();
        }
        ProgramElement peNode = new ProgramElement(this.activeStructureModel, name, kind, this.makeLocation(memberTypeDeclaration), typeModifiers, null, null);
        peNode.setSourceSignature(this.genSourceSignature(memberTypeDeclaration));
        peNode.setFormalComment(this.generateJavadocComment(memberTypeDeclaration));
        peNode.setAnnotationStyleDeclaration(isAnnotationStyleAspect);
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, BlockScope scope) {
        String fullName = "<undefined>";
        if (memberTypeDeclaration.allocation != null && memberTypeDeclaration.allocation.type != null) {
            fullName = "new " + memberTypeDeclaration.allocation.type.toString() + "() {..}";
        } else if (memberTypeDeclaration.binding != null && memberTypeDeclaration.binding.constantPoolName() != null) {
            fullName = new String(memberTypeDeclaration.name);
            int dollar = fullName.indexOf(36);
            fullName = fullName.substring(dollar + 1);
        }
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (TypeDeclaration.kind(memberTypeDeclaration.modifiers) == 2) {
            kind = IProgramElement.Kind.INTERFACE;
        } else if (TypeDeclaration.kind(memberTypeDeclaration.modifiers) == 3) {
            kind = IProgramElement.Kind.ENUM;
        } else if (TypeDeclaration.kind(memberTypeDeclaration.modifiers) == 4) {
            kind = IProgramElement.Kind.ANNOTATION;
        }
        boolean isAnnotationStyleAspect = false;
        if (memberTypeDeclaration.annotations != null) {
            for (int i = 0; i < memberTypeDeclaration.annotations.length; ++i) {
                Annotation annotation = memberTypeDeclaration.annotations[i];
                if (!Arrays.equals(annotation.type.getTypeBindingPublic(scope).signature(), "Lorg/aspectj/lang/annotation/Aspect;".toCharArray())) continue;
                kind = IProgramElement.Kind.ASPECT;
                if (memberTypeDeclaration instanceof AspectDeclaration) break;
                isAnnotationStyleAspect = true;
                break;
            }
        }
        ProgramElement peNode = new ProgramElement(this.activeStructureModel, fullName, kind, this.makeLocation(memberTypeDeclaration), memberTypeDeclaration.modifiers, null, null);
        peNode.setSourceSignature(this.genSourceSignature(memberTypeDeclaration));
        peNode.setFormalComment(this.generateJavadocComment(memberTypeDeclaration));
        peNode.setAnnotationStyleDeclaration(isAnnotationStyleAspect);
        if (peNode.getBytecodeSignature() == null && memberTypeDeclaration.binding != null && memberTypeDeclaration.binding.constantPoolName() != null) {
            StringTokenizer st = new StringTokenizer(new String(memberTypeDeclaration.binding.constantPoolName()), "/");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (st.hasMoreTokens()) continue;
                peNode.setBytecodeSignature(s);
            }
        }
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration memberTypeDeclaration, BlockScope scope) {
        this.stack.pop();
    }

    private String genSourceSignature(TypeDeclaration typeDeclaration) {
        StringBuffer output = new StringBuffer();
        typeDeclaration.printHeader(0, output);
        return output.toString();
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        ProgramElement peNode = null;
        if (methodDeclaration instanceof InterTypeDeclaration) {
            InterTypeDeclaration itd = (InterTypeDeclaration)methodDeclaration;
            ResolvedMember sig = itd.getSignature();
            peNode = new ProgramElement(this.activeStructureModel, null, IProgramElement.Kind.ERROR, this.makeLocation(methodDeclaration), sig != null ? sig.getModifiers() : 0, null, null);
        } else {
            peNode = new ProgramElement(this.activeStructureModel, null, IProgramElement.Kind.ERROR, this.makeLocation(methodDeclaration), methodDeclaration.modifiers, null, null);
        }
        this.formatter.genLabelAndKind(methodDeclaration, peNode);
        this.genBytecodeInfo(methodDeclaration, peNode);
        List namedPointcuts = this.genNamedPointcuts(methodDeclaration);
        if (methodDeclaration instanceof DeclareDeclaration) {
            DeclareDeclaration dDeclaration = (DeclareDeclaration)methodDeclaration;
            Declare decl = dDeclaration.declareDecl;
            if (decl instanceof DeclareParents) {
                TypePatternList tpl = ((DeclareParents)decl).getParents();
                ArrayList<String> parents = new ArrayList<String>();
                for (int i = 0; i < tpl.size(); ++i) {
                    parents.add(tpl.get(i).getExactType().getName().replaceAll("\\$", "."));
                }
                peNode.setParentTypes(parents);
            }
            if (decl instanceof DeclareAnnotation) {
                ResolvedType annotationType = ((DeclareAnnotation)decl).getAnnotationType();
                peNode.setAnnotationType(annotationType.getName());
            }
        }
        if (methodDeclaration.returnType != null) {
            if (peNode.getKind().equals(IProgramElement.Kind.INTER_TYPE_FIELD)) {
                InterTypeFieldDeclaration itfd = (InterTypeFieldDeclaration)methodDeclaration;
                if (itfd.getRealFieldType() != null) {
                    peNode.setCorrespondingType(new String(itfd.getRealFieldType().readableName()));
                } else {
                    peNode.setCorrespondingType(null);
                }
            } else if (methodDeclaration.returnType.resolvedType != null) {
                peNode.setCorrespondingType(new String(methodDeclaration.returnType.resolvedType.readableName()));
            } else {
                peNode.setCorrespondingType(null);
            }
        } else {
            peNode.setCorrespondingType(null);
        }
        peNode.setSourceSignature(this.genSourceSignature(methodDeclaration));
        peNode.setFormalComment(this.generateJavadocComment(methodDeclaration));
        if (peNode.getKind().equals(IProgramElement.Kind.METHOD) && peNode.getName().charAt(0) == 'm' && (peNode.toLabelString().equals("main(String[])") || peNode.toLabelString().equals("main(java.lang.String[])")) && peNode.getModifiers().contains(IProgramElement.Modifiers.STATIC) && peNode.getAccessibility().equals(IProgramElement.Accessibility.PUBLIC)) {
            ((IProgramElement)this.stack.peek()).setRunnable(true);
        }
        this.stack.push(peNode);
        return true;
    }

    private ResolvedMember getPointcutDeclaration(ReferencePointcut rp, MethodDeclaration declaration) {
        ResolvedMember[] members;
        EclipseFactory factory = ((AjLookupEnvironment)declaration.scope.environment()).factory;
        World world = factory.getWorld();
        UnresolvedType onType = rp.onType;
        if (onType == null) {
            if (declaration.binding != null) {
                ResolvedMember member = factory.makeResolvedMember(declaration.binding);
                onType = member.getDeclaringType();
            } else {
                return null;
            }
        }
        if ((members = onType.resolve(world).getDeclaredPointcuts()) != null) {
            for (int i = 0; i < members.length; ++i) {
                if (!members[i].getName().equals(rp.name)) continue;
                return members[i];
            }
        }
        return null;
    }

    private List genNamedPointcuts(MethodDeclaration methodDeclaration) {
        ArrayList pointcuts = new ArrayList();
        if (methodDeclaration instanceof AdviceDeclaration) {
            if (((AdviceDeclaration)methodDeclaration).pointcutDesignator != null) {
                this.addAllNamed(((AdviceDeclaration)methodDeclaration).pointcutDesignator.getPointcut(), pointcuts);
            }
        } else if (methodDeclaration instanceof PointcutDeclaration && ((PointcutDeclaration)methodDeclaration).pointcutDesignator != null) {
            this.addAllNamed(((PointcutDeclaration)methodDeclaration).pointcutDesignator.getPointcut(), pointcuts);
        }
        return pointcuts;
    }

    private void addAllNamed(Pointcut pointcut, List pointcuts) {
        if (pointcut == null) {
            return;
        }
        if (pointcut instanceof ReferencePointcut) {
            ReferencePointcut rp = (ReferencePointcut)pointcut;
            pointcuts.add(rp);
        } else if (pointcut instanceof AndPointcut) {
            AndPointcut ap = (AndPointcut)pointcut;
            this.addAllNamed(ap.getLeft(), pointcuts);
            this.addAllNamed(ap.getRight(), pointcuts);
        } else if (pointcut instanceof OrPointcut) {
            OrPointcut op = (OrPointcut)pointcut;
            this.addAllNamed(op.getLeft(), pointcuts);
            this.addAllNamed(op.getRight(), pointcuts);
        }
    }

    private String genSourceSignature(MethodDeclaration methodDeclaration) {
        int i;
        StringBuffer output = new StringBuffer();
        ASTNode.printModifiers(methodDeclaration.modifiers, output);
        TypeParameter[] types = methodDeclaration.typeParameters();
        if (types != null && types.length != 0) {
            output.append("<");
            for (i = 0; i < types.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                types[i].printStatement(0, output);
            }
            output.append("> ");
        }
        methodDeclaration.printReturnType(0, output).append(methodDeclaration.selector).append('(');
        if (methodDeclaration.arguments != null) {
            for (i = 0; i < methodDeclaration.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                methodDeclaration.arguments[i].print(0, output);
            }
        }
        output.append(')');
        if (methodDeclaration.thrownExceptions != null) {
            output.append(" throws ");
            for (i = 0; i < methodDeclaration.thrownExceptions.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                methodDeclaration.thrownExceptions[i].print(0, output);
            }
        }
        return output.toString();
    }

    protected void genBytecodeInfo(MethodDeclaration methodDeclaration, IProgramElement peNode) {
        if (methodDeclaration.binding != null) {
            try {
                EclipseFactory factory = ((AjLookupEnvironment)methodDeclaration.scope.environment()).factory;
                ResolvedMember member = factory.makeResolvedMember(methodDeclaration.binding);
                peNode.setBytecodeName(member.getName());
                peNode.setBytecodeSignature(member.getSignature());
            }
            catch (BCException bce) {
                bce.printStackTrace();
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
        ((IProgramElement)this.stack.peek()).addChild(peNode);
    }

    public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(ImportReference importRef, CompilationUnitScope scope) {
        int dotIndex = importRef.toString().lastIndexOf(46);
        String currPackageImport = "";
        if (dotIndex != -1) {
            currPackageImport = importRef.toString().substring(0, dotIndex);
        }
        if (((IProgramElement)this.stack.peek()).getPackageName().equals(currPackageImport)) {
            this.packageDecl = importRef;
        } else {
            ProgramElement peNode = new ProgramElement(this.activeStructureModel, new String(importRef.toString()), IProgramElement.Kind.IMPORT_REFERENCE, this.makeLocation(importRef), 0, null, null);
            if (importRef.isStatic()) {
                peNode.addModifiers(IProgramElement.Modifiers.STATIC);
            }
            peNode.setSourceSignature(this.genSourceSignature(importRef));
            IProgramElement containingTypeElement = (IProgramElement)this.stack.peek();
            ProgramElement imports = this.getImportReferencesRoot();
            imports.addChild(0, peNode);
            this.stack.push(peNode);
        }
        return true;
    }

    private ProgramElement getImportReferencesRoot() {
        IProgramElement element = (IProgramElement)this.stack.peek();
        boolean hasPackageDeclaration = ((IProgramElement)element.getChildren().get(0)).getKind().isPackageDeclaration();
        return (ProgramElement)element.getChildren().get(hasPackageDeclaration ? 1 : 0);
    }

    public void endVisit(ImportReference importRef, CompilationUnitScope scope) {
        int dotIndex = importRef.toString().lastIndexOf(46);
        String currPackageImport = "";
        if (dotIndex != -1) {
            currPackageImport = importRef.toString().substring(0, dotIndex);
        }
        if (!((IProgramElement)this.stack.peek()).getPackageName().equals(currPackageImport)) {
            this.stack.pop();
        }
    }

    private String genSourceSignature(ImportReference importreference) {
        StringBuffer output = new StringBuffer();
        output.append("import ");
        ASTNode.printModifiers(importreference.modifiers, output);
        output.append(importreference);
        output.append(";");
        return output.toString();
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        ProgramElement peNode = null;
        if (fieldDeclaration.type == null) {
            peNode = new ProgramElement(this.activeStructureModel, new String(fieldDeclaration.name), IProgramElement.Kind.ENUM_VALUE, this.makeLocation(fieldDeclaration), fieldDeclaration.modifiers, null, null);
            peNode.setCorrespondingType(fieldDeclaration.binding.type.debugName());
        } else {
            peNode = new ProgramElement(this.activeStructureModel, new String(fieldDeclaration.name), IProgramElement.Kind.FIELD, this.makeLocation(fieldDeclaration), fieldDeclaration.modifiers, null, null);
            peNode.setCorrespondingType(fieldDeclaration.type.toString());
        }
        peNode.setSourceSignature(this.genSourceSignature(fieldDeclaration));
        peNode.setFormalComment(this.generateJavadocComment(fieldDeclaration));
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.stack.pop();
    }

    protected String generateJavadocComment(ASTNode astNode) {
        if (this.buildConfig != null && !this.buildConfig.isGenerateJavadocsInModelMode()) {
            return null;
        }
        int startIndex = -1;
        if (astNode instanceof MethodDeclaration) {
            startIndex = ((MethodDeclaration)astNode).declarationSourceStart;
        } else if (astNode instanceof FieldDeclaration) {
            startIndex = ((FieldDeclaration)astNode).declarationSourceStart;
        } else if (astNode instanceof TypeDeclaration) {
            startIndex = ((TypeDeclaration)astNode).declarationSourceStart;
        } else if (astNode instanceof ConstructorDeclaration) {
            startIndex = ((ConstructorDeclaration)astNode).declarationSourceStart;
        }
        if (startIndex == -1) {
            return null;
        }
        if (this.currCompilationResult.compilationUnit.getContents()[startIndex] == '/') {
            char[] comment = CharOperation.subarray(this.currCompilationResult.compilationUnit.getContents(), startIndex, astNode.sourceStart);
            while (comment.length > 2) {
                int star = CharOperation.indexOf('*', comment);
                if (star == -1) {
                    return null;
                }
                if (star != 0 && comment[star - 1] == '/' && comment[star + 1] == '*' && (star - 2 < 0 || comment[star - 2] != '/')) {
                    boolean completed = false;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < comment.length && !completed; ++i) {
                        char curr = comment[i];
                        if (curr == '/' && sb.length() > 2 && sb.charAt(sb.length() - 1) == '*') {
                            completed = true;
                        }
                        sb.append(comment[i]);
                    }
                    if (sb.toString().indexOf("/**") != 0) {
                        return sb.toString().substring(sb.toString().indexOf("/**"));
                    }
                    return sb.toString();
                }
                comment = CharOperation.subarray(comment, star + 1, comment.length);
            }
        }
        return null;
    }

    protected String genSourceSignature(FieldDeclaration fieldDeclaration) {
        StringBuffer output = new StringBuffer();
        if (fieldDeclaration.type == null) {
            output.append(fieldDeclaration.name);
            return output.toString();
        }
        ASTNode.printModifiers(fieldDeclaration.modifiers, output);
        fieldDeclaration.type.print(0, output).append(' ').append(fieldDeclaration.name);
        output.append(" = ");
        if (fieldDeclaration.initialization != null && (fieldDeclaration.initialization instanceof Literal || fieldDeclaration.initialization instanceof OperatorExpression || fieldDeclaration.initialization instanceof Reference)) {
            fieldDeclaration.initialization.printExpression(0, output);
        } else {
            output.append("null");
        }
        output.append(";\n");
        return output.toString();
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        if ((constructorDeclaration.bits & 0x80) != 0) {
            this.stack.push(null);
            return true;
        }
        StringBuffer argumentsSignature = new StringBuffer();
        argumentsSignature.append("(");
        if (constructorDeclaration.arguments != null) {
            for (int i = 0; i < constructorDeclaration.arguments.length; ++i) {
                argumentsSignature.append(constructorDeclaration.arguments[i].type);
                if (i + 1 >= constructorDeclaration.arguments.length) continue;
                argumentsSignature.append(",");
            }
        }
        argumentsSignature.append(")");
        ProgramElement peNode = new ProgramElement(this.activeStructureModel, new String(constructorDeclaration.selector), IProgramElement.Kind.CONSTRUCTOR, this.makeLocation(constructorDeclaration), constructorDeclaration.modifiers, null, null);
        this.formatter.setParameters(constructorDeclaration, peNode);
        peNode.setModifiers(constructorDeclaration.modifiers);
        peNode.setSourceSignature(this.genSourceSignature(constructorDeclaration));
        peNode.setFormalComment(this.generateJavadocComment(constructorDeclaration));
        if (constructorDeclaration.binding != null) {
            String memberName = "";
            String memberBytecodeSignature = "";
            try {
                EclipseFactory factory = ((AjLookupEnvironment)constructorDeclaration.scope.environment()).factory;
                ResolvedMember member = factory.makeResolvedMember(constructorDeclaration.binding);
                memberName = member.getName();
                memberBytecodeSignature = member.getSignature();
            }
            catch (BCException bce) {
                memberName = "<undefined>";
            }
            catch (NullPointerException npe) {
                memberName = "<undefined>";
            }
            peNode.setBytecodeName(memberName);
            peNode.setBytecodeSignature(memberBytecodeSignature);
        }
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    private String genSourceSignature(ConstructorDeclaration constructorDeclaration) {
        int i;
        StringBuffer output = new StringBuffer();
        ASTNode.printModifiers(constructorDeclaration.modifiers, output);
        TypeParameter[] types = constructorDeclaration.typeParameters();
        if (types != null && types.length != 0) {
            output.append("<");
            for (i = 0; i < types.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                types[i].printStatement(0, output);
            }
            output.append("> ");
        }
        output.append(constructorDeclaration.selector).append('(');
        if (constructorDeclaration.arguments != null) {
            for (i = 0; i < constructorDeclaration.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                constructorDeclaration.arguments[i].print(0, output);
            }
        }
        output.append(')');
        if (constructorDeclaration.thrownExceptions != null) {
            output.append(" throws ");
            for (i = 0; i < constructorDeclaration.thrownExceptions.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                constructorDeclaration.thrownExceptions[i].print(0, output);
            }
        }
        return output.toString();
    }

    public boolean visit(Initializer initializer, MethodScope scope) {
        if (initializer == this.inInitializer) {
            return false;
        }
        this.inInitializer = initializer;
        ProgramElement peNode = new ProgramElement(this.activeStructureModel, "...", IProgramElement.Kind.INITIALIZER, this.makeLocation(initializer), initializer.modifiers, null, null);
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        initializer.block.traverse(this, scope);
        this.stack.pop();
        this.inInitializer = null;
        return false;
    }

    protected ISourceLocation makeLocation(ASTNode node) {
        String fileName = "";
        if (this.filename != null) {
            fileName = this.filename;
        }
        int startLine = this.getStartLine(node);
        int endLine = this.getEndLine(node);
        SourceLocation loc = null;
        if (startLine <= endLine) {
            loc = new SourceLocation(new File(fileName), startLine, endLine);
            loc.setOffset(node.sourceStart);
        } else {
            loc = new SourceLocation(new File(fileName), startLine);
            loc.setOffset(node.sourceStart);
        }
        return loc;
    }

    protected int getStartLine(ASTNode n) {
        return Util.getLineNumber(n.sourceStart, this.lineseps, 0, this.lineseps.length - 1);
    }

    protected int getEndLine(ASTNode n) {
        if (n instanceof AbstractVariableDeclaration) {
            return this.getEndLine((AbstractVariableDeclaration)n);
        }
        if (n instanceof AbstractMethodDeclaration) {
            return this.getEndLine((AbstractMethodDeclaration)n);
        }
        if (n instanceof TypeDeclaration) {
            return this.getEndLine((TypeDeclaration)n);
        }
        return Util.getLineNumber(n.sourceEnd, this.lineseps, 0, this.lineseps.length - 1);
    }

    private int getEndLine(AbstractVariableDeclaration avd) {
        return Util.getLineNumber(avd.declarationSourceEnd, this.lineseps, 0, this.lineseps.length - 1);
    }

    private int getEndLine(AbstractMethodDeclaration amd) {
        return Util.getLineNumber(amd.declarationSourceEnd, this.lineseps, 0, this.lineseps.length - 1);
    }

    private int getEndLine(TypeDeclaration td) {
        return Util.getLineNumber(td.declarationSourceEnd, this.lineseps, 0, this.lineseps.length - 1);
    }
}

