/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.aspectj.ajdt.internal.compiler.AjCompilerAdapter;
import org.aspectj.ajdt.internal.compiler.AjPipeliningCompilerAdapter;
import org.aspectj.ajdt.internal.compiler.CompilationResultDestinationManager;
import org.aspectj.ajdt.internal.compiler.CompilerAdapter;
import org.aspectj.ajdt.internal.compiler.IBinarySourceProvider;
import org.aspectj.ajdt.internal.compiler.ICompilerAdapter;
import org.aspectj.ajdt.internal.compiler.ICompilerAdapterFactory;
import org.aspectj.ajdt.internal.compiler.IIntermediateResultsRequestor;
import org.aspectj.ajdt.internal.compiler.IOutputClassFileNameProvider;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.AnonymousClassPublisher;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.problem.AjProblemReporter;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.AsmHierarchyBuilder;
import org.aspectj.ajdt.internal.core.builder.EclipseAdapterUtils;
import org.aspectj.ajdt.internal.core.builder.EmacsStructureModelManager;
import org.aspectj.ajdt.internal.core.builder.StatefulNameEnvironment;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.ILifecycleAware;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextFormatter;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.tools.ajc.Main;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.CustomMungerFactory;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.eclipse.core.runtime.OperationCanceledException;

public class AjBuildManager
implements IOutputClassFileNameProvider,
IBinarySourceProvider,
ICompilerAdapterFactory {
    private static final String CROSSREFS_FILE_NAME = "build.lst";
    private static final String CANT_WRITE_RESULT = "unable to write compilation result";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    public static boolean COPY_INPATH_DIR_RESOURCES = false;
    private static boolean DO_RUNTIME_VERSION_CHECK = false;
    static final boolean FAIL_IF_RUNTIME_NOT_FOUND = false;
    private static final FileFilter binarySourceFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(".class");
        }
    };
    public static AsmHierarchyBuilder asmHierarchyBuilder = new AsmHierarchyBuilder();
    private IProgressListener progressListener = null;
    private boolean environmentSupportsIncrementalCompilation = false;
    private int compiledCount;
    private int sourceFileCount;
    private JarOutputStream zos;
    private boolean batchCompile = true;
    private INameEnvironment environment;
    private Map binarySourcesForTheNextCompile = new HashMap();
    public AjBuildConfig buildConfig;
    private boolean ignoreOutxml;
    private boolean wasFullBuild = true;
    AjState state = new AjState(this);
    public CountingMessageHandler handler;
    private CustomMungerFactory customMungerFactory;

    public static void enableRuntimeVersionCheck(Main caller) {
        DO_RUNTIME_VERSION_CHECK = null != caller;
    }

    public BcelWeaver getWeaver() {
        return this.state.getWeaver();
    }

    public BcelWorld getBcelWorld() {
        return this.state.getBcelWorld();
    }

    public AjBuildManager(IMessageHandler holder) {
        this.handler = CountingMessageHandler.makeCountingMessageHandler(holder);
    }

    public void environmentSupportsIncrementalCompilation(boolean itDoes) {
        this.environmentSupportsIncrementalCompilation = itDoes;
    }

    public boolean doGenerateModel() {
        return this.buildConfig.isGenerateModelMode();
    }

    public boolean batchBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler) throws IOException, AbortException {
        return this.performBuild(buildConfig, baseHandler, true);
    }

    public boolean incrementalBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler) throws IOException, AbortException {
        return this.performBuild(buildConfig, baseHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler, boolean isFullBuild) throws IOException, AbortException {
        boolean ret;
        block64: {
            boolean bl;
            block63: {
                boolean bl2;
                block62: {
                    boolean bl3;
                    block61: {
                        boolean check222;
                        block60: {
                            boolean check222;
                            block59: {
                                boolean check222;
                                block58: {
                                    boolean bl4;
                                    block57: {
                                        ret = true;
                                        this.batchCompile = isFullBuild;
                                        this.wasFullBuild = isFullBuild;
                                        if (baseHandler instanceof ILifecycleAware) {
                                            ((ILifecycleAware)((Object)baseHandler)).buildStarting(!isFullBuild);
                                        }
                                        CompilationAndWeavingContext.reset();
                                        int phase = isFullBuild ? 0 : 1;
                                        ContextToken ct = CompilationAndWeavingContext.enteringPhase(phase, buildConfig);
                                        try {
                                            String check222;
                                            if (isFullBuild) {
                                                this.state = new AjState(this);
                                            }
                                            this.state.setCouldBeSubsequentIncrementalBuild(this.environmentSupportsIncrementalCompilation);
                                            boolean canIncremental = this.state.prepareForNextBuild(buildConfig);
                                            if (!canIncremental && !isFullBuild) {
                                                CompilationAndWeavingContext.leavingPhase(ct);
                                                if (this.state.listenerDefined()) {
                                                    this.state.getListener().recordDecision("Falling back to batch compilation");
                                                }
                                                bl4 = this.performBuild(buildConfig, baseHandler, true);
                                                Object var13_13 = null;
                                                break block57;
                                            }
                                            this.handler = CountingMessageHandler.makeCountingMessageHandler(baseHandler);
                                            if ((buildConfig == null || buildConfig.isCheckRuntimeVersion()) && DO_RUNTIME_VERSION_CHECK && (check222 = this.checkRtJar(buildConfig)) != null) {
                                                MessageUtil.warn(this.handler, check222);
                                            }
                                            this.setBuildConfig(buildConfig);
                                            if (isFullBuild || !AsmManager.attemptIncrementalModelRepairs) {
                                                this.setupModel(buildConfig);
                                            }
                                            if (isFullBuild) {
                                                this.initBcelWorld(this.handler);
                                            }
                                            if (this.handler.hasErrors()) {
                                                CompilationAndWeavingContext.leavingPhase(ct);
                                                check222 = false;
                                                break block58;
                                            }
                                            if (buildConfig.getOutputJar() != null && !this.openOutputStream(buildConfig.getOutputJar())) {
                                                CompilationAndWeavingContext.leavingPhase(ct);
                                                check222 = false;
                                                break block59;
                                            }
                                            if (isFullBuild) {
                                                if (buildConfig.isEmacsSymMode() || buildConfig.isGenerateModelMode()) {
                                                    AsmManager.setLastActiveStructureModel(this.state.getStructureModel());
                                                    this.getWorld().setModel(this.state.getStructureModel());
                                                }
                                                this.binarySourcesForTheNextCompile = this.state.getBinaryFilesToCompile(true);
                                                this.performCompilation(buildConfig.getFiles());
                                                this.state.clearBinarySourceFiles();
                                                if (!this.proceedOnError() && this.handler.hasErrors()) {
                                                    CompilationAndWeavingContext.leavingPhase(ct);
                                                    if (AsmManager.isReporting()) {
                                                        this.state.getStructureModel().reportModelInfo("After a batch build");
                                                    }
                                                    check222 = false;
                                                    break block60;
                                                }
                                                if (AsmManager.isReporting()) {
                                                    this.state.getStructureModel().reportModelInfo("After a batch build");
                                                }
                                            } else {
                                                AsmManager.setLastActiveStructureModel(this.state.getStructureModel());
                                                this.binarySourcesForTheNextCompile = this.state.getBinaryFilesToCompile(true);
                                                Set files = this.state.getFilesToCompile(true);
                                                if ((buildConfig.isEmacsSymMode() || buildConfig.isGenerateModelMode()) && AsmManager.attemptIncrementalModelRepairs) {
                                                    this.state.getStructureModel().resetDeltaProcessing();
                                                    this.state.getStructureModel().processDelta(files, this.state.getAddedFiles(), this.state.getDeletedFiles());
                                                }
                                                boolean hereWeGoAgain = !files.isEmpty() || !this.binarySourcesForTheNextCompile.isEmpty();
                                                for (int i = 0; i < 5 && hereWeGoAgain; ++i) {
                                                    if (this.state.listenerDefined()) {
                                                        this.state.getListener().recordInformation("Starting incremental compilation loop " + (i + 1) + " of possibly 5");
                                                    }
                                                    this.performCompilation(files);
                                                    if (!this.proceedOnError() && this.handler.hasErrors() || this.progressListener != null && this.progressListener.isCancelledRequested()) {
                                                        CompilationAndWeavingContext.leavingPhase(ct);
                                                        bl3 = false;
                                                        break block61;
                                                    }
                                                    if (this.state.requiresFullBatchBuild()) {
                                                        if (this.state.listenerDefined()) {
                                                            this.state.getListener().recordInformation(" Dropping back to full build");
                                                        }
                                                        bl2 = this.batchBuild(buildConfig, baseHandler);
                                                        break block62;
                                                    }
                                                    this.binarySourcesForTheNextCompile = this.state.getBinaryFilesToCompile(false);
                                                    files = this.state.getFilesToCompile(false);
                                                    boolean bl5 = hereWeGoAgain = !files.isEmpty() || !this.binarySourcesForTheNextCompile.isEmpty();
                                                    if (!hereWeGoAgain || !buildConfig.isEmacsSymMode() && !buildConfig.isGenerateModelMode() || !AsmManager.attemptIncrementalModelRepairs) continue;
                                                    this.state.getStructureModel().processDelta(files, this.state.getAddedFiles(), this.state.getDeletedFiles());
                                                }
                                                if (!files.isEmpty()) {
                                                    CompilationAndWeavingContext.leavingPhase(ct);
                                                    bl = this.batchBuild(buildConfig, baseHandler);
                                                    break block63;
                                                }
                                                if (AsmManager.isReporting()) {
                                                    this.state.getStructureModel().reportModelInfo("After an incremental build");
                                                }
                                            }
                                            if (buildConfig.isEmacsSymMode()) {
                                                new EmacsStructureModelManager().externalizeModel(this.state.getStructureModel());
                                            }
                                            if (buildConfig.isGenerateCrossRefsMode()) {
                                                File configFileProxy = new File(buildConfig.getOutputDir(), CROSSREFS_FILE_NAME);
                                                this.state.getStructureModel().writeStructureModel(configFileProxy.getAbsolutePath());
                                            }
                                            this.state.successfulCompile(buildConfig, isFullBuild);
                                            if (isFullBuild) {
                                                this.copyResourcesToDestination();
                                            }
                                            if (buildConfig.getOutxmlName() != null) {
                                                this.writeOutxmlFile();
                                            }
                                            if (buildConfig.isGenerateModelMode()) {
                                                this.state.getStructureModel().fireModelUpdated();
                                            }
                                            CompilationAndWeavingContext.leavingPhase(ct);
                                            break block64;
                                        }
                                        catch (Throwable throwable) {
                                            Object var13_21 = null;
                                            if (baseHandler instanceof ILifecycleAware) {
                                                ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
                                            }
                                            if (this.zos != null) {
                                                this.closeOutputStream(buildConfig.getOutputJar());
                                            }
                                            boolean bl6 = ret = !this.handler.hasErrors();
                                            if (this.getBcelWorld() != null) {
                                                BcelWorld bcelWorld = this.getBcelWorld();
                                                bcelWorld.reportTimers();
                                                bcelWorld.tidyUp();
                                            }
                                            if (this.getWeaver() == null) throw throwable;
                                            this.getWeaver().tidyUp();
                                            throw throwable;
                                        }
                                    }
                                    if (baseHandler instanceof ILifecycleAware) {
                                        ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
                                    }
                                    if (this.zos != null) {
                                        this.closeOutputStream(buildConfig.getOutputJar());
                                    }
                                    boolean bl7 = ret = !this.handler.hasErrors();
                                    if (this.getBcelWorld() != null) {
                                        BcelWorld bcelWorld = this.getBcelWorld();
                                        bcelWorld.reportTimers();
                                        bcelWorld.tidyUp();
                                    }
                                    if (this.getWeaver() == null) return bl4;
                                    this.getWeaver().tidyUp();
                                    return bl4;
                                }
                                Object var13_14 = null;
                                if (baseHandler instanceof ILifecycleAware) {
                                    ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
                                }
                                if (this.zos != null) {
                                    this.closeOutputStream(buildConfig.getOutputJar());
                                }
                                boolean bl8 = ret = !this.handler.hasErrors();
                                if (this.getBcelWorld() != null) {
                                    BcelWorld bcelWorld = this.getBcelWorld();
                                    bcelWorld.reportTimers();
                                    bcelWorld.tidyUp();
                                }
                                if (this.getWeaver() == null) return check222;
                                this.getWeaver().tidyUp();
                                return check222;
                            }
                            Object var13_15 = null;
                            if (baseHandler instanceof ILifecycleAware) {
                                ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
                            }
                            if (this.zos != null) {
                                this.closeOutputStream(buildConfig.getOutputJar());
                            }
                            boolean bl9 = ret = !this.handler.hasErrors();
                            if (this.getBcelWorld() != null) {
                                BcelWorld bcelWorld = this.getBcelWorld();
                                bcelWorld.reportTimers();
                                bcelWorld.tidyUp();
                            }
                            if (this.getWeaver() == null) return check222;
                            this.getWeaver().tidyUp();
                            return check222;
                        }
                        Object var13_16 = null;
                        if (baseHandler instanceof ILifecycleAware) {
                            ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
                        }
                        if (this.zos != null) {
                            this.closeOutputStream(buildConfig.getOutputJar());
                        }
                        boolean bl10 = ret = !this.handler.hasErrors();
                        if (this.getBcelWorld() != null) {
                            BcelWorld bcelWorld = this.getBcelWorld();
                            bcelWorld.reportTimers();
                            bcelWorld.tidyUp();
                        }
                        if (this.getWeaver() == null) return check222;
                        this.getWeaver().tidyUp();
                        return check222;
                    }
                    Object var13_17 = null;
                    if (baseHandler instanceof ILifecycleAware) {
                        ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
                    }
                    if (this.zos != null) {
                        this.closeOutputStream(buildConfig.getOutputJar());
                    }
                    boolean bl11 = ret = !this.handler.hasErrors();
                    if (this.getBcelWorld() != null) {
                        BcelWorld bcelWorld = this.getBcelWorld();
                        bcelWorld.reportTimers();
                        bcelWorld.tidyUp();
                    }
                    if (this.getWeaver() == null) return bl3;
                    this.getWeaver().tidyUp();
                    return bl3;
                }
                Object var13_18 = null;
                if (baseHandler instanceof ILifecycleAware) {
                    ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
                }
                if (this.zos != null) {
                    this.closeOutputStream(buildConfig.getOutputJar());
                }
                boolean bl12 = ret = !this.handler.hasErrors();
                if (this.getBcelWorld() != null) {
                    BcelWorld bcelWorld = this.getBcelWorld();
                    bcelWorld.reportTimers();
                    bcelWorld.tidyUp();
                }
                if (this.getWeaver() == null) return bl2;
                this.getWeaver().tidyUp();
                return bl2;
            }
            Object var13_19 = null;
            if (baseHandler instanceof ILifecycleAware) {
                ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
            }
            if (this.zos != null) {
                this.closeOutputStream(buildConfig.getOutputJar());
            }
            boolean bl13 = ret = !this.handler.hasErrors();
            if (this.getBcelWorld() != null) {
                BcelWorld bcelWorld = this.getBcelWorld();
                bcelWorld.reportTimers();
                bcelWorld.tidyUp();
            }
            if (this.getWeaver() == null) return bl;
            this.getWeaver().tidyUp();
            return bl;
        }
        Object var13_20 = null;
        if (baseHandler instanceof ILifecycleAware) {
            ((ILifecycleAware)((Object)baseHandler)).buildFinished(!isFullBuild);
        }
        if (this.zos != null) {
            this.closeOutputStream(buildConfig.getOutputJar());
        }
        boolean bl = ret = !this.handler.hasErrors();
        if (this.getBcelWorld() != null) {
            BcelWorld bcelWorld = this.getBcelWorld();
            bcelWorld.reportTimers();
            bcelWorld.tidyUp();
        }
        if (this.getWeaver() == null) return ret;
        this.getWeaver().tidyUp();
        return ret;
    }

    private boolean openOutputStream(File outJar) {
        try {
            BufferedOutputStream os = FileUtil.makeOutputStream(this.buildConfig.getOutputJar());
            this.zos = new JarOutputStream((OutputStream)os, this.getWeaver().getManifest(true));
        }
        catch (IOException ex) {
            Message message = new Message("Unable to open outjar " + outJar.getPath() + "(" + ex.getMessage() + ")", new SourceLocation(outJar, 0), true);
            this.handler.handleMessage(message);
            return false;
        }
        return true;
    }

    private void closeOutputStream(File outJar) {
        try {
            if (this.zos != null) {
                this.zos.close();
                if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                    this.buildConfig.getCompilationResultDestinationManager().reportFileWrite(outJar.getPath(), 2);
                }
            }
            this.zos = null;
            if (this.handler.hasErrors()) {
                outJar.delete();
                if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                    this.buildConfig.getCompilationResultDestinationManager().reportFileRemove(outJar.getPath(), 2);
                }
            }
        }
        catch (IOException ex) {
            Message message = new Message("Unable to write outjar " + outJar.getPath() + "(" + ex.getMessage() + ")", new SourceLocation(outJar, 0), true);
            this.handler.handleMessage(message);
        }
    }

    private void copyResourcesToDestination() throws IOException {
        Iterator<Object> i = this.buildConfig.getInJars().iterator();
        while (i.hasNext()) {
            File inJar = (File)i.next();
            this.copyResourcesFromJarFile(inJar);
        }
        i = this.buildConfig.getInpath().iterator();
        while (i.hasNext()) {
            File inPathElement = (File)i.next();
            if (inPathElement.isDirectory()) {
                this.copyResourcesFromDirectory(inPathElement);
                continue;
            }
            this.copyResourcesFromJarFile(inPathElement);
        }
        if (this.buildConfig.getSourcePathResources() != null) {
            i = this.buildConfig.getSourcePathResources().keySet().iterator();
            while (i.hasNext()) {
                String resource = (String)i.next();
                File from = (File)this.buildConfig.getSourcePathResources().get(resource);
                this.copyResourcesFromFile(from, resource, from);
            }
        }
        this.writeManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyResourcesFromJarFile(File jarFile) throws IOException {
        JarInputStream inStream = null;
        try {
            ZipEntry entry;
            inStream = new JarInputStream(new FileInputStream(jarFile));
            while ((entry = inStream.getNextEntry()) != null) {
                String filename = entry.getName();
                if (entry.isDirectory()) {
                    this.writeDirectory(filename, jarFile);
                } else if (this.acceptResource(filename, false)) {
                    byte[] bytes = FileUtil.readAsByteArray(inStream);
                    this.writeResource(filename, bytes, jarFile);
                }
                inStream.closeEntry();
            }
            Object var7_6 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inStream == null) throw throwable;
            inStream.close();
            throw throwable;
        }
        inStream.close();
    }

    private void copyResourcesFromDirectory(File dir) throws IOException {
        if (!COPY_INPATH_DIR_RESOURCES) {
            return;
        }
        File[] files = FileUtil.listFiles(dir, new FileFilter(){

            public boolean accept(File f) {
                boolean accept = !f.isDirectory() && !f.getName().endsWith(".class");
                return accept;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
            this.copyResourcesFromFile(files[i], filename, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyResourcesFromFile(File f, String filename, File src) throws IOException {
        if (!this.acceptResource(filename, true)) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            byte[] bytes = FileUtil.readAsByteArray(fis);
            this.writeResource(filename, bytes, src);
            Object var7_6 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fis == null) throw throwable;
            fis.close();
            throw throwable;
        }
        fis.close();
    }

    private void writeDirectory(String directory, File srcloc) throws IOException {
        if (this.state.hasResource(directory)) {
            Message msg = new Message("duplicate resource: '" + directory + "'", IMessage.WARNING, null, new SourceLocation(srcloc, 0));
            this.handler.handleMessage(msg);
            return;
        }
        if (this.zos != null) {
            ZipEntry newEntry = new ZipEntry(directory);
            this.zos.putNextEntry(newEntry);
            this.zos.closeEntry();
            this.state.recordResource(directory, srcloc);
        }
    }

    private void writeResource(String filename, byte[] content, File srcLocation) throws IOException {
        if (this.state.hasResource(filename)) {
            Message msg = new Message("duplicate resource: '" + filename + "'", IMessage.WARNING, null, new SourceLocation(srcLocation, 0));
            this.handler.handleMessage(msg);
            return;
        }
        if (filename.equals(this.buildConfig.getOutxmlName())) {
            this.ignoreOutxml = true;
            Message msg = new Message("-outxml/-outxmlfile option ignored because resource already exists: '" + filename + "'", IMessage.WARNING, null, new SourceLocation(srcLocation, 0));
            this.handler.handleMessage(msg);
        }
        if (this.zos != null) {
            ZipEntry newEntry = new ZipEntry(filename);
            this.zos.putNextEntry(newEntry);
            this.zos.write(content);
            this.zos.closeEntry();
        } else {
            File destDir = this.buildConfig.getOutputDir();
            if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                destDir = this.buildConfig.getCompilationResultDestinationManager().getOutputLocationForResource(srcLocation);
            }
            try {
                File outputLocation = new File(destDir, filename);
                BufferedOutputStream fos = FileUtil.makeOutputStream(outputLocation);
                ((OutputStream)fos).write(content);
                ((OutputStream)fos).close();
                if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                    this.buildConfig.getCompilationResultDestinationManager().reportFileWrite(outputLocation.getPath(), 3);
                }
            }
            catch (FileNotFoundException fnfe) {
                Message msg = new Message("unable to copy resource to output folder: '" + filename + "' - reason: " + fnfe.getMessage(), IMessage.ERROR, null, new SourceLocation(srcLocation, 0));
                this.handler.handleMessage(msg);
            }
        }
        this.state.recordResource(filename, srcLocation);
    }

    private void writeManifest() throws IOException {
        Manifest manifest = this.getWeaver().getManifest(false);
        if (manifest != null && this.zos == null) {
            File outputDir = this.buildConfig.getOutputDir();
            if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                outputDir = this.buildConfig.getCompilationResultDestinationManager().getDefaultOutputLocation();
            }
            if (outputDir == null) {
                return;
            }
            File outputLocation = new File(outputDir, MANIFEST_NAME);
            BufferedOutputStream fos = FileUtil.makeOutputStream(outputLocation);
            manifest.write(fos);
            ((OutputStream)fos).close();
            if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                this.buildConfig.getCompilationResultDestinationManager().reportFileWrite(outputLocation.getPath(), 3);
            }
        }
    }

    private boolean acceptResource(String resourceName, boolean fromFile) {
        return !resourceName.startsWith("CVS/") && resourceName.indexOf("/CVS/") == -1 && !resourceName.endsWith("/CVS") && !resourceName.endsWith(".class") && !resourceName.startsWith(".svn/") && resourceName.indexOf("/.svn/") == -1 && !resourceName.endsWith("/.svn") && (!resourceName.toUpperCase().equals(MANIFEST_NAME) || fromFile && this.zos == null);
    }

    private void writeOutxmlFile() throws IOException {
        if (this.ignoreOutxml) {
            return;
        }
        String filename = this.buildConfig.getOutxmlName();
        Map outputDirsAndAspects = this.findOutputDirsForAspects();
        Set outputDirs = outputDirsAndAspects.entrySet();
        Iterator iterator = outputDirs.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            File outputDir = (File)entry.getKey();
            List aspects = (List)entry.getValue();
            ByteArrayOutputStream baos = this.getOutxmlContents(aspects);
            if (this.zos != null) {
                ZipEntry newEntry = new ZipEntry(filename);
                this.zos.putNextEntry(newEntry);
                this.zos.write(baos.toByteArray());
                this.zos.closeEntry();
                continue;
            }
            File outputFile = new File(outputDir, filename);
            BufferedOutputStream fos = FileUtil.makeOutputStream(outputFile);
            ((OutputStream)fos).write(baos.toByteArray());
            ((OutputStream)fos).close();
            if (this.buildConfig.getCompilationResultDestinationManager() == null) continue;
            this.buildConfig.getCompilationResultDestinationManager().reportFileWrite(outputFile.getPath(), 3);
        }
    }

    private ByteArrayOutputStream getOutxmlContents(List aspectNames) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println("<aspectj>");
        ps.println("<aspects>");
        if (aspectNames != null) {
            Iterator i = aspectNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                ps.println("<aspect name=\"" + name + "\"/>");
            }
        }
        ps.println("</aspects>");
        ps.println("</aspectj>");
        ps.println();
        ps.close();
        return baos;
    }

    private Map findOutputDirsForAspects() {
        HashMap outputDirsToAspects = new HashMap();
        Map aspectNamesToFileNames = this.state.getAspectNamesToFileNameMap();
        if (this.buildConfig.getCompilationResultDestinationManager() == null || this.buildConfig.getCompilationResultDestinationManager().getAllOutputLocations().size() == 1) {
            File outputDir = this.buildConfig.getOutputDir();
            if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                outputDir = this.buildConfig.getCompilationResultDestinationManager().getDefaultOutputLocation();
            }
            ArrayList<String> aspectNames = new ArrayList<String>();
            if (aspectNamesToFileNames != null) {
                Set keys = aspectNamesToFileNames.keySet();
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    aspectNames.add(name);
                }
            }
            outputDirsToAspects.put(outputDir, aspectNames);
        } else {
            List outputDirs = this.buildConfig.getCompilationResultDestinationManager().getAllOutputLocations();
            Iterator iterator = outputDirs.iterator();
            while (iterator.hasNext()) {
                File outputDir = (File)iterator.next();
                outputDirsToAspects.put(outputDir, new ArrayList());
            }
            Set entrySet = aspectNamesToFileNames.entrySet();
            Iterator iterator2 = entrySet.iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String aspectName = (String)entry.getKey();
                char[] fileName = (char[])entry.getValue();
                File outputDir = this.buildConfig.getCompilationResultDestinationManager().getOutputLocationForClass(new File(new String(fileName)));
                if (!outputDirsToAspects.containsKey(outputDir)) {
                    outputDirsToAspects.put(outputDir, new ArrayList());
                }
                ((List)outputDirsToAspects.get(outputDir)).add(aspectName);
            }
        }
        return outputDirsToAspects;
    }

    private void setupModel(AjBuildConfig config) {
        if (!config.isEmacsSymMode() && !config.isGenerateModelMode()) {
            return;
        }
        CompilationResultDestinationManager crdm = config.getCompilationResultDestinationManager();
        AsmManager structureModel = AsmManager.createNewStructureModel(crdm == null ? Collections.EMPTY_MAP : crdm.getInpathMap());
        IHierarchy model = structureModel.getHierarchy();
        String rootLabel = "<root>";
        IProgramElement.Kind kind = IProgramElement.Kind.FILE_JAVA;
        if (this.buildConfig.getConfigFile() != null) {
            rootLabel = this.buildConfig.getConfigFile().getName();
            model.setConfigFile(this.buildConfig.getConfigFile().getAbsolutePath());
            kind = IProgramElement.Kind.FILE_LST;
        }
        model.setRoot(new ProgramElement(structureModel, rootLabel, kind, new ArrayList()));
        model.setFileMap(new HashMap());
        this.state.setStructureModel(structureModel);
    }

    public void setCustomMungerFactory(Object o) {
        this.customMungerFactory = (CustomMungerFactory)o;
    }

    public Object getCustomMungerFactory() {
        return this.customMungerFactory;
    }

    private void initBcelWorld(IMessageHandler handler) throws IOException {
        List<UnwovenClassFile> unwovenClasses;
        Message message;
        List cp = this.buildConfig.getFullClasspath();
        BcelWorld bcelWorld = new BcelWorld(cp, handler, null);
        bcelWorld.setBehaveInJava5Way(this.buildConfig.getBehaveInJava5Way());
        bcelWorld.setTiming(this.buildConfig.isTiming(), false);
        bcelWorld.setAddSerialVerUID(this.buildConfig.isAddSerialVerUID());
        bcelWorld.setXmlConfigured(this.buildConfig.isXmlConfigured());
        bcelWorld.setXmlFiles(this.buildConfig.getXmlFiles());
        bcelWorld.performExtraConfiguration(this.buildConfig.getXconfigurationInfo());
        bcelWorld.setTargetAspectjRuntimeLevel(this.buildConfig.getTargetAspectjRuntimeLevel());
        bcelWorld.setOptionalJoinpoints(this.buildConfig.getXJoinpoints());
        bcelWorld.setXnoInline(this.buildConfig.isXnoInline());
        bcelWorld.setXlazyTjp(this.buildConfig.isXlazyTjp());
        bcelWorld.setXHasMemberSupportEnabled(this.buildConfig.isXHasMemberEnabled());
        bcelWorld.setPinpointMode(this.buildConfig.isXdevPinpoint());
        bcelWorld.setErrorAndWarningThreshold(this.buildConfig.getOptions().errorThreshold, this.buildConfig.getOptions().warningThreshold);
        BcelWeaver bcelWeaver = new BcelWeaver(bcelWorld);
        bcelWeaver.setCustomMungerFactory(this.customMungerFactory);
        this.state.setWorld(bcelWorld);
        this.state.setWeaver(bcelWeaver);
        this.state.clearBinarySourceFiles();
        if (this.buildConfig.getLintMode().equals("default")) {
            bcelWorld.getLint().loadDefaultProperties();
        } else {
            bcelWorld.getLint().setAll(this.buildConfig.getLintMode());
        }
        if (this.buildConfig.getLintSpecFile() != null) {
            bcelWorld.getLint().setFromProperties(this.buildConfig.getLintSpecFile());
        }
        Iterator i = this.buildConfig.getAspectpath().iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            if (!f.exists()) {
                message = new Message("invalid aspectpath entry: " + f.getName(), null, true);
                handler.handleMessage(message);
                continue;
            }
            bcelWeaver.addLibraryJarFile(f);
        }
        File outputDir = this.buildConfig.getOutputDir();
        if (outputDir == null && this.buildConfig.getCompilationResultDestinationManager() != null) {
            outputDir = this.buildConfig.getCompilationResultDestinationManager().getDefaultOutputLocation();
        }
        Iterator i2 = this.buildConfig.getInJars().iterator();
        while (i2.hasNext()) {
            File inJar = (File)i2.next();
            unwovenClasses = bcelWeaver.addJarFile(inJar, outputDir, false);
            this.state.recordBinarySource(inJar.getPath(), unwovenClasses);
        }
        i2 = this.buildConfig.getInpath().iterator();
        while (i2.hasNext()) {
            File inPathElement = (File)i2.next();
            if (!inPathElement.isDirectory()) {
                unwovenClasses = bcelWeaver.addJarFile(inPathElement, outputDir, true);
                this.state.recordBinarySource(inPathElement.getPath(), unwovenClasses);
                continue;
            }
            File[] binSrcs = FileUtil.listFiles(inPathElement, binarySourceFilter);
            for (int j = 0; j < binSrcs.length; ++j) {
                UnwovenClassFile ucf = bcelWeaver.addClassFile(binSrcs[j], inPathElement, outputDir);
                ArrayList<UnwovenClassFile> ucfl = new ArrayList<UnwovenClassFile>();
                ucfl.add(ucf);
                this.state.recordBinarySource(binSrcs[j].getPath(), ucfl);
            }
        }
        bcelWeaver.setReweavableMode(this.buildConfig.isXNotReweavable());
        ResolvedType joinPoint = bcelWorld.resolve("org.aspectj.lang.JoinPoint");
        if (joinPoint.isMissing()) {
            message = new Message("classpath error: unable to find org.aspectj.lang.JoinPoint (check that aspectjrt.jar is in your classpath)", null, true);
            handler.handleMessage(message);
        }
    }

    public World getWorld() {
        return this.getBcelWorld();
    }

    public FileSystem getLibraryAccess(String[] classpaths, String[] filenames) {
        String defaultEncoding = this.buildConfig.getOptions().defaultEncoding;
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        return new FileSystem(classpaths, filenames, defaultEncoding, 2);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public CompilationUnit[] getCompilationUnits(String[] filenames) {
        int fileCount = filenames.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        String defaultEncoding = this.buildConfig.getOptions().defaultEncoding;
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        for (int i = 0; i < fileCount; ++i) {
            units[i] = new CompilationUnit(null, filenames[i], defaultEncoding);
        }
        return units;
    }

    public String extractDestinationPathFromSourceFile(CompilationResult result) {
        ICompilationUnit compilationUnit = result.compilationUnit;
        if (compilationUnit != null) {
            char[] fileName = compilationUnit.getFileName();
            int lastIndex = CharOperation.lastIndexOf(File.separatorChar, fileName);
            if (lastIndex == -1) {
                return System.getProperty("user.dir");
            }
            return new String(CharOperation.subarray(fileName, 0, lastIndex));
        }
        return System.getProperty("user.dir");
    }

    public void performCompilation(Collection files) {
        if (this.progressListener != null) {
            this.compiledCount = 0;
            this.sourceFileCount = files.size();
            this.progressListener.setText("compiling source files");
        }
        String[] filenames = new String[files.size()];
        int idx = 0;
        Iterator fIterator = files.iterator();
        while (fIterator.hasNext()) {
            File f = (File)fIterator.next();
            filenames[idx++] = f.getPath();
        }
        this.environment = this.state.getNameEnvironment();
        boolean environmentNeedsRebuilding = false;
        if (this.buildConfig.getChanged() != 0) {
            environmentNeedsRebuilding = true;
        }
        if (this.environment == null || environmentNeedsRebuilding) {
            List cps = this.buildConfig.getFullClasspath();
            Dump.saveFullClasspath(cps);
            String[] classpaths = new String[cps.size()];
            for (int i = 0; i < cps.size(); ++i) {
                classpaths[i] = (String)cps.get(i);
            }
            this.environment = new StatefulNameEnvironment(this.getLibraryAccess(classpaths, filenames), this.state.getClassNameToFileMap(), this.state);
            this.state.setNameEnvironment(this.environment);
        } else {
            ((StatefulNameEnvironment)this.environment).update(this.state.getClassNameToFileMap(), this.state.deltaAddedClasses);
            this.state.deltaAddedClasses.clear();
        }
        CompilerAdapter.setCompilerAdapterFactory(this);
        Compiler compiler = new Compiler(this.environment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.buildConfig.getOptions().getMap(), this.getBatchRequestor(), this.getProblemFactory());
        compiler.options.produceReferenceInfo = true;
        try {
            compiler.compile(this.getCompilationUnits(filenames));
        }
        catch (OperationCanceledException oce) {
            this.handler.handleMessage(new Message("build cancelled:" + oce.getMessage(), IMessage.WARNING, null, null));
        }
        CompilerAdapter.setCompilerAdapterFactory(null);
        AnonymousClassPublisher.aspectOf().setAnonymousClassCreationListener(null);
        this.environment.cleanup();
    }

    public void cleanupEnvironment() {
        if (this.environment != null) {
            this.environment.cleanup();
            this.environment = null;
        }
    }

    public IIntermediateResultsRequestor getInterimResultRequestor() {
        return new IIntermediateResultsRequestor(){

            public void acceptResult(InterimCompilationResult result) {
                if (AjBuildManager.this.progressListener != null) {
                    AjBuildManager.this.compiledCount++;
                    AjBuildManager.this.progressListener.setProgress((double)AjBuildManager.this.compiledCount / 2.0 / (double)AjBuildManager.this.sourceFileCount);
                    AjBuildManager.this.progressListener.setText("compiled: " + result.fileName());
                }
                AjBuildManager.this.state.noteResult(result);
                if (AjBuildManager.this.progressListener != null && AjBuildManager.this.progressListener.isCancelledRequested()) {
                    throw new AbortCompilation(true, new OperationCanceledException("Compilation cancelled as requested"));
                }
            }
        };
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult unitResult) {
                boolean hasErrors = unitResult.hasErrors();
                if (!hasErrors || AjBuildManager.this.proceedOnError()) {
                    Collection classFiles = unitResult.compiledTypes.values();
                    boolean shouldAddAspectName = AjBuildManager.this.buildConfig.getOutxmlName() != null;
                    Iterator iter = classFiles.iterator();
                    while (iter.hasNext()) {
                        ClassFile classFile = (ClassFile)iter.next();
                        String filename = new String(classFile.fileName());
                        String classname = filename.replace('/', '.');
                        filename = filename.replace('/', File.separatorChar) + ".class";
                        try {
                            if (AjBuildManager.this.buildConfig.getOutputJar() == null) {
                                ResolvedType type;
                                String outfile = this.writeDirectoryEntry(unitResult, classFile, filename);
                                if (AjBuildManager.this.environmentSupportsIncrementalCompilation && !classname.endsWith("$ajcMightHaveAspect") && (type = AjBuildManager.this.getBcelWorld().resolve(classname)).isAspect()) {
                                    AjBuildManager.this.state.recordAspectClassFile(outfile);
                                }
                            } else {
                                this.writeZipEntry(classFile, filename);
                            }
                            if (!shouldAddAspectName || classname.endsWith("$ajcMightHaveAspect")) continue;
                            this.addAspectName(classname, unitResult.getFileName());
                        }
                        catch (IOException ex) {
                            IMessage message = EclipseAdapterUtils.makeErrorMessage(new String(unitResult.fileName), AjBuildManager.CANT_WRITE_RESULT, (Exception)ex);
                            AjBuildManager.this.handler.handleMessage(message);
                        }
                    }
                    AjBuildManager.this.state.noteNewResult(unitResult);
                    unitResult.compiledTypes.clear();
                }
                if (unitResult.hasProblems() || unitResult.hasTasks()) {
                    CategorizedProblem[] problems = unitResult.getAllProblems();
                    for (int i = 0; i < problems.length; ++i) {
                        IMessage message = EclipseAdapterUtils.makeMessage(unitResult.compilationUnit, problems[i], AjBuildManager.this.getBcelWorld(), AjBuildManager.this.progressListener);
                        AjBuildManager.this.handler.handleMessage(message);
                    }
                }
            }

            private String writeDirectoryEntry(CompilationResult unitResult, ClassFile classFile, String filename) throws IOException {
                String outFile;
                File destinationPath = AjBuildManager.this.buildConfig.getOutputDir();
                if (AjBuildManager.this.buildConfig.getCompilationResultDestinationManager() != null) {
                    destinationPath = AjBuildManager.this.buildConfig.getCompilationResultDestinationManager().getOutputLocationForClass(new File(new String(unitResult.fileName)));
                }
                if (destinationPath == null) {
                    outFile = new File(filename).getName();
                    outFile = new File(AjBuildManager.this.extractDestinationPathFromSourceFile(unitResult), outFile).getPath();
                } else {
                    outFile = new File(destinationPath, filename).getPath();
                }
                try {
                    BufferedOutputStream os = FileUtil.makeOutputStream(new File(outFile));
                    os.write(classFile.getBytes());
                    os.close();
                }
                catch (FileNotFoundException fnfe) {
                    Message msg = new Message("unable to write out class file: '" + filename + "' - reason: " + fnfe.getMessage(), IMessage.ERROR, null, new SourceLocation(new File(outFile), 0));
                    AjBuildManager.this.handler.handleMessage(msg);
                }
                if (AjBuildManager.this.buildConfig.getCompilationResultDestinationManager() != null) {
                    AjBuildManager.this.buildConfig.getCompilationResultDestinationManager().reportFileWrite(outFile, 1);
                }
                return outFile;
            }

            private void writeZipEntry(ClassFile classFile, String name) throws IOException {
                name = name.replace(File.separatorChar, '/');
                ZipEntry newEntry = new ZipEntry(name);
                AjBuildManager.this.zos.putNextEntry(newEntry);
                AjBuildManager.this.zos.write(classFile.getBytes());
                AjBuildManager.this.zos.closeEntry();
            }

            private void addAspectName(String name, char[] fileContainingAspect) {
                BcelWorld world = AjBuildManager.this.getBcelWorld();
                ResolvedType type = world.resolve(name);
                if (type.isAspect()) {
                    if (AjBuildManager.this.state.getAspectNamesToFileNameMap() == null) {
                        AjBuildManager.this.state.initializeAspectNamesToFileNameMap();
                    }
                    if (!AjBuildManager.this.state.getAspectNamesToFileNameMap().containsKey(name)) {
                        AjBuildManager.this.state.getAspectNamesToFileNameMap().put(name, fileContainingAspect);
                    }
                }
            }
        };
    }

    protected boolean proceedOnError() {
        return this.buildConfig.getProceedOnError();
    }

    private void setBuildConfig(AjBuildConfig buildConfig) {
        this.buildConfig = buildConfig;
        if (!this.environmentSupportsIncrementalCompilation) {
            this.environmentSupportsIncrementalCompilation = buildConfig.isIncrementalMode() || buildConfig.isIncrementalFileMode();
        }
        this.handler.reset();
    }

    String makeClasspathString(AjBuildConfig buildConfig) {
        if (buildConfig == null || buildConfig.getFullClasspath() == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Iterator it = buildConfig.getFullClasspath().iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(it.next().toString());
        }
        return buf.toString();
    }

    private String checkRtJar(AjBuildConfig buildConfig) {
        if ("1.6.7".equals("DEVELOPMENT")) {
            return null;
        }
        if (buildConfig == null || buildConfig.getFullClasspath() == null) {
            return "no classpath specified";
        }
        String ret = null;
        Iterator it = buildConfig.getFullClasspath().iterator();
        while (it.hasNext()) {
            File p = new File((String)it.next());
            if (p.isFile() && p.getName().startsWith("aspectjrt") && p.getName().endsWith(".jar")) {
                try {
                    String version = null;
                    Manifest manifest = new JarFile(p).getManifest();
                    if (manifest == null) {
                        ret = "no manifest found in " + p.getAbsolutePath() + ", expected " + "1.6.7";
                        continue;
                    }
                    Attributes attr = manifest.getAttributes("org/aspectj/lang/");
                    if (null != attr && null != (version = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION))) {
                        version = version.trim();
                    }
                    if ("DEVELOPMENT".equals(version)) {
                        return null;
                    }
                    if (!"1.6.7".equals(version)) {
                        ret = "bad version number found in " + p.getAbsolutePath() + " expected " + "1.6.7" + " found " + version;
                        continue;
                    }
                }
                catch (IOException ioe) {
                    ret = "bad jar file found in " + p.getAbsolutePath() + " error: " + ioe;
                }
                return null;
            }
            if (!p.isFile() || p.getName().indexOf("org.aspectj.runtime") == -1) continue;
            return null;
        }
        if (ret != null) {
            return ret;
        }
        return "couldn't find aspectjrt.jar on classpath, checked: " + this.makeClasspathString(buildConfig);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AjBuildManager(");
        buf.append(")");
        return buf.toString();
    }

    public AsmManager getStructureModel() {
        return this.state == null ? null : this.state.getStructureModel();
    }

    public IProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(IProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public String getOutputClassFileName(char[] eclipseClassFileName, CompilationResult result) {
        String outFile;
        String filename = new String(eclipseClassFileName);
        filename = filename.replace('/', File.separatorChar) + ".class";
        File destinationPath = this.buildConfig.getOutputDir();
        if (this.buildConfig.getCompilationResultDestinationManager() != null) {
            File f = new File(new String(result.getFileName()));
            destinationPath = this.buildConfig.getCompilationResultDestinationManager().getOutputLocationForClass(f);
        }
        if (destinationPath == null) {
            outFile = new File(filename).getName();
            outFile = new File(this.extractDestinationPathFromSourceFile(result), outFile).getPath();
        } else {
            outFile = new File(destinationPath, filename).getPath();
        }
        return outFile;
    }

    public ICompilerAdapter getAdapter(Compiler forCompiler) {
        EclipseFactory factory;
        this.populateCompilerOptionsFromLintSettings(forCompiler);
        AjProblemReporter pr = new AjProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), forCompiler.options, this.getProblemFactory());
        forCompiler.problemReporter = pr;
        AjLookupEnvironment le = new AjLookupEnvironment(forCompiler, forCompiler.options, pr, this.environment);
        le.factory = factory = new EclipseFactory(le, this);
        pr.factory = factory;
        forCompiler.lookupEnvironment = le;
        forCompiler.parser = new Parser(pr, forCompiler.options.parseLiteralExpressionsAsConstants);
        if (this.getBcelWorld().shouldPipelineCompilation()) {
            IMessage message = MessageUtil.info("Pipelining compilation");
            this.handler.handleMessage(message);
            return new AjPipeliningCompilerAdapter(forCompiler, this.batchCompile, this.getBcelWorld(), this.getWeaver(), factory, this.getInterimResultRequestor(), this.progressListener, this, this, this.state.getBinarySourceMap(), this.buildConfig.isTerminateAfterCompilation(), this.buildConfig.getProceedOnError(), this.buildConfig.isNoAtAspectJAnnotationProcessing(), this.state);
        }
        return new AjCompilerAdapter(forCompiler, this.batchCompile, this.getBcelWorld(), this.getWeaver(), factory, this.getInterimResultRequestor(), this.progressListener, this, this, this.state.getBinarySourceMap(), this.buildConfig.isTerminateAfterCompilation(), this.buildConfig.getProceedOnError(), this.buildConfig.isNoAtAspectJAnnotationProcessing(), this.state);
    }

    private void populateCompilerOptionsFromLintSettings(Compiler forCompiler) {
        BcelWorld world = this.state.getBcelWorld();
        IMessage.Kind swallowedExceptionKind = world.getLint().swallowedExceptionInCatchBlock.getKind();
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.swallowedExceptionInCatchBlock", swallowedExceptionKind == null ? "ignore" : swallowedExceptionKind.toString());
        forCompiler.options.set(optionsMap);
    }

    public Map getBinarySourcesForThisWeave() {
        return this.binarySourcesForTheNextCompile;
    }

    public static AsmHierarchyBuilder getAsmHierarchyBuilder() {
        return asmHierarchyBuilder;
    }

    public static void setAsmHierarchyBuilder(AsmHierarchyBuilder newBuilder) {
        asmHierarchyBuilder = newBuilder;
    }

    public AjState getState() {
        return this.state;
    }

    public void setState(AjState buildState) {
        this.state = buildState;
    }

    public boolean wasFullBuild() {
        return this.wasFullBuild;
    }

    static {
        CompilationAndWeavingContext.registerFormatter(0, new AjBuildContexFormatter());
        CompilationAndWeavingContext.registerFormatter(1, new AjBuildContexFormatter());
    }

    private static class AjBuildContexFormatter
    implements ContextFormatter {
        private AjBuildContexFormatter() {
        }

        public String formatEntry(int phaseId, Object data) {
            StringBuffer sb = new StringBuffer();
            if (phaseId == 0) {
                sb.append("batch building ");
            } else {
                sb.append("incrementally building ");
            }
            AjBuildConfig config = (AjBuildConfig)data;
            List classpath = config.getClasspath();
            sb.append("with classpath: ");
            Iterator iter = classpath.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                sb.append(File.pathSeparator);
            }
            return sb.toString();
        }
    }
}

