/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareAnnotationDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseAnnotationConvertor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseScope;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.bridge.IMessage;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationAnnotationValue;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ClassAnnotationValue;
import org.aspectj.weaver.EnumAnnotationValue;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.StandardAnnotation;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.AtAjAttributes;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.Pointcut;

public class EclipseSourceType
extends AbstractReferenceTypeDelegate {
    private static final char[] pointcutSig = "Lorg/aspectj/lang/annotation/Pointcut;".toCharArray();
    private static final char[] aspectSig = "Lorg/aspectj/lang/annotation/Aspect;".toCharArray();
    protected ResolvedPointcutDefinition[] declaredPointcuts = null;
    protected ResolvedMember[] declaredMethods = null;
    protected ResolvedMember[] declaredFields = null;
    public List<Declare> declares = new ArrayList<Declare>();
    public List<EclipseTypeMunger> typeMungers = new ArrayList<EclipseTypeMunger>();
    private final EclipseFactory factory;
    private final SourceTypeBinding binding;
    private final TypeDeclaration declaration;
    private final CompilationUnitDeclaration unit;
    private boolean annotationsFullyResolved = false;
    private boolean annotationTypesAreResolved = false;
    private ResolvedType[] annotationTypes = null;
    private boolean discoveredAnnotationTargetKinds = false;
    private AnnotationTargetKind[] annotationTargetKinds;
    private AnnotationAJ[] annotations = null;
    private static final char[] valuesCharArray = "values".toCharArray();
    private static final char[] valueOfCharArray = "valueOf".toCharArray();
    private static final char[] jlString = "Ljava/lang/String;".toCharArray();
    private static final char[] joinPoint = "Lorg/aspectj/lang/JoinPoint;".toCharArray();
    private static final char[] joinPointStaticPart = "Lorg/aspectj/lang/JoinPoint$StaticPart;".toCharArray();
    private static final char[] joinPointEnclosingStaticPart = "Lorg/aspectj/lang/JoinPoint$EnclosingStaticPart;".toCharArray();
    private static final char[] proceedingJoinPoint = "Lorg/aspectj/lang/ProceedingJoinPoint;".toCharArray();
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;

    protected EclipseFactory eclipseWorld() {
        return this.factory;
    }

    public EclipseSourceType(ReferenceType resolvedTypeX, EclipseFactory factory, SourceTypeBinding binding, TypeDeclaration declaration, CompilationUnitDeclaration unit) {
        super(resolvedTypeX, true);
        this.factory = factory;
        this.binding = binding;
        this.declaration = declaration;
        this.unit = unit;
        this.setSourceContext(new EclipseSourceContext(declaration.compilationResult));
        resolvedTypeX.setStartPos(declaration.sourceStart);
        resolvedTypeX.setEndPos(declaration.sourceEnd);
    }

    public boolean isAspect() {
        boolean isCodeStyle = this.declaration instanceof AspectDeclaration;
        return isCodeStyle ? isCodeStyle : this.isAnnotationStyleAspect();
    }

    public boolean isAnonymous() {
        if (this.declaration.binding != null) {
            return this.declaration.binding.isAnonymousType();
        }
        return (this.declaration.modifiers & 0x300) != 0;
    }

    public boolean isNested() {
        if (this.declaration.binding != null) {
            return this.declaration.binding.isMemberType();
        }
        return (this.declaration.modifiers & 0x400) != 0;
    }

    public ResolvedType getOuterClass() {
        if (this.declaration.binding != null) {
            ReferenceBinding enclosingType = this.declaration.binding.enclosingType();
            return enclosingType == null ? null : this.eclipseWorld().fromEclipse(enclosingType);
        }
        if (this.declaration.enclosingType == null) {
            return null;
        }
        return this.eclipseWorld().fromEclipse(this.declaration.enclosingType.binding);
    }

    public boolean isAnnotationStyleAspect() {
        if (this.declaration.annotations == null) {
            return false;
        }
        ResolvedType[] annotations = this.getAnnotationTypes();
        for (int i = 0; i < annotations.length; ++i) {
            if (!"org.aspectj.lang.annotation.Aspect".equals(annotations[i].getName())) continue;
            return true;
        }
        return false;
    }

    private String getPointcutStringFromAnnotationStylePointcut(AbstractMethodDeclaration amd) {
        Annotation[] ans = amd.annotations;
        if (ans == null) {
            return "";
        }
        for (int i = 0; i < ans.length; ++i) {
            char[] sig;
            if (ans[i].resolvedType == null || !CharOperation.equals(pointcutSig, sig = ans[i].resolvedType.signature())) continue;
            if (ans[i].memberValuePairs().length == 0) {
                return "";
            }
            Expression expr = ans[i].memberValuePairs()[0].value;
            if (expr instanceof StringLiteral) {
                StringLiteral sLit = (StringLiteral)expr;
                return new String(sLit.source());
            }
            if (expr instanceof NameReference && ((NameReference)expr).binding instanceof FieldBinding) {
                Binding b = ((NameReference)expr).binding;
                Constant c = ((FieldBinding)b).constant;
                return c.stringValue();
            }
            throw new BCException("Do not know how to recover pointcut definition from " + expr + " (type " + expr.getClass().getName() + ")");
        }
        return "";
    }

    private boolean isAnnotationStylePointcut(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        for (int i = 0; i < annotations.length; ++i) {
            char[] sig;
            if (annotations[i].resolvedType == null || !CharOperation.equals(pointcutSig, sig = annotations[i].resolvedType.signature())) continue;
            return true;
        }
        return false;
    }

    public WeaverStateInfo getWeaverState() {
        return null;
    }

    public ResolvedType getSuperclass() {
        if (this.binding.isInterface()) {
            return this.getResolvedTypeX().getWorld().getCoreType(UnresolvedType.OBJECT);
        }
        return this.eclipseWorld().fromEclipse(this.binding.superclass());
    }

    public ResolvedType[] getDeclaredInterfaces() {
        return this.eclipseWorld().fromEclipse(this.binding.superInterfaces());
    }

    protected void fillDeclaredMembers() {
        ArrayList<ResolvedPointcutDefinition> declaredPointcuts = new ArrayList<ResolvedPointcutDefinition>();
        ArrayList<ResolvedMemberImpl> declaredMethods = new ArrayList<ResolvedMemberImpl>();
        ArrayList<ResolvedMember> declaredFields = new ArrayList<ResolvedMember>();
        MethodBinding[] ms = this.binding.methods();
        AbstractMethodDeclaration[] methods = this.declaration.methods;
        if (methods != null) {
            for (AbstractMethodDeclaration amd : methods) {
                if (amd == null || amd.ignoreFurtherInvestigation) continue;
                if (amd instanceof PointcutDeclaration) {
                    PointcutDeclaration d = (PointcutDeclaration)amd;
                    ResolvedPointcutDefinition df = d.makeResolvedPointcutDefinition(this.factory);
                    if (df == null) continue;
                    declaredPointcuts.add(df);
                    continue;
                }
                if (amd instanceof InterTypeDeclaration || amd instanceof DeclareDeclaration && !(amd instanceof DeclareAnnotationDeclaration) || amd instanceof AdviceDeclaration) continue;
                if (amd.annotations != null && this.isAnnotationStylePointcut(amd.annotations)) {
                    ResolvedPointcutDefinition df = this.makeResolvedPointcutDefinition(amd);
                    if (df == null) continue;
                    declaredPointcuts.add(df);
                    continue;
                }
                if (amd.binding == null || !amd.binding.isValidBinding()) continue;
                ResolvedMemberImpl member = this.factory.makeResolvedMember(amd.binding);
                if (this.unit != null) {
                    boolean positionKnown = true;
                    if (amd.binding.sourceMethod() == null && amd.binding.declaringClass instanceof SourceTypeBinding) {
                        SourceTypeBinding stb = (SourceTypeBinding)amd.binding.declaringClass;
                        if (stb.scope == null || stb.scope.referenceContext == null) {
                            positionKnown = false;
                        }
                    }
                    if (positionKnown) {
                        member.setSourceContext(new EclipseSourceContext(this.unit.compilationResult, amd.binding.sourceStart()));
                        member.setPosition(amd.binding.sourceStart(), amd.binding.sourceEnd());
                    } else {
                        member.setSourceContext(new EclipseSourceContext(this.unit.compilationResult, 0));
                        member.setPosition(0, 0);
                    }
                }
                declaredMethods.add(member);
            }
        }
        if (this.isEnum()) {
            for (MethodBinding mb : ms) {
                if (!(mb instanceof SyntheticMethodBinding) || !mb.isStatic()) continue;
                if (CharOperation.equals(mb.selector, valuesCharArray) && mb.parameters.length == 0 && mb.returnType.isArrayType() && ((ArrayBinding)mb.returnType).leafComponentType() == this.binding) {
                    ResolvedMemberImpl valuesMember = this.factory.makeResolvedMember(mb);
                    valuesMember.setSourceContext(new EclipseSourceContext(this.unit.compilationResult, 0));
                    valuesMember.setPosition(0, 0);
                    declaredMethods.add(valuesMember);
                    continue;
                }
                if (!CharOperation.equals(mb.selector, valueOfCharArray) || mb.parameters.length != 1 || !CharOperation.equals(mb.parameters[0].signature(), jlString) || mb.returnType != this.binding) continue;
                ResolvedMemberImpl valueOfMember = this.factory.makeResolvedMember(mb);
                valueOfMember.setSourceContext(new EclipseSourceContext(this.unit.compilationResult, 0));
                valueOfMember.setPosition(0, 0);
                declaredMethods.add(valueOfMember);
            }
        }
        for (FieldBinding f : this.binding.fields()) {
            declaredFields.add(this.factory.makeResolvedMember(f));
        }
        this.declaredPointcuts = declaredPointcuts.toArray(new ResolvedPointcutDefinition[declaredPointcuts.size()]);
        this.declaredMethods = declaredMethods.toArray(new ResolvedMember[declaredMethods.size()]);
        this.declaredFields = declaredFields.toArray(new ResolvedMember[declaredFields.size()]);
    }

    private ResolvedPointcutDefinition makeResolvedPointcutDefinition(AbstractMethodDeclaration md) {
        if (md.binding == null) {
            return null;
        }
        EclipseSourceContext eSourceContext = new EclipseSourceContext(md.compilationResult);
        Pointcut pc = null;
        if (!md.isAbstract()) {
            String expression = this.getPointcutStringFromAnnotationStylePointcut(md);
            try {
                pc = new PatternParser(expression, eSourceContext).parsePointcut();
            }
            catch (ParserException pe) {
                pc = Pointcut.makeMatchesNothing(Pointcut.SYMBOLIC);
            }
        }
        FormalBinding[] bindings = this.buildFormalAdviceBindingsFrom(md);
        AtAjAttributes.LazyResolvedPointcutDefinition rpd = new AtAjAttributes.LazyResolvedPointcutDefinition(this.factory.fromBinding(md.binding.declaringClass), md.modifiers, new String(md.selector), this.factory.fromBindings(md.binding.parameters), this.factory.fromBinding(md.binding.returnType), pc, new EclipseScope(bindings, md.scope));
        rpd.setPosition(md.sourceStart, md.sourceEnd);
        rpd.setSourceContext(eSourceContext);
        return rpd;
    }

    private FormalBinding[] buildFormalAdviceBindingsFrom(AbstractMethodDeclaration mDecl) {
        if (mDecl.arguments == null) {
            return new FormalBinding[0];
        }
        if (mDecl.binding == null) {
            return new FormalBinding[0];
        }
        EclipseFactory factory = EclipseFactory.fromScopeLookupEnvironment(mDecl.scope);
        String extraArgName = "";
        FormalBinding[] ret = new FormalBinding[mDecl.arguments.length];
        for (int i = 0; i < mDecl.arguments.length; ++i) {
            Argument arg = mDecl.arguments[i];
            String name = new String(arg.name);
            TypeBinding argTypeBinding = mDecl.binding.parameters[i];
            UnresolvedType type = factory.fromBinding(argTypeBinding);
            ret[i] = CharOperation.equals(joinPoint, argTypeBinding.signature()) || CharOperation.equals(joinPointStaticPart, argTypeBinding.signature()) || CharOperation.equals(joinPointEnclosingStaticPart, argTypeBinding.signature()) || CharOperation.equals(proceedingJoinPoint, argTypeBinding.signature()) || name.equals(extraArgName) ? new FormalBinding.ImplicitFormalBinding(type, name, i) : new FormalBinding(type, name, i, arg.sourceStart, arg.sourceEnd);
        }
        return ret;
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.declaredFields == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredFields;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.declaredMethods == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredMethods;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        if (this.declaredPointcuts == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredPointcuts;
    }

    public int getModifiers() {
        return this.binding.modifiers & 0xFFFF;
    }

    public String toString() {
        return "EclipseSourceType(" + new String(this.binding.sourceName()) + ")";
    }

    public void checkPointcutDeclarations() {
        ResolvedMember[] pointcuts = this.getDeclaredPointcuts();
        boolean sawError = false;
        int len = pointcuts.length;
        for (int i = 0; i < len; ++i) {
            if (pointcuts[i] == null) continue;
            if (pointcuts[i].isAbstract()) {
                if (!this.isAspect()) {
                    this.eclipseWorld().showMessage(IMessage.ERROR, "abstract pointcut only allowed in aspect" + pointcuts[i].getName(), pointcuts[i].getSourceLocation(), null);
                    sawError = true;
                } else if (!this.binding.isAbstract()) {
                    this.eclipseWorld().showMessage(IMessage.ERROR, "abstract pointcut in concrete aspect" + pointcuts[i], pointcuts[i].getSourceLocation(), null);
                    sawError = true;
                }
            }
            for (int j = i + 1; j < len; ++j) {
                if (pointcuts[j] == null || !pointcuts[i].getName().equals(pointcuts[j].getName())) continue;
                this.eclipseWorld().showMessage(IMessage.ERROR, "duplicate pointcut name: " + pointcuts[j].getName(), pointcuts[i].getSourceLocation(), pointcuts[j].getSourceLocation());
                sawError = true;
            }
        }
        if (sawError || !this.isAspect()) {
            return;
        }
        this.getResolvedTypeX().getExposedPointcuts();
    }

    public boolean isInterface() {
        return this.binding.isInterface();
    }

    public boolean isEnum() {
        return (this.binding.getAccessFlags() & 0x4000) != 0;
    }

    public boolean isAnnotation() {
        return (this.binding.getAccessFlags() & 0x2000) != 0;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        if (!this.isAnnotation()) {
            return false;
        }
        return (this.binding.getAnnotationTagBits() & 0x300000000000L) == 0x300000000000L;
    }

    public String getRetentionPolicy() {
        if (this.isAnnotation()) {
            if ((this.binding.getAnnotationTagBits() & 0x300000000000L) == 0x300000000000L) {
                return "RUNTIME";
            }
            if ((this.binding.getAnnotationTagBits() & 0x300000000000L) == 0x100000000000L) {
                return "SOURCE";
            }
            if ((this.binding.getAnnotationTagBits() & 0x300000000000L) == 0x200000000000L) {
                return "CLASS";
            }
        }
        return null;
    }

    public boolean canAnnotationTargetType() {
        if (this.isAnnotation()) {
            return (this.binding.getAnnotationTagBits() & 0x1000000000L) != 0L;
        }
        return false;
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        if (this.discoveredAnnotationTargetKinds) {
            return this.annotationTargetKinds;
        }
        this.discoveredAnnotationTargetKinds = true;
        this.annotationTargetKinds = null;
        if (this.isAnnotation()) {
            ArrayList<AnnotationTargetKind> targetKinds = new ArrayList<AnnotationTargetKind>();
            if ((this.binding.getAnnotationTagBits() & 0x40000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.ANNOTATION_TYPE);
            }
            if ((this.binding.getAnnotationTagBits() & 0x10000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.CONSTRUCTOR);
            }
            if ((this.binding.getAnnotationTagBits() & 0x2000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.FIELD);
            }
            if ((this.binding.getAnnotationTagBits() & 0x20000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.LOCAL_VARIABLE);
            }
            if ((this.binding.getAnnotationTagBits() & 0x4000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.METHOD);
            }
            if ((this.binding.getAnnotationTagBits() & 0x80000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.PACKAGE);
            }
            if ((this.binding.getAnnotationTagBits() & 0x8000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.PARAMETER);
            }
            if ((this.binding.getAnnotationTagBits() & 0x1000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.TYPE);
            }
            if (!targetKinds.isEmpty()) {
                this.annotationTargetKinds = new AnnotationTargetKind[targetKinds.size()];
                return targetKinds.toArray(this.annotationTargetKinds);
            }
        }
        return this.annotationTargetKinds;
    }

    private void ensureAnnotationTypesResolved() {
        int declarationAnnoCount;
        int n = declarationAnnoCount = this.declaration.annotations == null ? 0 : this.declaration.annotations.length;
        if (!this.annotationTypesAreResolved || declarationAnnoCount != this.annotationTypes.length) {
            Annotation[] as = this.declaration.annotations;
            if (as == null) {
                this.annotationTypes = ResolvedType.NONE;
            } else {
                this.annotationTypes = new ResolvedType[as.length];
                for (int a = 0; a < as.length; ++a) {
                    TypeBinding tb = as[a].type.resolveType(this.declaration.staticInitializerScope);
                    this.annotationTypes[a] = tb == null ? ResolvedType.MISSING : this.factory.fromTypeBindingToRTX(tb);
                }
            }
            this.annotationTypesAreResolved = true;
        }
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationTypesResolved();
        int max = this.annotationTypes.length;
        for (int a = 0; a < max; ++a) {
            if (!ofType.equals(this.annotationTypes[a])) continue;
            return true;
        }
        return false;
    }

    public AnnotationAJ[] getAnnotations() {
        Annotation[] as;
        int declarationAnnoCount;
        int n = declarationAnnoCount = this.declaration.annotations == null ? 0 : this.declaration.annotations.length;
        if (this.annotations != null && this.annotations.length == declarationAnnoCount) {
            return this.annotations;
        }
        if (!this.annotationsFullyResolved || this.annotations.length != declarationAnnoCount) {
            TypeDeclaration.resolveAnnotations((BlockScope)this.declaration.staticInitializerScope, this.declaration.annotations, (Binding)this.binding);
            this.annotationsFullyResolved = true;
        }
        if ((as = this.declaration.annotations) == null || as.length == 0) {
            this.annotations = AnnotationAJ.EMPTY_ARRAY;
        } else {
            this.annotations = new AnnotationAJ[as.length];
            for (int i = 0; i < as.length; ++i) {
                this.annotations[i] = this.convertEclipseAnnotation(as[i], this.factory.getWorld());
            }
        }
        return this.annotations;
    }

    public AnnotationAJ convertEclipseAnnotation(Annotation eclipseAnnotation, World w) {
        ResolvedType annotationType = this.factory.fromTypeBindingToRTX(eclipseAnnotation.type.resolvedType);
        boolean isRuntimeVisible = ((long)eclipseAnnotation.bits & 0x300000000000L) == 0x300000000000L;
        StandardAnnotation annotationAJ = new StandardAnnotation(annotationType, isRuntimeVisible);
        this.generateAnnotation(eclipseAnnotation, annotationAJ, w);
        return annotationAJ;
    }

    private void generateAnnotation(Annotation annotation, StandardAnnotation annotationAJ, World w) {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairs = normalAnnotation.memberValuePairs;
            if (memberValuePairs != null) {
                for (MemberValuePair memberValuePair : memberValuePairs) {
                    AnnotationNameValuePair anvp;
                    AnnotationValue av;
                    MethodBinding methodBinding = memberValuePair.binding;
                    if (methodBinding == null) {
                        if (memberValuePair.value instanceof MarkerAnnotation) {
                            MarkerAnnotation eMarkerAnnotation = (MarkerAnnotation)memberValuePair.value;
                            AnnotationBinding eMarkerAnnotationBinding = eMarkerAnnotation.getCompilerAnnotation();
                            ReferenceBinding eAnnotationType = eMarkerAnnotationBinding.getAnnotationType();
                            ResolvedType ajAnnotationType = this.factory.fromTypeBindingToRTX(eAnnotationType);
                            boolean isRuntimeVisible = ((long)eMarkerAnnotation.bits & 0x300000000000L) == 0x300000000000L;
                            StandardAnnotation ajAnnotation = new StandardAnnotation(ajAnnotationType, isRuntimeVisible);
                            AnnotationAnnotationValue av2 = new AnnotationAnnotationValue(ajAnnotation);
                            AnnotationNameValuePair anvp2 = new AnnotationNameValuePair(new String(memberValuePair.name), av2);
                            annotationAJ.addNameValuePair(anvp2);
                            continue;
                        }
                        if (memberValuePair.value instanceof Literal) {
                            av = this.generateElementValue(memberValuePair.value, ((Literal)memberValuePair.value).resolvedType);
                            anvp = new AnnotationNameValuePair(new String(memberValuePair.name), av);
                            annotationAJ.addNameValuePair(anvp);
                            continue;
                        }
                        if (memberValuePair.value instanceof ArrayInitializer) {
                            ArrayInitializer arrayInitializer = (ArrayInitializer)memberValuePair.value;
                            Expression[] expressions = arrayInitializer.expressions;
                            AnnotationValue[] arrayValues = new AnnotationValue[expressions.length];
                            for (int e = 0; e < expressions.length; ++e) {
                                arrayValues[e] = this.generateElementValue(expressions[e], ((ArrayBinding)arrayInitializer.resolvedType).leafComponentType);
                            }
                            ArrayAnnotationValue array = new ArrayAnnotationValue(arrayValues);
                            AnnotationNameValuePair anvp3 = new AnnotationNameValuePair(new String(memberValuePair.name), array);
                            annotationAJ.addNameValuePair(anvp3);
                            continue;
                        }
                        throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
                    }
                    av = this.generateElementValue(memberValuePair.value, methodBinding.returnType);
                    anvp = new AnnotationNameValuePair(new String(memberValuePair.name), av);
                    annotationAJ.addNameValuePair(anvp);
                }
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            MemberValuePair mvp = singleMemberAnnotation.memberValuePairs()[0];
            if (mvp.value instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)mvp.value;
                Expression[] expressions = arrayInitializer.expressions;
                AnnotationValue[] arrayValues = new AnnotationValue[expressions.length];
                for (int e = 0; e < expressions.length; ++e) {
                    arrayValues[e] = this.generateElementValue(expressions[e], ((ArrayBinding)arrayInitializer.resolvedType).leafComponentType);
                }
                ArrayAnnotationValue array = new ArrayAnnotationValue(arrayValues);
                AnnotationNameValuePair anvp = new AnnotationNameValuePair(new String(mvp.name), array);
                annotationAJ.addNameValuePair(anvp);
            } else {
                MethodBinding methodBinding = mvp.binding;
                if (methodBinding == null) {
                    throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
                }
                AnnotationValue av = this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType);
                annotationAJ.addNameValuePair(new AnnotationNameValuePair(new String(singleMemberAnnotation.memberValuePairs()[0].name), av));
            }
        } else {
            if (annotation instanceof MarkerAnnotation) {
                return;
            }
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
        }
    }

    private AnnotationValue generateElementValue(Expression defaultValue, TypeBinding memberValuePairReturnType) {
        Constant constant = defaultValue.constant;
        TypeBinding defaultValueBinding = defaultValue.resolvedType;
        if (defaultValueBinding == null) {
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        if (memberValuePairReturnType.isArrayType() && !defaultValueBinding.isArrayType()) {
            if (constant != null && constant != Constant.NotAConstant) {
                AnnotationValue av = EclipseAnnotationConvertor.generateElementValueForConstantExpression(defaultValue, defaultValueBinding);
                return new ArrayAnnotationValue(new AnnotationValue[]{av});
            }
            AnnotationValue av = this.generateElementValueForNonConstantExpression(defaultValue, defaultValueBinding);
            return new ArrayAnnotationValue(new AnnotationValue[]{av});
        }
        if (constant != null && constant != Constant.NotAConstant) {
            AnnotationValue av = EclipseAnnotationConvertor.generateElementValueForConstantExpression(defaultValue, defaultValueBinding);
            if (av == null) {
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            return av;
        }
        AnnotationValue av = this.generateElementValueForNonConstantExpression(defaultValue, defaultValueBinding);
        return av;
    }

    private AnnotationValue generateElementValueForNonConstantExpression(Expression defaultValue, TypeBinding defaultValueBinding) {
        if (defaultValueBinding != null) {
            if (defaultValueBinding.isEnum()) {
                NameReference nameReference;
                FieldBinding fieldBinding = null;
                if (defaultValue instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (defaultValue instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)defaultValue;
                    fieldBinding = (FieldBinding)((SingleNameReference)nameReference).binding;
                } else {
                    throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
                }
                if (fieldBinding != null) {
                    String sig = new String(fieldBinding.type.signature());
                    EnumAnnotationValue enumValue = new EnumAnnotationValue(sig, new String(fieldBinding.name));
                    return enumValue;
                }
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            if (defaultValue instanceof ClassLiteralAccess) {
                ClassLiteralAccess cla = (ClassLiteralAccess)defaultValue;
                TypeBinding claTargetType = cla.targetType;
                String classLiteralSig = new String(claTargetType.signature());
                ClassAnnotationValue classValue = new ClassAnnotationValue(classLiteralSig);
                return classValue;
            }
            if (defaultValueBinding.isAnnotationType()) {
                if (defaultValue instanceof MarkerAnnotation) {
                    ResolvedType ajAnnotationType = this.factory.fromTypeBindingToRTX(defaultValueBinding);
                    StandardAnnotation ajAnnotation = new StandardAnnotation(ajAnnotationType, ajAnnotationType.isAnnotationWithRuntimeRetention());
                    AnnotationAnnotationValue av = new AnnotationAnnotationValue(ajAnnotation);
                    return av;
                }
                if (defaultValue instanceof NormalAnnotation) {
                    NormalAnnotation normalAnnotation = (NormalAnnotation)defaultValue;
                    ResolvedType ajAnnotationType = this.factory.fromTypeBindingToRTX(defaultValueBinding);
                    StandardAnnotation ajAnnotation = new StandardAnnotation(ajAnnotationType, ajAnnotationType.isAnnotationWithRuntimeRetention());
                    MemberValuePair[] pairs = normalAnnotation.memberValuePairs;
                    if (pairs != null) {
                        for (int p = 0; p < pairs.length; ++p) {
                            MemberValuePair pair = pairs[p];
                            Expression valueEx = pair.value;
                            AnnotationValue pairValue = null;
                            pairValue = valueEx instanceof Literal ? this.generateElementValue(valueEx, ((Literal)valueEx).resolvedType) : this.generateElementValue(pair.value, pair.binding.returnType);
                            ajAnnotation.addNameValuePair(new AnnotationNameValuePair(new String(pair.name), pairValue));
                        }
                    }
                    AnnotationAnnotationValue av = new AnnotationAnnotationValue(ajAnnotation);
                    return av;
                }
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            if (defaultValueBinding.isArrayType()) {
                if (defaultValue instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)defaultValue;
                    int arrayLength = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    AnnotationValue[] values = new AnnotationValue[arrayLength];
                    for (int i = 0; i < arrayLength; ++i) {
                        values[i] = this.generateElementValue(arrayInitializer.expressions[i], defaultValueBinding.leafComponentType());
                    }
                    ArrayAnnotationValue aav = new ArrayAnnotationValue(values);
                    return aav;
                }
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationTypesResolved();
        return this.annotationTypes;
    }

    public PerClause getPerClause() {
        if (!this.isAnnotationStyleAspect()) {
            PerClause pc;
            if (this.declaration instanceof AspectDeclaration && (pc = ((AspectDeclaration)this.declaration).perClause) != null) {
                return pc;
            }
            return new PerSingleton();
        }
        PerClause pc = null;
        if (this.declaration instanceof AspectDeclaration) {
            pc = ((AspectDeclaration)this.declaration).perClause;
        }
        if (pc == null) {
            PerClause.Kind kind = this.getPerClauseForTypeDeclaration(this.declaration);
            return new PerFromSuper(kind);
        }
        return pc;
    }

    PerClause.Kind getPerClauseForTypeDeclaration(TypeDeclaration typeDeclaration) {
        Annotation[] annotations = typeDeclaration.annotations;
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            if (annotation == null || annotation.resolvedType == null || !CharOperation.equals(aspectSig, annotation.resolvedType.signature())) continue;
            if (annotation.memberValuePairs() == null || annotation.memberValuePairs().length == 0) {
                PerClause.Kind kind = this.lookupPerClauseKind(typeDeclaration.binding.superclass);
                if (kind == null) {
                    return PerClause.SINGLETON;
                }
                return kind;
            }
            if (annotation instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation theAnnotation = (SingleMemberAnnotation)annotation;
                String clause = new String(((StringLiteral)theAnnotation.memberValue).source());
                return this.determinePerClause(typeDeclaration, clause);
            }
            if (annotation instanceof NormalAnnotation) {
                NormalAnnotation theAnnotation = (NormalAnnotation)annotation;
                if (theAnnotation.memberValuePairs == null || theAnnotation.memberValuePairs.length < 1) {
                    return PerClause.SINGLETON;
                }
                String clause = new String(((StringLiteral)theAnnotation.memberValuePairs[0].value).source());
                return this.determinePerClause(typeDeclaration, clause);
            }
            this.eclipseWorld().showMessage(IMessage.ABORT, "@Aspect annotation is expected to be SingleMemberAnnotation with 'String value()' as unique element", new EclipseSourceLocation(typeDeclaration.compilationResult, typeDeclaration.sourceStart, typeDeclaration.sourceEnd), null);
            return PerClause.SINGLETON;
        }
        return null;
    }

    private PerClause.Kind determinePerClause(TypeDeclaration typeDeclaration, String clause) {
        if (clause.startsWith("perthis(")) {
            return PerClause.PEROBJECT;
        }
        if (clause.startsWith("pertarget(")) {
            return PerClause.PEROBJECT;
        }
        if (clause.startsWith("percflow(")) {
            return PerClause.PERCFLOW;
        }
        if (clause.startsWith("percflowbelow(")) {
            return PerClause.PERCFLOW;
        }
        if (clause.startsWith("pertypewithin(")) {
            return PerClause.PERTYPEWITHIN;
        }
        if (clause.startsWith("issingleton(")) {
            return PerClause.SINGLETON;
        }
        this.eclipseWorld().showMessage(IMessage.ABORT, "cannot determine perClause '" + clause + "'", new EclipseSourceLocation(typeDeclaration.compilationResult, typeDeclaration.sourceStart, typeDeclaration.sourceEnd), null);
        return PerClause.SINGLETON;
    }

    private PerClause.Kind lookupPerClauseKind(ReferenceBinding binding) {
        PerClause.Kind kind;
        if (binding instanceof BinaryTypeBinding) {
            ResolvedType superTypeX = this.factory.fromEclipse(binding);
            PerClause perClause = superTypeX.getPerClause();
            kind = perClause != null ? superTypeX.getPerClause().getKind() : null;
        } else if (binding instanceof SourceTypeBinding) {
            SourceTypeBinding sourceSc = (SourceTypeBinding)binding;
            kind = sourceSc.scope.referenceContext instanceof AspectDeclaration ? ((AspectDeclaration)sourceSc.scope.referenceContext).perClause.getKind() : this.getPerClauseForTypeDeclaration(sourceSc.scope.referenceContext);
        } else {
            kind = null;
        }
        return kind;
    }

    public Collection getDeclares() {
        return this.declares;
    }

    public Collection getPrivilegedAccesses() {
        return Collections.EMPTY_LIST;
    }

    public Collection getTypeMungers() {
        return this.typeMungers;
    }

    public boolean doesNotExposeShadowMungers() {
        return true;
    }

    public String getDeclaredGenericSignature() {
        return CharOperation.charToString(this.binding.genericSignature());
    }

    public boolean isGeneric() {
        return this.binding.isGenericType();
    }

    public TypeVariable[] getTypeVariables() {
        if (this.declaration.typeParameters == null) {
            return new TypeVariable[0];
        }
        TypeVariable[] typeVariables = new TypeVariable[this.declaration.typeParameters.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            typeVariables[i] = this.typeParameter2TypeVariable(this.declaration.typeParameters[i]);
        }
        return typeVariables;
    }

    private TypeVariable typeParameter2TypeVariable(TypeParameter typeParameter) {
        String name = new String(typeParameter.name);
        ReferenceBinding superclassBinding = typeParameter.binding.superclass;
        UnresolvedType superclass = UnresolvedType.forSignature(new String(superclassBinding.signature()));
        UnresolvedType[] superinterfaces = null;
        ReferenceBinding[] superInterfaceBindings = typeParameter.binding.superInterfaces;
        if (superInterfaceBindings != null) {
            superinterfaces = new UnresolvedType[superInterfaceBindings.length];
            for (int i = 0; i < superInterfaceBindings.length; ++i) {
                superinterfaces[i] = UnresolvedType.forSignature(new String(superInterfaceBindings[i].signature()));
            }
        }
        TypeVariable tv = new TypeVariable(name, superclass, superinterfaces);
        tv.setDeclaringElement(this.factory.fromBinding(typeParameter.binding.declaringElement));
        tv.setRank(typeParameter.binding.rank);
        return tv;
    }

    static class MissingImplementationException
    extends RuntimeException {
        MissingImplementationException(String reason) {
            super(reason);
        }
    }
}

