/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd;

import org.aspectj.org.eclipse.jdt.internal.core.nd.IDestructable;
import org.aspectj.org.eclipse.jdt.internal.core.nd.INdVisitor;
import org.aspectj.org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;

public abstract class NdNode
implements IDestructable {
    public static final FieldShort NODE_TYPE;
    public static final StructDef<NdNode> type;
    public final long address;
    private Nd nd;

    static {
        type = StructDef.create(NdNode.class);
        NODE_TYPE = type.addShort();
        type.done();
    }

    public static long addressOf(NdNode nullable) {
        if (nullable == null) {
            return 0L;
        }
        return nullable.address;
    }

    public static NdNode load(Nd nd, long address) {
        if (address == 0L) {
            return null;
        }
        return nd.getNode(address, NODE_TYPE.get(nd, address));
    }

    public static <T extends NdNode> T load(Nd nd, long address, Class<T> clazz) {
        if (address == 0L) {
            return null;
        }
        NdNode result = nd.getNode(address, NODE_TYPE.get(nd, address));
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new IndexException("Found wrong data type at address " + address + ". Expected a subclass of " + clazz + " but found " + result.getClass());
        }
        return (T)result;
    }

    public final void delete() {
        this.getNd().delete(this.address);
    }

    protected NdNode(Nd nd, long address) {
        this.nd = nd;
        this.address = address;
    }

    protected NdNode(Nd nd) {
        Database db = nd.getDB();
        this.nd = nd;
        short nodeType = nd.getNodeType(this.getClass());
        ITypeFactory factory1 = nd.getTypeFactory(nodeType);
        this.address = db.malloc(factory1.getRecordSize(), (short)(256 + nodeType));
        NODE_TYPE.put(nd, this.address, nodeType);
    }

    protected Database getDB() {
        return this.nd.getDB();
    }

    public Nd getNd() {
        return this.nd;
    }

    public short getNodeType() {
        return this.nd.getNodeType(this.getClass());
    }

    public final long getAddress() {
        return this.address;
    }

    public final long getBindingID() {
        return this.address;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NdNode) {
            NdNode other = (NdNode)obj;
            return this.getNd() == other.getNd() && this.address == other.address;
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return (int)(this.address >> 3);
    }

    public void accept(INdVisitor visitor) {
    }

    public static int getNodeId(int linkageID, int nodeType) {
        return linkageID << 16 | nodeType & 0xFFFF;
    }

    protected byte getByte(long offset) {
        return this.getDB().getByte(offset);
    }

    protected static boolean getBit(int bitVector, int offset) {
        int mask = 1 << offset;
        return (bitVector & mask) != 0;
    }

    @Override
    public void destruct() {
    }
}

