/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantPool;

public class EnclosingMethod
extends Attribute {
    private int classIndex;
    private int methodIndex;

    public EnclosingMethod(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), constantPool);
    }

    private EnclosingMethod(int n, int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)17, n, n2, constantPool);
        this.classIndex = n3;
        this.methodIndex = n4;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitEnclosingMethod(this);
    }

    public Attribute copy(ConstantPool constantPool) {
        throw new RuntimeException("Not implemented yet!");
    }

    public final int getEnclosingClassIndex() {
        return this.classIndex;
    }

    public final int getEnclosingMethodIndex() {
        return this.methodIndex;
    }

    public final void setEnclosingClassIndex(int n) {
        this.classIndex = n;
    }

    public final void setEnclosingMethodIndex(int n) {
        this.methodIndex = n;
    }

    public final ConstantClass getEnclosingClass() {
        ConstantClass constantClass = (ConstantClass)this.cpool.getConstant(this.classIndex, (byte)7);
        return constantClass;
    }

    public final ConstantNameAndType getEnclosingMethod() {
        if (this.methodIndex == 0) {
            return null;
        }
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cpool.getConstant(this.methodIndex, (byte)12);
        return constantNameAndType;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.classIndex);
        dataOutputStream.writeShort(this.methodIndex);
    }
}

