/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationElementValue;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.ArrayElementValue;
import org.aspectj.apache.bcel.classfile.annotation.ClassElementValue;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValue;
import org.aspectj.apache.bcel.classfile.annotation.SimpleElementValue;

public abstract class ElementValue {
    public static final int STRING = 115;
    public static final int ENUM_CONSTANT = 101;
    public static final int CLASS = 99;
    public static final int ANNOTATION = 64;
    public static final int ARRAY = 91;
    public static final int PRIMITIVE_INT = 73;
    public static final int PRIMITIVE_BYTE = 66;
    public static final int PRIMITIVE_CHAR = 67;
    public static final int PRIMITIVE_DOUBLE = 68;
    public static final int PRIMITIVE_FLOAT = 70;
    public static final int PRIMITIVE_LONG = 74;
    public static final int PRIMITIVE_SHORT = 83;
    public static final int PRIMITIVE_BOOLEAN = 90;
    protected int type;
    protected ConstantPool cpool;

    protected ElementValue(int n, ConstantPool constantPool) {
        this.type = n;
        this.cpool = constantPool;
    }

    public int getElementValueType() {
        return this.type;
    }

    public abstract String stringifyValue();

    public abstract void dump(DataOutputStream var1) throws IOException;

    public static ElementValue readElementValue(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        switch (n) {
            case 66: {
                return new SimpleElementValue(66, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 67: {
                return new SimpleElementValue(67, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 68: {
                return new SimpleElementValue(68, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 70: {
                return new SimpleElementValue(70, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 73: {
                return new SimpleElementValue(73, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 74: {
                return new SimpleElementValue(74, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 83: {
                return new SimpleElementValue(83, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 90: {
                return new SimpleElementValue(90, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 115: {
                return new SimpleElementValue(115, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 101: {
                return new EnumElementValue(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), constantPool);
            }
            case 99: {
                return new ClassElementValue(dataInputStream.readUnsignedShort(), constantPool);
            }
            case 64: {
                return new AnnotationElementValue(64, AnnotationGen.read(dataInputStream, constantPool, true), constantPool);
            }
            case 91: {
                int n2 = dataInputStream.readUnsignedShort();
                ElementValue[] elementValueArray = new ElementValue[n2];
                for (int i = 0; i < n2; ++i) {
                    elementValueArray[i] = ElementValue.readElementValue(dataInputStream, constantPool);
                }
                return new ArrayElementValue(91, elementValueArray, constantPool);
            }
        }
        throw new RuntimeException("Unexpected element value kind in annotation: " + n);
    }

    protected ConstantPool getConstantPool() {
        return this.cpool;
    }

    public static ElementValue copy(ElementValue elementValue, ConstantPool constantPool, boolean bl) {
        switch (elementValue.getElementValueType()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new SimpleElementValue((SimpleElementValue)elementValue, constantPool, bl);
            }
            case 101: {
                return new EnumElementValue((EnumElementValue)elementValue, constantPool, bl);
            }
            case 64: {
                return new AnnotationElementValue((AnnotationElementValue)elementValue, constantPool, bl);
            }
            case 91: {
                return new ArrayElementValue((ArrayElementValue)elementValue, constantPool, bl);
            }
            case 99: {
                return new ClassElementValue((ClassElementValue)elementValue, constantPool, bl);
            }
        }
        throw new RuntimeException("Not implemented yet! (" + elementValue.getElementValueType() + ")");
    }
}

