/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.util.ClassLoaderReference;
import org.aspectj.apache.bcel.util.DefaultClassLoaderReference;
import org.aspectj.apache.bcel.util.Repository;

public class NonCachingClassLoaderRepository
implements Repository {
    private static ClassLoader bootClassLoader = null;
    private final ClassLoaderReference loaderRef;
    private final Map<String, JavaClass> loadedClasses = new SoftHashMap();

    public NonCachingClassLoaderRepository(ClassLoader classLoader) {
        this.loaderRef = new DefaultClassLoaderReference(classLoader != null ? classLoader : NonCachingClassLoaderRepository.getBootClassLoader());
    }

    public NonCachingClassLoaderRepository(ClassLoaderReference classLoaderReference) {
        this.loaderRef = classLoaderReference;
    }

    private static synchronized ClassLoader getBootClassLoader() {
        if (bootClassLoader == null) {
            bootClassLoader = new URLClassLoader(new URL[0]);
        }
        return bootClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeClass(JavaClass javaClass) {
        Map<String, JavaClass> map = this.loadedClasses;
        synchronized (map) {
            this.loadedClasses.put(javaClass.getClassName(), javaClass);
        }
        javaClass.setRepository(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClass(JavaClass javaClass) {
        Map<String, JavaClass> map = this.loadedClasses;
        synchronized (map) {
            this.loadedClasses.remove(javaClass.getClassName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaClass findClass(String string) {
        Map<String, JavaClass> map = this.loadedClasses;
        synchronized (map) {
            if (this.loadedClasses.containsKey(string)) {
                return this.loadedClasses.get(string);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, JavaClass> map = this.loadedClasses;
        synchronized (map) {
            this.loadedClasses.clear();
        }
    }

    @Override
    public JavaClass loadClass(String string) throws ClassNotFoundException {
        JavaClass javaClass = this.findClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        javaClass = this.loadJavaClass(string);
        this.storeClass(javaClass);
        return javaClass;
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    private JavaClass loadJavaClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/');
        try {
            InputStream inputStream = this.loaderRef.getClassLoader().getResourceAsStream(string2 + ".class");
            if (inputStream == null) {
                throw new ClassNotFoundException(string + " not found.");
            }
            ClassParser classParser = new ClassParser(inputStream, string);
            return classParser.parse();
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
    }

    public static class SoftHashMap
    extends AbstractMap {
        private Map<Object, SpecialValue> map;
        private ReferenceQueue rq = new ReferenceQueue();

        public SoftHashMap(Map<Object, SpecialValue> map) {
            this.map = map;
        }

        public SoftHashMap() {
            this(new HashMap<Object, SpecialValue>());
        }

        public SoftHashMap(Map<Object, SpecialValue> map, boolean bl) {
            this(map);
        }

        private void processQueue() {
            SpecialValue specialValue = null;
            while ((specialValue = (SpecialValue)this.rq.poll()) != null) {
                this.map.remove(specialValue.key);
            }
        }

        @Override
        public Object get(Object object) {
            SpecialValue specialValue = this.map.get(object);
            if (specialValue == null) {
                return null;
            }
            if (specialValue.get() == null) {
                this.map.remove(specialValue.key);
                return null;
            }
            return specialValue.get();
        }

        @Override
        public Object put(Object object, Object object2) {
            this.processQueue();
            return this.map.put(object, new SpecialValue(object, object2));
        }

        @Override
        public Set entrySet() {
            return this.map.entrySet();
        }

        @Override
        public void clear() {
            this.processQueue();
            Set<Object> set = this.map.keySet();
            for (Object object : set) {
                this.map.remove(object);
            }
        }

        @Override
        public int size() {
            this.processQueue();
            return this.map.size();
        }

        @Override
        public Object remove(Object object) {
            this.processQueue();
            SpecialValue specialValue = this.map.remove(object);
            if (specialValue == null) {
                return null;
            }
            if (specialValue.get() != null) {
                return specialValue.get();
            }
            return null;
        }

        class SpecialValue
        extends SoftReference {
            private final Object key;

            SpecialValue(Object object, Object object2) {
                super(object2, SoftHashMap.this.rq);
                this.key = object;
            }
        }
    }
}

