/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.indexer;

import org.aspectj.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IMethodBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IPackageBinding;
import org.aspectj.org.eclipse.jdt.core.dom.ITypeBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.indexer.Package;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTreeNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeInterface;
import org.eclipse.core.runtime.IProgressMonitor;

public class BindingToIndexConverter {
    private static final boolean ENABLE_LOGGING = false;
    private JavaIndex index;
    private NdResourceFile resource;

    public BindingToIndexConverter(NdResourceFile resource) {
        this.resource = resource;
        this.index = JavaIndex.getIndex(resource.getNd());
    }

    public void addBinding(NdTreeNode parent, IBinding binding, IProgressMonitor monitor) {
        switch (binding.getKind()) {
            case 2: {
                this.addType((ITypeBinding)binding, monitor);
                break;
            }
            case 5: {
                this.addAnnotation(parent, (IAnnotationBinding)binding, monitor);
                break;
            }
            case 4: {
                this.addMethod(parent, (IMethodBinding)binding, monitor);
                break;
            }
            case 3: {
                this.addVariable(parent, (IVariableBinding)binding, monitor);
                break;
            }
            case 1: {
                this.addPackage(parent, (IPackageBinding)binding, monitor);
                break;
            }
            case 6: {
                this.addMemberValuePair(parent, (IMemberValuePairBinding)binding, monitor);
                break;
            }
            default: {
                Package.log("Encountered unknown binding type: " + binding.getKind(), null);
            }
        }
    }

    public void addMemberValuePair(NdTreeNode parent, IMemberValuePairBinding binding, IProgressMonitor monitor) {
        this.logInfo("Adding member value pair: " + binding.getName());
    }

    public void addPackage(NdTreeNode parent, IPackageBinding binding, IProgressMonitor monitor) {
        this.logInfo("Adding package: " + binding.getName());
    }

    public void addVariable(NdTreeNode parent, IVariableBinding binding, IProgressMonitor monitor) {
        this.logInfo("Adding variable: " + binding.getName());
    }

    public void addMethod(NdTreeNode parent, IMethodBinding binding, IProgressMonitor monitor) {
        this.logInfo("Adding method: " + binding.getName());
    }

    public void addAnnotation(NdTreeNode parent, IAnnotationBinding binding, IProgressMonitor monitor) {
        this.logInfo("Adding annotation: " + binding.getName());
    }

    public NdType addType(ITypeBinding binding, IProgressMonitor monitor) {
        this.logInfo("Adding type: " + binding.getBinaryName());
        NdTypeId name = this.makeTypeId(binding);
        NdType type = name.findTypeByResourceAddress(this.resource.address);
        if (type == null) {
            type = new NdType(this.getNd(), this.resource);
        }
        type.setTypeId(name);
        ITypeBinding superclass = binding.getSuperclass();
        if (superclass != null) {
            type.setSuperclass(this.makeTypeId(superclass));
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding next = iTypeBindingArray[n2];
            new NdTypeInterface(this.getNd(), type, this.makeTypeId(next));
            ++n2;
        }
        return type;
    }

    private void logInfo(String string) {
    }

    private NdTypeId makeTypeId(ITypeBinding forBinding) {
        return this.index.createTypeId(JavaNames.binaryNameToFieldDescriptor(forBinding.getBinaryName().toCharArray()));
    }

    private Nd getNd() {
        return this.resource.getNd();
    }
}

