/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldSearchIndex;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.FileFingerprint;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTreeNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdWorkspaceLocation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NdResourceFile
extends NdTreeNode {
    public static final FieldSearchKey<JavaIndex> FILENAME;
    public static final FieldOneToMany<NdBinding> ALL_NODES;
    public static final FieldLong TIME_LAST_USED;
    public static final FieldLong TIME_LAST_SCANNED;
    public static final FieldLong SIZE_LAST_SCANNED;
    public static final FieldLong HASHCODE_LAST_SCANNED;
    public static final FieldOneToMany<NdWorkspaceLocation> WORKSPACE_MAPPINGS;
    public static final FieldString JAVA_ROOT;
    public static final StructDef<NdResourceFile> type;

    static {
        type = StructDef.create(NdResourceFile.class, NdTreeNode.type);
        FILENAME = FieldSearchKey.create(type, JavaIndex.FILES);
        ALL_NODES = FieldOneToMany.create(type, NdBinding.FILE, 16);
        TIME_LAST_USED = type.addLong();
        TIME_LAST_SCANNED = type.addLong();
        SIZE_LAST_SCANNED = type.addLong();
        HASHCODE_LAST_SCANNED = type.addLong();
        WORKSPACE_MAPPINGS = FieldOneToMany.create(type, NdWorkspaceLocation.RESOURCE);
        JAVA_ROOT = type.addString();
        type.done();
    }

    public NdResourceFile(Nd dom, long address) {
        super(dom, address);
    }

    public NdResourceFile(Nd nd) {
        super(nd, null);
    }

    public List<NdTreeNode> getChildren() {
        return NdTreeNode.CHILDREN.asList(this.getNd(), this.address);
    }

    public boolean isInIndex() {
        Nd nd;
        block3: {
            try {
                nd = this.getNd();
                if (NdNode.NODE_TYPE.get(nd, this.address) == nd.getNodeType(this.getClass())) break block3;
                return false;
            }
            catch (IndexException e) {
                return false;
            }
        }
        char[] filename = FILENAME.get(this.getNd(), this.address).getChars();
        NdResourceFile result = JavaIndex.FILES.findBest(nd, Database.DATA_AREA_OFFSET, FieldSearchIndex.SearchCriteria.create(filename), new FieldSearchIndex.IResultRank(){

            @Override
            public long getRank(Nd testNd, long testAddress) {
                if (testAddress == NdResourceFile.this.address) {
                    return 1L;
                }
                return -1L;
            }
        });
        return this.equals(result);
    }

    public List<IPath> getAllWorkspaceLocations() {
        final ArrayList<IPath> result = new ArrayList<IPath>();
        WORKSPACE_MAPPINGS.accept(this.getNd(), this.address, new FieldOneToMany.Visitor<NdWorkspaceLocation>(){

            @Override
            public void visit(int index, NdWorkspaceLocation toVisit) {
                result.add(new Path(toVisit.getPath().getString()));
            }
        });
        return result;
    }

    public IPath getFirstWorkspaceLocation() {
        if (WORKSPACE_MAPPINGS.isEmpty(this.getNd(), this.address)) {
            return Path.EMPTY;
        }
        return new Path(WORKSPACE_MAPPINGS.get(this.getNd(), this.address, 0).getPath().toString());
    }

    public IPath getAnyOpenWorkspaceLocation(IWorkspaceRoot root) {
        int numMappings = WORKSPACE_MAPPINGS.size(this.getNd(), this.address);
        int mapping = 0;
        while (mapping < numMappings) {
            IProject project;
            NdWorkspaceLocation nextMapping = WORKSPACE_MAPPINGS.get(this.getNd(), this.address, mapping);
            Path nextPath = new Path(nextMapping.getPath().getString());
            if (!nextPath.isEmpty() && (project = root.getProject(nextPath.segment(0))).isOpen()) {
                return nextPath;
            }
            ++mapping;
        }
        return Path.EMPTY;
    }

    public IPath getPath() {
        IPath workspacePath = this.getFirstWorkspaceLocation();
        if (workspacePath.isEmpty()) {
            return new Path(this.getLocation().getString());
        }
        return workspacePath;
    }

    public List<NdWorkspaceLocation> getWorkspaceMappings() {
        return WORKSPACE_MAPPINGS.asList(this.getNd(), this.address);
    }

    public IString getLocation() {
        return FILENAME.get(this.getNd(), this.address);
    }

    public void setLocation(String filename) {
        FILENAME.put(this.getNd(), this.address, filename);
    }

    public FileFingerprint getFingerprint() {
        return new FileFingerprint(this.getTimeLastScanned(), this.getSizeLastScanned(), this.getHashcodeLastScanned());
    }

    private long getHashcodeLastScanned() {
        return HASHCODE_LAST_SCANNED.get(this.getNd(), this.address);
    }

    public boolean isDoneIndexing() {
        return this.getTimeLastScanned() != 0L;
    }

    public long getTimeLastScanned() {
        return TIME_LAST_SCANNED.get(this.getNd(), this.address);
    }

    public long getSizeLastScanned() {
        return SIZE_LAST_SCANNED.get(this.getNd(), this.address);
    }

    public long getTimeLastUsed() {
        return TIME_LAST_USED.get(this.getNd(), this.address);
    }

    public void setTimeLastUsed(long timeLastUsed) {
        TIME_LAST_USED.put(this.getNd(), this.address, timeLastUsed);
    }

    public void setFingerprint(FileFingerprint newFingerprint) {
        TIME_LAST_SCANNED.put(this.getNd(), this.address, newFingerprint.getTime());
        HASHCODE_LAST_SCANNED.put(this.getNd(), this.address, newFingerprint.getHash());
        SIZE_LAST_SCANNED.put(this.getNd(), this.address, newFingerprint.getSize());
    }

    public void setPackageFragmentRoot(char[] javaRoot) {
        JAVA_ROOT.put(this.getNd(), this.address, javaRoot);
    }

    public IString getPackageFragmentRoot() {
        IString javaRoot = JAVA_ROOT.get(this.getNd(), this.address);
        if (javaRoot.length() == 0) {
            return this.getLocation();
        }
        return javaRoot;
    }

    public void markAsInvalid() {
        TIME_LAST_SCANNED.put(this.getNd(), this.address, 0L);
    }

    public int getBindingCount() {
        return ALL_NODES.size(this.getNd(), this.address);
    }

    public List<NdBinding> getBindings() {
        return ALL_NODES.asList(this.getNd(), this.address);
    }

    public NdBinding getBinding(int index) {
        return ALL_NODES.get(this.getNd(), this.address, index);
    }

    public String toString() {
        try {
            return FILENAME.get(this.getNd(), this.address).toString();
        }
        catch (RuntimeException e) {
            return super.toString();
        }
    }
}

