/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.swing.CompilerMessagesCellRenderer;
import org.aspectj.bridge.IMessage;
import org.aspectj.tools.ajbrowser.ui.BrowserMessageHandler;

public class MessageHandlerPanel
extends JPanel {
    private static final long serialVersionUID = -2251912345065588977L;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList list;
    private DefaultListModel listModel;
    private BorderLayout borderLayout1 = new BorderLayout();

    public void showMessageHandlerPanel(BrowserMessageHandler handler, boolean showPanel) {
        if (!showPanel) {
            this.setVisible(false);
            return;
        }
        this.createList(handler.getMessages());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.list.setModel(this.listModel);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 1) {
                    int index = MessageHandlerPanel.this.list.locationToIndex(e.getPoint());
                    if (MessageHandlerPanel.this.listModel.getSize() >= index && index != -1) {
                        IMessage message = (IMessage)MessageHandlerPanel.this.listModel.getElementAt(index);
                        Ajde.getDefault().getEditorAdapter().showSourceLine(message.getSourceLocation(), true);
                    }
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        this.list.setCellRenderer(new CompilerMessagesCellRenderer());
        this.setVisible(showPanel);
    }

    private void createList(List messages) {
        this.list = new JList();
        this.listModel = new DefaultListModel();
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            this.listModel.addElement(iterator.next());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }
}

