/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import org.aspectj.asm.internal.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Block;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CommonPrinter {
    StringBuilder output = new StringBuilder();
    private int tab = 0;
    MethodScope mscope;
    AbstractMethodDeclaration declaration;
    protected int expressionLevel = 0;

    public CommonPrinter(MethodScope mscope) {
        this.mscope = mscope;
    }

    protected StringBuilder printTypeReference(TypeReference tr) {
        if (tr instanceof Wildcard) {
            Wildcard w = (Wildcard)tr;
            this.output.append('?');
            if (w.bound != null) {
                if (w.kind == 1) {
                    this.output.append(" extends ");
                } else if (w.kind == 2) {
                    this.output.append(" super ");
                }
                this.printTypeReference(w.bound);
            }
            return this.output;
        }
        if (tr instanceof ParameterizedSingleTypeReference) {
            int i;
            ParameterizedSingleTypeReference pstr = (ParameterizedSingleTypeReference)tr;
            ReferenceBinding tb = (ReferenceBinding)this.mscope.getType(pstr.token);
            this.output.append(CharOperation.concatWith(tb.compoundName, '.'));
            this.output.append('<');
            TypeReference[] typeArguments = pstr.typeArguments;
            for (i = 0; i < typeArguments.length; ++i) {
                if (i > 0) {
                    this.output.append(',');
                }
                this.printTypeReference(typeArguments[i]);
            }
            this.output.append('>');
            for (i = 0; i < pstr.dimensions; ++i) {
                this.output.append("[]");
            }
            return this.output;
        }
        if (tr instanceof ParameterizedQualifiedTypeReference) {
            int i;
            ParameterizedQualifiedTypeReference pqtr = (ParameterizedQualifiedTypeReference)tr;
            this.output.append(CharOperation.concatWith(pqtr.tokens, '.'));
            this.output.append('<');
            TypeReference[][] typeArguments = pqtr.typeArguments;
            TypeReference[] ofInterest = typeArguments[typeArguments.length - 1];
            for (i = 0; i < ofInterest.length; ++i) {
                if (i > 0) {
                    this.output.append(',');
                }
                this.printTypeReference(ofInterest[i]);
            }
            this.output.append('>');
            for (i = 0; i < pqtr.dimensions(); ++i) {
                this.output.append("[]");
            }
            return this.output;
        }
        if (tr instanceof SingleTypeReference) {
            SingleTypeReference str = (SingleTypeReference)tr;
            TypeBinding tb = this.mscope.getType(str.token);
            this.output.append(tb.debugName());
            for (int i = 0; i < str.dimensions(); ++i) {
                this.output.append("[]");
            }
            return this.output;
        }
        if (tr instanceof QualifiedTypeReference) {
            QualifiedTypeReference qtr = (QualifiedTypeReference)tr;
            this.output.append(CharOperation.concatWith(qtr.tokens, '.'));
            for (int i = 0; i < qtr.dimensions(); ++i) {
                this.output.append("[]");
            }
            return this.output;
        }
        this.throwit(tr);
        return this.output;
    }

    protected StringBuilder printMemberValuePair(MemberValuePair mvp) {
        this.output.append(mvp.name).append(" = ");
        this.printExpression(mvp.value);
        return this.output;
    }

    protected StringBuilder printAnnotations(Annotation[] annotations) {
        int length = annotations.length;
        for (int i = 0; i < length; ++i) {
            this.printAnnotation(annotations[i]);
            this.output.append(" ");
        }
        return this.output;
    }

    public StringBuilder printAnnotation(Annotation annotation) {
        this.output.append('@');
        this.printExpression(annotation.type);
        MemberValuePair[] mvps = annotation.memberValuePairs();
        if (mvps != null && mvps.length > 0) {
            this.output.append('(');
            for (int m = 0; m < mvps.length; ++m) {
                if (m > 0) {
                    this.output.append(',');
                }
                this.printMemberValuePair(mvps[m]);
            }
            this.output.append(')');
        }
        return this.output;
    }

    public String toString() {
        return this.output.toString();
    }

    protected StringBuilder printBody(int indent) {
        if (this.declaration.isAbstract()) {
            return this.output.append(';');
        }
        this.output.append(" {");
        if (this.declaration.statements != null) {
            for (int i = 0; i < this.declaration.statements.length; ++i) {
                this.output.append('\n');
                this.printStatement(this.declaration.statements[i], indent);
            }
        }
        this.output.append('\n');
        this.printIndent(indent == 0 ? 0 : indent - 1).append('}');
        return this.output;
    }

    protected StringBuilder printBody(AbstractMethodDeclaration amd, int indent) {
        if (amd.isAbstract()) {
            return this.output.append(';');
        }
        this.output.append(" {");
        if (amd.statements != null) {
            for (int i = 0; i < amd.statements.length; ++i) {
                this.output.append('\n');
                this.printStatement(amd.statements[i], indent);
            }
        }
        this.output.append('\n');
        this.printIndent(indent == 0 ? 0 : indent - 1).append('}');
        return this.output;
    }

    protected StringBuilder printArgument(Argument argument) {
        this.printModifiers(argument.modifiers);
        if (argument.annotations != null) {
            this.printAnnotations(argument.annotations);
        }
        this.printTypeReference(argument.type).append(' ');
        return this.output.append(argument.name);
    }

    void throwit(Object o) {
        System.out.println("so far:" + this.output.toString());
        throw new IllegalStateException(o == null ? "" : o.getClass().getName() + ":" + o);
    }

    void throwit() {
        throw new IllegalStateException();
    }

    public StringBuilder printIndent(int indent) {
        for (int i = indent; i > 0; --i) {
            this.output.append("  ");
        }
        return this.output;
    }

    public StringBuilder printModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.output.append("public ");
        }
        if ((modifiers & 2) != 0) {
            this.output.append("private ");
        }
        if ((modifiers & 4) != 0) {
            this.output.append("protected ");
        }
        if ((modifiers & 8) != 0) {
            this.output.append("static ");
        }
        if ((modifiers & 0x10) != 0) {
            this.output.append("final ");
        }
        if ((modifiers & 0x20) != 0) {
            this.output.append("synchronized ");
        }
        if ((modifiers & 0x40) != 0) {
            this.output.append("volatile ");
        }
        if ((modifiers & 0x80) != 0) {
            this.output.append("transient ");
        }
        if ((modifiers & 0x100) != 0) {
            this.output.append("native ");
        }
        if ((modifiers & 0x400) != 0) {
            this.output.append("abstract ");
        }
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder printExpression(Expression e) {
        block77: {
            block76: {
                block75: {
                    block74: {
                        block73: {
                            block72: {
                                block71: {
                                    block70: {
                                        block69: {
                                            block68: {
                                                block67: {
                                                    block66: {
                                                        block64: {
                                                            block65: {
                                                                block63: {
                                                                    block62: {
                                                                        block61: {
                                                                            block60: {
                                                                                Object fb;
                                                                                block59: {
                                                                                    block58: {
                                                                                        block57: {
                                                                                            block56: {
                                                                                                block55: {
                                                                                                    block54: {
                                                                                                        block53: {
                                                                                                            block52: {
                                                                                                                block51: {
                                                                                                                    block50: {
                                                                                                                        try {
                                                                                                                            ++this.expressionLevel;
                                                                                                                            if (!(e instanceof TypeReference)) break block50;
                                                                                                                            StringBuilder stringBuilder = this.printTypeReference((TypeReference)e);
                                                                                                                            Object var7_30 = null;
                                                                                                                            --this.expressionLevel;
                                                                                                                            return stringBuilder;
                                                                                                                        }
                                                                                                                        catch (Throwable throwable) {
                                                                                                                            Object var7_59 = null;
                                                                                                                            --this.expressionLevel;
                                                                                                                            throw throwable;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (!(e instanceof IntLiteral)) break block51;
                                                                                                                    StringBuilder stringBuilder = this.output.append(((IntLiteral)e).value);
                                                                                                                    Object var7_31 = null;
                                                                                                                    --this.expressionLevel;
                                                                                                                    return stringBuilder;
                                                                                                                }
                                                                                                                if (!(e instanceof CharLiteral)) break block52;
                                                                                                                StringBuilder stringBuilder = this.output.append(((CharLiteral)e).source());
                                                                                                                Object var7_32 = null;
                                                                                                                --this.expressionLevel;
                                                                                                                return stringBuilder;
                                                                                                            }
                                                                                                            if (!(e instanceof DoubleLiteral)) break block53;
                                                                                                            StringBuilder stringBuilder = this.output.append(((DoubleLiteral)e).source());
                                                                                                            Object var7_33 = null;
                                                                                                            --this.expressionLevel;
                                                                                                            return stringBuilder;
                                                                                                        }
                                                                                                        if (!(e instanceof LongLiteral)) break block54;
                                                                                                        StringBuilder stringBuilder = this.output.append(((LongLiteral)e).source());
                                                                                                        Object var7_34 = null;
                                                                                                        --this.expressionLevel;
                                                                                                        return stringBuilder;
                                                                                                    }
                                                                                                    if (!(e instanceof FloatLiteral)) break block55;
                                                                                                    StringBuilder stringBuilder = this.output.append(((FloatLiteral)e).source());
                                                                                                    Object var7_35 = null;
                                                                                                    --this.expressionLevel;
                                                                                                    return stringBuilder;
                                                                                                }
                                                                                                if (!(e instanceof TrueLiteral)) break block56;
                                                                                                StringBuilder stringBuilder = this.output.append(((TrueLiteral)e).source());
                                                                                                Object var7_36 = null;
                                                                                                --this.expressionLevel;
                                                                                                return stringBuilder;
                                                                                            }
                                                                                            if (!(e instanceof FalseLiteral)) break block57;
                                                                                            StringBuilder stringBuilder = this.output.append(((FalseLiteral)e).source());
                                                                                            Object var7_37 = null;
                                                                                            --this.expressionLevel;
                                                                                            return stringBuilder;
                                                                                        }
                                                                                        if (!(e instanceof ClassLiteralAccess)) break block58;
                                                                                        this.printTypeReference(((ClassLiteralAccess)e).type);
                                                                                        StringBuilder stringBuilder = this.output.append(".class");
                                                                                        Object var7_38 = null;
                                                                                        --this.expressionLevel;
                                                                                        return stringBuilder;
                                                                                    }
                                                                                    if (!(e instanceof StringLiteral)) break block59;
                                                                                    StringBuilder stringBuilder = this.printStringLiteral((StringLiteral)e);
                                                                                    Object var7_39 = null;
                                                                                    --this.expressionLevel;
                                                                                    return stringBuilder;
                                                                                }
                                                                                if (!(e instanceof SingleNameReference)) break block60;
                                                                                SingleNameReference snr = (SingleNameReference)e;
                                                                                if (snr.binding instanceof ReferenceBinding) {
                                                                                    this.output.append(CharOperation.concatWith(((ReferenceBinding)snr.binding).compoundName, '.'));
                                                                                } else if (snr.binding instanceof ParameterizedFieldBinding) {
                                                                                    ParameterizedFieldBinding pfb = (ParameterizedFieldBinding)snr.binding;
                                                                                    this.output.append(pfb.name);
                                                                                } else if (snr.binding instanceof LocalVariableBinding) {
                                                                                    LocalVariableBinding lvb = (LocalVariableBinding)snr.binding;
                                                                                    this.output.append(lvb.name);
                                                                                } else if (snr.binding instanceof FieldBinding) {
                                                                                    fb = (FieldBinding)snr.binding;
                                                                                    ReferenceBinding rb = ((FieldBinding)fb).declaringClass;
                                                                                    if (((FieldBinding)fb).isStatic()) {
                                                                                        this.output.append(CharOperation.concatWith(rb.compoundName, '.'));
                                                                                        this.output.append('.');
                                                                                        this.output.append(((FieldBinding)fb).name);
                                                                                    } else {
                                                                                        this.output.append(snr.token);
                                                                                    }
                                                                                    boolean bl = true;
                                                                                } else {
                                                                                    this.throwit(snr.binding);
                                                                                }
                                                                                fb = this.output;
                                                                                Object var7_40 = null;
                                                                                --this.expressionLevel;
                                                                                return fb;
                                                                            }
                                                                            if (!(e instanceof QualifiedNameReference)) break block61;
                                                                            QualifiedNameReference qnr = (QualifiedNameReference)e;
                                                                            if (qnr.binding instanceof FieldBinding) {
                                                                                FieldBinding fb = (FieldBinding)qnr.binding;
                                                                                ReferenceBinding rb = fb.declaringClass;
                                                                                if (fb.isStatic()) {
                                                                                    this.output.append(CharOperation.concatWith(rb.compoundName, '.'));
                                                                                    this.output.append('.');
                                                                                    this.output.append(fb.name);
                                                                                } else {
                                                                                    this.output.append(CharOperation.concatWith(qnr.tokens, '.'));
                                                                                }
                                                                            } else if (qnr.binding instanceof ReferenceBinding) {
                                                                                this.output.append(CharOperation.concatWith(qnr.tokens, '.'));
                                                                            } else if (qnr.binding instanceof LocalVariableBinding) {
                                                                                this.output.append(CharOperation.concatWith(qnr.tokens, '.'));
                                                                            } else {
                                                                                this.throwit(qnr.binding);
                                                                            }
                                                                            StringBuilder stringBuilder = this.output;
                                                                            Object var7_41 = null;
                                                                            --this.expressionLevel;
                                                                            return stringBuilder;
                                                                        }
                                                                        if (!(e instanceof ArrayReference)) break block62;
                                                                        ArrayReference ar = (ArrayReference)e;
                                                                        this.printExpression(ar.receiver).append('[');
                                                                        StringBuilder stringBuilder = this.printExpression(ar.position).append(']');
                                                                        Object var7_42 = null;
                                                                        --this.expressionLevel;
                                                                        return stringBuilder;
                                                                    }
                                                                    if (!(e instanceof MessageSend)) break block63;
                                                                    StringBuilder ar = this.printMessageSendStatement((MessageSend)e);
                                                                    Object var7_43 = null;
                                                                    --this.expressionLevel;
                                                                    return ar;
                                                                }
                                                                if (!(e instanceof ThisReference)) break block64;
                                                                ThisReference tr = (ThisReference)e;
                                                                if (!tr.isImplicitThis()) break block65;
                                                                StringBuilder stringBuilder = this.output;
                                                                Object var7_44 = null;
                                                                --this.expressionLevel;
                                                                return stringBuilder;
                                                            }
                                                            StringBuilder stringBuilder = this.output.append("this");
                                                            Object var7_45 = null;
                                                            --this.expressionLevel;
                                                            return stringBuilder;
                                                        }
                                                        if (!(e instanceof CastExpression)) break block66;
                                                        StringBuilder tr = this.printCastExpression((CastExpression)e);
                                                        Object var7_46 = null;
                                                        --this.expressionLevel;
                                                        return tr;
                                                    }
                                                    if (!(e instanceof BinaryExpression)) break block67;
                                                    if (this.expressionLevel != 0) {
                                                        this.output.append('(');
                                                    }
                                                    ++this.expressionLevel;
                                                    BinaryExpression be = (BinaryExpression)e;
                                                    this.printExpression(be.left).append(' ').append(be.operatorToString()).append(' ');
                                                    this.printExpression(be.right);
                                                    --this.expressionLevel;
                                                    if (this.expressionLevel != 0) {
                                                        this.output.append(')');
                                                    }
                                                    StringBuilder stringBuilder = this.output;
                                                    Object var7_47 = null;
                                                    --this.expressionLevel;
                                                    return stringBuilder;
                                                }
                                                if (!(e instanceof NullLiteral)) break block68;
                                                StringBuilder stringBuilder = this.output.append("null");
                                                Object var7_48 = null;
                                                --this.expressionLevel;
                                                return stringBuilder;
                                            }
                                            if (!(e instanceof QualifiedAllocationExpression)) break block69;
                                            StringBuilder stringBuilder = this.printQualifiedAllocationExpression((QualifiedAllocationExpression)e, 0);
                                            Object var7_49 = null;
                                            --this.expressionLevel;
                                            return stringBuilder;
                                        }
                                        if (!(e instanceof AllocationExpression)) break block70;
                                        StringBuilder stringBuilder = this.printAllocationExpression((AllocationExpression)e);
                                        Object var7_50 = null;
                                        --this.expressionLevel;
                                        return stringBuilder;
                                    }
                                    if (!(e instanceof ArrayInitializer)) break block71;
                                    StringBuilder stringBuilder = this.printArrayInitialized((ArrayInitializer)e);
                                    Object var7_51 = null;
                                    --this.expressionLevel;
                                    return stringBuilder;
                                }
                                if (!(e instanceof FieldReference)) break block72;
                                StringBuilder stringBuilder = this.printFieldReference((FieldReference)e);
                                Object var7_52 = null;
                                --this.expressionLevel;
                                return stringBuilder;
                            }
                            if (!(e instanceof UnaryExpression)) break block73;
                            StringBuilder stringBuilder = this.printUnaryExpression((UnaryExpression)e);
                            Object var7_53 = null;
                            --this.expressionLevel;
                            return stringBuilder;
                        }
                        if (!(e instanceof InstanceOfExpression)) break block74;
                        StringBuilder stringBuilder = this.printInstanceOfExpression((InstanceOfExpression)e);
                        Object var7_54 = null;
                        --this.expressionLevel;
                        return stringBuilder;
                    }
                    if (!(e instanceof Assignment)) break block75;
                    StringBuilder stringBuilder = this.printAssignment((Assignment)e, false);
                    Object var7_55 = null;
                    --this.expressionLevel;
                    return stringBuilder;
                }
                if (!(e instanceof ArrayAllocationExpression)) break block76;
                StringBuilder stringBuilder = this.printArrayAllocationExpression((ArrayAllocationExpression)e);
                Object var7_56 = null;
                --this.expressionLevel;
                return stringBuilder;
            }
            if (!(e instanceof ConditionalExpression)) break block77;
            StringBuilder stringBuilder = this.printConditionalExpression((ConditionalExpression)e);
            Object var7_57 = null;
            --this.expressionLevel;
            return stringBuilder;
        }
        this.throwit(e);
        StringBuilder stringBuilder = this.output;
        Object var7_58 = null;
        --this.expressionLevel;
        return stringBuilder;
    }

    private StringBuilder printConditionalExpression(ConditionalExpression e) {
        if (this.expressionLevel != 0) {
            this.output.append('(');
        }
        ++this.expressionLevel;
        this.printExpression(e.condition).append(" ? ");
        this.printExpression(e.valueIfTrue).append(" : ");
        this.printExpression(e.valueIfFalse);
        --this.expressionLevel;
        if (this.expressionLevel != 0) {
            this.output.append(')');
        }
        return this.output;
    }

    private StringBuilder printArrayAllocationExpression(ArrayAllocationExpression aae) {
        this.output.append("new ");
        this.printTypeReference(aae.type);
        for (int i = 0; i < aae.dimensions.length; ++i) {
            if (aae.dimensions[i] == null) {
                this.output.append("[]");
                continue;
            }
            this.output.append('[');
            this.printExpression(aae.dimensions[i]);
            this.output.append(']');
        }
        if (aae.initializer != null) {
            this.printExpression(aae.initializer);
        }
        return this.output;
    }

    private StringBuilder printInstanceOfExpression(InstanceOfExpression e) {
        if (this.expressionLevel != 0) {
            this.output.append('(');
        }
        ++this.expressionLevel;
        this.printExpression(e.expression).append(" instanceof ");
        this.printTypeReference(e.type);
        --this.expressionLevel;
        if (this.expressionLevel != 0) {
            this.output.append(')');
        }
        return this.output;
    }

    private StringBuilder printUnaryExpression(UnaryExpression e) {
        if (this.expressionLevel != 0) {
            this.output.append('(');
        }
        ++this.expressionLevel;
        this.output.append(e.operatorToString()).append(' ');
        this.printExpression(e.expression);
        --this.expressionLevel;
        if (this.expressionLevel != 0) {
            this.output.append(')');
        }
        return this.output;
    }

    private StringBuilder printFieldReference(FieldReference fr) {
        this.printExpression(fr.receiver).append('.').append(fr.token);
        return this.output;
    }

    private StringBuilder printArrayInitialized(ArrayInitializer e) {
        this.output.append('{');
        if (e.expressions != null) {
            for (int i = 0; i < e.expressions.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printExpression(e.expressions[i]);
            }
        }
        return this.output.append('}');
    }

    private StringBuilder printCastExpression(CastExpression e) {
        this.output.append('(');
        this.output.append('(');
        this.printExpression(e.type).append(") ");
        this.printExpression(e.expression);
        this.output.append(')');
        return this.output;
    }

    private StringBuilder printStringLiteral(StringLiteral e) {
        this.output.append('\"');
        block10: for (int i = 0; i < e.source().length; ++i) {
            switch (e.source()[i]) {
                case '\b': {
                    this.output.append("\\b");
                    continue block10;
                }
                case '\t': {
                    this.output.append("\\t");
                    continue block10;
                }
                case '\n': {
                    this.output.append("\\n");
                    continue block10;
                }
                case '\f': {
                    this.output.append("\\f");
                    continue block10;
                }
                case '\r': {
                    this.output.append("\\r");
                    continue block10;
                }
                case '\"': {
                    this.output.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    this.output.append("\\'");
                    continue block10;
                }
                case '\\': {
                    this.output.append("\\\\");
                    continue block10;
                }
                default: {
                    this.output.append(e.source()[i]);
                }
            }
        }
        this.output.append('\"');
        return this.output;
    }

    public StringBuilder printExpression(SingleTypeReference str) {
        this.output.append(str.token);
        return this.output;
    }

    protected StringBuilder printStatement(Statement statement, int indent) {
        return this.printStatement(statement, indent, true);
    }

    protected StringBuilder printStatement(Statement statement, int indent, boolean applyIndent) {
        if (statement instanceof ReturnStatement) {
            this.printIndent(indent).append("return ");
            if (((ReturnStatement)statement).expression != null) {
                this.printExpression(((ReturnStatement)statement).expression);
            }
            return this.output.append(';');
        }
        if (statement instanceof PostfixExpression) {
            return this.printPostfixExpression((PostfixExpression)statement);
        }
        if (statement instanceof PrefixExpression) {
            return this.printPrefixExpression((PrefixExpression)statement);
        }
        if (statement instanceof MessageSend) {
            this.printIndent(indent);
            MessageSend ms = (MessageSend)statement;
            this.printMessageSendStatement(ms);
            return this.output.append(';');
        }
        if (statement instanceof QualifiedAllocationExpression) {
            this.printIndent(indent);
            this.printQualifiedAllocationExpression((QualifiedAllocationExpression)statement, indent);
            return this.output.append(';');
        }
        if (statement instanceof Assignment) {
            this.printIndent(indent);
            this.printAssignment((Assignment)statement);
            return this.output.append(';');
        }
        if (statement instanceof TryStatement) {
            this.printTryStatement((TryStatement)statement, indent);
            return this.output;
        }
        if (statement instanceof IfStatement) {
            this.printIndent(indent);
            IfStatement is = (IfStatement)statement;
            this.printIndent(indent).append("if (");
            this.printExpression(is.condition).append(")\n");
            this.printStatement(is.thenStatement, indent + 2);
            if (is.elseStatement != null) {
                this.output.append('\n');
                this.printIndent(indent);
                this.output.append("else\n");
                this.printStatement(is.elseStatement, indent + 2);
            }
            return this.output;
        }
        if (statement instanceof Block) {
            this.printBlock((Block)statement, indent, applyIndent);
            return this.output;
        }
        if (statement instanceof LocalDeclaration) {
            return this.printLocalDeclaration((LocalDeclaration)statement, indent);
        }
        if (statement instanceof SwitchStatement) {
            return this.printSwitchStatement((SwitchStatement)statement, indent);
        }
        if (statement instanceof CaseStatement) {
            return this.printCaseStatement((CaseStatement)statement, indent);
        }
        if (statement instanceof BreakStatement) {
            return this.printBreakStatement((BreakStatement)statement, indent);
        }
        if (statement instanceof ThrowStatement) {
            return this.printThrowStatement((ThrowStatement)statement, indent);
        }
        if (statement instanceof TypeDeclaration) {
            return this.printTypeDeclaration((TypeDeclaration)statement, indent, false).append(';');
        }
        if (statement instanceof AssertStatement) {
            return this.printAssertStatement((AssertStatement)statement, indent);
        }
        if (statement instanceof ForStatement) {
            return this.printForStatement((ForStatement)statement, indent);
        }
        if (statement instanceof ForeachStatement) {
            return this.printForeachStatement((ForeachStatement)statement, indent);
        }
        System.err.println(statement);
        System.err.println(statement.getClass().getName());
        this.throwit(statement);
        return this.output;
    }

    private StringBuilder printPostfixExpression(PostfixExpression pe) {
        this.printExpression(pe.lhs);
        this.output.append(' ');
        this.output.append(pe.operatorToString());
        return this.output;
    }

    private StringBuilder printPrefixExpression(PrefixExpression pe) {
        this.output.append(pe.operatorToString());
        this.output.append(' ');
        this.printExpression(pe.lhs);
        return this.output;
    }

    public StringBuilder printAsExpression(LocalDeclaration ld, int indent) {
        this.printModifiers(ld.modifiers);
        if (ld.annotations != null) {
            this.printAnnotations(ld.annotations);
        }
        if (ld.type != null) {
            this.printTypeReference(ld.type).append(' ');
        }
        this.output.append(ld.name);
        switch (ld.getKind()) {
            case 3: {
                if (ld.initialization == null) break;
                this.printExpression(ld.initialization);
                break;
            }
            default: {
                if (ld.initialization == null) break;
                this.output.append(" = ");
                this.printExpression(ld.initialization);
            }
        }
        return this.output;
    }

    private StringBuilder printForeachStatement(ForeachStatement statement, int indent) {
        this.printIndent(indent).append("for (");
        this.printAsExpression(statement.elementVariable, indent);
        this.output.append(" : ");
        this.printExpression(statement.collection).append(") ");
        if (statement.action == null) {
            this.output.append(';');
        } else {
            this.printStatement(statement.action, indent + 1);
        }
        return this.output;
    }

    private StringBuilder printForStatement(ForStatement fs, int indent) {
        int i;
        this.printIndent(indent).append("for (");
        if (fs.initializations != null) {
            for (i = 0; i < fs.initializations.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printStatement(fs.initializations[i], 0);
            }
        }
        if (!this.output.toString().endsWith(";")) {
            this.output.append("; ");
        }
        if (fs.condition != null) {
            this.printExpression(fs.condition);
        }
        this.output.append("; ");
        if (fs.increments != null) {
            for (i = 0; i < fs.increments.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printStatement(fs.increments[i], 0);
            }
        }
        this.output.append(") ");
        if (fs.action == null) {
            this.output.append(';');
        } else {
            this.printStatement(fs.action, indent + 1, false);
        }
        return this.output;
    }

    private StringBuilder printAssertStatement(AssertStatement as, int indent) {
        this.printIndent(indent);
        this.output.append("assert ");
        this.printExpression(as.assertExpression);
        if (as.exceptionArgument != null) {
            this.output.append(": ");
            this.printExpression(as.exceptionArgument);
        }
        return this.output.append(';');
    }

    private StringBuilder printThrowStatement(ThrowStatement ts, int indent) {
        this.printIndent(indent).append("throw ");
        this.printExpression(ts.exception);
        return this.output.append(';');
    }

    private StringBuilder printBreakStatement(BreakStatement statement, int indent) {
        this.printIndent(indent).append("break ");
        if (statement.label != null) {
            this.output.append(statement.label);
        }
        return this.output.append(';');
    }

    private StringBuilder printCaseStatement(CaseStatement statement, int indent) {
        this.printIndent(indent);
        if (statement.constantExpression == null) {
            this.output.append("default : ");
        } else {
            this.output.append("case ");
            this.printExpression(statement.constantExpression).append(" : ");
        }
        return this.output;
    }

    private StringBuilder printSwitchStatement(SwitchStatement statement, int indent) {
        this.printIndent(indent).append("switch (");
        this.printExpression(statement.expression).append(") {");
        if (statement.statements != null) {
            for (int i = 0; i < statement.statements.length; ++i) {
                this.output.append('\n');
                if (statement.statements[i] instanceof CaseStatement) {
                    this.printStatement(statement.statements[i], indent);
                    continue;
                }
                this.printStatement(statement.statements[i], indent + 2);
            }
        }
        this.output.append("\n");
        return this.printIndent(indent).append('}');
    }

    private StringBuilder printLocalDeclaration(LocalDeclaration statement, int indent) {
        this.printAbstractVariableDeclarationAsExpression(statement, indent);
        switch (statement.getKind()) {
            case 3: {
                return this.output.append(',');
            }
        }
        return this.output.append(';');
    }

    private StringBuilder printAbstractVariableDeclarationAsExpression(AbstractVariableDeclaration avd, int indent) {
        this.printIndent(indent);
        this.printModifiers(avd.modifiers);
        if (avd.annotations != null) {
            this.printAnnotations(avd.annotations);
        }
        if (avd.type != null) {
            this.printTypeReference(avd.type).append(' ');
        }
        this.output.append(avd.name);
        switch (avd.getKind()) {
            case 3: {
                if (avd.initialization == null) break;
                this.printExpression(avd.initialization);
                break;
            }
            default: {
                if (avd.initialization == null) break;
                this.output.append(" = ");
                this.printExpression(avd.initialization);
            }
        }
        return this.output;
    }

    private StringBuilder printBlock(Block b, int indent, boolean applyIndent) {
        if (applyIndent) {
            this.printIndent(indent);
        }
        this.output.append("{\n");
        this.printBody(b, indent);
        this.printIndent(indent);
        return this.output.append('}');
    }

    public StringBuilder printBody(Block b, int indent) {
        if (b.statements == null) {
            return this.output;
        }
        for (int i = 0; i < b.statements.length; ++i) {
            this.printStatement(b.statements[i], indent + 1);
            this.output.append('\n');
        }
        return this.output;
    }

    private StringBuilder printTryStatement(TryStatement statement, int indent) {
        this.printIndent(indent).append("try ");
        this.printBlock(statement.tryBlock, indent, false);
        if (statement.catchBlocks != null) {
            for (int i = 0; i < statement.catchBlocks.length; ++i) {
                this.output.append(" catch (");
                this.printArgument(statement.catchArguments[i]).append(") ");
                this.printBlock(statement.catchBlocks[i], indent, false);
            }
        }
        if (statement.finallyBlock != null) {
            this.output.append(" finally ");
            this.printBlock(statement.finallyBlock, indent, false);
        }
        return this.output;
    }

    private StringBuilder printAssignment(Assignment statement) {
        return this.printAssignment(statement, this.expressionLevel != 0);
    }

    private StringBuilder printAssignment(Assignment statement, boolean parens) {
        if (parens) {
            this.output.append('(');
        }
        this.printExpression(statement.lhs).append(" = ");
        this.printExpression(statement.expression);
        if (parens) {
            this.output.append(')');
        }
        return this.output;
    }

    private StringBuilder printMessageSendStatement(MessageSend ms) {
        if (!ms.receiver.isImplicitThis()) {
            this.printExpression(ms.receiver).append('.');
        }
        if (ms.typeArguments != null) {
            this.output.append('<');
            int max = ms.typeArguments.length - 1;
            for (int j = 0; j < max; ++j) {
                this.printTypeReference(ms.typeArguments[j]);
                this.output.append(", ");
            }
            this.printTypeReference(ms.typeArguments[max]);
            this.output.append('>');
        }
        this.output.append(ms.selector).append('(');
        if (ms.arguments != null) {
            for (int i = 0; i < ms.arguments.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printExpression(ms.arguments[i]);
            }
        }
        return this.output.append(')');
    }

    protected StringBuilder printQualifiedAllocationExpression(QualifiedAllocationExpression qae, int indent) {
        if (qae.enclosingInstance != null) {
            this.printExpression(qae.enclosingInstance).append('.');
        }
        this.printAllocationExpression(qae);
        if (qae.anonymousType != null) {
            this.printTypeDeclaration(qae.anonymousType, indent, true);
        }
        return this.output;
    }

    protected StringBuilder printTypeDeclaration(TypeDeclaration td, int indent, boolean isAnonymous) {
        if (td.javadoc != null) {
            this.throwit(td);
        }
        if ((td.bits & 0x200) == 0) {
            this.printIndent(this.tab);
            this.printTypeDeclarationHeader(td);
        }
        this.printTypeDeclarationBody(td, indent, isAnonymous);
        return this.output;
    }

    public StringBuilder printTypeDeclarationBody(TypeDeclaration td, int indent, boolean isAnonymous) {
        int i;
        this.output.append(" {");
        if (td.memberTypes != null) {
            for (i = 0; i < td.memberTypes.length; ++i) {
                if (td.memberTypes[i] == null) continue;
                this.output.append('\n');
                this.printTypeDeclaration(td.memberTypes[i], indent + 1, false);
            }
        }
        if (td.fields != null) {
            for (int fieldI = 0; fieldI < td.fields.length; ++fieldI) {
                if (td.fields[fieldI] == null) continue;
                this.output.append('\n');
                this.printFieldDeclaration(td.fields[fieldI], indent + 1);
            }
        }
        if (td.methods != null) {
            for (i = 0; i < td.methods.length; ++i) {
                if (td.methods[i] == null) continue;
                AbstractMethodDeclaration amd = td.methods[i];
                if (amd instanceof MethodDeclaration) {
                    this.output.append('\n');
                    this.printMethodDeclaration((MethodDeclaration)amd, indent + 1);
                    continue;
                }
                if (amd instanceof ConstructorDeclaration) {
                    if (isAnonymous) continue;
                    this.output.append('\n');
                    this.printConstructorDeclaration((ConstructorDeclaration)amd, indent + 1);
                    continue;
                }
                this.throwit(amd);
            }
        }
        this.output.append('\n');
        return this.printIndent(indent).append('}');
    }

    protected StringBuilder printFieldDeclaration(FieldDeclaration fd, int indent) {
        this.printIndent(indent);
        this.printModifiers(fd.modifiers);
        if (fd.annotations != null) {
            this.printAnnotations(fd.annotations);
        }
        if (fd.type != null) {
            this.printTypeReference(fd.type).append(' ');
        }
        this.output.append(fd.name);
        switch (fd.getKind()) {
            case 3: {
                if (fd.initialization == null) break;
                this.printExpression(fd.initialization);
                break;
            }
            default: {
                if (fd.initialization == null) break;
                this.output.append(" = ");
                this.printExpression(fd.initialization);
            }
        }
        this.output.append(';');
        return this.output;
    }

    protected StringBuilder printConstructorDeclaration(ConstructorDeclaration amd, int tab) {
        int i;
        if (amd.javadoc != null) {
            this.throwit();
        }
        this.printIndent(tab);
        if (amd.annotations != null) {
            this.printAnnotations(amd.annotations);
        }
        this.printModifiers(amd.modifiers);
        TypeParameter[] typeParams = amd.typeParameters();
        if (typeParams != null) {
            this.output.append('<');
            int max = typeParams.length - 1;
            for (int j = 0; j < max; ++j) {
                this.printTypeParameter(typeParams[j]);
                this.output.append(", ");
            }
            this.printTypeParameter(typeParams[max]);
            this.output.append('>');
        }
        this.output.append(amd.selector).append('(');
        if (amd.arguments != null) {
            for (i = 0; i < amd.arguments.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printArgument(amd.arguments[i]);
            }
        }
        this.output.append(')');
        if (amd.thrownExceptions != null) {
            this.output.append(" throws ");
            for (i = 0; i < amd.thrownExceptions.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.throwit();
            }
        }
        this.printBody(amd, tab + 1);
        return this.output;
    }

    private StringBuilder printMethodDeclaration(MethodDeclaration amd, int tab) {
        int i;
        if (amd.javadoc != null) {
            this.throwit();
        }
        this.printIndent(tab);
        if (amd.annotations != null) {
            this.printAnnotations(amd.annotations);
        }
        this.printModifiers(amd.modifiers);
        TypeParameter[] typeParams = amd.typeParameters();
        if (typeParams != null) {
            this.output.append('<');
            int max = typeParams.length - 1;
            for (int j = 0; j < max; ++j) {
                this.printTypeParameter(typeParams[j]);
                this.output.append(", ");
            }
            this.printTypeParameter(typeParams[max]);
            this.output.append('>');
        }
        this.printReturnType(amd.returnType).append(amd.selector).append('(');
        if (amd.arguments != null) {
            for (i = 0; i < amd.arguments.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printArgument(amd.arguments[i]);
            }
        }
        this.output.append(')');
        if (amd.thrownExceptions != null) {
            this.output.append(" throws ");
            for (i = 0; i < amd.thrownExceptions.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.throwit();
            }
        }
        this.printBody(amd, tab + 1);
        return this.output;
    }

    public StringBuilder printReturnType(TypeReference tr) {
        if (tr == null) {
            return this.output;
        }
        return this.printExpression(tr).append(' ');
    }

    public static final int kind(int flags) {
        switch (flags & 0x6200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    protected StringBuilder printTypeDeclarationHeader(TypeDeclaration td) {
        int i;
        this.printModifiers(td.modifiers);
        if (td.annotations != null) {
            this.printAnnotations(td.annotations);
        }
        switch (CommonPrinter.kind(td.modifiers)) {
            case 1: {
                this.output.append("class ");
                break;
            }
            case 2: {
                this.output.append("interface ");
                break;
            }
            case 3: {
                this.output.append("enum ");
                break;
            }
            case 4: {
                this.output.append("@interface ");
            }
        }
        this.output.append(td.name);
        if (td.typeParameters != null) {
            this.output.append("<");
            for (i = 0; i < td.typeParameters.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printTypeParameter(td.typeParameters[i]);
            }
            this.output.append(">");
        }
        if (td.superclass != null) {
            this.output.append(" extends ");
            this.printTypeReference(td.superclass);
        }
        if (td.superInterfaces != null && td.superInterfaces.length > 0) {
            switch (CommonPrinter.kind(td.modifiers)) {
                case 1: 
                case 3: {
                    this.output.append(" implements ");
                    break;
                }
                case 2: 
                case 4: {
                    this.output.append(" extends ");
                }
            }
            for (i = 0; i < td.superInterfaces.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printTypeReference(td.superInterfaces[i]);
            }
        }
        return this.output;
    }

    protected StringBuilder printTypeParameter(TypeParameter tp) {
        this.output.append(tp.name);
        if (tp.type != null) {
            this.output.append(" extends ");
            this.printTypeReference(tp.type);
        }
        if (tp.bounds != null) {
            for (int i = 0; i < tp.bounds.length; ++i) {
                this.output.append(" & ");
                this.printTypeReference(tp.bounds[i]);
            }
        }
        return this.output;
    }

    protected StringBuilder printAllocationExpression(AllocationExpression ae) {
        if (ae.type != null) {
            this.output.append("new ");
        }
        if (ae.typeArguments != null) {
            this.output.append('<');
            int max = ae.typeArguments.length - 1;
            for (int j = 0; j < max; ++j) {
                this.printTypeReference(ae.typeArguments[j]);
                this.output.append(", ");
            }
            this.printTypeReference(ae.typeArguments[max]);
            this.output.append('>');
        }
        if (ae.type != null) {
            this.printExpression(ae.type);
        }
        this.output.append('(');
        if (ae.arguments != null) {
            for (int i = 0; i < ae.arguments.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printExpression(ae.arguments[i]);
            }
        }
        return this.output.append(')');
    }
}

